/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.bindings.BindingServiceAddon;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.addons.CommandProcessingAddon;
import org.eclipse.e4.ui.internal.workbench.addons.HandlerProcessingAddon;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MHandlerContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.services.ContextServiceAddon;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class HandlerActivationTest {
    private static final String COMMANDID = "handlerActivationTest";
    protected IEclipseContext appContext;
    protected E4Workbench wb;
    private MCommand command;
    private MWindow window;
    private EHandlerService handlerService;
    private ParameterizedCommand parameterizedCommand;
    private MPerspective perspectiveA;
    private MPart partA1;
    private MPerspective perspectiveB;
    private MPart partA2;
    private EPartService partService;
    private MPart partB1;
    private EModelService ems;

    @Before
    public void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set(CommandServiceAddon.class, (Object)((CommandServiceAddon)ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.appContext)));
        this.appContext.set(ContextServiceAddon.class, (Object)((ContextServiceAddon)ContextInjectionFactory.make(ContextServiceAddon.class, (IEclipseContext)this.appContext)));
        this.appContext.set(BindingServiceAddon.class, (Object)((BindingServiceAddon)ContextInjectionFactory.make(BindingServiceAddon.class, (IEclipseContext)this.appContext)));
        this.appContext.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
        this.ems = (EModelService)this.appContext.get(EModelService.class);
        this.createLayoutWithThreeContextLayers();
    }

    @After
    public void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    public void createLayoutWithThreeContextLayers() {
        this.window = (MWindow)this.ems.createModelElement(MWindow.class);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        this.window.getChildren().add(perspectiveStack);
        this.perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        this.perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        MPartStack stackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        this.partA1 = (MPart)this.ems.createModelElement(MPart.class);
        this.partA2 = (MPart)this.ems.createModelElement(MPart.class);
        stackA.getChildren().add(this.partA1);
        stackA.getChildren().add(this.partA2);
        this.perspectiveA.getChildren().add(stackA);
        perspectiveStack.getChildren().add(this.perspectiveA);
        MPartStack stackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        this.partB1 = (MPart)this.ems.createModelElement(MPart.class);
        stackB.getChildren().add(this.partB1);
        stackB.setSelectedElement((MUIElement)this.partB1);
        this.perspectiveB.getChildren().add(stackB);
        perspectiveStack.getChildren().add(this.perspectiveB);
        perspectiveStack.setSelectedElement((MUIElement)this.perspectiveA);
        stackA.setSelectedElement((MUIElement)this.partA1);
        this.command = (MCommand)this.ems.createModelElement(MCommand.class);
        this.command.setElementId(COMMANDID);
        this.command.setCommandName("Test Handler Activation");
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        application.getCommands().add(this.command);
        application.getChildren().add(this.window);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.appContext.set(CommandProcessingAddon.class, (Object)((CommandProcessingAddon)ContextInjectionFactory.make(CommandProcessingAddon.class, (IEclipseContext)this.appContext)));
        this.appContext.set(HandlerProcessingAddon.class, (Object)((HandlerProcessingAddon)ContextInjectionFactory.make(HandlerProcessingAddon.class, (IEclipseContext)this.appContext)));
        this.wb = new E4Workbench((MApplicationElement)this.window, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)this.window);
        ECommandService commandService = (ECommandService)this.appContext.get(ECommandService.class);
        this.handlerService = (EHandlerService)this.appContext.get(EHandlerService.class);
        this.parameterizedCommand = commandService.createCommand(COMMANDID, null);
        this.partService = (EPartService)this.appContext.get(EPartService.class);
    }

    @Test
    public void testHandlerInWindowOnly() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        TestHandler testHandler = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.window);
        this.executeCommand();
        Assert.assertTrue((boolean)testHandler.isExecuted());
    }

    @Test
    public void testHandlerInActivePerspectiveOnly() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        TestHandler testHandler = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.perspectiveA);
        this.executeCommand();
        Assert.assertTrue((boolean)testHandler.isExecuted());
    }

    @Test
    public void testHandlerInActivePartOnly() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        TestHandler testHandler = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.partA1);
        this.executeCommand();
        Assert.assertTrue((boolean)testHandler.isExecuted());
    }

    @Test
    public void testHandlerInInactivePerspectiveOnly() {
        TestHandler testHandler = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.perspectiveB);
        this.executeCommand();
        Assert.assertFalse((boolean)testHandler.isExecuted());
    }

    @Test
    public void testHandlerInInactivePartOnly() {
        TestHandler testHandler = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.partA2);
        this.executeCommand();
        Assert.assertFalse((boolean)testHandler.isExecuted());
    }

    @Test
    public void testHandlerInActivePartAndPerspective() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        TestHandler testHandler = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.partA1);
        TestHandler testHandler2 = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.perspectiveA);
        this.executeCommand();
        Assert.assertTrue((boolean)testHandler.isExecuted());
        Assert.assertFalse((boolean)testHandler2.isExecuted());
    }

    @Test
    public void testHandlerInActivePartAndWindow() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        TestHandler testHandler = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.partA1);
        TestHandler testHandler2 = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.window);
        this.executeCommand();
        Assert.assertTrue((boolean)testHandler.isExecuted());
        Assert.assertFalse((boolean)testHandler2.isExecuted());
    }

    @Test
    public void testHandlerInActivePerspectiveAndWindow() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        TestHandler testHandler = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.perspectiveA);
        TestHandler testHandler2 = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.window);
        this.executeCommand();
        Assert.assertTrue((boolean)testHandler.isExecuted());
        Assert.assertFalse((boolean)testHandler2.isExecuted());
    }

    @Test
    public void testHandlerInActivePartAndPerspectiveAndWindow() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        TestHandler testHandler = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.partA1);
        TestHandler testHandler2 = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.perspectiveA);
        TestHandler testHandler3 = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.window);
        this.executeCommand();
        Assert.assertTrue((boolean)testHandler.isExecuted());
        Assert.assertFalse((boolean)testHandler2.isExecuted());
        Assert.assertFalse((boolean)testHandler3.isExecuted());
    }

    @Test
    public void testHandlerSwitchToInactivePart() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        TestHandler testHandler = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.partA2);
        this.executeCommand();
        Assert.assertFalse((boolean)testHandler.isExecuted());
        this.partService.activate(this.partA2);
        this.executeCommand();
        Assert.assertTrue((boolean)testHandler.isExecuted());
    }

    @Test
    public void testHandlerSwitchToInactivePerspective() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        TestHandler testHandlerA = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.perspectiveA);
        TestHandler testHandlerB = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.perspectiveB);
        this.partService.switchPerspective(this.perspectiveB);
        this.executeCommand();
        Assert.assertFalse((boolean)testHandlerA.isExecuted());
        Assert.assertTrue((boolean)testHandlerB.isExecuted());
    }

    @Test
    public void testHandlerSwitchToInactivePartInOtherPerspectiveWithPerspectiveHandlers() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        TestHandler testHandlerA = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.perspectiveA);
        TestHandler testHandlerB = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.perspectiveB);
        this.partService.switchPerspective(this.perspectiveB);
        this.partService.activate(this.partB1);
        this.executeCommand();
        Assert.assertFalse((boolean)testHandlerA.isExecuted());
        Assert.assertTrue((boolean)testHandlerB.isExecuted());
    }

    @Test
    public void testHandlerSwitchToInactivePartInOtherPerspectiveWithPartHandlers() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        TestHandler testHandlerA = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.partA1);
        TestHandler testHandlerB = this.createTestHandlerInHandlerContainer((MHandlerContainer)this.partB1);
        this.partService.switchPerspective(this.perspectiveB);
        this.partService.activate(this.partB1);
        this.executeCommand();
        Assert.assertFalse((boolean)testHandlerA.isExecuted());
        Assert.assertTrue((boolean)testHandlerB.isExecuted());
    }

    private TestHandler createTestHandlerInHandlerContainer(MHandlerContainer handlerContainer) {
        MHandler handler = (MHandler)this.ems.createModelElement(MHandler.class);
        handler.setCommand(this.command);
        TestHandler testHandler = new TestHandler(){
            private boolean executed;

            @Execute
            public void execute() {
                this.executed = true;
            }

            @Override
            public boolean isExecuted() {
                return this.executed;
            }
        };
        handler.setObject((Object)testHandler);
        handlerContainer.getHandlers().add(handler);
        return testHandler;
    }

    private void executeCommand() {
        this.handlerService.executeHandler(this.parameterizedCommand);
    }

    public static interface TestHandler {
        public boolean isExecuted();
    }
}

