/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MApplicationCommandAccessTest {
    private static final int NUMBER_OF_COMMANDS = 1000;
    protected IEclipseContext applicationContext;
    protected E4Workbench wb;

    @Before
    public void setUp() throws Exception {
        this.applicationContext = E4Application.createDefaultContext();
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.applicationContext);
    }

    @After
    public void tearDown() throws Exception {
        this.applicationContext.dispose();
    }

    @Test
    public void testCreateApplictionWithCommands() {
        MApplication application = this.createAppWithCommands();
        Assert.assertEquals((long)1000L, (long)application.getCommands().size());
    }

    @Test
    public void testRemovalOfCommands() {
        MApplication application = this.createAppWithCommands();
        application.getCommands().remove(0);
        Assert.assertEquals((long)999L, (long)application.getCommands().size());
    }

    @Test
    public void testFindCorrectCommand() {
        MApplication application = this.createAppWithCommands();
        boolean found = false;
        for (MCommand command : application.getCommands()) {
            if (!command.getElementId().equals(String.valueOf(999))) continue;
            found = true;
            break;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testFindCorrectCommandDirectAccess() {
        MApplication application = this.createAppWithCommands();
        MCommand command = application.getCommand(String.valueOf(999));
        Assert.assertNotNull((Object)command);
        MCommand commandShouldBeNull = application.getCommand("invalid");
        Assert.assertNull((Object)commandShouldBeNull);
    }

    @Test
    public void testFindNullAfterCommandRemoval() {
        MApplication application = this.createAppWithCommands();
        MCommand command = application.getCommand(String.valueOf(999));
        Assert.assertNotNull((Object)command);
        application.getCommands().remove(command);
        MCommand commandShouldBeNull = application.getCommand(String.valueOf(999));
        Assert.assertNull((Object)commandShouldBeNull);
    }

    @Test
    public void testCommandAfterAddingIt() {
        MApplication application = this.createAppWithCommands();
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        MCommand commandShouldBeNull = application.getCommand("neucommand");
        Assert.assertNull((Object)commandShouldBeNull);
        MCommand mCommand = (MCommand)modelService.createModelElement(MCommand.class);
        mCommand.setElementId("neucommand");
        application.getCommands().add(mCommand);
        MCommand neuCommnad = application.getCommand("neucommand");
        Assert.assertNotNull((Object)neuCommnad);
    }

    private MApplication createAppWithCommands() {
        EModelService modelService = (EModelService)this.applicationContext.get(EModelService.class);
        MApplication application = (MApplication)modelService.createModelElement(MApplication.class);
        int i = 0;
        while (i < 1000) {
            MCommand command = (MCommand)modelService.createModelElement(MCommand.class);
            command.setElementId(String.valueOf(i));
            application.getCommands().add(command);
            ++i;
        }
        return application;
    }
}

