/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import jakarta.inject.Inject;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.tests.rules.WorkbenchContextRule;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class MSaveablePartTest {
    @Rule
    public WorkbenchContextRule contextRule = new WorkbenchContextRule();
    @Inject
    private EModelService ems;
    @Inject
    private MApplication application;

    @Test
    public void testCreateView() {
        MWindow window = this.createWindowWithOneView("Part Name");
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        CTabItem item = folder.getItem(0);
        Assert.assertEquals((Object)"Part Name", (Object)item.getText());
        Assert.assertFalse((boolean)part.isDirty());
        part.setDirty(true);
        Assert.assertEquals((Object)"*Part Name", (Object)item.getText());
        part.setDirty(false);
        Assert.assertEquals((Object)"Part Name", (Object)item.getText());
    }

    private MWindow createWindowWithOneView(String partName) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setHeight(300);
        window.setWidth(400);
        window.setLabel("MyWindow");
        MPartSashContainer sash = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(sash);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        sash.getChildren().add(stack);
        MPart contributedPart = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(contributedPart);
        contributedPart.setLabel(partName);
        contributedPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        return window;
    }
}

