/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import jakarta.inject.Inject;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.ItemType;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.tests.rules.WorkbenchContextRule;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class MToolItemTest {
    @Rule
    public WorkbenchContextRule contextRule = new WorkbenchContextRule();
    @Inject
    private EModelService ems;
    @Inject
    private MApplication application;

    private void testMToolItem_Text(String before, String beforeExpected, String after, String afterExpected) {
        MTrimmedWindow window = (MTrimmedWindow)this.ems.createModelElement(MTrimmedWindow.class);
        MTrimBar trimBar = (MTrimBar)this.ems.createModelElement(MTrimBar.class);
        MToolBar toolBar = (MToolBar)this.ems.createModelElement(MToolBar.class);
        MToolItem toolItem = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        toolItem.setLabel(before);
        window.getTrimBars().add(trimBar);
        trimBar.getChildren().add(toolBar);
        toolBar.getChildren().add(toolItem);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench((MWindow)window);
        Object widget = toolItem.getWidget();
        Assert.assertNotNull((Object)widget);
        Assert.assertTrue((boolean)(widget instanceof ToolItem));
        ToolItem toolItemWidget = (ToolItem)widget;
        Assert.assertEquals((Object)beforeExpected, (Object)toolItemWidget.getText());
        toolItem.setLabel(after);
        Assert.assertEquals((Object)afterExpected, (Object)toolItemWidget.getText());
    }

    @Test
    public void testMToolItem_Text_NullNull() {
        this.testMToolItem_Text(null, "", null, "");
    }

    @Test
    public void testMToolItem_Text_NullEmpty() {
        this.testMToolItem_Text(null, "", "", "");
    }

    @Test
    public void testMToolItem_Text_NullString() {
        this.testMToolItem_Text(null, "", "label", "label");
    }

    @Test
    public void testMToolItem_Text_EmptyNull() {
        this.testMToolItem_Text("", "", null, "");
    }

    @Test
    public void testMToolItem_Text_EmptyEmpty() {
        this.testMToolItem_Text("", "", "", "");
    }

    @Test
    public void testMToolItem_Text_EmptyString() {
        this.testMToolItem_Text("", "", "label", "label");
    }

    @Test
    public void testMToolItem_Text_StringNull() {
        this.testMToolItem_Text("label", "label", null, "");
    }

    @Test
    public void testMToolItem_Text_StringEmpty() {
        this.testMToolItem_Text("label", "label", "", "");
    }

    @Test
    public void testMToolItem_Text_StringStringUnchanged() {
        this.testMToolItem_Text("label", "label", "label", "label");
    }

    @Test
    public void testMToolItem_Text_StringStringChanged() {
        this.testMToolItem_Text("label", "label", "label2", "label2");
    }

    private void testMToolItem_Tooltip(String before, String beforeExpected, String after, String afterExpected) {
        MTrimmedWindow window = (MTrimmedWindow)this.ems.createModelElement(MTrimmedWindow.class);
        MTrimBar trimBar = (MTrimBar)this.ems.createModelElement(MTrimBar.class);
        MToolBar toolBar = (MToolBar)this.ems.createModelElement(MToolBar.class);
        MToolItem toolItem = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        toolItem.setTooltip(before);
        window.getTrimBars().add(trimBar);
        trimBar.getChildren().add(toolBar);
        toolBar.getChildren().add(toolItem);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench((MWindow)window);
        Object widget = toolItem.getWidget();
        Assert.assertNotNull((Object)widget);
        Assert.assertTrue((boolean)(widget instanceof ToolItem));
        ToolItem toolItemWidget = (ToolItem)widget;
        Assert.assertEquals((Object)beforeExpected, (Object)toolItemWidget.getToolTipText());
        toolItem.setTooltip(after);
        Assert.assertEquals((Object)afterExpected, (Object)toolItemWidget.getToolTipText());
    }

    @Test
    public void testMToolItem_Tooltip_NullNull() {
        this.testMToolItem_Tooltip(null, null, null, null);
    }

    @Test
    public void testMToolItem_Tooltip_NullEmpty() {
        this.testMToolItem_Tooltip(null, null, "", "");
    }

    @Test
    public void testMToolItem_Tooltip_NullString() {
        this.testMToolItem_Tooltip(null, null, "toolTip", "toolTip");
    }

    @Test
    public void testMToolItem_Tooltip_EmptyNull() {
        this.testMToolItem_Tooltip("", "", null, null);
    }

    @Test
    public void testMToolItem_Tooltip_EmptyEmpty() {
        this.testMToolItem_Tooltip("", "", "", "");
    }

    @Test
    public void testMToolItem_Tooltip_EmptyString() {
        this.testMToolItem_Tooltip("", "", "toolTip", "toolTip");
    }

    @Test
    public void testMToolItem_Tooltip_StringNull() {
        this.testMToolItem_Tooltip("toolTip", "toolTip", null, null);
    }

    @Test
    public void testMToolItem_Tooltip_StringEmpty() {
        this.testMToolItem_Tooltip("toolTip", "toolTip", "", "");
    }

    @Test
    public void testMToolItem_Tooltip_StringStringUnchanged() {
        this.testMToolItem_Tooltip("toolTip", "toolTip", "toolTip", "toolTip");
    }

    @Test
    public void testMToolItem_Tooltip_StringStringChanged() {
        this.testMToolItem_Tooltip("toolTip", "toolTip", "toolTip2", "toolTip2");
    }

    @Test
    public void testMToolItem_RadioItems() {
        MTrimmedWindow window = (MTrimmedWindow)this.ems.createModelElement(MTrimmedWindow.class);
        MTrimBar trimBar = (MTrimBar)this.ems.createModelElement(MTrimBar.class);
        MToolBar toolBar = (MToolBar)this.ems.createModelElement(MToolBar.class);
        MToolItem toolItem1 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        MToolItem toolItem2 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        toolItem1.setType(ItemType.RADIO);
        toolItem2.setType(ItemType.RADIO);
        window.getTrimBars().add(trimBar);
        trimBar.getChildren().add(toolBar);
        toolBar.getChildren().add(toolItem1);
        toolBar.getChildren().add(toolItem2);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench((MWindow)window);
        Object widget1 = toolItem1.getWidget();
        Assert.assertNotNull((Object)widget1);
        Assert.assertTrue((boolean)(widget1 instanceof ToolItem));
        Object widget2 = toolItem2.getWidget();
        Assert.assertNotNull((Object)widget2);
        Assert.assertTrue((boolean)(widget2 instanceof ToolItem));
        ToolItem toolItemWidget1 = (ToolItem)widget1;
        ToolItem toolItemWidget2 = (ToolItem)widget2;
        toolItemWidget1.setSelection(false);
        toolItemWidget2.setSelection(true);
        toolItemWidget1.notifyListeners(13, new Event());
        toolItemWidget2.notifyListeners(13, new Event());
        Assert.assertFalse((boolean)toolItem1.isSelected());
        Assert.assertTrue((boolean)toolItem2.isSelected());
        toolItemWidget2.setSelection(false);
        toolItemWidget1.setSelection(true);
        toolItemWidget2.notifyListeners(13, new Event());
        toolItemWidget1.notifyListeners(13, new Event());
        Assert.assertTrue((boolean)toolItem1.isSelected());
        Assert.assertFalse((boolean)toolItem2.isSelected());
        toolItem1.setSelected(false);
        Assert.assertFalse((boolean)toolItemWidget1.getSelection());
        toolItem2.setSelected(true);
        Assert.assertTrue((boolean)toolItemWidget2.getSelection());
    }
}

