/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import jakarta.inject.Inject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.tests.rules.WorkbenchContextRule;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class MWindowTest {
    @Rule
    public WorkbenchContextRule contextRule = new WorkbenchContextRule();
    @Inject
    private IEclipseContext appContext;
    @Inject
    private EModelService ems;
    @Inject
    private MApplication application;

    @Test
    public void testCreateWindow() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setLabel("MyWindow");
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        Widget topWidget = (Widget)window.getWidget();
        Assert.assertNotNull((Object)topWidget);
        Assert.assertTrue((boolean)(topWidget instanceof Shell));
        Assert.assertEquals((Object)"MyWindow", (Object)((Shell)topWidget).getText());
        Assert.assertEquals((Object)topWidget, (Object)this.appContext.get("activeShell"));
    }

    @Test
    public void testWindowVisibility() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setLabel("MyWindow");
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        Widget topWidget = (Widget)window.getWidget();
        Assert.assertNotNull((Object)topWidget);
        Assert.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        Assert.assertTrue((boolean)shell.getVisible());
        window.setVisible(false);
        Assert.assertFalse((boolean)shell.getVisible());
        window.setVisible(true);
        Assert.assertTrue((boolean)shell.getVisible());
    }

    @Test
    public void testWindowInvisibleCreate() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setLabel("MyWindow");
        window.setVisible(false);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        Widget topWidget = (Widget)window.getWidget();
        Assert.assertNotNull((Object)topWidget);
        Assert.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        Assert.assertFalse((boolean)shell.getVisible());
    }

    @Test
    public void testCreateView() {
        MWindow window = this.createWindowWithOneView();
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        Assert.assertEquals((long)1L, (long)folder.getItemCount());
        Control c = folder.getItem(0).getControl();
        Assert.assertTrue((boolean)(c instanceof Composite));
        Control[] viewPart = ((Composite)c).getChildren();
        Assert.assertEquals((long)1L, (long)viewPart.length);
        Assert.assertTrue((boolean)(viewPart[0] instanceof Tree));
    }

    @Test
    public void testContextChildren() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        MWindow window = this.createWindowWithOneView();
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        Widget topWidget = (Widget)window.getWidget();
        Assert.assertNotNull((Object)topWidget);
        Assert.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        Assert.assertEquals((Object)"MyWindow", (Object)shell.getText());
        IEclipseContext child = this.appContext.getActiveChild();
        Assert.assertNotNull((Object)child);
        Assert.assertEquals((Object)window.getContext(), (Object)child);
        MPart modelPart = this.getContributedPart(window);
        Assert.assertNotNull((Object)modelPart);
        Assert.assertEquals((Object)window, (Object)modelPart.getParent().getParent().getParent());
        AbstractPartRenderer factory = (AbstractPartRenderer)modelPart.getRenderer();
        factory.activate(modelPart);
        IEclipseContext next = child.getActiveChild();
        while (next != null) {
            child = next;
            if ((next = child.getActiveChild()) != child) continue;
            Assert.fail((String)"Cycle detected in part context");
            break;
        }
        Assert.assertNotEquals((Object)window.getContext(), (Object)child);
        MPart contextPart = (MPart)child.get(MPart.class);
        Assert.assertNotNull((Object)contextPart);
        Assert.assertEquals((Object)window, (Object)contextPart.getParent().getParent().getParent());
    }

    @Test
    public void testCreateMenu() {
        MWindow window = this.createWindowWithOneViewAndMenu();
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        ((MenuManager)((Widget)window.getMainMenu().getWidget()).getData()).updateAll(true);
        Widget topWidget = (Widget)window.getWidget();
        Assert.assertNotNull((Object)topWidget);
        Assert.assertTrue((boolean)(topWidget instanceof Shell));
        Shell shell = (Shell)topWidget;
        Menu menuBar = shell.getMenuBar();
        Assert.assertNotNull((Object)menuBar);
        Assert.assertEquals((long)1L, (long)menuBar.getItemCount());
        MenuItem fileItem = menuBar.getItem(0);
        Assert.assertEquals((Object)"File", (Object)fileItem.getText());
        Menu fileMenu = fileItem.getMenu();
        fileMenu.notifyListeners(22, null);
        Assert.assertEquals((long)2L, (long)fileMenu.getItemCount());
        fileMenu.notifyListeners(23, null);
        MMenu mainMenu = window.getMainMenu();
        MMenu modelFileMenu = (MMenu)mainMenu.getChildren().get(0);
        MMenuItem item2Model = (MMenuItem)modelFileMenu.getChildren().get(0);
        item2Model.setToBeRendered(false);
        fileMenu.notifyListeners(22, null);
        Assert.assertEquals((long)1L, (long)fileMenu.getItemCount());
        fileMenu.notifyListeners(23, null);
        item2Model.setToBeRendered(true);
        fileMenu.notifyListeners(22, null);
        Assert.assertEquals((long)2L, (long)fileMenu.getItemCount());
        fileMenu.notifyListeners(23, null);
    }

    @Test
    public void testWindow_Name() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setLabel("windowName");
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        Object widget = window.getWidget();
        Assert.assertNotNull((Object)widget);
        Assert.assertTrue((boolean)(widget instanceof Shell));
        Shell shell = (Shell)widget;
        Assert.assertEquals((Object)shell.getText(), (Object)window.getLabel());
        Assert.assertEquals((Object)"windowName", (Object)shell.getText());
        window.setLabel("windowName2");
        Assert.assertEquals((Object)shell.getText(), (Object)window.getLabel());
        Assert.assertEquals((Object)"windowName2", (Object)shell.getText());
    }

    @Ignore
    @Test
    public void TODOtestWindow_X() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setX(200);
        window.setY(200);
        window.setWidth(200);
        window.setHeight(200);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        Object widget = window.getWidget();
        Assert.assertTrue((boolean)(widget instanceof Shell));
        Shell shell = (Shell)widget;
        Rectangle bounds = shell.getBounds();
        Assert.assertEquals((long)window.getX(), (long)bounds.x);
        Assert.assertEquals((long)200L, (long)bounds.x);
        window.setX(300);
        while (shell.getDisplay().readAndDispatch()) {
        }
        bounds = shell.getBounds();
        Assert.assertEquals((long)300L, (long)window.getX());
        Assert.assertEquals((long)window.getX(), (long)bounds.x);
        Assert.assertEquals((long)300L, (long)bounds.x);
    }

    @Ignore
    @Test
    public void TODOtestWindow_Y() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setX(200);
        window.setY(200);
        window.setWidth(200);
        window.setHeight(200);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        Object widget = window.getWidget();
        Assert.assertTrue((boolean)(widget instanceof Shell));
        Shell shell = (Shell)widget;
        Rectangle bounds = shell.getBounds();
        Assert.assertEquals((long)window.getY(), (long)bounds.y);
        Assert.assertEquals((long)200L, (long)bounds.y);
        window.setY(300);
        while (shell.getDisplay().readAndDispatch()) {
        }
        bounds = shell.getBounds();
        Assert.assertEquals((long)300L, (long)window.getY());
        Assert.assertEquals((long)window.getY(), (long)bounds.y);
        Assert.assertEquals((long)300L, (long)bounds.y);
    }

    @Test
    public void testWindow_Width() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setX(200);
        window.setY(200);
        window.setWidth(200);
        window.setHeight(200);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        Object widget = window.getWidget();
        Assert.assertTrue((boolean)(widget instanceof Shell));
        Shell shell = (Shell)widget;
        Assert.assertEquals((long)shell.getBounds().width, (long)window.getWidth());
        Assert.assertEquals((long)200L, (long)shell.getBounds().width);
        window.setWidth(300);
        while (shell.getDisplay().readAndDispatch()) {
        }
        Assert.assertEquals((long)shell.getBounds().width, (long)window.getWidth());
        Assert.assertEquals((long)300L, (long)shell.getBounds().width);
    }

    @Test
    public void testWindow_Height() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setX(200);
        window.setY(200);
        window.setWidth(200);
        window.setHeight(200);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        Object widget = window.getWidget();
        Assert.assertTrue((boolean)(widget instanceof Shell));
        Shell shell = (Shell)widget;
        Assert.assertEquals((long)shell.getBounds().height, (long)window.getHeight());
        Assert.assertEquals((long)200L, (long)shell.getBounds().height);
        window.setHeight(300);
        DisplayHelper.waitForCondition((Display)shell.getDisplay(), (long)10000L, () -> 300 == shell.getBounds().height);
        Assert.assertEquals((long)shell.getBounds().height, (long)window.getHeight());
    }

    @Test
    public void testDetachedWindow() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setLabel("MyWindow");
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        detachedWindow.setLabel("DetachedWindow");
        window.getWindows().add(detachedWindow);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertTrue((boolean)(window.getWidget() instanceof Shell));
        Assert.assertTrue((boolean)(detachedWindow.getWidget() instanceof Shell));
        Shell topShell = (Shell)window.getWidget();
        Shell detachedShell = (Shell)detachedWindow.getWidget();
        Assert.assertEquals((Object)window, (Object)this.ems.getContainer((MUIElement)detachedWindow));
        Assert.assertNull((String)"Should have no shell image", (Object)topShell.getImage());
        Assert.assertEquals((String)"Detached should have same image", (Object)topShell.getImage(), (Object)detachedShell.getImage());
        window.setIconURI("platform:/plugin/org.eclipse.e4.ui.tests/icons/filenav_nav.svg");
        while (topShell.getDisplay().readAndDispatch()) {
        }
        Assert.assertNotNull((String)"Should have shell image", (Object)topShell.getImage());
        Assert.assertEquals((String)"Detached should have same image", (Object)topShell.getImage(), (Object)detachedShell.getImage());
        window.setIconURI(null);
        while (topShell.getDisplay().readAndDispatch()) {
        }
        Assert.assertNull((String)"Should have no shell image", (Object)topShell.getImage());
        Assert.assertEquals((String)"Detached should have same image", (Object)topShell.getImage(), (Object)detachedShell.getImage());
        window.setIconURI("platform:/plugin/org.eclipse.e4.ui.tests/icons/filenav_nav.svg");
        this.application.getChildren().add(detachedWindow);
        while (topShell.getDisplay().readAndDispatch()) {
        }
        Assert.assertTrue((boolean)window.getWindows().isEmpty());
        Assert.assertNotEquals((Object)window, (Object)this.ems.getContainer((MUIElement)detachedWindow));
        Assert.assertNotNull((Object)topShell.getImage());
        Assert.assertNull((Object)detachedShell.getImage());
    }

    private MPart getContributedPart(MWindow window) {
        MPartSashContainer psc = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)psc.getChildren().get(0);
        return (MPart)stack.getChildren().get(0);
    }

    private MWindow createWindowWithOneView() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setHeight(300);
        window.setWidth(400);
        window.setLabel("MyWindow");
        MPartSashContainer sash = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(sash);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        sash.getChildren().add(stack);
        MPart contributedPart = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(contributedPart);
        contributedPart.setLabel("Sample View");
        contributedPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        return window;
    }

    private MWindow createWindowWithOneViewAndMenu() {
        MWindow window = this.createWindowWithOneView();
        MMenu menuBar = (MMenu)this.ems.createModelElement(MMenu.class);
        window.setMainMenu(menuBar);
        MMenu fileMenu = (MMenu)this.ems.createModelElement(MMenu.class);
        fileMenu.setLabel("File");
        fileMenu.setElementId("file");
        menuBar.getChildren().add(fileMenu);
        MMenuItem item1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item1.setElementId("item1");
        item1.setLabel("item1");
        fileMenu.getChildren().add(item1);
        MMenuItem item2 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        item2.setElementId("item2");
        item2.setLabel("item2");
        fileMenu.getChildren().add(item2);
        return window;
    }
}

