/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.ContributorFactorySimple;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.internal.workbench.E4XMIResource;
import org.eclipse.e4.ui.internal.workbench.E4XMIResourceFactory;
import org.eclipse.e4.ui.internal.workbench.ExtensionsSort;
import org.eclipse.e4.ui.internal.workbench.ModelAssembler;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.impl.ApplicationFactoryImpl;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.fragment.MFragmentFactory;
import org.eclipse.e4.ui.model.fragment.MModelFragment;
import org.eclipse.e4.ui.model.fragment.MModelFragments;
import org.eclipse.e4.ui.model.fragment.MStringModelFragment;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.swt.DisplayUISynchronize;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.equinox.log.ExtendedLogReaderService;
import org.eclipse.equinox.log.LogFilter;
import org.eclipse.swt.widgets.Display;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;

public class ModelAssemblerTests {
    private static final String EXTENSION_POINT_ID = "org.eclipse.e4.workbench.model";
    private static final String BUNDLE_SYMBOLIC_NAME = "org.eclipse.e4.ui.tests";
    private static final String APPLICATION_ID = "org.eclipse.e4.ui.tests.modelassembler.app";
    private IEclipseContext appContext;
    private MApplication application;
    private E4XMIResourceFactory factory;
    private ResourceSetImpl resourceSet;
    private E4XMIResource appResource;
    private ModelAssembler assembler;
    private EModelService modelService;
    private static final int COUNTDOWN_TIMEOUT = 10000;
    private ArrayDeque<String> logMessages;
    private ModelAssemblerTestLogListener logListener;

    @Before
    public void setup() {
        this.appContext = E4Application.createDefaultContext();
        this.application = ApplicationFactoryImpl.eINSTANCE.createApplication();
        this.application.setElementId(APPLICATION_ID);
        this.application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)this.application);
        this.appContext.set(UISynchronize.class, (Object)new DisplayUISynchronize(Display.getDefault()));
        this.factory = new E4XMIResourceFactory();
        this.appResource = (E4XMIResource)this.factory.createResource(URI.createURI((String)"virtualuri"));
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.getResources().add((Object)this.appResource);
        this.appResource.getContents().add((Object)((EObject)this.application));
        this.assembler = (ModelAssembler)this.appContext.get(ModelAssembler.class);
        this.assembler.init(this.application, this.appContext, (UISynchronize)new DisplayUISynchronize(Display.getDefault()));
        ContextInjectionFactory.invoke((Object)this.assembler, PostConstruct.class, (IEclipseContext)this.appContext);
        this.logMessages = new ArrayDeque();
        this.logListener = new ModelAssemblerTestLogListener();
        ExtendedLogReaderService log = (ExtendedLogReaderService)this.appContext.get(ExtendedLogReaderService.class);
        LogFilter logFilter = (bundle, loggerName, logLevel) -> "org.eclipse.e4.ui.internal.workbench.ModelAssembler".equals(loggerName);
        log.addLogListener((LogListener)this.logListener, logFilter);
        this.modelService = (EModelService)this.application.getContext().get(EModelService.class);
    }

    @After
    public void tearDown() {
        ExtendedLogReaderService log = (ExtendedLogReaderService)this.appContext.get(ExtendedLogReaderService.class);
        log.removeLogListener((LogListener)this.logListener);
    }

    @Test
    public void testFragments_emptyFragment() throws Exception {
        MStringModelFragment fragment = MFragmentFactory.INSTANCE.createStringModelFragment();
        String contributorURI = "testFragments_emptyFragment_contribURI";
        List elements = this.assembler.processModelFragment((MModelFragment)fragment, "testFragments_emptyFragment_contribURI", true);
        Assert.assertTrue((boolean)elements.isEmpty());
        List modelElements = this.modelService.findElements((MApplicationElement)this.application, MApplicationElement.class, 29, element -> element.getContributorURI() != null && element.getContributorURI().equals("testFragments_emptyFragment_contribURI"));
        Assert.assertTrue((boolean)modelElements.isEmpty());
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    public void testFragments_workingFragment() throws Exception {
        MWindow window = (MWindow)this.modelService.createModelElement(MWindow.class);
        String contributedElementId = "testFragments_workingFragment-contributedWindow";
        window.setElementId("testFragments_workingFragment-contributedWindow");
        MStringModelFragment fragment = MFragmentFactory.INSTANCE.createStringModelFragment();
        fragment.setFeaturename("children");
        String fragmentParentId = APPLICATION_ID;
        fragment.setParentElementId(APPLICATION_ID);
        fragment.getElements().add(window);
        Resource fragmentResource = this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        fragmentResource.getContents().add((Object)((EObject)fragment));
        Assert.assertEquals(null, (Object)this.modelService.find("testFragments_workingFragment-contributedWindow", (MUIElement)this.application));
        String contributorURI = "testFragments_emptyFragment_contribURI";
        List elements = this.assembler.processModelFragment((MModelFragment)fragment, "testFragments_emptyFragment_contribURI", false);
        Assert.assertEquals((Object)window, (Object)this.modelService.find("testFragments_workingFragment-contributedWindow", (MUIElement)this.application));
        Assert.assertEquals((long)1L, (long)elements.size());
        Assert.assertEquals((Object)"testFragments_emptyFragment_contribURI", (Object)((MApplicationElement)elements.get(0)).getContributorURI());
        Assert.assertTrue((boolean)elements.contains(window));
        MUIElement found = this.modelService.find("testFragments_workingFragment-contributedWindow", (MUIElement)this.application);
        Assert.assertEquals((Object)window, (Object)found);
        Assert.assertEquals((Object)APPLICATION_ID, (Object)found.getParent().getElementId());
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    @Ignore
    public void testFragments_existingXMIID_checkExists() throws Exception {
        MStringModelFragment fragment = MFragmentFactory.INSTANCE.createStringModelFragment();
        fragment.setFeaturename("children");
        fragment.setParentElementId(APPLICATION_ID);
        E4XMIResource fragmentResource = (E4XMIResource)this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        fragmentResource.getContents().add((Object)((EObject)fragment));
        String contributedElementId = "testFragments_existingElementID-contributedWindow";
        MWindow window1 = (MWindow)this.modelService.createModelElement(MWindow.class);
        window1.setElementId("testFragments_existingElementID-contributedWindow");
        MWindow window2 = (MWindow)this.modelService.createModelElement(MWindow.class);
        window2.setElementId("testFragments_existingElementID-contributedWindow");
        this.application.getChildren().add(window1);
        fragment.getElements().add(window2);
        String xmiId = "testFragments_existingXMIID_XMIID";
        this.appResource.setID((EObject)window1, "testFragments_existingXMIID_XMIID");
        fragmentResource.setID((EObject)window2, "testFragments_existingXMIID_XMIID");
        String contributorURI = "testFragments_existingElementID_contribURI";
        window1.setContributorURI("testFragments_existingElementID_contribURI");
        window2.setContributorURI("testFragments_existingElementID_contribURI");
        List elements = this.assembler.processModelFragment((MModelFragment)fragment, "testFragments_existingElementID_contribURI", true);
        Assert.assertEquals((long)0L, (long)elements.size());
        MUIElement found = this.modelService.find("testFragments_existingElementID-contributedWindow", (MUIElement)this.application);
        Assert.assertEquals((Object)window1, (Object)found);
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    public void testFragments_existingXMIID_ignoreExists() throws Exception {
        MStringModelFragment fragment = MFragmentFactory.INSTANCE.createStringModelFragment();
        fragment.setFeaturename("children");
        fragment.setParentElementId(APPLICATION_ID);
        E4XMIResource fragmentResource = (E4XMIResource)this.factory.createResource(URI.createURI((String)"fragmentvirtualuri"));
        this.resourceSet.getResources().add((Object)fragmentResource);
        fragmentResource.getContents().add((Object)((EObject)fragment));
        String contributedElementId = "testFragments_existingElementID-contributedWindow";
        MWindow window1 = (MWindow)this.modelService.createModelElement(MWindow.class);
        window1.setElementId("testFragments_existingElementID-contributedWindow");
        MWindow window2 = (MWindow)this.modelService.createModelElement(MWindow.class);
        window2.setElementId("testFragments_existingElementID-contributedWindow");
        this.application.getChildren().add(window1);
        fragment.getElements().add(window2);
        String xmiId = "testFragments_existingXMIID_XMIID";
        this.appResource.setID((EObject)window1, "testFragments_existingXMIID_XMIID");
        fragmentResource.setID((EObject)window2, "testFragments_existingXMIID_XMIID");
        String contributorID = "testFragments_existingElementID_contribURI";
        List elements = this.assembler.processModelFragment((MModelFragment)fragment, "testFragments_existingElementID_contribURI", false);
        Assert.assertEquals((long)elements.size(), (long)1L);
        MUIElement found = this.modelService.find("testFragments_existingElementID-contributedWindow", (MUIElement)this.application);
        Assert.assertEquals((Object)found, (Object)window2);
        Assert.assertEquals((Object)"testFragments_existingElementID_contribURI", (Object)found.getContributorURI());
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    public void testImports() {
        ArrayList<MTrimmedWindow> imports = new ArrayList<MTrimmedWindow>();
        ArrayList<MPlaceholder> addedElements = new ArrayList<MPlaceholder>();
        String windowElementId = "testImports_emptyList_window1";
        MTrimmedWindow importWindow1 = (MTrimmedWindow)this.modelService.createModelElement(MTrimmedWindow.class);
        importWindow1.setElementId("testImports_emptyList_window1");
        MModelFragments fragment = MFragmentFactory.INSTANCE.createModelFragments();
        fragment.getImports().add(importWindow1);
        imports.add(importWindow1);
        MTrimmedWindow realWindow1 = (MTrimmedWindow)this.modelService.createModelElement(MTrimmedWindow.class);
        realWindow1.setElementId("testImports_emptyList_window1");
        this.application.getChildren().add(realWindow1);
        MPlaceholder placeholder = (MPlaceholder)this.modelService.createModelElement(MPlaceholder.class);
        placeholder.setRef((MUIElement)importWindow1);
        addedElements.add(placeholder);
        this.assembler.resolveImports(imports, addedElements);
        Assert.assertEquals((Object)realWindow1, (Object)placeholder.getRef());
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    public void testImports_noImportElementId() throws Exception {
        CountDownLatch countDownLatch;
        ArrayList<MTrimmedWindow> imports = new ArrayList<MTrimmedWindow>();
        ArrayList<MPlaceholder> addedElements = new ArrayList<MPlaceholder>();
        MTrimmedWindow importWindow1 = (MTrimmedWindow)this.modelService.createModelElement(MTrimmedWindow.class);
        importWindow1.setElementId(null);
        MModelFragments fragment = MFragmentFactory.INSTANCE.createModelFragments();
        fragment.getImports().add(importWindow1);
        imports.add(importWindow1);
        MTrimmedWindow realWindow1 = (MTrimmedWindow)this.modelService.createModelElement(MTrimmedWindow.class);
        realWindow1.setElementId("testImports_emptyList_window1");
        this.application.getChildren().add(realWindow1);
        MPlaceholder placeholder = (MPlaceholder)this.modelService.createModelElement(MPlaceholder.class);
        placeholder.setRef((MUIElement)importWindow1);
        addedElements.add(placeholder);
        this.logListener.countDownLatch = countDownLatch = new CountDownLatch(1);
        this.assembler.resolveImports(imports, addedElements);
        Assert.assertEquals(null, (Object)placeholder.getRef());
        boolean completed = countDownLatch.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)"Timeout - no event received", (boolean)completed);
        Assert.assertEquals((long)1L, (long)this.logMessages.size());
        Assert.assertEquals((Object)"Could not resolve import for null", (Object)this.logMessages.poll());
    }

    @Test
    public void testModelProcessingOrder() throws Exception {
        MTrimmedWindow trimmedWindow = (MTrimmedWindow)this.modelService.createModelElement(MTrimmedWindow.class);
        trimmedWindow.setElementId("testModelProcessingOrder-trimmedWindow");
        this.application.getChildren().add(trimmedWindow);
        MPart part = (MPart)this.modelService.createModelElement(MPart.class);
        part.setElementId("testModelProcessingOrder-part");
        trimmedWindow.getChildren().add(part);
        MArea area = (MArea)this.modelService.createModelElement(MArea.class);
        area.setElementId("testModelProcessingOrder-area");
        trimmedWindow.getChildren().add(area);
        IContributor contributor = ContributorFactorySimple.createContributor((Object)BUNDLE_SYMBOLIC_NAME);
        IExtensionRegistry registry = this.createTestExtensionRegistry();
        this.assembler.setExtensionRegistry(registry);
        Assert.assertEquals((long)0L, (long)registry.getConfigurationElementsFor(EXTENSION_POINT_ID).length);
        String dataFilePath = "org.eclipse.e4.ui.tests/data/ModelAssembler/modelProcessingOrder.xml";
        registry.addContribution(this.getContentsAsInputStream(dataFilePath), contributor, false, null, null, null);
        this.assembler.processModel(true);
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    public void testPreProcessor_nonPersistedState_always() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_always.xml", true, false);
        Assert.assertEquals((long)1L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((Object)"simpleprocessor.pre", (Object)((MPartDescriptor)this.application.getDescriptors().get(0)).getElementId());
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    public void testPreProcessor_persistedState_always() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_always.xml", false, false);
        Assert.assertEquals((long)1L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((Object)"simpleprocessor.pre", (Object)((MPartDescriptor)this.application.getDescriptors().get(0)).getElementId());
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    public void testPreProcessor_nonPersistedState_initial() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_initial.xml", true, false);
        Assert.assertEquals((long)1L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((Object)"simpleprocessor.pre", (Object)((MPartDescriptor)this.application.getDescriptors().get(0)).getElementId());
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    public void testPreProcessor_persistedState_initial() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_initial.xml", false, false);
        Assert.assertEquals((long)0L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    public void testPostProcessor_persistedState_always() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_always.xml", false, true);
        Assert.assertEquals((long)1L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((Object)"simpleprocessor.post", (Object)((MPartDescriptor)this.application.getDescriptors().get(0)).getElementId());
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    public void testPostProcessor_nonPersistedState_always() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_always.xml", true, true);
        Assert.assertEquals((long)1L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((Object)"simpleprocessor.post", (Object)((MPartDescriptor)this.application.getDescriptors().get(0)).getElementId());
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    public void testPostProcessor_NonPersistedState_initial() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_initial.xml", true, true);
        Assert.assertEquals((long)1L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((Object)"simpleprocessor.post", (Object)((MPartDescriptor)this.application.getDescriptors().get(0)).getElementId());
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    public void testPostProcessor_persistedState_initial() throws Exception {
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_initial.xml", false, true);
        Assert.assertEquals((long)0L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    public void testProcessor_noProcessor() throws Exception {
        CountDownLatch countDownLatch;
        this.logListener.countDownLatch = countDownLatch = new CountDownLatch(1);
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processor_null.xml", true, false);
        boolean completed = countDownLatch.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)"Timeout - no event received", (boolean)completed);
        Assert.assertEquals((long)1L, (long)this.logMessages.size());
        Assert.assertEquals((Object)"Unable to create processor null from org.eclipse.e4.ui.tests", (Object)this.logMessages.poll());
        Assert.assertEquals((long)0L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    public void testProcessor_processorNotFound() throws Exception {
        CountDownLatch countDownLatch;
        this.logListener.countDownLatch = countDownLatch = new CountDownLatch(1);
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processor_wrongProcessorClass.xml", true, false);
        boolean completed = countDownLatch.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)"Timeout - no event received", (boolean)completed);
        Assert.assertEquals((long)1L, (long)this.logMessages.size());
        Assert.assertEquals((Object)"Unable to create processor org.eclipse.e4.ui.tests.workbench.SimplePreProcessor_NotFound from org.eclipse.e4.ui.tests", (Object)this.logMessages.poll());
        Assert.assertEquals((long)0L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
    }

    @Test
    public void testProcessor_wrongAppId() throws Exception {
        CountDownLatch countDownLatch;
        this.logListener.countDownLatch = countDownLatch = new CountDownLatch(1);
        this.application.setElementId("newID");
        this.testProcessor("org.eclipse.e4.ui.tests/data/ModelAssembler/processors_initial.xml", true, true);
        boolean completed = countDownLatch.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)"Timeout - no event received", (boolean)completed);
        Assert.assertEquals((long)1L, (long)this.logMessages.size());
        Assert.assertEquals((Object)"Could not find element with id org.eclipse.e4.ui.tests.modelassembler.app", (Object)this.logMessages.poll());
        Assert.assertEquals((long)0L, (long)this.logMessages.size());
        Assert.assertEquals((long)1L, (long)this.application.getDescriptors().size());
        Assert.assertEquals((Object)"simpleprocessor.post", (Object)((MPartDescriptor)this.application.getDescriptors().get(0)).getElementId());
    }

    private void testProcessor(String filePath, boolean initial, boolean afterFragments) throws Exception {
        IContributor contributor = ContributorFactorySimple.createContributor((Object)BUNDLE_SYMBOLIC_NAME);
        IExtensionRegistry registry = this.createTestExtensionRegistry();
        Assert.assertEquals((long)0L, (long)registry.getConfigurationElementsFor(EXTENSION_POINT_ID).length);
        registry.addContribution(this.getContentsAsInputStream(filePath), contributor, false, null, null, null);
        IExtensionPoint extPoint = registry.getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] extensions = (IExtension[])new ExtensionsSort().sort((Object[])extPoint.getExtensions());
        Assert.assertEquals((long)0L, (long)this.application.getDescriptors().size());
        this.assembler.runProcessors(extensions, initial, afterFragments);
    }

    private IExtensionRegistry createTestExtensionRegistry() {
        IExtensionRegistry defaultRegistry = RegistryFactory.getRegistry();
        IExtensionPoint extensionPoint = defaultRegistry.getExtensionPoint(EXTENSION_POINT_ID);
        ExtensionRegistry registry = (ExtensionRegistry)RegistryFactory.createRegistry(null, null, null);
        registry.addExtensionPoint(extensionPoint.getUniqueIdentifier(), extensionPoint.getContributor(), false, extensionPoint.getLabel(), extensionPoint.getSchemaReference(), null);
        this.appContext.set(IExtensionRegistry.class, (Object)registry);
        return registry;
    }

    private InputStream getContentsAsInputStream(String filePath) throws IOException {
        URI uri = URI.createPlatformPluginURI((String)filePath, (boolean)true);
        return URIConverter.INSTANCE.createInputStream(uri);
    }

    class ModelAssemblerTestLogListener
    implements LogListener {
        CountDownLatch countDownLatch;

        ModelAssemblerTestLogListener() {
        }

        public void logged(LogEntry entry) {
            ModelAssemblerTests.this.logMessages.add(entry.getMessage());
            if (this.countDownLatch != null) {
                this.countDownLatch.countDown();
            }
        }
    }
}

