/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.e4.ui.internal.workbench.PartStackUtil;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.tests.rules.WorkbenchContextRule;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ModelServiceImplTest {
    private static final String DUMMY_EDITOR_ID = "dummyEditor";
    @Rule
    public WorkbenchContextRule contextRule = new WorkbenchContextRule();
    @Inject
    private EModelService modelService;
    private MPart editor;

    @Before
    public void setUp() throws Exception {
        this.editor = (MPart)this.modelService.createModelElement(MPart.class);
        this.editor.setElementId(DUMMY_EDITOR_ID);
        this.editor.getTags().add("Editor");
    }

    @Test
    public void testModelServiceFindElementsWithEditorInSharedElements() {
        MApplication app = this.createAppWithEditorInSharedElements();
        List findElements = this.modelService.findElements((MUIElement)app, DUMMY_EDITOR_ID, MPart.class, null, 128);
        Assert.assertTrue((boolean)findElements.contains(this.editor));
    }

    private MApplication createAppWithEditorInSharedElements() {
        MApplication app = (MApplication)this.modelService.createModelElement(MApplication.class);
        MTrimmedWindow trimmedWindow = (MTrimmedWindow)this.modelService.createModelElement(MTrimmedWindow.class);
        MArea editorArea = (MArea)this.modelService.createModelElement(MArea.class);
        editorArea.setElementId("org.eclipse.ui.editorss");
        MPartStack editorPartStack = (MPartStack)this.modelService.createModelElement(MPartStack.class);
        PartStackUtil.initializeAsPrimaryDataStack((MPartStack)editorPartStack);
        editorPartStack.getChildren().add(this.editor);
        editorArea.getChildren().add(editorPartStack);
        trimmedWindow.getSharedElements().add(editorArea);
        app.getChildren().add(trimmedWindow);
        return app;
    }

    @Test
    public void testRemovePerspectiveModelWhenPerspectiveHasNoParent() {
        MPerspective perspective = (MPerspective)Mockito.mock(MPerspective.class);
        ((MPerspective)Mockito.doReturn(null).when((Object)perspective)).getParent();
        this.modelService.removePerspectiveModel(perspective, (MWindow)Mockito.mock(MWindow.class));
        ((MPerspective)Mockito.verify((Object)perspective, (VerificationMode)Mockito.never())).setToBeRendered(false);
    }
}

