/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import jakarta.inject.Inject;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.tests.rules.WorkbenchContextRule;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class PartOnTopManagerTest {
    @Rule
    public WorkbenchContextRule contextRule = new WorkbenchContextRule();
    @Inject
    private EModelService ems;
    @Inject
    private MApplication application;

    private boolean isPartOnTop(MContext context) {
        if (context.getContext() != null) {
            Object object = context.getContext().get("elementOnTop");
            return Boolean.TRUE.equals(object);
        }
        return false;
    }

    @Test
    public void test_PartOnTop() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)part));
    }

    @Test
    public void test_PlaceholderOnTop() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MPlaceholder placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholder.setRef((MUIElement)part);
        perspective.getChildren().add(placeholder);
        perspective.setSelectedElement((MUIElement)placeholder);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)part));
    }

    @Test
    public void test_PartOnTopStackSwitch() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(part);
        partStack.setSelectedElement((MUIElement)part);
        MPart secondPart = (MPart)this.ems.createModelElement(MPart.class);
        secondPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(secondPart);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)part));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        partStack.setSelectedElement((MUIElement)secondPart);
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)part));
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)secondPart));
    }

    @Test
    public void test_PlaceholderOnTopStackSwitch() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MPlaceholder placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholder.setRef((MUIElement)part);
        partStack.getChildren().add(placeholder);
        partStack.setSelectedElement((MUIElement)placeholder);
        MPart secondPart = (MPart)this.ems.createModelElement(MPart.class);
        secondPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(secondPart);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)part));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        partStack.setSelectedElement((MUIElement)secondPart);
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)part));
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)secondPart));
        partStack.setSelectedElement((MUIElement)placeholder);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)part));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
    }

    @Test
    public void test_PartOnTopPerspectiveSwitch() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPerspective secondPerspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(secondPerspective);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(part);
        partStack.setSelectedElement((MUIElement)part);
        MPart secondPart = (MPart)this.ems.createModelElement(MPart.class);
        secondPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(secondPart);
        MPart secondPerspectivePart = (MPart)this.ems.createModelElement(MPart.class);
        secondPerspectivePart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        secondPerspective.getChildren().add(secondPerspectivePart);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)part));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.switchPerspective(secondPerspective);
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)part));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)secondPerspectivePart));
    }

    @Test
    public void test_PlaceholderOnTopPerspectiveSwitch() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart sharedPart = (MPart)this.ems.createModelElement(MPart.class);
        sharedPart.setElementId("sharedPart");
        sharedPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(sharedPart);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        MPerspective firstPerspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(firstPerspective);
        perspectiveStack.setSelectedElement((MUIElement)firstPerspective);
        MPlaceholder firstPerspectivePlaceholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        firstPerspectivePlaceholder.setElementId("firstPerspectivePlaceholder");
        firstPerspectivePlaceholder.setRef((MUIElement)sharedPart);
        firstPerspective.getChildren().add(firstPerspectivePlaceholder);
        MPerspective secondPerspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(secondPerspective);
        MPartSashContainer secondPerspectiveSash = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        secondPerspective.getChildren().add(secondPerspectiveSash);
        secondPerspective.setSelectedElement((MUIElement)secondPerspectiveSash);
        MPartStack secondPerspectivePartStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        secondPerspectiveSash.getChildren().add(secondPerspectivePartStack);
        secondPerspectiveSash.setSelectedElement((MUIElement)secondPerspectivePartStack);
        MPlaceholder secondPerspectivePartStackPlaceholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        secondPerspectivePartStackPlaceholder.setElementId("secondPerspectivePartStackPlaceholder");
        secondPerspectivePartStackPlaceholder.setRef((MUIElement)sharedPart);
        secondPerspectivePartStack.getChildren().add(secondPerspectivePartStackPlaceholder);
        MPart secondPart = (MPart)this.ems.createModelElement(MPart.class);
        secondPart.setElementId("secondPart");
        secondPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        secondPerspectivePartStack.getChildren().add(secondPart);
        secondPerspectivePartStack.setSelectedElement((MUIElement)secondPart);
        MPart secondPerspectiveOnTopPart = (MPart)this.ems.createModelElement(MPart.class);
        secondPerspectiveOnTopPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        secondPerspectiveSash.getChildren().add(secondPerspectiveOnTopPart);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)sharedPart));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPerspectiveOnTopPart));
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.switchPerspective(secondPerspective);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)sharedPart));
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)secondPerspectiveOnTopPart));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        secondPerspectivePartStack.setSelectedElement((MUIElement)secondPerspectivePartStackPlaceholder);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)sharedPart));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)secondPerspectiveOnTopPart));
        partService.switchPerspective(firstPerspective);
        Assert.assertTrue((boolean)this.isPartOnTop((MContext)sharedPart));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPart));
        Assert.assertFalse((boolean)this.isPartOnTop((MContext)secondPerspectiveOnTopPart));
    }
}

