/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import jakarta.inject.Inject;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.statusreporter.StatusReporter;
import org.eclipse.e4.ui.internal.workbench.swt.IEventLoopAdvisor;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.tests.rules.WorkbenchContextRule;
import org.eclipse.e4.ui.tests.workbench.Bug374326;
import org.eclipse.e4.ui.tests.workbench.LayoutView;
import org.eclipse.e4.ui.tests.workbench.SampleToolControl;
import org.eclipse.e4.ui.tests.workbench.SampleView;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.addons.cleanupaddon.CleanupAddon;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.test.Screenshots;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.rules.TestWatcher;
import org.osgi.service.log.LogLevel;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class PartRenderingEngineTests {
    @Rule
    public WorkbenchContextRule contextRule = new WorkbenchContextRule();
    @Inject
    private IEclipseContext appContext;
    @Inject
    private EModelService ems;
    @Inject
    private MApplication application;
    private final LogListener listener = entry -> {
        if (!this.logged) {
            this.logged = entry.getLogLevel() == LogLevel.ERROR;
        }
    };
    private boolean logged = false;
    private Consumer<RuntimeException> runtimeExceptionHandler;
    @Rule
    public TestName testName = new TestName();
    @Rule
    public TestWatcher screenshotRule = Screenshots.onFailure(null);

    @Before
    public void setUp() {
        this.logged = false;
        LogReaderService logReaderService = (LogReaderService)this.appContext.get(LogReaderService.class);
        logReaderService.addLogListener(this.listener);
    }

    @After
    public void tearDown() throws Exception {
        LogReaderService logReaderService = (LogReaderService)this.appContext.get(LogReaderService.class);
        logReaderService.removeLogListener(this.listener);
    }

    private void checkLog() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)this.logged);
    }

    private void addRuntimeExceptionHandler() {
        Display display = Display.getDefault();
        this.runtimeExceptionHandler = display.getRuntimeExceptionHandler();
        display.setRuntimeExceptionHandler(e -> this.handle((Throwable)e, new IEventLoopAdvisor(){

            public void eventLoopIdle(Display display) {
                display.sleep();
            }

            public void eventLoopException(Throwable exception) {
                StatusReporter statusReporter = (StatusReporter)PartRenderingEngineTests.this.appContext.get(StatusReporter.class);
                if (statusReporter != null) {
                    statusReporter.report(statusReporter.newStatus(4, "Internal Error", exception), 32, new Object[]{exception});
                }
            }
        }));
    }

    private void handle(Throwable ex, IEventLoopAdvisor advisor) {
        try {
            try {
                advisor.eventLoopException(ex);
            }
            catch (Throwable t) {
                if ("ThreadDeath".equals(t.getClass().getSimpleName())) {
                    throw t;
                }
                t.printStackTrace();
                this.resetRuntimeExceptionHandler();
            }
        }
        finally {
            this.resetRuntimeExceptionHandler();
        }
    }

    private void resetRuntimeExceptionHandler() {
        if (this.runtimeExceptionHandler != null) {
            Display.getDefault().setRuntimeExceptionHandler(this.runtimeExceptionHandler);
        }
    }

    @Test
    public void ensureRemovalOfWindowDoesNotResultInExceptionBug298415() {
        MWindow window = this.createWindowWithOneView("Part Name");
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        IPresentationEngine renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class);
        renderer.removeGui((MUIElement)part);
        renderer.removeGui((MUIElement)window);
        this.contextRule.spinEventLoop();
    }

    @Test
    public void testAddWindowBug299219() throws Exception {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)window.getWidget());
        MWindow window2 = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window2);
        Assert.assertNotNull((Object)window2.getWidget());
    }

    @Test
    public void testPartStack_SetActiveChildBug299379() throws Exception {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        this.contextRule.createAndRunWorkbench(window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        Assert.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class);
        service.activate(partB);
        Assert.assertEquals((String)"Activating another part should've altered the tab folder's selection", (long)1L, (long)tabFolder.getSelectionIndex());
    }

    @Test
    public void testPartStack_SetActiveChild2Bug299379() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        stack.setSelectedElement((MUIElement)partA);
        this.contextRule.createAndRunWorkbench(window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        Assert.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class);
        service.showPart(partB.getElementId(), EPartService.PartState.ACTIVATE);
        Assert.assertEquals((String)"Showing a part should alter the tab folder's selection", (long)1L, (long)tabFolder.getSelectionIndex());
    }

    @Test
    public void testPartStack_SetActiveChild3Bug299379() {
        MPartDescriptor descriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        descriptor.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        descriptor.setElementId("part");
        descriptor.setCategory("aStack");
        this.application.getDescriptors().add(descriptor);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        stack.getTags().add("aStack");
        window.getChildren().add(stack);
        this.contextRule.createAndRunWorkbench(window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        Assert.assertEquals((long)0L, (long)tabFolder.getItemCount());
        EPartService service = (EPartService)window.getContext().get(EPartService.class);
        MPart shownPart = service.showPart("part", EPartService.PartState.ACTIVATE);
        Assert.assertEquals((long)1L, (long)tabFolder.getItemCount());
        Assert.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
        Assert.assertEquals((String)"The shown part should be the active part", (Object)shownPart, (Object)stack.getSelectedElement());
    }

    @Test
    public void testPartStack_SetActiveChild4Bug299379() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        this.contextRule.createAndRunWorkbench(window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        Assert.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
        stack.setSelectedElement((MUIElement)partB);
        Assert.assertEquals((String)"Switching the active child should've changed the folder's selection", (long)1L, (long)tabFolder.getSelectionIndex());
    }

    @Test
    public void testPartStack_SetActiveChild5Bug295250() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partB);
        Assert.assertEquals((String)"Adding a part to a stack should not cause the stack's active child to change", (Object)partA, (Object)stack.getSelectedElement());
        Assert.assertNull((String)"The object should not have been instantiated", (Object)partB.getObject());
    }

    @Test
    public void testPartStack_SetActiveChild6Bug298797() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        this.contextRule.createAndRunWorkbench(window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        Assert.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
        Assert.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partB);
        Assert.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
        Assert.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        stack.setSelectedElement((MUIElement)partB);
        Assert.assertEquals((long)1L, (long)tabFolder.getSelectionIndex());
        Assert.assertEquals((Object)partB, (Object)stack.getSelectedElement());
    }

    @Test
    public void testPartStack_ViewMenuHidenWhenPartsClosed_Bug377228() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(part);
        MMenu menu = (MMenu)this.ems.createModelElement(MMenu.class);
        menu.getTags().add("ViewMenu");
        part.getMenus().add(menu);
        MDirectMenuItem item = (MDirectMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        menu.getChildren().add(item);
        this.contextRule.createAndRunWorkbench(window);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        Composite compA = (Composite)folder.getTopRight();
        ToolBar toolbar = null;
        Control[] controlArray = compA.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.getData().equals("ViewMenu")) {
                toolbar = (ToolBar)child;
            }
            ++n2;
        }
        Assert.assertNotNull(toolbar);
        Assert.assertTrue((boolean)toolbar.getVisible());
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.hidePart(part, true);
        this.contextRule.spinEventLoop();
        Assert.assertFalse((boolean)toolbar.getVisible());
    }

    @Test
    public void testPartStack_ViewMenuShowWhenItemsAdded_Bug385083() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(part);
        MMenu menu = (MMenu)this.ems.createModelElement(MMenu.class);
        menu.getTags().add("ViewMenu");
        part.getMenus().add(menu);
        this.contextRule.createAndRunWorkbench(window);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        Composite compA = (Composite)folder.getTopRight();
        ToolBar toolbar = null;
        Control[] controlArray = compA.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (child.getData().equals("ViewMenu")) {
                toolbar = (ToolBar)child;
            }
            ++n2;
        }
        Assert.assertNotNull(toolbar);
        Assert.assertFalse((boolean)toolbar.getVisible());
        MDirectMenuItem item = (MDirectMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        menu.getChildren().add(item);
        this.contextRule.spinEventLoop();
        Assert.assertTrue((boolean)toolbar.getVisible());
    }

    @Test
    public void testCreateGuiBug301021() {
        MPartDescriptor descriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        descriptor.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        descriptor.setElementId("part");
        descriptor.setCategory("aStack");
        this.application.getDescriptors().add(descriptor);
        MPartDescriptor descriptor2 = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        descriptor2.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        descriptor2.setElementId("part2");
        descriptor2.setCategory("aStack");
        this.application.getDescriptors().add(descriptor2);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MPartSashContainer partSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        stack.setElementId("aStack");
        partSashContainer.getChildren().add(stack);
        window.getChildren().add(partSashContainer);
        this.application.getChildren().add(window);
        MWindow window2 = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window2);
        this.contextRule.createAndRunWorkbench(window);
        IPresentationEngine engine = (IPresentationEngine)this.appContext.get(IPresentationEngine.class);
        engine.createGui((MUIElement)window2);
        EPartService service = (EPartService)window2.getContext().get(EPartService.class);
        service.showPart("part", EPartService.PartState.VISIBLE);
        service.showPart("part", EPartService.PartState.CREATE);
        service.showPart("part2", EPartService.PartState.CREATE);
        this.contextRule.spinEventLoop();
    }

    @Test
    public void testPart_ToBeRendered() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        this.contextRule.createAndRunWorkbench(window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        Assert.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class);
        service.activate(partB);
        Assert.assertEquals((long)1L, (long)tabFolder.getSelectionIndex());
        partB.setToBeRendered(false);
        Assert.assertEquals((long)1L, (long)tabFolder.getItemCount());
        Assert.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
        Assert.assertEquals((Object)partA, (Object)stack.getSelectedElement());
    }

    @Test
    public void testPart_ToBeRendered2() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partB.setToBeRendered(false);
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        stack.setSelectedElement((MUIElement)partA);
        this.contextRule.createAndRunWorkbench(window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        Assert.assertEquals((long)1L, (long)tabFolder.getItemCount());
        Assert.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
        partB.setToBeRendered(true);
        Assert.assertEquals((String)"Rendering another part in the stack should not change the selection", (long)0L, (long)tabFolder.getSelectionIndex());
        Assert.assertEquals((Object)partA, (Object)stack.getSelectedElement());
        Assert.assertEquals((long)2L, (long)tabFolder.getItemCount());
        Assert.assertNotNull((Object)partB.getObject());
    }

    @Test
    public void testClientObjectUnsetWhenNotRenderedBug301439() {
        MWindow window = this.createWindowWithOneView("");
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        MPartSashContainer container = (MPartSashContainer)window.getChildren().get(0);
        MPartStack stack = (MPartStack)container.getChildren().get(0);
        MPart part = (MPart)stack.getChildren().get(0);
        Assert.assertNotNull((Object)part.getWidget());
        Assert.assertNotNull((Object)part.getRenderer());
        Assert.assertNotNull((Object)part.getObject());
        part.setToBeRendered(false);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        Assert.assertNull((Object)part.getWidget());
        Assert.assertNull((Object)part.getRenderer());
        Assert.assertNull((Object)part.getObject());
        Assert.assertEquals((long)0L, (long)tabFolder.getItemCount());
    }

    @Test
    public void testCTabItem_SetControl_Bug304211() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.setSelectedElement((MUIElement)partA);
        this.contextRule.createAndRunWorkbench(window);
        IPresentationEngine engine = (IPresentationEngine)this.appContext.get(IPresentationEngine.class);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        CTabItem itemA = folder.getItem(0);
        Assert.assertEquals((String)"The presentation engine should have created the part and set it", (Object)partA.getWidget(), (Object)itemA.getControl());
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partB);
        CTabItem item2 = folder.getItem(1);
        Assert.assertNull((String)"For a stack, the object will not be rendered unless explicitly required", (Object)item2.getControl());
        engine.createGui((MUIElement)partB);
        Assert.assertEquals((String)"The presentation engine should have created the part and set it", (Object)partB.getWidget(), (Object)item2.getControl());
        stack.setSelectedElement((MUIElement)partB);
        Assert.assertEquals((String)"Selecting the element should not have changed anything", (Object)partB.getWidget(), (Object)item2.getControl());
    }

    @Test
    public void testToBeRenderedCausesSelectionChanges() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        this.contextRule.createAndRunWorkbench(window);
        CTabFolder tabFolder = (CTabFolder)stack.getWidget();
        Assert.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
        EPartService service = (EPartService)window.getContext().get(EPartService.class);
        service.activate(partB);
        Assert.assertEquals((long)1L, (long)tabFolder.getSelectionIndex());
        service.activate(partA);
        partA.setToBeRendered(false);
        Assert.assertEquals((long)1L, (long)tabFolder.getItemCount());
        Assert.assertEquals((long)0L, (long)tabFolder.getSelectionIndex());
        Assert.assertEquals((Object)partB, (Object)stack.getSelectedElement());
    }

    @Test
    public void testSetSelectedElement() {
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        boolean causedException = false;
        try {
            stack.setSelectedElement((MUIElement)partA);
        }
        catch (IllegalArgumentException e) {
            causedException = true;
        }
        Assert.assertFalse((String)"Exception should not have been thrown", (boolean)causedException);
        causedException = false;
        try {
            stack.setSelectedElement((MUIElement)partC);
        }
        catch (IllegalArgumentException e) {
            causedException = true;
        }
        Assert.assertTrue((String)"Exception should have been thrown", (boolean)causedException);
    }

    @Test
    public void testSelectedElementNullingTBR() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartSashContainer container = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(container);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partC.setElementId("partC");
        partC.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        container.getChildren().add(partA);
        container.getChildren().add(partB);
        container.getChildren().add(partC);
        this.contextRule.createAndRunWorkbench(window);
        container.setSelectedElement((MUIElement)partA);
        partB.setToBeRendered(false);
        Assert.assertEquals((String)"Changing the TBR of a non-selected element should not change the value of the container's seletedElement", (Object)partA, (Object)container.getSelectedElement());
        container.setSelectedElement((MUIElement)partA);
        partA.setToBeRendered(false);
        Assert.assertNotEquals((String)"Changing the TBR of the selected element should have moved selection to a TBR item", (Object)partA, (Object)container.getSelectedElement());
        if ("gtk".equals(SWT.getPlatform())) {
            Assert.assertTrue((String)"Changing the TBR of the selected element should have moved selection to a TBR item", (boolean)((MPartSashContainerElement)container.getSelectedElement()).isToBeRendered());
            partC.setToBeRendered(false);
            Assert.assertNull((String)"Changing the TBR of all elements to false should have set the field to null", (Object)container.getSelectedElement());
        } else {
            Assert.assertNull((String)"Changing the TBR of the selected element should have set the field to null", (Object)container.getSelectedElement());
        }
    }

    @Test
    public void testSelectedElementNullingParentChange() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        MPartSashContainer container = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(container);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setElementId("partA");
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setElementId("partB");
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partC.setElementId("partC");
        partC.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        container.getChildren().add(partA);
        container.getChildren().add(partB);
        container.getChildren().add(partC);
        this.contextRule.createAndRunWorkbench(window);
        container.setSelectedElement((MUIElement)partA);
        container.getChildren().remove(partB);
        Assert.assertEquals((String)"Changing the parent of a non-selected element should not change the value of the container's seletedElement", (Object)partA, (Object)container.getSelectedElement());
        container.setSelectedElement((MUIElement)partA);
        container.getChildren().remove(partA);
        Assert.assertNull((String)"Changing the parent of the selected element should have set the field to null", (Object)container.getSelectedElement());
    }

    @Test
    public void testCreateGuiBug301950() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getChildren().add(part);
        IPresentationEngine renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class);
        renderer.createGui((MUIElement)part);
        renderer.removeGui((MUIElement)part);
        this.contextRule.spinEventLoop();
    }

    @Test
    public void testRemoveGuiBug307578() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partB);
        this.contextRule.createAndRunWorkbench(window);
        CTabFolder folder = (CTabFolder)stack.getWidget();
        Assert.assertEquals((long)2L, (long)folder.getItemCount());
        Assert.assertNull((Object)partB.getRenderer());
        Assert.assertNull((Object)partB.getObject());
        Assert.assertNull((Object)partB.getWidget());
        IPresentationEngine renderer = (IPresentationEngine)this.appContext.get(IPresentationEngine.class);
        renderer.removeGui((MUIElement)partB);
        Assert.assertEquals((long)1L, (long)folder.getItemCount());
    }

    @Test
    public void testRemoveGuiBug324033() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partC.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)partA.getObject());
        Assert.assertNull((Object)partB.getObject());
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).removeGui((MUIElement)partC);
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).removeGui((MUIElement)partStack);
        Assert.assertNull((Object)partA.getObject());
        Assert.assertNull((Object)partB.getObject());
    }

    @Test
    public void testRemoveGuiBug323496() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPlaceholder placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholder.setRef((MUIElement)part);
        part.setCurSharedRef(placeholder);
        perspective.getChildren().add(placeholder);
        perspective.setSelectedElement((MUIElement)placeholder);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)part.getObject());
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).removeGui((MUIElement)perspective);
        Assert.assertNull((Object)part.getObject());
    }

    @Test
    public void testBug324839() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(partB);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)partA.getObject());
        Assert.assertNull((Object)partB.getObject());
        ((EPartService)this.appContext.get(EPartService.class)).hidePart(partA, true);
        Assert.assertNull((Object)partA.getObject());
        Assert.assertNotNull((Object)partB.getObject());
    }

    @Test
    public void testBug317591_NonSharedPart() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(partA);
        stack.setSelectedElement((MUIElement)partA);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)partA.getObject());
        stack.setToBeRendered(false);
        Assert.assertNull((Object)partA.getObject());
    }

    @Test
    public void testBug317591_SharedPart() {
        MPartDescriptor descriptorA = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        descriptorA.setElementId("sharedA");
        descriptorA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        this.application.getDescriptors().add(descriptorA);
        MPartDescriptor descriptorB = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        descriptorB.setElementId("sharedB");
        descriptorB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        this.application.getDescriptors().add(descriptorB);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        this.contextRule.createAndRunWorkbench(window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        MPlaceholder placeholderA = partService.createSharedPart("sharedA");
        stack.getChildren().add(placeholderA);
        stack.setSelectedElement((MUIElement)placeholderA);
        MPart partA = (MPart)placeholderA.getRef();
        Assert.assertNotNull((Object)partA.getObject());
        stack.setToBeRendered(false);
        Assert.assertNull((Object)partA.getObject());
    }

    @Test
    public void testRemoveGuiBug324228_1() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveA.setElementId("perspectiveA");
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)part);
        part.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveB.setElementId("perspectiveB");
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)part);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        this.contextRule.createAndRunWorkbench(window);
        SampleView view = (SampleView)part.getObject();
        Assert.assertFalse((boolean)view.isDestroyed());
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        ((EModelService)this.appContext.get(EModelService.class)).removePerspectiveModel(perspectiveB, window);
        Assert.assertFalse((boolean)view.isDestroyed());
        Assert.assertNotNull((Object)part.getContext().getParent());
        Assert.assertEquals((Object)perspectiveA.getContext(), (Object)part.getContext().getParent());
    }

    @Test
    public void testRemoveGuiBug324228_2() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveA.setElementId("perspectiveA");
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)part);
        part.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveB.setElementId("perspectiveB");
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)part);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        this.contextRule.createAndRunWorkbench(window);
        SampleView view = (SampleView)part.getObject();
        Assert.assertFalse((boolean)view.isDestroyed());
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        placeholderB.setToBeRendered(false);
        Assert.assertFalse((boolean)view.isDestroyed());
        Assert.assertNotNull((Object)part.getContext().getParent());
        Assert.assertEquals((Object)perspectiveA.getContext(), (Object)part.getContext().getParent());
    }

    @Test
    public void testRemoveGuiBug324228_3() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getSharedElements().add(partStack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(part);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveA.setElementId("perspectiveA");
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)partStack);
        partStack.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveB.setElementId("perspectiveB");
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partStack);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        this.contextRule.createAndRunWorkbench(window);
        SampleView view = (SampleView)part.getObject();
        Assert.assertFalse((boolean)view.isDestroyed());
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        placeholderB.setToBeRendered(false);
        Assert.assertFalse((boolean)view.isDestroyed());
        Assert.assertNotNull((Object)part.getContext().getParent());
        Assert.assertEquals((Object)perspectiveA.getContext(), (Object)part.getContext().getParent());
    }

    @Test
    public void testRemoveGuiBug324228_4() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getSharedElements().add(partStack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(part);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveA.setElementId("perspectiveA");
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)partStack);
        partStack.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveB.setElementId("perspectiveB");
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partStack);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        this.contextRule.createAndRunWorkbench(window);
        SampleView view = (SampleView)part.getObject();
        Assert.assertFalse((boolean)view.isDestroyed());
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        ((EModelService)this.appContext.get(EModelService.class)).removePerspectiveModel(perspectiveB, window);
        Assert.assertFalse((boolean)view.isDestroyed());
        Assert.assertNotNull((Object)part.getContext().getParent());
        Assert.assertEquals((Object)perspectiveA.getContext(), (Object)part.getContext().getParent());
    }

    @Test
    public void testRemoveGuiBug324230() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartSashContainer sashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(sashContainer);
        window.setSelectedElement((MUIElement)sashContainer);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setToBeRendered(false);
        sashContainer.getChildren().add(part);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)sashContainer.getWidget());
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).removeGui((MUIElement)sashContainer);
        Assert.assertNull((Object)sashContainer.getWidget());
    }

    @Test
    public void testBug317849() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartSashContainer sashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(sashContainer);
        window.setSelectedElement((MUIElement)sashContainer);
        MPlaceholder sharedAreaPlaceholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        sashContainer.getChildren().add(sharedAreaPlaceholder);
        sashContainer.setSelectedElement((MUIElement)sharedAreaPlaceholder);
        MPartSashContainer sharedSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getSharedElements().add(sharedSashContainer);
        sharedAreaPlaceholder.setRef((MUIElement)sharedSashContainer);
        sharedSashContainer.setCurSharedRef(sharedAreaPlaceholder);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        sharedSashContainer.getChildren().add(partStack);
        sharedSashContainer.setSelectedElement((MUIElement)partStack);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)partStack.getWidget());
        Assert.assertNotNull((Object)sharedSashContainer.getWidget());
        Assert.assertNotNull((Object)sashContainer.getWidget());
    }

    @Test
    public void testBug326087() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartSashContainer sashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(sashContainer);
        window.setSelectedElement((MUIElement)sashContainer);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        sashContainer.getChildren().add(partStack);
        sashContainer.setSelectedElement((MUIElement)partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)partA.getWidget());
        Assert.assertNull((Object)partB.getWidget());
        partStack.setSelectedElement((MUIElement)partB);
        Assert.assertNotNull((Object)partA.getWidget());
        Assert.assertNotNull((Object)partB.getWidget());
        ((IPresentationEngine)this.application.getContext().get(IPresentationEngine.class)).removeGui((MUIElement)sashContainer);
        Assert.assertEquals((Object)partB, (Object)partStack.getSelectedElement());
    }

    @Test
    public void testBug327701() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getSharedElements().add(partStack);
        MPart part1 = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(part1);
        MPart part2 = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(part2);
        partStack.setSelectedElement((MUIElement)part2);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)partStack);
        partStack.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)partStack);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        this.contextRule.createAndRunWorkbench(window);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveB);
        perspectiveB.getContext().activate();
        perspectiveB.setToBeRendered(false);
        Assert.assertEquals((Object)perspectiveA.getContext(), (Object)part2.getContext().getParent());
    }

    @Test
    public void testBug326699() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getSharedElements().add(partStack);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder partStackPlaceholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partStack.setCurSharedRef(partStackPlaceholderA);
        partStackPlaceholderA.setRef((MUIElement)partStack);
        perspectiveA.getChildren().add(partStackPlaceholderA);
        perspectiveA.setSelectedElement((MUIElement)partStackPlaceholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder partStackPlaceholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partStackPlaceholderB.setRef((MUIElement)partStack);
        perspectiveB.getChildren().add(partStackPlaceholderB);
        perspectiveB.setSelectedElement((MUIElement)partStackPlaceholderB);
        MPart part1 = (MPart)this.ems.createModelElement(MPart.class);
        part1.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(part1);
        partStack.setSelectedElement((MUIElement)part1);
        MPart part2 = (MPart)this.ems.createModelElement(MPart.class);
        part2.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(part2);
        this.contextRule.createAndRunWorkbench(window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(part1);
        partService.activate(part2);
        partService.activate(part1);
        partService.switchPerspective(perspectiveB);
        partService.switchPerspective(perspectiveA);
        SampleView view1 = (SampleView)part1.getObject();
        SampleView view2 = (SampleView)part2.getObject();
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).removeGui((MUIElement)window);
        Assert.assertFalse((boolean)view1.nullParentContext);
        Assert.assertFalse((boolean)view2.nullParentContext);
    }

    @Test
    public void testBug327807() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart part1 = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(part1);
        partStack.setSelectedElement((MUIElement)part1);
        MPart part2 = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(part2);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertEquals((Object)part1, (Object)partStack.getSelectedElement());
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).removeGui((MUIElement)window);
        Assert.assertEquals((Object)part1, (Object)partStack.getSelectedElement());
    }

    @Test
    public void testBug328629() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartSashContainer partSashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        partSashContainer.setToBeRendered(false);
        window.getChildren().add(partSashContainer);
        this.contextRule.createAndRunWorkbench(window);
        partSashContainer.setToBeRendered(true);
    }

    @Test
    public void test331685() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        this.contextRule.createAndRunWorkbench(window);
        IPresentationEngine engine = (IPresentationEngine)this.appContext.get(IPresentationEngine.class);
        engine.removeGui((MUIElement)part);
        Assert.assertNull((Object)part.getWidget());
        engine.createGui((MUIElement)part, null, window.getContext());
        engine.removeGui((MUIElement)part);
    }

    @Test
    public void testBug331795_1() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)part.getObject());
        Assert.assertNotNull((Object)part.getContext());
        this.addRuntimeExceptionHandler();
        SampleView view = (SampleView)part.getObject();
        view.errorOnWidgetDisposal = true;
        part.setToBeRendered(false);
        Assert.assertTrue((String)"The view should have been destroyed", (boolean)view.isDestroyed());
        Assert.assertNull((Object)part.getObject());
        Assert.assertNull((Object)part.getContext());
    }

    @Test
    public void testBug331795_2() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)part.getObject());
        Assert.assertNotNull((Object)part.getContext());
        this.addRuntimeExceptionHandler();
        SampleView view = (SampleView)part.getObject();
        view.errorOnPreDestroy = true;
        part.setToBeRendered(false);
        Assert.assertTrue((String)"The view should have been destroyed", (boolean)view.isDestroyed());
        Assert.assertNull((Object)part.getObject());
        Assert.assertNull((Object)part.getContext());
    }

    @Test
    public void testBug329079() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setVisible(false);
        window.getChildren().add(part);
        this.contextRule.createAndRunWorkbench(window);
    }

    @Test
    public void testRemoveGui_Bug332163() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective1 = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective1);
        perspectiveStack.setSelectedElement((MUIElement)perspective1);
        MPlaceholder partPlaceholderA1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholderA1.setRef((MUIElement)part);
        part.setCurSharedRef(partPlaceholderA1);
        perspective1.getChildren().add(partPlaceholderA1);
        perspective1.setSelectedElement((MUIElement)partPlaceholderA1);
        MPerspective perspective2 = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective2);
        MPlaceholder partPlaceholder2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        partPlaceholder2.setRef((MUIElement)part);
        perspective2.getChildren().add(partPlaceholder2);
        perspective2.setSelectedElement((MUIElement)partPlaceholder2);
        this.contextRule.createAndRunWorkbench(window);
        IEclipseContext perspectiveContext1 = perspective1.getContext();
        IEclipseContext partContext = part.getContext();
        Assert.assertEquals((Object)perspectiveContext1, (Object)partContext.getParent());
        Assert.assertEquals((Object)partContext, (Object)perspectiveContext1.getActiveChild());
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.switchPerspective(perspective2);
        IEclipseContext perspectiveContext2 = perspective2.getContext();
        Assert.assertEquals((Object)partContext, (Object)perspectiveContext1.getActiveChild());
        Assert.assertEquals((Object)perspectiveContext2, (Object)partContext.getParent());
        Assert.assertEquals((Object)partContext, (Object)perspectiveContext2.getActiveChild());
        partService.hidePart(part);
        Assert.assertEquals((Object)perspectiveContext1, (Object)partContext.getParent());
        Assert.assertEquals((Object)partContext, (Object)perspectiveContext1.getActiveChild());
        Assert.assertNull((String)"perspective2 doesn't have any parts, it should not have an active child context", (Object)perspectiveContext2.getActiveChild());
    }

    @Test
    public void testBug334644_01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        window.setToBeRendered(false);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNull((String)"No widget for an unrendered window", (Object)window.getWidget());
        Assert.assertNull((String)"No context for an unrendered window", (Object)window.getContext());
        window.setToBeRendered(true);
        Assert.assertNotNull((String)"Rendered window should have a widget", (Object)window.getWidget());
        Assert.assertNotNull((String)"Rendered window should have a context", (Object)window.getContext());
    }

    @Test
    public void testBug334644_02() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        window.setToBeRendered(true);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((String)"Rendered window should have a widget", (Object)window.getWidget());
        Assert.assertNotNull((String)"Rendered window should have a context", (Object)window.getContext());
        window.setToBeRendered(false);
        Assert.assertNull((String)"No widget for an unrendered window", (Object)window.getWidget());
        Assert.assertNull((String)"No context for an unrendered window", (Object)window.getContext());
    }

    @Test
    public void testRemoveGui_Bug334577_01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        perspective.getWindows().add(detachedWindow);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)detachedWindow.getContext());
        Assert.assertNotNull((Object)detachedWindow.getWidget());
        perspective.setToBeRendered(false);
        Assert.assertNull((Object)detachedWindow.getContext());
        Assert.assertNull((Object)detachedWindow.getWidget());
    }

    @Test
    public void testRemoveGui_Bug334577_02() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        window.getWindows().add(detachedWindow);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)detachedWindow.getContext());
        Assert.assertNotNull((Object)detachedWindow.getWidget());
        window.setToBeRendered(false);
        Assert.assertNull((Object)detachedWindow.getContext());
        Assert.assertNull((Object)detachedWindow.getWidget());
    }

    @Test
    public void testBug336139() {
        MTrimmedWindow window = (MTrimmedWindow)this.ems.createModelElement(MTrimmedWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MTrimBar trimBar = (MTrimBar)this.ems.createModelElement(MTrimBar.class);
        window.getTrimBars().add(trimBar);
        MToolControl toolControl = (MToolControl)this.ems.createModelElement(MToolControl.class);
        trimBar.getChildren().add(toolControl);
        this.contextRule.createAndRunWorkbench((MWindow)window);
    }

    @Test
    public void testBut336225() {
        MTrimmedWindow window = (MTrimmedWindow)this.ems.createModelElement(MTrimmedWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MTrimBar trimBar = (MTrimBar)this.ems.createModelElement(MTrimBar.class);
        window.getTrimBars().add(trimBar);
        MToolControl toolControl = (MToolControl)this.ems.createModelElement(MToolControl.class);
        toolControl.setContributionURI(SampleToolControl.CONTRIBUTION_URI);
        trimBar.getChildren().add(toolControl);
        this.contextRule.createAndRunWorkbench((MWindow)window);
        SampleToolControl impl = (SampleToolControl)toolControl.getObject();
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).removeGui((MUIElement)window);
        Assert.assertFalse((String)"The shell should not have been disposed first", (boolean)impl.shellEagerlyDestroyed);
    }

    @Test
    public void testBug330662() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        window.getSharedElements().add(area);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        area.getChildren().add(partStack);
        area.setSelectedElement((MUIElement)partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveA.setElementId("perspectiveA");
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)area);
        area.setCurSharedRef(placeholderA);
        perspectiveA.getChildren().add(placeholderA);
        perspectiveA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveB.setElementId("perspectiveB");
        perspectiveStack.getChildren().add(perspectiveB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)area);
        perspectiveB.getChildren().add(placeholderB);
        perspectiveB.setSelectedElement((MUIElement)placeholderB);
        this.contextRule.createAndRunWorkbench(window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.showPart(partB, EPartService.PartState.ACTIVATE);
        partService.switchPerspective(perspectiveB);
        ((IPresentationEngine)window.getContext().get(IPresentationEngine.class)).removeGui((MUIElement)perspectiveA);
        Assert.assertEquals((Object)perspectiveB.getContext(), (Object)partA.getContext().getParent());
        Assert.assertEquals((Object)perspectiveB.getContext(), (Object)partB.getContext().getParent());
    }

    @Test
    public void testBug335444_A() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        this.contextRule.createAndRunWorkbench(window);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        window.getWindows().add(detachedWindow);
        Assert.assertNotNull((Object)detachedWindow.getContext());
        Assert.assertNotNull((Object)detachedWindow.getWidget());
        Assert.assertNotNull((Object)detachedWindow.getRenderer());
    }

    @Test
    public void testBug335444_B() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        this.contextRule.createAndRunWorkbench(window);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        perspective.getWindows().add(detachedWindow);
        Assert.assertNotNull((Object)detachedWindow.getContext());
        Assert.assertNotNull((Object)detachedWindow.getWidget());
        Assert.assertNotNull((Object)detachedWindow.getRenderer());
    }

    @Test
    public void testBug335444_C() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        detachedWindow.setToBeRendered(false);
        window.getWindows().add(detachedWindow);
        this.contextRule.createAndRunWorkbench(window);
        detachedWindow.setToBeRendered(true);
        Assert.assertNotNull((Object)detachedWindow.getContext());
        Assert.assertNotNull((Object)detachedWindow.getWidget());
        Assert.assertNotNull((Object)detachedWindow.getRenderer());
    }

    @Test
    public void testBug335444_D() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        detachedWindow.setToBeRendered(false);
        perspective.getWindows().add(detachedWindow);
        this.contextRule.createAndRunWorkbench(window);
        detachedWindow.setToBeRendered(true);
        Assert.assertNotNull((Object)detachedWindow.getContext());
        Assert.assertNotNull((Object)detachedWindow.getWidget());
        Assert.assertNotNull((Object)detachedWindow.getRenderer());
    }

    private void testBug326175(boolean visible) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        this.contextRule.createAndRunWorkbench(window);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        detachedWindow.setVisible(visible);
        window.getWindows().add(detachedWindow);
        ((IPresentationEngine)this.appContext.get(IPresentationEngine.class)).createGui((MUIElement)detachedWindow);
        if (visible) {
            Assert.assertEquals((Object)detachedWindow.getContext(), (Object)window.getContext().getActiveChild());
        } else {
            Assert.assertEquals((Object)part.getContext(), (Object)window.getContext().getActiveChild());
        }
    }

    @Ignore
    @Test
    public void TODOtestBug326175_True() {
        this.testBug326175(true);
    }

    @Test
    public void testBug326175_False() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        this.testBug326175(false);
    }

    @Test
    public void testCreateGui_Bug319004() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        this.contextRule.createAndRunWorkbench(window);
        MToolBar toolBar = (MToolBar)this.ems.createModelElement(MToolBar.class);
        part.setToolbar(toolBar);
        IPresentationEngine engine = (IPresentationEngine)this.appContext.get(IPresentationEngine.class);
        engine.createGui((MUIElement)toolBar);
    }

    @Test
    public void testBug339286() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MToolBar toolBarA = (MToolBar)this.ems.createModelElement(MToolBar.class);
        partA.setToolbar(toolBarA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(partB);
        MToolBar toolBarB = (MToolBar)this.ems.createModelElement(MToolBar.class);
        partB.setToolbar(toolBarB);
        this.contextRule.createAndRunWorkbench(window);
        Widget widgetA = (Widget)toolBarA.getWidget();
        Widget widgetB = (Widget)toolBarB.getWidget();
        Assert.assertNotNull((Object)widgetA);
        Assert.assertFalse((boolean)widgetA.isDisposed());
        Assert.assertNull((Object)widgetB);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB);
        widgetA = (Widget)toolBarA.getWidget();
        widgetB = (Widget)toolBarB.getWidget();
        Assert.assertNotNull((Object)widgetA);
        Assert.assertFalse((boolean)widgetA.isDisposed());
        Assert.assertNotNull((Object)widgetB);
        Assert.assertFalse((boolean)widgetB.isDisposed());
    }

    @Test
    public void testBug334580_01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MToolBar toolBar = (MToolBar)this.ems.createModelElement(MToolBar.class);
        part.setToolbar(toolBar);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveA.setElementId("perspectiveA");
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveA.getChildren().add(partStackA);
        perspectiveA.setSelectedElement((MUIElement)partStackA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)part);
        part.setCurSharedRef(placeholderA);
        partStackA.getChildren().add(placeholderA);
        partStackA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveB.setElementId("perspectiveB");
        perspectiveStack.getChildren().add(perspectiveB);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveB.getChildren().add(partStackB);
        perspectiveB.setSelectedElement((MUIElement)partStackB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)part);
        partStackB.getChildren().add(placeholderB);
        partStackB.setSelectedElement((MUIElement)placeholderB);
        this.contextRule.createAndRunWorkbench(window);
        Shell limboShell = (Shell)this.appContext.get("limbo");
        Assert.assertNotNull((Object)limboShell);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.switchPerspective(perspectiveB);
        partService.switchPerspective(perspectiveA);
        Control control = (Control)toolBar.getWidget();
        Assert.assertNotNull((Object)control);
        Assert.assertFalse((boolean)control.isDisposed());
        partService.hidePart(part);
        control = (Control)toolBar.getWidget();
        Assert.assertNotNull((Object)control);
        Assert.assertFalse((boolean)control.isDisposed());
        Assert.assertEquals((Object)limboShell, (Object)control.getShell());
        partService.switchPerspective(perspectiveB);
        partService.hidePart(part);
        Assert.assertTrue((boolean)control.isDisposed());
        Assert.assertNull((Object)toolBar.getWidget());
    }

    @Test
    public void testBug334580_02() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MToolBar toolBarA = (MToolBar)this.ems.createModelElement(MToolBar.class);
        partA.setToolbar(toolBarA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        partStack.getChildren().add(partB);
        MToolBar toolBarB = (MToolBar)this.ems.createModelElement(MToolBar.class);
        partB.setToolbar(toolBarB);
        this.contextRule.createAndRunWorkbench(window);
        Shell limboShell = (Shell)this.appContext.get("limbo");
        Assert.assertNotNull((Object)limboShell);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB);
        partService.activate(partA);
        Control controlA = (Control)toolBarA.getWidget();
        Control controlB = (Control)toolBarB.getWidget();
        Assert.assertNotNull((Object)controlA);
        Assert.assertFalse((boolean)controlA.isDisposed());
        Assert.assertNotNull((Object)controlB);
        Assert.assertFalse((boolean)controlB.isDisposed());
        partService.hidePart(partA);
        controlB = (Control)toolBarB.getWidget();
        Assert.assertNull((Object)toolBarA.getWidget());
        Assert.assertTrue((boolean)controlA.isDisposed());
        Assert.assertNotNull((Object)controlB);
        Assert.assertFalse((boolean)controlB.isDisposed());
        partService.hidePart(partB);
        Assert.assertNull((Object)toolBarA.getWidget());
        Assert.assertNull((Object)toolBarB.getWidget());
        Assert.assertTrue((boolean)controlB.isDisposed());
    }

    @Test
    public void testBug334580_03() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partA);
        partStack.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        this.contextRule.createAndRunWorkbench(window);
        Shell limboShell = (Shell)this.appContext.get("limbo");
        Assert.assertNotNull((Object)limboShell);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.activate(partB);
        partService.activate(partA);
        partService.hidePart(partA);
        Assert.assertFalse((boolean)this.logged);
    }

    @Test
    public void testBug342439_01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setVisible(false);
        partStack.getChildren().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partB);
        this.contextRule.createAndRunWorkbench(window);
        CTabFolder folder = (CTabFolder)partStack.getWidget();
        Assert.assertEquals((long)1L, (long)folder.getItemCount());
        Assert.assertNull((Object)partA.getWidget());
        partA.setVisible(true);
        Assert.assertEquals((long)2L, (long)folder.getItemCount());
        Assert.assertNull((Object)partA.getWidget());
        ((EPartService)window.getContext().get(EPartService.class)).showPart(partA, EPartService.PartState.ACTIVATE);
        Assert.assertEquals((long)2L, (long)folder.getItemCount());
        Assert.assertNotNull((Object)partA.getWidget());
    }

    @Test
    public void testBug342439_02() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setVisible(false);
        partStack.getChildren().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partB);
        this.contextRule.createAndRunWorkbench(window);
        CTabFolder folder = (CTabFolder)partStack.getWidget();
        Assert.assertEquals((long)1L, (long)folder.getItemCount());
        partA.setToBeRendered(false);
        Assert.assertEquals((long)1L, (long)folder.getItemCount());
        partA.setVisible(true);
        Assert.assertEquals((long)1L, (long)folder.getItemCount());
        partA.setVisible(false);
        Assert.assertEquals((long)1L, (long)folder.getItemCount());
    }

    @Test
    public void testBug342366() throws Exception {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(partStack);
        window.setSelectedElement((MUIElement)partStack);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partB);
        partStack.setSelectedElement((MUIElement)partB);
        this.contextRule.createAndRunWorkbench(window);
        CTabFolder folder = (CTabFolder)partStack.getWidget();
        Assert.assertEquals((long)2L, (long)folder.getItemCount());
        partA.setVisible(false);
        Assert.assertEquals((long)1L, (long)folder.getItemCount());
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStack.getChildren().add(partC);
        this.checkLog();
    }

    @Test
    public void testBug343305() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MToolBar toolBar = (MToolBar)this.ems.createModelElement(MToolBar.class);
        part.setToolbar(toolBar);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveA.getChildren().add(partStackA);
        perspectiveA.setSelectedElement((MUIElement)partStackA);
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)part);
        part.setCurSharedRef(placeholderA);
        partStackA.getChildren().add(placeholderA);
        partStackA.setSelectedElement((MUIElement)placeholderA);
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspectiveB);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveB.getChildren().add(partStackB);
        perspectiveB.setSelectedElement((MUIElement)partStackB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setToBeRendered(false);
        placeholderB.setRef((MUIElement)part);
        partStackB.getChildren().add(placeholderB);
        this.contextRule.createAndRunWorkbench(window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.switchPerspective(perspectiveB);
        partService.switchPerspective(perspectiveA);
        Control control = (Control)toolBar.getWidget();
        Composite stackIntermediate = control.getParent();
        Control parent = (Control)partStackA.getWidget();
        Assert.assertEquals((Object)parent, (Object)stackIntermediate.getParent());
        partStackB.setToBeRendered(false);
        stackIntermediate = control.getParent();
        Assert.assertEquals((Object)parent, (Object)stackIntermediate.getParent());
    }

    @Test
    public void testBug343442() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MToolBar toolBar = (MToolBar)this.ems.createModelElement(MToolBar.class);
        part.setToolbar(toolBar);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspective.getChildren().add(partStack);
        perspective.setSelectedElement((MUIElement)partStack);
        MPlaceholder placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholder.setRef((MUIElement)part);
        part.setCurSharedRef(placeholder);
        partStack.getChildren().add(placeholder);
        partStack.setSelectedElement((MUIElement)placeholder);
        this.contextRule.createAndRunWorkbench(window);
        partStack.getChildren().remove(placeholder);
        partStack.getChildren().add(placeholder);
        partStack.setSelectedElement((MUIElement)placeholder);
        Assert.assertEquals((Object)partStack.getWidget(), (Object)((Control)toolBar.getWidget()).getParent().getParent());
    }

    @Test
    public void testBug343524() {
        MTrimmedWindow window = (MTrimmedWindow)this.ems.createModelElement(MTrimmedWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MTrimBar trimBar = (MTrimBar)this.ems.createModelElement(MTrimBar.class);
        window.getTrimBars().add(trimBar);
        this.contextRule.createAndRunWorkbench((MWindow)window);
        Assert.assertNotNull((Object)trimBar.getWidget());
        trimBar.setToBeRendered(false);
        Assert.assertNull((Object)trimBar.getWidget());
        trimBar.setToBeRendered(true);
        Assert.assertNotNull((Object)trimBar.getWidget());
    }

    @Test
    public void ensureCleanUpAddonCleansUp() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPartSashContainer sashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(sashContainer);
        window.setSelectedElement((MUIElement)sashContainer);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        sashContainer.getChildren().add(partStackA);
        sashContainer.setSelectedElement((MUIElement)partStackA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partStackA.getChildren().add(partA);
        partStackA.setSelectedElement((MUIElement)partA);
        MPartStack partStackForPartBPartC = (MPartStack)this.ems.createModelElement(MPartStack.class);
        sashContainer.getChildren().add(partStackForPartBPartC);
        sashContainer.setSelectedElement((MUIElement)partStackForPartBPartC);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.getTags().add("removeOnHide");
        partStackForPartBPartC.getChildren().add(partB);
        partStackForPartBPartC.setSelectedElement((MUIElement)partB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partC.getTags().add("removeOnHide");
        partStackForPartBPartC.getChildren().add(partC);
        partStackForPartBPartC.setSelectedElement((MUIElement)partC);
        MPartStack partStackForEditor = (MPartStack)this.ems.createModelElement(MPartStack.class);
        partStackForEditor.getTags().add("NoAutoCollapse");
        sashContainer.getChildren().add(partStackForEditor);
        MPart editor = (MPart)this.ems.createModelElement(MPart.class);
        editor.getTags().add("removeOnHide");
        partStackForEditor.getChildren().add(editor);
        partStackForEditor.setSelectedElement((MUIElement)editor);
        ContextInjectionFactory.make(CleanupAddon.class, (IEclipseContext)this.appContext);
        this.contextRule.createAndRunWorkbench(window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.hidePart(partA);
        this.contextRule.spinEventLoop();
        Assert.assertTrue((String)" PartStack with children should be rendered", (boolean)partStackForPartBPartC.isToBeRendered());
        partService.hidePart(partB);
        partService.hidePart(partC);
        this.contextRule.spinEventLoop();
        Assert.assertFalse((String)"CleanupAddon should ensure that partStack is not rendered anymore, as all childs have been removed", (boolean)partStackForPartBPartC.isToBeRendered());
        Assert.assertFalse((String)"Part stack should be removed", (boolean)partStackForPartBPartC.isToBeRendered());
        partService.hidePart(editor, true);
        this.contextRule.spinEventLoop();
        Assert.assertTrue((String)"PartStack with IPresentationEngine.NO_AUTO_COLLAPSE should not be closed if children are removed", (boolean)partStackForEditor.isToBeRendered());
    }

    @Test
    public void testBug332463() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MArea area = (MArea)this.ems.createModelElement(MArea.class);
        window.getChildren().add(area);
        window.setSelectedElement((MUIElement)area);
        MPartSashContainer sashContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        area.getChildren().add(sashContainer);
        area.setSelectedElement((MUIElement)sashContainer);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        sashContainer.getChildren().add(partStackA);
        sashContainer.setSelectedElement((MUIElement)partStackA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partStackA.getChildren().add(partA);
        partStackA.setSelectedElement((MUIElement)partA);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partStackA.getChildren().add(partB);
        partStackA.setSelectedElement((MUIElement)partB);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        sashContainer.getChildren().add(partStackB);
        sashContainer.setSelectedElement((MUIElement)partStackB);
        MPart partC = (MPart)this.ems.createModelElement(MPart.class);
        partStackB.getChildren().add(partC);
        partStackB.setSelectedElement((MUIElement)partC);
        ContextInjectionFactory.make(CleanupAddon.class, (IEclipseContext)this.appContext);
        this.contextRule.createAndRunWorkbench(window);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.hidePart(partB);
        this.contextRule.spinEventLoop();
        partService.hidePart(partA, true);
        this.contextRule.spinEventLoop();
        partService.hidePart(partC, true);
        this.contextRule.spinEventLoop();
        Assert.assertNotNull((Object)area.getWidget());
        Assert.assertTrue((boolean)area.isToBeRendered());
    }

    @Test
    public void testBug348215_PartOnlyContextReparent() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        window.getWindows().add(detachedWindow);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        detachedWindow.getChildren().add(part);
        detachedWindow.setSelectedElement((MUIElement)part);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)part.getContext());
        Assert.assertEquals((Object)detachedWindow.getContext(), (Object)part.getContext().getParent());
        detachedWindow.getChildren().remove(part);
        window.getChildren().add(part);
        Assert.assertNotNull((Object)part.getContext());
        Assert.assertEquals((Object)part.getContext().getParent(), (Object)window.getContext());
    }

    @Test
    public void testBug348215_PartContextReparent() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        window.getWindows().add(detachedWindow);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        detachedWindow.getChildren().add(stack);
        detachedWindow.setSelectedElement((MUIElement)stack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        stack.getChildren().add(part);
        stack.setSelectedElement((MUIElement)part);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)part.getContext());
        Assert.assertEquals((Object)part.getContext().getParent(), (Object)detachedWindow.getContext());
        detachedWindow.getChildren().remove(stack);
        window.getChildren().add(stack);
        Assert.assertNotNull((Object)part.getContext());
        Assert.assertEquals((Object)part.getContext().getParent(), (Object)window.getContext());
    }

    @Test
    public void testBug348215_PartPlaceholderContextReparent() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        window.getWindows().add(detachedWindow);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        detachedWindow.getChildren().add(stack);
        detachedWindow.setSelectedElement((MUIElement)stack);
        MPlaceholder ph = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        ph.setRef((MUIElement)part);
        stack.getChildren().add(ph);
        stack.setSelectedElement((MUIElement)ph);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)part.getContext());
        Assert.assertEquals((Object)part.getContext().getParent(), (Object)detachedWindow.getContext());
        detachedWindow.getChildren().remove(stack);
        window.getChildren().add(stack);
        Assert.assertNotNull((Object)part.getContext());
        Assert.assertEquals((Object)part.getContext().getParent(), (Object)window.getContext());
    }

    @Test
    public void testBug349076() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPlaceholder ph = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        ph.setRef((MUIElement)part);
        part.setCurSharedRef(ph);
        stack.getChildren().add(ph);
        stack.setSelectedElement((MUIElement)ph);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        window.getWindows().add(detachedWindow);
        MPartStack detachedStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        detachedWindow.getChildren().add(detachedStack);
        detachedWindow.setSelectedElement((MUIElement)detachedStack);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)part.getContext());
        Assert.assertEquals((Object)part.getContext().getParent(), (Object)window.getContext());
        stack.getChildren().remove(ph);
        detachedStack.getChildren().add(ph);
        Assert.assertNotNull((Object)part.getContext());
        Assert.assertEquals((Object)part.getContext().getParent(), (Object)detachedWindow.getContext());
    }

    @Test
    public void testBug369229() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MPartSashContainer container = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(container);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setContributionURI(LayoutView.CONTRIBUTION_URI);
        container.getChildren().add(partA);
        MPartSashContainer innerContainer = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        container.getChildren().add(innerContainer);
        MPartSashContainer innerContainer2 = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        innerContainer.getChildren().add(innerContainer2);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setContributionURI(LayoutView.CONTRIBUTION_URI);
        innerContainer.getChildren().add(partB);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)partA.getWidget());
        Assert.assertNotNull((Object)partB.getWidget());
    }

    @Test
    public void testBug348069_01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        this.contextRule.createAndRunWorkbench(window);
        SampleView view = (SampleView)part.getObject();
        Assert.assertFalse((boolean)view.isDestroyed());
        ((Shell)window.getWidget()).close();
        Assert.assertTrue((boolean)view.isDestroyed());
        Assert.assertTrue((boolean)this.application.getChildren().contains(window));
    }

    @Test
    public void testBug348069_02() {
        MWindow windowA = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowA);
        this.application.setSelectedElement((MUIElement)windowA);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        partA.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        windowA.getChildren().add(partA);
        windowA.setSelectedElement((MUIElement)partA);
        MWindow windowB = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(windowB);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        partB.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        windowB.getChildren().add(partB);
        windowB.setSelectedElement((MUIElement)partB);
        this.contextRule.createAndRunWorkbench(windowA);
        this.contextRule.createAndRunWorkbench(windowB);
        SampleView viewA = (SampleView)partA.getObject();
        Assert.assertFalse((boolean)viewA.isDestroyed());
        SampleView viewB = (SampleView)partB.getObject();
        Assert.assertFalse((boolean)viewB.isDestroyed());
        ((Shell)windowB.getWidget()).close();
        Assert.assertTrue((boolean)viewB.isDestroyed());
        Assert.assertFalse((boolean)windowB.isToBeRendered());
        Assert.assertFalse((boolean)this.application.getChildren().contains(windowB));
        ((Shell)windowA.getWidget()).close();
        Assert.assertTrue((boolean)viewA.isDestroyed());
        Assert.assertTrue((boolean)windowA.isToBeRendered());
        Assert.assertTrue((boolean)this.application.getChildren().contains(windowA));
    }

    @Test
    public void testBug348069_DetachedWindow_01() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        window.getWindows().add(detachedWindow);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        detachedWindow.getChildren().add(part);
        detachedWindow.setSelectedElement((MUIElement)part);
        this.contextRule.createAndRunWorkbench(window);
        SampleView view = (SampleView)part.getObject();
        Assert.assertFalse((boolean)view.isDestroyed());
        ((Shell)detachedWindow.getWidget()).close();
        Assert.assertTrue((boolean)view.isDestroyed());
        Assert.assertTrue((boolean)window.getWindows().contains(detachedWindow));
    }

    @Test
    public void testBug348069_DetachedWindow_02() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        window.getWindows().add(detachedWindow);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        detachedWindow.getChildren().add(part);
        detachedWindow.setSelectedElement((MUIElement)part);
        this.contextRule.createAndRunWorkbench(window);
        SampleView view = (SampleView)part.getObject();
        Assert.assertFalse((boolean)view.isDestroyed());
        detachedWindow.setSelectedElement(null);
        detachedWindow.getChildren().remove(part);
        window.getChildren().add(part);
        ((Shell)detachedWindow.getWidget()).close();
        Assert.assertFalse((boolean)view.isDestroyed());
        Assert.assertFalse((boolean)window.getWindows().contains(detachedWindow));
    }

    @Test
    public void testBug348069_DetachedWindow_03() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        window.getWindows().add(detachedWindow);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        detachedWindow.getChildren().add(part);
        detachedWindow.setSelectedElement((MUIElement)part);
        this.contextRule.createAndRunWorkbench(window);
        SampleView view = (SampleView)part.getObject();
        Assert.assertFalse((boolean)view.isDestroyed());
        ((Shell)detachedWindow.getWidget()).close();
        Assert.assertTrue((boolean)view.isDestroyed());
        Assert.assertTrue((boolean)window.getWindows().contains(detachedWindow));
    }

    private void testBug348069_DetachedPerspectiveWindow_01(boolean createPlaceholder) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        perspective.getWindows().add(detachedWindow);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        detachedWindow.getChildren().add(partStack);
        detachedWindow.setSelectedElement((MUIElement)partStack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        if (createPlaceholder) {
            window.getSharedElements().add(part);
            MPlaceholder placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
            placeholder.setRef((MUIElement)part);
            part.setCurSharedRef(placeholder);
            partStack.getChildren().add(placeholder);
            partStack.setSelectedElement((MUIElement)placeholder);
        } else {
            partStack.getChildren().add(part);
            partStack.setSelectedElement((MUIElement)part);
        }
        this.contextRule.createAndRunWorkbench(window);
        SampleView view = (SampleView)part.getObject();
        Assert.assertFalse((boolean)view.isDestroyed());
        ((Shell)detachedWindow.getWidget()).close();
        Assert.assertTrue((boolean)view.isDestroyed());
        Assert.assertTrue((boolean)perspective.getWindows().contains(detachedWindow));
    }

    @Test
    public void testBug348069_DetachedPerspectiveWindow_01_TRUE() {
        this.testBug348069_DetachedPerspectiveWindow_01(true);
    }

    @Test
    public void testBug348069_DetachedPerspectiveWindow_01_FALSE() {
        this.testBug348069_DetachedPerspectiveWindow_01(false);
    }

    private void testBug348069_DetachedPerspectiveWindow_02(boolean createPlaceholder) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MWindow detachedWindow = (MWindow)this.ems.createModelElement(MWindow.class);
        perspective.getWindows().add(detachedWindow);
        MPartStack partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        detachedWindow.getChildren().add(partStack);
        detachedWindow.setSelectedElement((MUIElement)partStack);
        MPlaceholder placeholder = null;
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        if (createPlaceholder) {
            window.getSharedElements().add(part);
            placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
            placeholder.setRef((MUIElement)part);
            part.setCurSharedRef(placeholder);
            partStack.getChildren().add(placeholder);
            partStack.setSelectedElement((MUIElement)placeholder);
        } else {
            partStack.getChildren().add(part);
            partStack.setSelectedElement((MUIElement)part);
        }
        this.contextRule.createAndRunWorkbench(window);
        SampleView view = (SampleView)part.getObject();
        Assert.assertFalse((boolean)view.isDestroyed());
        if (createPlaceholder) {
            partStack.setSelectedElement(null);
            partStack.getChildren().remove(placeholder);
            perspective.getChildren().add(placeholder);
        } else {
            partStack.setSelectedElement(null);
            partStack.getChildren().remove(part);
            perspective.getChildren().add(part);
        }
        ((Shell)detachedWindow.getWidget()).close();
        Assert.assertFalse((boolean)view.isDestroyed());
        Assert.assertFalse((boolean)perspective.getWindows().contains(detachedWindow));
    }

    @Test
    public void testBug348069_DetachedPerspectiveWindow_02_TRUE() {
        this.testBug348069_DetachedPerspectiveWindow_02(true);
    }

    @Test
    public void testBug348069_DetachedPerspectiveWindow_02_FALSE() {
        this.testBug348069_DetachedPerspectiveWindow_02(false);
    }

    @Test
    public void testBug371100() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        window.getChildren().add(stack);
        window.setSelectedElement((MUIElement)stack);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setVisible(false);
        stack.getChildren().add(part);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        stack.setSelectedElement((MUIElement)part);
        Assert.assertFalse((boolean)this.logged);
    }

    @Test
    public void testBug372226() {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537639", (boolean)"macosx".equals(Platform.getOS()));
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        Shell subShell = new Shell((Shell)window.getWidget());
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(part);
        ((EModelService)this.appContext.get(EModelService.class)).hostElement((MUIElement)part, window, (Object)subShell, window.getContext());
        Control control = (Control)part.getWidget();
        Assert.assertEquals((Object)subShell, (Object)control.getParent());
        ((EPartService)this.appContext.get(EPartService.class)).activate(part);
        Assert.assertEquals((Object)subShell, (Object)control.getParent());
    }

    @Test
    public void testBug374326() {
        MTrimmedWindow window = (MTrimmedWindow)this.ems.createModelElement(MTrimmedWindow.class);
        MTrimBar trim = (MTrimBar)this.ems.createModelElement(MTrimBar.class);
        window.getTrimBars().add(trim);
        MToolBar toolBar = (MToolBar)this.ems.createModelElement(MToolBar.class);
        trim.getChildren().add(toolBar);
        MToolControl dummyToolControl = (MToolControl)this.ems.createModelElement(MToolControl.class);
        toolBar.getChildren().add(dummyToolControl);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench((MWindow)window);
        MToolControl toolControl = (MToolControl)this.ems.createModelElement(MToolControl.class);
        toolControl.setVisible(false);
        toolControl.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.Bug374326");
        toolBar.getChildren().add(toolControl);
        Assert.assertNull((Object)toolControl.getObject());
        toolControl.setVisible(true);
        Bug374326 obj = (Bug374326)toolControl.getObject();
        Shell shell = (Shell)window.getWidget();
        Assert.assertEquals((Object)shell, (Object)obj.getControl().getShell());
    }

    private MWindow createWindowWithOneView(String partName) {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        window.setHeight(300);
        window.setWidth(400);
        window.setLabel("MyWindow");
        MPartSashContainer sash = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(sash);
        MPartStack stack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        sash.getChildren().add(stack);
        MPart contributedPart = (MPart)this.ems.createModelElement(MPart.class);
        stack.getChildren().add(contributedPart);
        contributedPart.setLabel(partName);
        contributedPart.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        return window;
    }

    @Test
    public void testBug564299() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        window.getSharedElements().add(part);
        part.setContributionURI("platform:/plugin/org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        MToolBar toolbar = (MToolBar)this.ems.createModelElement(MToolBar.class);
        part.setToolbar(toolbar);
        MPartSashContainer partSash = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        window.getChildren().add(partSash);
        MPlaceholder placeholder1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholder1.setRef((MUIElement)part);
        partSash.getChildren().add(placeholder1);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        partSash.getChildren().add(perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        MPlaceholder placeholder2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholder2.setRef((MUIElement)part);
        perspective.getChildren().add(placeholder2);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertTrue((boolean)placeholder1.isToBeRendered());
        Assert.assertTrue((boolean)placeholder2.isToBeRendered());
        MDirectToolItem item = (MDirectToolItem)this.ems.createModelElement(MDirectToolItem.class);
        toolbar.getChildren().add(item);
        Assert.assertTrue((boolean)placeholder1.isToBeRendered());
        Assert.assertTrue((boolean)placeholder2.isToBeRendered());
    }

    @Test
    public void test369434() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspective.setVisible(false);
        perspectiveStack.getChildren().add(perspective);
        perspectiveStack.setSelectedElement((MUIElement)perspective);
        this.application.getChildren().add(window);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertFalse((boolean)this.logged);
    }

    @Test
    public void test_persistState_371087() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)part.getObject());
        Assert.assertNotNull((Object)part.getContext());
        this.addRuntimeExceptionHandler();
        SampleView view = (SampleView)part.getObject();
        view.errorOnWidgetDisposal = true;
        part.setToBeRendered(false);
        Assert.assertTrue((String)"The view should have been destroyed", (boolean)view.isStatePersisted());
        Assert.assertNull((Object)part.getObject());
        Assert.assertNull((Object)part.getContext());
    }

    @Test
    public void test_persistState_371087_1() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getChildren().add(part);
        window.setSelectedElement((MUIElement)part);
        this.contextRule.createAndRunWorkbench(window);
        Assert.assertNotNull((Object)part.getObject());
        Assert.assertNotNull((Object)part.getContext());
        this.addRuntimeExceptionHandler();
        SampleView view = (SampleView)part.getObject();
        view.errorOnWidgetDisposal = true;
        window.setToBeRendered(false);
        Assert.assertTrue((String)"The view should have been destroyed", (boolean)view.isStatePersisted());
        Assert.assertNull((Object)part.getObject());
        Assert.assertNull((Object)part.getContext());
    }

    @Test
    public void testCurSharedRefBug457939() {
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(window);
        this.application.setSelectedElement((MUIElement)window);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setContributionURI("bundleclass://org.eclipse.e4.ui.tests/org.eclipse.e4.ui.tests.workbench.SampleView");
        window.getSharedElements().add(part);
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        window.getChildren().add(perspectiveStack);
        window.setSelectedElement((MUIElement)perspectiveStack);
        MPerspective perspectiveA = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveA.setElementId("perspectiveA");
        perspectiveStack.getChildren().add(perspectiveA);
        perspectiveStack.setSelectedElement((MUIElement)perspectiveA);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveA.getChildren().add(partStackA);
        perspectiveA.setSelectedElement((MUIElement)partStackA);
        Assert.assertNull((Object)part.getCurSharedRef());
        MPlaceholder placeholderA = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderA.setRef((MUIElement)part);
        part.setCurSharedRef(placeholderA);
        partStackA.getChildren().add(placeholderA);
        partStackA.setSelectedElement((MUIElement)placeholderA);
        Assert.assertEquals((Object)placeholderA, (Object)part.getCurSharedRef());
        MPerspective perspectiveB = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspectiveB.setElementId("perspectiveB");
        perspectiveStack.getChildren().add(perspectiveB);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        perspectiveB.getChildren().add(partStackB);
        perspectiveB.setSelectedElement((MUIElement)partStackB);
        MPlaceholder placeholderB = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholderB.setRef((MUIElement)part);
        partStackB.getChildren().add(placeholderB);
        partStackB.setSelectedElement((MUIElement)placeholderB);
        Assert.assertEquals((Object)placeholderA, (Object)part.getCurSharedRef());
        this.contextRule.createAndRunWorkbench(window);
        Shell limboShell = (Shell)this.appContext.get("limbo");
        Assert.assertNotNull((Object)limboShell);
        EPartService partService = (EPartService)window.getContext().get(EPartService.class);
        partService.switchPerspective(perspectiveB);
        Assert.assertEquals((Object)placeholderB, (Object)part.getCurSharedRef());
        partService.switchPerspective(perspectiveA);
        Assert.assertEquals((Object)placeholderA, (Object)part.getCurSharedRef());
        EModelService modelService = (EModelService)window.getContext().get(EModelService.class);
        modelService.removePerspectiveModel(perspectiveA, window);
        Assert.assertEquals((Object)perspectiveB, (Object)modelService.getActivePerspective(window));
        Assert.assertEquals((Object)placeholderB, (Object)part.getCurSharedRef());
        partService.switchPerspective(perspectiveB);
        modelService.removePerspectiveModel(perspectiveB, window);
        Assert.assertNull((Object)part.getCurSharedRef());
    }
}

