/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MBasicFactory;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class SWTPartRendererTest {
    private SWTPartRenderer renderer;
    private Shell shell;
    private MPart part;
    private IEclipseContext context;
    private Map<String, Object[]> stylingEngineExecutedMethods;

    @Before
    public void setUp() throws Exception {
        this.renderer = new SWTPartRenderer(){

            public Object createWidget(MUIElement element, Object parent) {
                return null;
            }
        };
        this.shell = Display.getDefault().getActiveShell();
        this.stylingEngineExecutedMethods = new HashMap<String, Object[]>();
        this.context = EclipseContextFactory.create();
        this.context.set(IStylingEngine.class, (Object)((IStylingEngine)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IStylingEngine.class}, (proxy, method, args) -> {
            this.stylingEngineExecutedMethods.put(method.getName(), args);
            return null;
        })));
        this.part = MBasicFactory.INSTANCE.createPart();
        this.part.setElementId("org.eclipse.elementId");
        this.part.setContext(this.context);
    }

    @Test
    public void testSetCSSInfo() throws Exception {
        Button button = new Button((Composite)this.shell, 8);
        this.renderer.setCSSInfo((MUIElement)this.part, (Object)button);
        Object[] setClassnameAndIdParams = this.stylingEngineExecutedMethods.get("setClassnameAndId");
        Assert.assertNotNull((Object)setClassnameAndIdParams);
        Assert.assertEquals((long)3L, (long)setClassnameAndIdParams.length);
        Assert.assertEquals((Object)button, (Object)setClassnameAndIdParams[0]);
        Assert.assertEquals((Object)"MPart", (Object)setClassnameAndIdParams[1].toString());
        Assert.assertEquals((Object)"org-eclipse-elementId", (Object)setClassnameAndIdParams[2].toString());
    }

    @Test
    public void testSetCSSInfoWhenUIElementWithTags() throws Exception {
        Button button = new Button((Composite)this.shell, 8);
        this.part.getTags().add("tag1");
        this.part.getTags().add("tag2");
        this.renderer.setCSSInfo((MUIElement)this.part, (Object)button);
        Object[] setClassnameAndIdParams = this.stylingEngineExecutedMethods.get("setClassnameAndId");
        Assert.assertNotNull((Object)setClassnameAndIdParams);
        Assert.assertEquals((long)3L, (long)setClassnameAndIdParams.length);
        Assert.assertEquals((Object)button, (Object)setClassnameAndIdParams[0]);
        Assert.assertEquals((Object)"MPart tag1 tag2", (Object)setClassnameAndIdParams[1].toString());
        Assert.assertEquals((Object)"org-eclipse-elementId", (Object)setClassnameAndIdParams[2].toString());
    }

    @Test
    public void testSetCSSInfoWhenNoCSSStylingEngineInContext() throws Exception {
        Button button = new Button((Composite)this.shell, 8);
        this.context.remove(IStylingEngine.class);
        this.renderer.setCSSInfo((MUIElement)this.part, (Object)button);
        Object[] setClassnameAndIdParams = this.stylingEngineExecutedMethods.get("setClassnameAndId");
        Assert.assertNull((Object)setClassnameAndIdParams);
    }
}

