/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.E4Workbench;
import org.eclipse.e4.ui.internal.workbench.swt.E4Application;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.swt.widgets.Display;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SashRendererTest {
    private IEclipseContext appContext;
    private E4Workbench wb;
    private EModelService ems;

    @Before
    public void setUp() throws Exception {
        this.appContext = E4Application.createDefaultContext();
        this.appContext.set("presentationURI", (Object)"bundleclass://org.eclipse.e4.ui.workbench.swt/org.eclipse.e4.ui.internal.workbench.swt.PartRenderingEngine");
        this.ems = (EModelService)this.appContext.get(EModelService.class);
    }

    @After
    public void tearDown() throws Exception {
        if (this.wb != null) {
            this.wb.close();
        }
        this.appContext.dispose();
    }

    @Test
    public void testBug310027() {
        MApplication application = (MApplication)this.ems.createModelElement(MApplication.class);
        MWindow window = (MWindow)this.ems.createModelElement(MWindow.class);
        MPartSashContainer container = (MPartSashContainer)this.ems.createModelElement(MPartSashContainer.class);
        MPartStack partStackA = (MPartStack)this.ems.createModelElement(MPartStack.class);
        MPartStack partStackB = (MPartStack)this.ems.createModelElement(MPartStack.class);
        MPart partA = (MPart)this.ems.createModelElement(MPart.class);
        MPart partB = (MPart)this.ems.createModelElement(MPart.class);
        window.setWidth(600);
        window.setHeight(400);
        partStackA.setContainerData("50");
        partStackB.setContainerData("50");
        application.getChildren().add(window);
        application.setSelectedElement((MUIElement)window);
        window.getChildren().add(container);
        window.setSelectedElement((MUIElement)container);
        container.getChildren().add(partStackA);
        container.getChildren().add(partStackB);
        container.setSelectedElement((MUIElement)partStackA);
        partStackA.getChildren().add(partA);
        partStackA.setSelectedElement((MUIElement)partA);
        partStackA.getChildren().add(partB);
        partStackA.setSelectedElement((MUIElement)partB);
        application.setContext(this.appContext);
        this.appContext.set(MApplication.class, (Object)application);
        this.wb = new E4Workbench((MApplicationElement)application, this.appContext);
        this.wb.createAndRunUI((MApplicationElement)window);
        Assert.assertEquals((Object)"50", (Object)partStackA.getContainerData());
        Assert.assertEquals((Object)"50", (Object)partStackB.getContainerData());
        partStackB.setToBeRendered(false);
        while (Display.getDefault().readAndDispatch()) {
        }
        Assert.assertEquals((Object)"50", (Object)partStackA.getContainerData());
    }
}

