/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.workbench;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.e4.ui.internal.workbench.TopologicalSort;
import org.junit.Assert;
import org.junit.Test;

public class TopoSortTests {
    @Test
    public void testTopoSorter() {
        TestSorter ts = new TestSorter();
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type;
            ts.type = type = typeArray[n2];
            List<Integer> results = Arrays.asList((Integer[])ts.sort(ts.getTestData()));
            Assert.assertTrue((results.indexOf(1) < results.indexOf(2) ? 1 : 0) != 0);
            Assert.assertTrue((results.indexOf(1) < results.indexOf(3) ? 1 : 0) != 0);
            Assert.assertTrue((results.indexOf(1) < results.indexOf(5) ? 1 : 0) != 0);
            Assert.assertTrue((results.indexOf(1) < results.indexOf(7) ? 1 : 0) != 0);
            Assert.assertTrue((results.indexOf(2) < results.indexOf(4) ? 1 : 0) != 0);
            Assert.assertTrue((results.indexOf(2) < results.indexOf(6) ? 1 : 0) != 0);
            Assert.assertTrue((results.indexOf(2) < results.indexOf(10) ? 1 : 0) != 0);
            Assert.assertTrue((results.indexOf(3) < results.indexOf(6) ? 1 : 0) != 0);
            Assert.assertTrue((results.indexOf(3) < results.indexOf(9) ? 1 : 0) != 0);
            Assert.assertTrue((results.indexOf(4) < results.indexOf(8) ? 1 : 0) != 0);
            Assert.assertTrue((results.indexOf(5) < results.indexOf(10) ? 1 : 0) != 0);
            ++n2;
        }
    }

    @Test
    public void testCycles() {
        CycleTestSorter ts = new CycleTestSorter();
        Type[] typeArray = Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type type;
            ts.type = type = typeArray[n2];
            List<String> results = Arrays.asList((String[])ts.sort(ts.getTestData()));
            Assert.assertTrue((results.indexOf("A") < results.indexOf("D") ? 1 : 0) != 0);
            Assert.assertTrue((results.indexOf("B") < results.indexOf("D") ? 1 : 0) != 0);
            Assert.assertTrue((results.indexOf("C") < results.indexOf("D") ? 1 : 0) != 0);
            Assert.assertTrue((results.indexOf("A") < results.indexOf("D") ? 1 : 0) != 0);
            ++n2;
        }
    }

    @Test
    public void testSorter() {
        CycleCausingExceptionSorter sorter = new CycleCausingExceptionSorter();
        Integer[] sort = (Integer[])sorter.sort(sorter.getTestData());
        Assert.assertNotNull((Object)sort);
    }

    static class CycleCausingExceptionSorter
    extends TopologicalSort<Integer, Integer> {
        CycleCausingExceptionSorter() {
        }

        public Integer[] getTestData() {
            return new Integer[]{1, 2, 3, 4, 5};
        }

        protected Integer getId(Integer object) {
            return object;
        }

        protected Collection<Integer> getRequirements(Integer id) {
            switch (id) {
                case 1: {
                    return Arrays.asList(2);
                }
                case 2: {
                    return Arrays.asList(3, 4);
                }
                case 3: {
                    return Arrays.asList(4);
                }
                case 4: {
                    return Arrays.asList(1, 5);
                }
                case 5: {
                    return Arrays.asList(1);
                }
            }
            throw new IllegalStateException();
        }

        protected Collection<Integer> getDependencies(Integer id) {
            switch (id) {
                case 1: {
                    return Arrays.asList(4, 5);
                }
                case 2: {
                    return Arrays.asList(1);
                }
                case 3: {
                    return Arrays.asList(2);
                }
                case 4: {
                    return Arrays.asList(3, 2);
                }
                case 5: {
                    return Arrays.asList(4);
                }
            }
            throw new IllegalStateException();
        }
    }

    static class CycleTestSorter
    extends TopologicalSort<String, String> {
        Type type = Type.REQUIREMENTS;

        CycleTestSorter() {
        }

        public String[] getTestData() {
            return new String[]{"A", "B", "C", "D"};
        }

        protected String getId(String o) {
            return o;
        }

        protected Collection<String> getRequirements(String id) {
            if (this.type == Type.DEPENDENCIES) {
                return null;
            }
            switch (id) {
                case "A": {
                    return Collections.singleton("B");
                }
                case "B": {
                    return Collections.singleton("C");
                }
                case "C": {
                    return Collections.singleton("A");
                }
                case "D": {
                    return Collections.singleton("A");
                }
            }
            throw new IllegalArgumentException(id);
        }

        protected Collection<String> getDependencies(String id) {
            if (this.type == Type.REQUIREMENTS) {
                return null;
            }
            switch (id) {
                case "A": {
                    return Arrays.asList("C", "D");
                }
                case "B": {
                    return Collections.singleton("A");
                }
                case "C": {
                    return Collections.singleton("B");
                }
                case "D": {
                    return null;
                }
            }
            throw new IllegalArgumentException(id);
        }
    }

    static class TestSorter
    extends TopologicalSort<Integer, Integer> {
        Type type = Type.REQUIREMENTS;

        TestSorter() {
        }

        public Integer[] getTestData() {
            return new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        }

        protected Collection<Integer> getRequirements(Integer value) {
            if (this.type == Type.DEPENDENCIES) {
                return Collections.emptyList();
            }
            switch (value) {
                case 1: {
                    return Collections.emptyList();
                }
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    return Collections.singleton(1);
                }
                case 4: {
                    return Collections.singleton(2);
                }
                case 6: {
                    return Arrays.asList(2, 3);
                }
                case 8: {
                    return Collections.singleton(4);
                }
                case 9: {
                    return Collections.singleton(3);
                }
                case 10: {
                    return Arrays.asList(2, 5);
                }
            }
            throw new IllegalArgumentException(value.toString());
        }

        protected Collection<Integer> getDependencies(Integer value) {
            if (this.type == Type.REQUIREMENTS) {
                return Collections.emptyList();
            }
            switch (value) {
                case 1: {
                    return Arrays.asList(2, 3, 5, 7);
                }
                case 2: {
                    return Arrays.asList(4, 6, 10);
                }
                case 3: {
                    return Arrays.asList(6, 9);
                }
                case 4: {
                    return Arrays.asList(8);
                }
                case 5: {
                    return Arrays.asList(10);
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    return Collections.emptyList();
                }
            }
            throw new IllegalArgumentException(value.toString());
        }

        protected Integer getId(Integer o) {
            return o;
        }
    }

    static enum Type {
        REQUIREMENTS,
        DEPENDENCIES,
        BOTH;

    }
}

