/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import jakarta.inject.Inject;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.e4.ui.tests.rules.WorkbenchContextRule;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.jface.action.MenuManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class MenuManagerRendererTest {
    @Rule
    public WorkbenchContextRule contextRule = new WorkbenchContextRule();
    @Inject
    private EModelService ems;
    @Inject
    private MApplication application;
    private MMenu menu;
    private MTrimmedWindow window;

    @Before
    public void setUp() throws Exception {
        this.window = (MTrimmedWindow)this.ems.createModelElement(MTrimmedWindow.class);
        this.application.getChildren().add(this.window);
        this.menu = (MMenu)this.ems.createModelElement(MMenu.class);
        this.window.setMainMenu(this.menu);
    }

    @Test
    public void testMMenuItem_Visible() {
        MMenuItem menuItem1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        this.menu.getChildren().add(menuItem1);
        MMenuItem menyItem2 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        menyItem2.setVisible(false);
        this.menu.getChildren().add(menyItem2);
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        MenuManager mm = this.getMenuManager();
        Assert.assertEquals((long)2L, (long)mm.getSize());
        Assert.assertTrue((boolean)mm.getItems()[0].isVisible());
        Assert.assertFalse((boolean)mm.getItems()[1].isVisible());
        menuItem1.setVisible(false);
        Assert.assertEquals((long)2L, (long)mm.getSize());
        Assert.assertFalse((boolean)mm.getItems()[0].isVisible());
        Assert.assertFalse((boolean)mm.getItems()[1].isVisible());
        menuItem1.setVisible(true);
        Assert.assertEquals((long)2L, (long)mm.getSize());
        Assert.assertTrue((boolean)mm.getItems()[0].isVisible());
        Assert.assertFalse((boolean)mm.getItems()[1].isVisible());
    }

    @Test
    public void testMMenuItem_ToBeRendered() {
        MMenuItem menuItem1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        this.menu.getChildren().add(menuItem1);
        MMenuItem menyItem2 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        menyItem2.setToBeRendered(false);
        this.menu.getChildren().add(menyItem2);
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        MenuManager mm = this.getMenuManager();
        Assert.assertEquals((long)1L, (long)mm.getSize());
        Assert.assertTrue((boolean)mm.getItems()[0].isVisible());
        menuItem1.setToBeRendered(false);
        Assert.assertEquals((long)0L, (long)mm.getSize());
        menuItem1.setToBeRendered(true);
        Assert.assertEquals((long)1L, (long)mm.getSize());
        Assert.assertTrue((boolean)mm.getItems()[0].isVisible());
    }

    @Test
    @Ignore(value="Bug 560200")
    public void testMMenu_ToBeRendered() {
        MMenu submenu1 = (MMenu)this.ems.createModelElement(MMenu.class);
        this.menu.getChildren().add(submenu1);
        MMenuItem menuItem1 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        submenu1.getChildren().add(menuItem1);
        MMenu submenu2 = (MMenu)this.ems.createModelElement(MMenu.class);
        submenu2.setToBeRendered(false);
        this.menu.getChildren().add(submenu2);
        MMenuItem menyItem2 = (MMenuItem)this.ems.createModelElement(MDirectMenuItem.class);
        submenu2.getChildren().add(menyItem2);
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        MenuManager mm = this.getMenuManager();
        Assert.assertEquals((long)1L, (long)mm.getSize());
        Assert.assertTrue((boolean)mm.getItems()[0].isVisible());
        submenu1.setToBeRendered(false);
        Assert.assertEquals((long)0L, (long)mm.getSize());
        submenu1.setToBeRendered(true);
        Assert.assertEquals((long)1L, (long)mm.getSize());
        Assert.assertTrue((boolean)mm.getItems()[0].isVisible());
    }

    private MenuManagerRenderer getMenuManagerRenderer() {
        Object renderer = this.menu.getRenderer();
        Assert.assertEquals(MenuManagerRenderer.class, renderer.getClass());
        return (MenuManagerRenderer)renderer;
    }

    private MenuManager getMenuManager() {
        return this.getMenuManagerRenderer().getManager(this.menu);
    }
}

