/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import jakarta.inject.Inject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.PartStackUtil;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.services.IStylingEngine;
import org.eclipse.e4.ui.services.internal.events.EventBroker;
import org.eclipse.e4.ui.tests.rules.WorkbenchContextRule;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class StackRendererTest {
    private static final String PART_DESC_ICON = "platform:/plugin/org.eclipse.e4.ui.tests/icons/pinned_ovr.svg";
    private static final String PART_ICON = "platform:/plugin/org.eclipse.e4.ui.tests/icons/filenav_nav.svg";
    @Rule
    public WorkbenchContextRule contextRule = new WorkbenchContextRule();
    @Inject
    private IEclipseContext context;
    @Inject
    private EModelService ems;
    @Inject
    private MApplication application;
    private MWindow window;
    private MPartStack partStack;

    @Before
    public void setUp() throws Exception {
        this.window = (MWindow)this.ems.createModelElement(MWindow.class);
        this.application.getChildren().add(this.window);
        this.application.setSelectedElement((MUIElement)this.window);
        this.partStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        this.window.getChildren().add(this.partStack);
    }

    @Test
    public void testTabStateHandlerWhenOneOfSupportedTagChangeEvents() throws Exception {
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        this.partStack.getChildren().add(part);
        part.setLabel("some title");
        CTabItemStylingMethodsListener executedMethodsListener = new CTabItemStylingMethodsListener(part);
        this.context.set(IStylingEngine.class, (Object)((IStylingEngine)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IStylingEngine.class}, (InvocationHandler)executedMethodsListener)));
        this.contextRule.createAndRunWorkbench(this.window);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ChangedElement", part);
        params.put("NewValue", "busy");
        params.put("OldValue", null);
        ((EventBroker)this.context.get(EventBroker.class)).send("org/eclipse/e4/ui/model/application/ApplicationElement/tags/*".replace("*", "SET"), params);
        Assert.assertEquals((long)1L, (long)executedMethodsListener.getMethodExecutionCount("setClassnameAndId(.+)"));
    }

    @Test
    public void testTabStateHandlerWhenSelectionChangedEvent() throws Exception {
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        this.partStack.getChildren().add(part);
        part.setLabel("some title");
        CTabItemStylingMethodsListener executedMethodsListener = new CTabItemStylingMethodsListener(part);
        this.context.set(IStylingEngine.class, (Object)((IStylingEngine)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IStylingEngine.class}, (InvocationHandler)executedMethodsListener)));
        this.contextRule.createAndRunWorkbench(this.window);
        MPlaceholder placeHolder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeHolder.setRef((MUIElement)part);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ChangedElement", this.partStack);
        params.put("NewValue", placeHolder);
        params.put("OldValue", null);
        ((EventBroker)this.context.get(EventBroker.class)).send("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*".replace("*", "SET"), params);
        Assert.assertEquals((long)1L, (long)executedMethodsListener.getMethodExecutionCount("setClassnameAndId(.+)"));
    }

    @Test
    public void testBug475357_IconChanges() throws Exception {
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("myelementid");
        partDescriptor.setLabel("some title");
        partDescriptor.setIconURI(PART_DESC_ICON);
        this.application.getDescriptors().add(partDescriptor);
        MPart part1 = this.ems.createPart(partDescriptor);
        MPart part2 = this.ems.createPart(partDescriptor);
        this.partStack.getChildren().add(part1);
        this.partStack.getChildren().add(part2);
        this.contextRule.createAndRunWorkbench(this.window);
        part1.setIconURI(PART_DESC_ICON);
        CTabItem item = ((CTabFolder)this.partStack.getWidget()).getItem(0);
        Image image = item.getImage();
        part1.setIconURI(PART_ICON);
        Assert.assertNotEquals((Object)item.getImage(), (Object)image);
    }

    @Test
    public void testBug475357_PartIconOverridesDescriptor() throws Exception {
        MPartDescriptor partDescriptor = (MPartDescriptor)this.ems.createModelElement(MPartDescriptor.class);
        partDescriptor.setElementId("myelementid");
        partDescriptor.setLabel("some title");
        partDescriptor.setIconURI(PART_DESC_ICON);
        this.application.getDescriptors().add(partDescriptor);
        MPart part1 = this.ems.createPart(partDescriptor);
        MPart part2 = this.ems.createPart(partDescriptor);
        this.partStack.getChildren().add(part1);
        this.partStack.getChildren().add(part2);
        this.contextRule.createAndRunWorkbench(this.window);
        CTabItem item = ((CTabFolder)this.partStack.getWidget()).getItem(1);
        Image descImage = item.getImage();
        part2.setIconURI(PART_ICON);
        Image partIcon = item.getImage();
        Assert.assertNotEquals((Object)partIcon, (Object)descImage);
        part2.setIconURI(null);
        Image ovrwriteIcon = item.getImage();
        Assert.assertNotEquals((Object)ovrwriteIcon, (Object)partIcon);
        Assert.assertEquals((Object)ovrwriteIcon, (Object)descImage);
    }

    @Test
    public void testBug564561_ToolbarVisible_initial() {
        MPart part1 = (MPart)this.ems.createModelElement(MPart.class);
        MPart part2 = (MPart)this.ems.createModelElement(MPart.class);
        this.partStack.getChildren().add(part1);
        this.partStack.getChildren().add(part2);
        this.partStack.setSelectedElement((MUIElement)part1);
        MToolBar toolbar1 = (MToolBar)this.ems.createModelElement(MToolBar.class);
        toolbar1.setVisible(false);
        part1.setToolbar(toolbar1);
        MToolBar toolbar2 = (MToolBar)this.ems.createModelElement(MToolBar.class);
        toolbar2.setVisible(true);
        part2.setToolbar(toolbar2);
        this.contextRule.createAndRunWorkbench(this.window);
        Assert.assertTrue((boolean)toolbar1.isVisible());
        Assert.assertFalse((boolean)toolbar2.isVisible());
        this.partStack.setSelectedElement((MUIElement)part2);
        Assert.assertFalse((boolean)toolbar1.isVisible());
        Assert.assertTrue((boolean)toolbar2.isVisible());
    }

    @Test
    public void testBug564561_ToolbarVisible_added1() {
        MPart part1 = (MPart)this.ems.createModelElement(MPart.class);
        this.partStack.getChildren().add(part1);
        this.partStack.setSelectedElement((MUIElement)part1);
        this.contextRule.createAndRunWorkbench(this.window);
        MPart part2 = (MPart)this.ems.createModelElement(MPart.class);
        MToolBar toolbar2 = (MToolBar)this.ems.createModelElement(MToolBar.class);
        toolbar2.setVisible(true);
        part2.setToolbar(toolbar2);
        this.partStack.getChildren().add(part2);
        Assert.assertFalse((boolean)toolbar2.isVisible());
    }

    @Test
    public void testBug564561_ToolbarVisible_added2() {
        MPart part1 = (MPart)this.ems.createModelElement(MPart.class);
        MPart part2 = (MPart)this.ems.createModelElement(MPart.class);
        this.partStack.getChildren().add(part1);
        this.partStack.getChildren().add(part2);
        this.partStack.setSelectedElement((MUIElement)part1);
        this.contextRule.createAndRunWorkbench(this.window);
        MToolBar toolbar1 = (MToolBar)this.ems.createModelElement(MToolBar.class);
        toolbar1.setVisible(false);
        part1.setToolbar(toolbar1);
        MToolBar toolbar2 = (MToolBar)this.ems.createModelElement(MToolBar.class);
        toolbar2.setVisible(true);
        part2.setToolbar(toolbar2);
        Assert.assertTrue((boolean)toolbar1.isVisible());
        Assert.assertFalse((boolean)toolbar2.isVisible());
    }

    @Test
    public void testBug572598_SharedPartAndToolbarNotDisposed() {
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        this.window.getSharedElements().add(part);
        MToolBar toolbar = (MToolBar)this.ems.createModelElement(MToolBar.class);
        part.setToolbar(toolbar);
        MPlaceholder ph1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        ph1.setRef((MUIElement)part);
        this.partStack.getChildren().add(ph1);
        this.partStack.setSelectedElement((MUIElement)ph1);
        MPartStack partStack2 = (MPartStack)this.ems.createModelElement(MPartStack.class);
        this.window.getChildren().add(partStack2);
        this.window.setSelectedElement((MUIElement)partStack2);
        MPlaceholder ph2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        ph2.setRef((MUIElement)part);
        partStack2.getChildren().add(ph2);
        partStack2.setSelectedElement((MUIElement)ph2);
        this.contextRule.createAndRunWorkbench(this.window);
        Assert.assertNotNull((Object)part.getWidget());
        Assert.assertFalse((boolean)((Widget)part.getWidget()).isDisposed());
        Assert.assertNotNull((Object)toolbar.getWidget());
        Assert.assertFalse((boolean)((Widget)toolbar.getWidget()).isDisposed());
        partStack2.setToBeRendered(false);
        Assert.assertNotNull((Object)part.getWidget());
        Assert.assertFalse((boolean)((Widget)part.getWidget()).isDisposed());
        Assert.assertNotNull((Object)toolbar.getWidget());
        Assert.assertFalse((boolean)((Widget)toolbar.getWidget()).isDisposed());
    }

    @Test
    public void testBug573518_SharedPartToolbarShown1() {
        MPart part1 = (MPart)this.ems.createModelElement(MPart.class);
        this.window.getSharedElements().add(part1);
        MPart part2 = (MPart)this.ems.createModelElement(MPart.class);
        this.window.getSharedElements().add(part2);
        MToolBar toolbar = (MToolBar)this.ems.createModelElement(MToolBar.class);
        part2.setToolbar(toolbar);
        MPlaceholder ph1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        ph1.setRef((MUIElement)part1);
        this.partStack.getChildren().add(ph1);
        this.partStack.setSelectedElement((MUIElement)ph1);
        MPlaceholder ph2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        ph2.setRef((MUIElement)part2);
        this.partStack.getChildren().add(ph2);
        this.contextRule.createAndRunWorkbench(this.window);
        Assert.assertTrue((boolean)toolbar.isVisible());
        Assert.assertNull((Object)toolbar.getWidget());
        this.partStack.setSelectedElement((MUIElement)ph2);
        Assert.assertTrue((boolean)toolbar.isVisible());
        Assert.assertNotNull((Object)toolbar.getWidget());
    }

    @Test
    public void testBug573518_SharedPartToolbarShown2() {
        MPart part1 = (MPart)this.ems.createModelElement(MPart.class);
        this.window.getSharedElements().add(part1);
        MPart part2 = (MPart)this.ems.createModelElement(MPart.class);
        this.window.getSharedElements().add(part2);
        MToolBar toolbar = (MToolBar)this.ems.createModelElement(MToolBar.class);
        part2.setToolbar(toolbar);
        MPlaceholder ph1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        ph1.setRef((MUIElement)part1);
        this.partStack.getChildren().add(ph1);
        this.partStack.setSelectedElement((MUIElement)ph1);
        MPlaceholder ph2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        ph2.setRef((MUIElement)part2);
        part2.setCurSharedRef(ph2);
        this.partStack.getChildren().add(ph2);
        this.contextRule.createAndRunWorkbench(this.window);
        Assert.assertFalse((boolean)toolbar.isVisible());
        Assert.assertNull((Object)toolbar.getWidget());
        this.partStack.setSelectedElement((MUIElement)ph2);
        Assert.assertTrue((boolean)toolbar.isVisible());
        Assert.assertNotNull((Object)toolbar.getWidget());
    }

    @Test
    public void testOnboardingRenderedWithCorrectSizeForEditorStack() {
        PartStackUtil.makeEditorStack((MPartStack)this.partStack);
        this.contextRule.createAndRunWorkbench(this.window);
        Composite uiContainer = (Composite)((StackRenderer)this.partStack.getRenderer()).getUIContainer((MUIElement)this.partStack);
        CTabFolder tabFolder = (CTabFolder)((Composite)uiContainer.getChildren()[0]).getChildren()[0];
        Assert.assertNotNull((Object)tabFolder.getChildren());
        Assert.assertEquals((long)4L, (long)tabFolder.getChildren().length);
        Composite outerOnboardingComposite = (Composite)tabFolder.getChildren()[2];
        Rectangle expected = new Rectangle(2, 30, tabFolder.getSize().x - 4, tabFolder.getSize().y - 30 - 2);
        Assert.assertEquals((Object)expected, (Object)outerOnboardingComposite.getBounds());
        Composite innerOnboardingComposite = (Composite)outerOnboardingComposite.getChildren()[0];
        Assert.assertEquals((long)2L, (long)innerOnboardingComposite.getChildren().length);
        Assert.assertNull((Object)((Label)innerOnboardingComposite.getChildren()[0]).getImage());
        Assert.assertEquals((Object)"", (Object)((Label)innerOnboardingComposite.getChildren()[1]).getText());
    }

    @Test
    public void testOnboardingNotRenderedForNonEditorStack() {
        this.partStack.getTags().add("OtherStack");
        this.contextRule.createAndRunWorkbench(this.window);
        Composite uiContainer = (Composite)((StackRenderer)this.partStack.getRenderer()).getUIContainer((MUIElement)this.partStack);
        CTabFolder tabFolder = (CTabFolder)((Composite)uiContainer.getChildren()[0]).getChildren()[0];
        Assert.assertNotNull((Object)tabFolder.getChildren());
        Assert.assertEquals((long)2L, (long)tabFolder.getChildren().length);
    }

    @Test
    public void testOnboardingIsFilled() {
        MPerspective perspective = this.createPerspective();
        PartStackUtil.makeEditorStack((MPartStack)this.partStack);
        this.contextRule.createAndRunWorkbench(this.window);
        this.switchToPerspective(perspective);
        CTabFolder tabFolder = (CTabFolder)this.partStack.getWidget();
        this.assertFilledOnboardingInformation(tabFolder);
    }

    private MPerspective createPerspective() {
        MPerspective perspective = (MPerspective)this.ems.createModelElement(MPerspective.class);
        perspective.getTags().add("persp.editorOnboardingText:Onboarding text");
        perspective.getTags().add("persp.editorOnboardingImageUri:platform:/plugin/org.eclipse.e4.ui.tests/icons/filenav_nav.svg");
        perspective.getTags().add("persp.editorOnboardingCommand:Find Actions$$$STRG+3");
        MPerspectiveStack perspectiveStack = (MPerspectiveStack)this.ems.createModelElement(MPerspectiveStack.class);
        perspectiveStack.getChildren().add(perspective);
        this.window.getChildren().add(perspectiveStack);
        MPlaceholder placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholder.setRef((MUIElement)this.partStack);
        perspective.getChildren().add(placeholder);
        return perspective;
    }

    private void switchToPerspective(MPerspective perspective) {
        HashMap<String, MPerspective> params = new HashMap<String, MPerspective>();
        params.put("ChangedElement", perspective);
        ((EventBroker)this.context.get(EventBroker.class)).send("org/eclipse/e4/ui/LifeCycle/perspSwitched", params);
    }

    private void assertFilledOnboardingInformation(CTabFolder tabFolder) {
        Assert.assertNotNull((Object)tabFolder.getChildren());
        Composite innerOnboardingComposite = null;
        Control[] controlArray = tabFolder.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Composite innerComposite;
            Control control;
            Composite outerComposite;
            Control child = controlArray[n2];
            if (child instanceof Composite && (outerComposite = (Composite)child).getChildren().length > 0 && (control = outerComposite.getChildren()[0]) instanceof Composite && (innerComposite = (Composite)control).getChildren().length == 4) {
                innerOnboardingComposite = innerComposite;
                break;
            }
            ++n2;
        }
        Assert.assertNotNull(innerOnboardingComposite);
        Assert.assertNotNull((Object)((Label)innerOnboardingComposite.getChildren()[0]).getImage());
        Assert.assertEquals((Object)"Onboarding text", (Object)((Label)innerOnboardingComposite.getChildren()[1]).getText());
        Assert.assertEquals((Object)"Find Actions", (Object)((Label)innerOnboardingComposite.getChildren()[2]).getText());
        Assert.assertEquals((Object)"STRG+3", (Object)((Label)innerOnboardingComposite.getChildren()[3]).getText());
    }

    @Test
    public void testOnboardingIsFilledForEveryEditorStack() {
        MPerspective perspective = this.createPerspective();
        PartStackUtil.makeEditorStack((MPartStack)this.partStack);
        this.contextRule.createAndRunWorkbench(this.window);
        MPartStack secondPartStack = (MPartStack)this.ems.createModelElement(MPartStack.class);
        PartStackUtil.makeEditorStack((MPartStack)secondPartStack);
        MPlaceholder placeholder = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeholder.setRef((MUIElement)secondPartStack);
        perspective.getChildren().add(placeholder);
        this.window.getChildren().add(secondPartStack);
        this.switchToPerspective(perspective);
        CTabFolder tabFolder = (CTabFolder)secondPartStack.getWidget();
        this.assertFilledOnboardingInformation(tabFolder);
    }

    @Test
    public void testOnboardingIsHiddenWhenEditorOpened() {
        PartStackUtil.makeEditorStack((MPartStack)this.partStack);
        this.contextRule.createAndRunWorkbench(this.window);
        Composite uiContainer = (Composite)((StackRenderer)this.partStack.getRenderer()).getUIContainer((MUIElement)this.partStack);
        CTabFolder tabFolder = (CTabFolder)((Composite)uiContainer.getChildren()[0]).getChildren()[0];
        Assert.assertNotNull((Object)tabFolder.getChildren());
        Assert.assertEquals((long)4L, (long)tabFolder.getChildren().length);
        Composite outerOnboardingComposite = (Composite)tabFolder.getChildren()[2];
        Rectangle expected = new Rectangle(2, 30, tabFolder.getSize().x - 4, tabFolder.getSize().y - 30 - 2);
        Assert.assertEquals((Object)expected, (Object)outerOnboardingComposite.getBounds());
        MPart part1 = (MPart)this.ems.createModelElement(MPart.class);
        this.partStack.getChildren().add(part1);
        this.partStack.setSelectedElement((MUIElement)part1);
        expected = new Rectangle(2, 30, 0, 0);
        Assert.assertEquals((Object)expected, (Object)outerOnboardingComposite.getBounds());
    }

    @Test
    public void testToolbarIsReparentedToNewCompositeForTopRightOfTabFolder() {
        MPartStack partStack2 = (MPartStack)this.ems.createModelElement(MPartStack.class);
        this.window.getChildren().add(partStack2);
        MPart part = (MPart)this.ems.createModelElement(MPart.class);
        part.setToolbar((MToolBar)this.ems.createModelElement(MToolBar.class));
        MPlaceholder placeHolder1 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeHolder1.setRef((MUIElement)part);
        this.partStack.getChildren().add(placeHolder1);
        MPlaceholder placeHolder2 = (MPlaceholder)this.ems.createModelElement(MPlaceholder.class);
        placeHolder2.setRef((MUIElement)part);
        partStack2.getChildren().add(placeHolder2);
        partStack2.setSelectedElement((MUIElement)placeHolder2);
        this.contextRule.createAndRunWorkbench(this.window);
        CTabFolder tabFolder = (CTabFolder)partStack2.getWidget();
        Control toolbarControl = (Control)part.getToolbar().getWidget();
        Assert.assertSame((Object)tabFolder.getTopRight(), (Object)toolbarControl.getParent());
    }

    private static class CTabItemStylingMethodsListener
    implements InvocationHandler {
        private final MPart part;
        private final List<String> methods;

        public CTabItemStylingMethodsListener(MPart part) {
            this.part = part;
            this.methods = new ArrayList<String>();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.isTabItemForPart(args[0])) {
                this.methods.add(String.format("%s(%s)", method.getName(), Arrays.toString(args)));
            }
            return null;
        }

        private boolean isTabItemForPart(Object obj) {
            if (obj instanceof CTabItem) {
                CTabItem item = (CTabItem)obj;
                if (this.part.getLabel().equals(item.getText())) {
                    return true;
                }
            }
            return false;
        }

        public int getMethodExecutionCount(String methodPattern) {
            int result = 0;
            for (String method : this.methods) {
                if (!method.matches(methodPattern)) continue;
                ++result;
            }
            return result;
        }
    }
}

