/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectToolItem;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.e4.ui.tests.rules.WorkbenchContextRule;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.SWTException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class ToolBarManagerRendererTest {
    @Rule
    public WorkbenchContextRule contextRule = new WorkbenchContextRule();
    @Inject
    private EModelService ems;
    @Inject
    private MApplication application;
    @Inject
    private IEventBroker eventBroker;
    private String toolBarId;
    private MToolBar toolBar;
    private MTrimmedWindow window;

    @Before
    public void setUp() throws Exception {
        this.window = (MTrimmedWindow)this.ems.createModelElement(MTrimmedWindow.class);
        this.application.getChildren().add(this.window);
        MTrimBar trimBar = (MTrimBar)this.ems.createModelElement(MTrimBar.class);
        this.window.getTrimBars().add(trimBar);
        this.toolBarId = "ToolBarManagerRendererTest.toolBar";
        this.toolBar = (MToolBar)this.ems.createModelElement(MToolBar.class);
        this.toolBar.setElementId(this.toolBarId);
        trimBar.getChildren().add(this.toolBar);
    }

    @Test
    public void testMToolItem_isVisible() {
        MToolItem toolItem1 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        this.toolBar.getChildren().add(toolItem1);
        MToolItem toolItem2 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        toolItem2.setVisible(false);
        this.toolBar.getChildren().add(toolItem2);
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        ToolBarManager tbm = this.getToolBarManager();
        Assert.assertEquals((long)2L, (long)tbm.getSize());
        Assert.assertTrue((boolean)tbm.getItems()[0].isVisible());
        Assert.assertFalse((boolean)tbm.getItems()[1].isVisible());
        toolItem1.setVisible(false);
        Assert.assertEquals((long)2L, (long)tbm.getSize());
        Assert.assertFalse((boolean)tbm.getItems()[0].isVisible());
        Assert.assertFalse((boolean)tbm.getItems()[1].isVisible());
        toolItem1.setVisible(true);
        Assert.assertEquals((long)2L, (long)tbm.getSize());
        Assert.assertTrue((boolean)tbm.getItems()[0].isVisible());
        Assert.assertFalse((boolean)tbm.getItems()[1].isVisible());
    }

    @Test
    public void testMToolItem_toBeRendered() {
        MToolItem toolItem1 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        this.toolBar.getChildren().add(toolItem1);
        MToolItem toolItem2 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        toolItem2.setToBeRendered(false);
        this.toolBar.getChildren().add(toolItem2);
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        ToolBarManager tbm = this.getToolBarManager();
        Assert.assertEquals((long)1L, (long)tbm.getSize());
        Assert.assertTrue((boolean)tbm.getItems()[0].isVisible());
        toolItem1.setToBeRendered(false);
        Assert.assertEquals((long)0L, (long)tbm.getSize());
        toolItem1.setToBeRendered(true);
        Assert.assertEquals((long)1L, (long)tbm.getSize());
        Assert.assertTrue((boolean)tbm.getItems()[0].isVisible());
    }

    @Test
    public void testMToolBarContribution_toBeRendered() {
        ArrayList errors = new ArrayList();
        EventHandler eventHandler = event -> {
            if (UIEvents.isADD((Event)event)) {
                MToolBar toolbar = (MToolBar)event.getProperty("ChangedElement");
                toolbar.setToBeRendered(false);
            }
        };
        ILogListener logListener = (status, plugin) -> {
            if (status.getException() instanceof SWTException) {
                errors.add(plugin + ":" + String.valueOf(status));
            }
        };
        try {
            Platform.addLogListener((ILogListener)logListener);
            this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", eventHandler);
            MToolBarContribution toolContribution = (MToolBarContribution)this.ems.createModelElement(MToolBarContribution.class);
            toolContribution.setParentId(this.toolBarId);
            toolContribution.getChildren().add((MToolBarElement)this.ems.createModelElement(MDirectToolItem.class));
            this.application.getToolBarContributions().add(toolContribution);
            this.contextRule.createAndRunWorkbench((MWindow)this.window);
            Assert.assertNull((Object)this.toolBar.getRenderer());
            Assert.assertTrue((String)("Error(s) occurred while rendering toolbar: " + String.valueOf(errors)), (boolean)errors.isEmpty());
        }
        finally {
            this.eventBroker.unsubscribe(eventHandler);
            Platform.removeLogListener((ILogListener)logListener);
        }
    }

    @Test
    public void testDynamicItem_AddOne() {
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        ToolBarManager tbm = this.getToolBarManager();
        Assert.assertEquals((long)0L, (long)tbm.getSize());
        MToolItem toolItem1 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        this.toolBar.getChildren().add(toolItem1);
        Assert.assertEquals((long)1L, (long)tbm.getSize());
    }

    @Test
    public void testDynamicItem_AddOneBefore() {
        MToolItem toolItem1 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        this.toolBar.getChildren().add(toolItem1);
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        ToolBarManager tbm = this.getToolBarManager();
        Assert.assertEquals((long)1L, (long)tbm.getSize());
        MToolItem toolItem2 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        toolItem2.setElementId("Item2");
        this.toolBar.getChildren().add(0, toolItem2);
        Assert.assertEquals((long)2L, (long)tbm.getSize());
        Assert.assertEquals((Object)"Item2", (Object)tbm.getItems()[0].getId());
    }

    @Test
    public void testDynamicItem_AddMany() {
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        ToolBarManager tbm = this.getToolBarManager();
        Assert.assertEquals((long)0L, (long)tbm.getSize());
        MToolItem toolItem1 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        MToolItem toolItem2 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        List<MToolItem> itemList = Arrays.asList(toolItem1, toolItem2);
        this.toolBar.getChildren().addAll(itemList);
        Assert.assertEquals((long)2L, (long)tbm.getSize());
    }

    @Test
    public void testDynamicItem_RemoveOne() {
        MToolItem toolItem1 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        this.toolBar.getChildren().add(toolItem1);
        MToolItem toolItem2 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        toolItem2.setElementId("Item2");
        this.toolBar.getChildren().add(toolItem2);
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        ToolBarManager tbm = this.getToolBarManager();
        Assert.assertEquals((long)2L, (long)tbm.getSize());
        Assert.assertNotNull((Object)toolItem1.getWidget());
        this.toolBar.getChildren().remove(0);
        Assert.assertEquals((long)1L, (long)tbm.getSize());
        Assert.assertEquals((Object)"Item2", (Object)tbm.getItems()[0].getId());
        Assert.assertNull((Object)toolItem1.getWidget());
    }

    @Test
    public void testDynamicItem_RemoveMany() {
        MToolItem toolItem1 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        this.toolBar.getChildren().add(toolItem1);
        MToolItem toolItem2 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        toolItem2.setElementId("Item2");
        this.toolBar.getChildren().add(toolItem2);
        MToolItem toolItem3 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        this.toolBar.getChildren().add(toolItem3);
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        ToolBarManager tbm = this.getToolBarManager();
        Assert.assertEquals((long)3L, (long)tbm.getSize());
        List<MToolItem> itemList = Arrays.asList(toolItem1, toolItem3);
        this.toolBar.getChildren().removeAll(itemList);
        Assert.assertEquals((long)1L, (long)tbm.getSize());
        Assert.assertEquals((Object)"Item2", (Object)tbm.getItems()[0].getId());
    }

    @Test
    public void testDynamicItem_RemoveAll() {
        MToolItem toolItem1 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        this.toolBar.getChildren().add(toolItem1);
        MToolItem toolItem2 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        this.toolBar.getChildren().add(toolItem2);
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        ToolBarManager tbm = this.getToolBarManager();
        Assert.assertEquals((long)2L, (long)tbm.getSize());
        this.toolBar.getChildren().clear();
        Assert.assertEquals((long)0L, (long)tbm.getSize());
    }

    @Test
    public void testDynamicItem_Move() {
        MToolItem toolItem1 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        toolItem1.setElementId("Item1");
        this.toolBar.getChildren().add(toolItem1);
        MToolItem toolItem2 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        toolItem2.setElementId("Item2");
        this.toolBar.getChildren().add(toolItem2);
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        ToolBarManager tbm = this.getToolBarManager();
        Assert.assertEquals((long)2L, (long)tbm.getSize());
        Assert.assertEquals((Object)"Item1", (Object)tbm.getItems()[0].getId());
        Assert.assertEquals((Object)"Item2", (Object)tbm.getItems()[1].getId());
        ECollections.move((List)this.toolBar.getChildren(), (int)0, (int)1);
        Assert.assertEquals((long)2L, (long)tbm.getSize());
        Assert.assertEquals((Object)"Item2", (Object)tbm.getItems()[0].getId());
        Assert.assertEquals((Object)"Item1", (Object)tbm.getItems()[1].getId());
    }

    @Test
    public void testDynamicItem_Reconcile_AddOne() {
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        ToolBarManagerRenderer renderer = this.getToolBarManagerRenderer();
        ToolBarManager tbm = this.getToolBarManager();
        Assert.assertEquals((long)0L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((long)0L, (long)tbm.getSize());
        TestActionContributionItem item1 = new TestActionContributionItem();
        item1.setId("Item1");
        tbm.add((IContributionItem)item1);
        renderer.reconcileManagerToModel((IToolBarManager)tbm, this.toolBar);
        Assert.assertEquals((long)1L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)"Item1", (Object)((MToolBarElement)this.toolBar.getChildren().get(0)).getElementId());
        Assert.assertEquals((long)1L, (long)tbm.getSize());
        Assert.assertEquals((Object)((Object)item1), (Object)tbm.getItems()[0]);
    }

    @Test
    public void testDynamicItem_Reconcile_RemoveOne() {
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        ToolBarManagerRenderer renderer = this.getToolBarManagerRenderer();
        ToolBarManager tbm = this.getToolBarManager();
        TestActionContributionItem item1 = new TestActionContributionItem();
        tbm.add((IContributionItem)item1);
        renderer.reconcileManagerToModel((IToolBarManager)tbm, this.toolBar);
        Assert.assertEquals((long)1L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((long)1L, (long)tbm.getSize());
        Assert.assertFalse((boolean)item1.disposed);
        tbm.remove((IContributionItem)item1);
        renderer.reconcileManagerToModel((IToolBarManager)tbm, this.toolBar);
        Assert.assertEquals((long)0L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((long)0L, (long)tbm.getSize());
        Assert.assertFalse((boolean)item1.disposed);
        item1.dispose();
        Assert.assertTrue((boolean)item1.disposed);
    }

    @Test
    public void testDynamicItem_Reconcile_RemoveOneByID() {
        MToolItem toolItem1 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        toolItem1.setElementId("Item1");
        this.toolBar.getChildren().add(toolItem1);
        MToolItem toolItem2 = (MToolItem)this.ems.createModelElement(MDirectToolItem.class);
        toolItem2.setElementId("Item2");
        this.toolBar.getChildren().add(toolItem2);
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        ToolBarManagerRenderer renderer = this.getToolBarManagerRenderer();
        ToolBarManager tbm = this.getToolBarManager();
        Assert.assertEquals((long)2L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((long)2L, (long)tbm.getSize());
        tbm.remove("Item1");
        renderer.reconcileManagerToModel((IToolBarManager)tbm, this.toolBar);
        Assert.assertEquals((long)1L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((long)1L, (long)tbm.getSize());
        Assert.assertEquals((Object)"Item2", (Object)tbm.getItems()[0].getId());
    }

    @Test
    public void testDynamicItem_Reconcile_Move() {
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        ToolBarManagerRenderer renderer = this.getToolBarManagerRenderer();
        ToolBarManager tbm = this.getToolBarManager();
        Assert.assertEquals((long)0L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((long)0L, (long)tbm.getSize());
        TestActionContributionItem item1 = new TestActionContributionItem();
        item1.setId("Item1");
        tbm.add((IContributionItem)item1);
        TestActionContributionItem item2 = new TestActionContributionItem();
        item2.setId("Item2");
        tbm.add((IContributionItem)item2);
        renderer.reconcileManagerToModel((IToolBarManager)tbm, this.toolBar);
        Assert.assertEquals((long)2L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)"Item1", (Object)((MToolBarElement)this.toolBar.getChildren().get(0)).getElementId());
        Assert.assertEquals((Object)"Item2", (Object)((MToolBarElement)this.toolBar.getChildren().get(1)).getElementId());
        Assert.assertEquals((long)2L, (long)tbm.getSize());
        Assert.assertEquals((Object)((Object)item1), (Object)tbm.getItems()[0]);
        Assert.assertEquals((Object)((Object)item2), (Object)tbm.getItems()[1]);
        Assert.assertFalse((boolean)item1.disposed);
        Assert.assertFalse((boolean)item2.disposed);
        tbm.remove((IContributionItem)item1);
        tbm.remove((IContributionItem)item2);
        tbm.add((IContributionItem)item2);
        tbm.add((IContributionItem)item1);
        renderer.reconcileManagerToModel((IToolBarManager)tbm, this.toolBar);
        Assert.assertEquals((long)2L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((Object)"Item2", (Object)((MToolBarElement)this.toolBar.getChildren().get(0)).getElementId());
        Assert.assertEquals((Object)"Item1", (Object)((MToolBarElement)this.toolBar.getChildren().get(1)).getElementId());
        Assert.assertEquals((long)2L, (long)tbm.getSize());
        Assert.assertEquals((Object)((Object)item2), (Object)tbm.getItems()[0]);
        Assert.assertEquals((Object)((Object)item1), (Object)tbm.getItems()[1]);
        Assert.assertFalse((boolean)item1.disposed);
        Assert.assertFalse((boolean)item2.disposed);
    }

    @Test
    public void testDynamicItem_Reconcile_Visibility() {
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        ToolBarManagerRenderer renderer = this.getToolBarManagerRenderer();
        ToolBarManager tbm = this.getToolBarManager();
        Assert.assertEquals((long)0L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((long)0L, (long)tbm.getSize());
        TestActionContributionItem item1 = new TestActionContributionItem();
        tbm.add((IContributionItem)item1);
        TestActionContributionItem item2 = new TestActionContributionItem();
        tbm.add((IContributionItem)item2);
        item2.setVisible(false);
        renderer.reconcileManagerToModel((IToolBarManager)tbm, this.toolBar);
        Assert.assertEquals((long)2L, (long)this.toolBar.getChildren().size());
        Assert.assertTrue((boolean)((MToolBarElement)this.toolBar.getChildren().get(0)).isVisible());
        Assert.assertFalse((boolean)((MToolBarElement)this.toolBar.getChildren().get(1)).isVisible());
        Assert.assertTrue((boolean)item1.isVisible());
        Assert.assertFalse((boolean)item2.isVisible());
        item1.setVisible(false);
        renderer.reconcileManagerToModel((IToolBarManager)tbm, this.toolBar);
        Assert.assertEquals((long)2L, (long)this.toolBar.getChildren().size());
        Assert.assertFalse((boolean)((MToolBarElement)this.toolBar.getChildren().get(0)).isVisible());
        Assert.assertFalse((boolean)((MToolBarElement)this.toolBar.getChildren().get(1)).isVisible());
        Assert.assertFalse((boolean)item1.isVisible());
        Assert.assertFalse((boolean)item2.isVisible());
        item1.setVisible(true);
        renderer.reconcileManagerToModel((IToolBarManager)tbm, this.toolBar);
        Assert.assertEquals((long)2L, (long)this.toolBar.getChildren().size());
        Assert.assertTrue((boolean)((MToolBarElement)this.toolBar.getChildren().get(0)).isVisible());
        Assert.assertFalse((boolean)((MToolBarElement)this.toolBar.getChildren().get(1)).isVisible());
        Assert.assertTrue((boolean)item1.isVisible());
        Assert.assertFalse((boolean)item2.isVisible());
    }

    @Test
    public void testDynamicItem_Reconcile_Action_Multiple() {
        this.contextRule.createAndRunWorkbench((MWindow)this.window);
        ToolBarManagerRenderer renderer = this.getToolBarManagerRenderer();
        ToolBarManager tbm = this.getToolBarManager();
        Assert.assertEquals((long)0L, (long)this.toolBar.getChildren().size());
        Assert.assertEquals((long)0L, (long)tbm.getSize());
        Action action = new Action("Dummy"){};
        tbm.add((IAction)action);
        tbm.add((IAction)action);
        Assert.assertEquals((long)2L, (long)tbm.getSize());
        renderer.reconcileManagerToModel((IToolBarManager)tbm, this.toolBar);
        Assert.assertEquals((long)2L, (long)this.toolBar.getChildren().size());
    }

    private ToolBarManagerRenderer getToolBarManagerRenderer() {
        Object renderer = this.toolBar.getRenderer();
        Assert.assertEquals(ToolBarManagerRenderer.class, renderer.getClass());
        return (ToolBarManagerRenderer)renderer;
    }

    private ToolBarManager getToolBarManager() {
        return this.getToolBarManagerRenderer().getManager(this.toolBar);
    }

    private static class TestActionContributionItem
    extends ActionContributionItem {
        private boolean disposed = false;

        public TestActionContributionItem() {
            super((IAction)new Action("Dummy"){});
        }

        public void dispose() {
            this.disposed = true;
            super.dispose();
        }
    }
}

