/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace;

import java.util.function.Predicate;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.findandreplace.FindReplaceLogic;
import org.eclipse.ui.internal.findandreplace.IFindReplaceLogic;
import org.eclipse.ui.internal.findandreplace.SearchOptions;
import org.eclipse.ui.internal.findandreplace.status.FindAllStatus;
import org.eclipse.ui.internal.findandreplace.status.FindStatus;
import org.eclipse.ui.internal.findandreplace.status.InvalidRegExStatus;
import org.eclipse.ui.internal.findandreplace.status.NoStatus;
import org.eclipse.ui.internal.findandreplace.status.ReplaceAllStatus;
import org.eclipse.ui.texteditor.IFindReplaceTargetExtension2;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class FindReplaceLogicTest {
    private static final String LINE_STRING = "line";
    private static final int LINE_STRING_LENGTH = "line".length();
    Shell parentShell;

    private IFindReplaceLogic setupFindReplaceLogicObject(TextViewer target) {
        FindReplaceLogic findReplaceLogic = new FindReplaceLogic();
        if (target != null) {
            findReplaceLogic.updateTarget(target.getFindReplaceTarget(), true);
        }
        return findReplaceLogic;
    }

    private TextViewer setupTextViewer(String contentText) {
        TextViewer textViewer = new TextViewer((Composite)this.parentShell, 2816);
        textViewer.setDocument((IDocument)new Document(contentText));
        textViewer.getControl().setFocus();
        return textViewer;
    }

    private void setFindAndReplaceString(IFindReplaceLogic findReplaceLogic, String findString, String replaceString) {
        findReplaceLogic.setFindString(findString);
        findReplaceLogic.setReplaceString(replaceString);
    }

    @After
    public void disposeShell() {
        if (this.parentShell != null) {
            this.parentShell.dispose();
        }
    }

    @Before
    public void setupShell() {
        this.parentShell = new Shell();
    }

    @Test
    public void testPerformReplaceAllBackwards() {
        TextViewer textViewer = this.setupTextViewer("");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        this.performReplaceAllBaseTestcases(findReplaceLogic, textViewer);
    }

    @Test
    public void testPerformReplaceAllForwards() {
        TextViewer textViewer = this.setupTextViewer("");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        this.performReplaceAllBaseTestcases(findReplaceLogic, textViewer);
    }

    private void performReplaceAllBaseTestcases(IFindReplaceLogic findReplaceLogic, TextViewer textViewer) {
        textViewer.setDocument((IDocument)new Document("aaaa"));
        this.setFindAndReplaceString(findReplaceLogic, "a", "b");
        findReplaceLogic.performReplaceAll();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"bbbb"));
        this.expectStatusIsReplaceAllWithCount(findReplaceLogic, 4);
        this.setFindAndReplaceString(findReplaceLogic, "b", "aa");
        findReplaceLogic.performReplaceAll();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"aaaaaaaa"));
        this.expectStatusIsReplaceAllWithCount(findReplaceLogic, 4);
        this.setFindAndReplaceString(findReplaceLogic, "b", "c");
        findReplaceLogic.performReplaceAll();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"aaaaaaaa"));
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
        this.setFindAndReplaceString(findReplaceLogic, "aaaaaaaa", "d");
        findReplaceLogic.performReplaceAll();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"d"));
        this.expectStatusIsReplaceAllWithCount(findReplaceLogic, 1);
        this.setFindAndReplaceString(findReplaceLogic, "d", "");
        findReplaceLogic.performReplaceAll();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)""));
        this.expectStatusIsReplaceAllWithCount(findReplaceLogic, 1);
        textViewer.getDocument().set("f");
        this.setFindAndReplaceString(findReplaceLogic, "f", "");
        findReplaceLogic.performReplaceAll();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)""));
        this.expectStatusIsReplaceAllWithCount(findReplaceLogic, 1);
        IFindReplaceTarget mockFindReplaceTarget = (IFindReplaceTarget)Mockito.mock(IFindReplaceTarget.class);
        Mockito.when((Object)mockFindReplaceTarget.isEditable()).thenReturn((Object)false);
        findReplaceLogic.updateTarget(mockFindReplaceTarget, false);
        this.setFindAndReplaceString(findReplaceLogic, "a", "b");
        findReplaceLogic.performReplaceAll();
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
    }

    @Test
    public void testPerformReplaceAllForwardRegEx() {
        TextViewer textViewer = this.setupTextViewer("hello@eclipse.com looks.almost@like_an_email");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.REGEX);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        this.setFindAndReplaceString(findReplaceLogic, ".+\\@.+\\.com", "");
        findReplaceLogic.performReplaceAll();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)" looks.almost@like_an_email"));
        this.expectStatusIsReplaceAllWithCount(findReplaceLogic, 1);
        this.setFindAndReplaceString(findReplaceLogic, "( looks.)|(like_)", "");
        findReplaceLogic.performReplaceAll();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"almost@an_email"));
        this.expectStatusIsReplaceAllWithCount(findReplaceLogic, 2);
        this.setFindAndReplaceString(findReplaceLogic, "[", "");
        findReplaceLogic.performReplaceAll();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"almost@an_email"));
        this.expectStatusIsMessageWithString(findReplaceLogic, "Unclosed character class near index 0" + System.lineSeparator() + "[" + System.lineSeparator() + "^");
    }

    @Test
    public void testPerformReplaceAllForward() {
        TextViewer textViewer = this.setupTextViewer("hello@eclipse.com looks.almost@like_an_email");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.REGEX);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        this.setFindAndReplaceString(findReplaceLogic, ".+\\@.+\\.com", "");
        findReplaceLogic.performReplaceAll();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)" looks.almost@like_an_email"));
        this.expectStatusIsReplaceAllWithCount(findReplaceLogic, 1);
        this.setFindAndReplaceString(findReplaceLogic, "( looks.)|(like_)", "");
        findReplaceLogic.performReplaceAll();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"almost@an_email"));
        this.expectStatusIsReplaceAllWithCount(findReplaceLogic, 2);
        this.setFindAndReplaceString(findReplaceLogic, "[", "");
        findReplaceLogic.performReplaceAll();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"almost@an_email"));
        this.expectStatusIsMessageWithString(findReplaceLogic, "Unclosed character class near index 0" + System.lineSeparator() + "[" + System.lineSeparator() + "^");
    }

    @Test
    public void testPerformSelectAndReplace() {
        TextViewer textViewer = this.setupTextViewer("Hello<replace>World<replace>!");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        this.setFindAndReplaceString(findReplaceLogic, "<replace>", " ");
        findReplaceLogic.performSearch();
        findReplaceLogic.performSelectAndReplace();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello World<replace>!"));
        this.expectStatusEmpty(findReplaceLogic);
        findReplaceLogic.performSelectAndReplace();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello World !"));
        this.expectStatusEmpty(findReplaceLogic);
    }

    @Test
    public void testPerformSelectAndReplaceRegEx() {
        TextViewer textViewer = this.setupTextViewer("Hello<replace>World<replace>!");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.activate(SearchOptions.REGEX);
        this.setFindAndReplaceString(findReplaceLogic, "<(\\w*)>", " ");
        findReplaceLogic.performSearch();
        boolean status = findReplaceLogic.performSelectAndReplace();
        Assert.assertTrue((boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello World<replace>!"));
        this.expectStatusEmpty(findReplaceLogic);
        status = findReplaceLogic.performSelectAndReplace();
        Assert.assertTrue((boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello World !"));
        this.expectStatusEmpty(findReplaceLogic);
        status = findReplaceLogic.performSelectAndReplace();
        Assert.assertEquals((String)"Status wasn't correctly returned", (Object)false, (Object)status);
        Assert.assertEquals((String)"Text shouldn't have been changed", (Object)"Hello World !", (Object)textViewer.getDocument().get());
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
    }

    @Test
    public void testPerformSelectAndReplaceRegExWithLinebreaks() {
        TextViewer textViewer = this.setupTextViewer("Hello\nWorld\n!");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.activate(SearchOptions.REGEX);
        findReplaceLogic.deactivate(SearchOptions.WRAP);
        this.setFindAndReplaceString(findReplaceLogic, "o$", "o!");
        boolean status = findReplaceLogic.performSelectAndReplace();
        Assert.assertTrue((boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello!\nWorld\n!"));
        this.expectStatusEmpty(findReplaceLogic);
        this.setFindAndReplaceString(findReplaceLogic, "d\n!", "d!");
        status = findReplaceLogic.performSelectAndReplace();
        Assert.assertTrue((boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello!\nWorld!"));
        this.expectStatusEmpty(findReplaceLogic);
        this.setFindAndReplaceString(findReplaceLogic, "", " ");
        status = findReplaceLogic.performSelectAndReplace();
        Assert.assertEquals((String)"Status wasn't correctly returned", (Object)false, (Object)status);
        Assert.assertEquals((String)"Text shouldn't have been changed", (Object)"Hello!\nWorld!", (Object)textViewer.getDocument().get());
    }

    @Test
    public void testPerformSelectAndReplaceWithConfigurationChanges() {
        TextViewer textViewer = this.setupTextViewer("Hello<replace>World<replace>!<replace>!");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.activate(SearchOptions.REGEX);
        this.setFindAndReplaceString(findReplaceLogic, "<(\\w*)>", " ");
        boolean status = findReplaceLogic.performSelectAndReplace();
        Assert.assertTrue((boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello World<replace>!<replace>!"));
        this.expectStatusEmpty(findReplaceLogic);
        this.setFindAndReplaceString(findReplaceLogic, "<replace>", " ");
        findReplaceLogic.deactivate(SearchOptions.REGEX);
        status = findReplaceLogic.performSelectAndReplace();
        Assert.assertTrue((boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello World !<replace>!"));
        this.expectStatusEmpty(findReplaceLogic);
        this.setFindAndReplaceString(findReplaceLogic, "<(\\w*)>", " ");
        findReplaceLogic.activate(SearchOptions.REGEX);
        status = findReplaceLogic.performSelectAndReplace();
        Assert.assertTrue((boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello World ! !"));
        this.expectStatusEmpty(findReplaceLogic);
        status = findReplaceLogic.performSelectAndReplace();
        Assert.assertEquals((String)"Status wasn't correctly returned", (Object)false, (Object)status);
        Assert.assertEquals((String)"Text shouldn't have been changed", (Object)"Hello World ! !", (Object)textViewer.getDocument().get());
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
    }

    @Test
    public void testPerformSelectAndReplaceBackward() {
        TextViewer textViewer = this.setupTextViewer("Hello<replace>World<replace>!");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.deactivate(SearchOptions.FORWARD);
        findReplaceLogic.activate(SearchOptions.WRAP);
        this.setFindAndReplaceString(findReplaceLogic, "<replace>", " ");
        findReplaceLogic.performSearch();
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.WRAPPED);
        findReplaceLogic.performSelectAndReplace();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello<replace>World !"));
        findReplaceLogic.performSelectAndReplace();
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello World !"));
        this.expectStatusEmpty(findReplaceLogic);
    }

    @Test
    public void testPerformReplaceAndFind_caseInsensitive() {
        TextViewer textViewer = this.setupTextViewer("Hello<replace>World<replace>!");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        this.setFindAndReplaceString(findReplaceLogic, "<Replace>", " ");
        boolean status = findReplaceLogic.performReplaceAndFind();
        Assert.assertTrue((String)"replace should have been performed", (boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello World<replace>!"));
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelectionText(), (Matcher)Matchers.equalTo((Object)"<replace>"));
        this.expectStatusEmpty(findReplaceLogic);
        this.setFindAndReplaceString(findReplaceLogic, "<replace>", " ");
        status = findReplaceLogic.performReplaceAndFind();
        Assert.assertTrue((String)"replace should have been performed", (boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello World !"));
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
        status = findReplaceLogic.performReplaceAndFind();
        Assert.assertFalse((String)"replace should not have been performed", (boolean)status);
        Assert.assertEquals((String)"Text shouldn't have been changed", (Object)"Hello World !", (Object)textViewer.getDocument().get());
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
    }

    @Test
    public void testPerformReplaceAndFind_caseSensitive() {
        TextViewer textViewer = this.setupTextViewer("Hello<Replace>World<replace>!");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.activate(SearchOptions.CASE_SENSITIVE);
        this.setFindAndReplaceString(findReplaceLogic, "<replace>", " ");
        boolean status = findReplaceLogic.performReplaceAndFind();
        Assert.assertTrue((String)"replace should have been performed", (boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello<Replace>World !"));
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelectionText(), (Matcher)Matchers.equalTo((Object)" "));
        status = findReplaceLogic.performReplaceAndFind();
        Assert.assertFalse((String)"replace should not have been performed", (boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello<Replace>World !"));
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelectionText(), (Matcher)Matchers.equalTo((Object)" "));
    }

    @Test
    public void testPerformReplaceAndFind_caseSensitiveAndIncremental() {
        TextViewer textViewer = this.setupTextViewer("Hello<replace>World<replace>!");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.activate(SearchOptions.INCREMENTAL);
        this.setFindAndReplaceString(findReplaceLogic, "<Replace>", " ");
        boolean status = findReplaceLogic.performReplaceAndFind();
        Assert.assertTrue((String)"replace should have been performed", (boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello World<replace>!"));
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelectionText(), (Matcher)Matchers.equalTo((Object)"<replace>"));
        this.expectStatusEmpty(findReplaceLogic);
        this.setFindAndReplaceString(findReplaceLogic, "<replace>", " ");
        status = findReplaceLogic.performReplaceAndFind();
        Assert.assertTrue((String)"replace should have been performed", (boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello World !"));
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
        status = findReplaceLogic.performReplaceAndFind();
        Assert.assertFalse((String)"replace should not have been performed", (boolean)status);
        Assert.assertEquals((String)"Text shouldn't have been changed", (Object)"Hello World !", (Object)textViewer.getDocument().get());
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
    }

    @Test
    public void testPerformReplaceAndFindRegEx() {
        TextViewer textViewer = this.setupTextViewer("Hello<replace>World<replace>!<r>!");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.activate(SearchOptions.REGEX);
        this.executeReplaceAndFindRegExTest(textViewer, findReplaceLogic);
    }

    @Test
    public void testPerformReplaceAndFindRegEx_incrementalActive() {
        TextViewer textViewer = this.setupTextViewer("Hello<replace>World<replace>!<r>!");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.activate(SearchOptions.INCREMENTAL);
        findReplaceLogic.activate(SearchOptions.REGEX);
        this.executeReplaceAndFindRegExTest(textViewer, findReplaceLogic);
    }

    @Test
    public void testPerformReplaceAndFindRegEx_withInvalidEscapeInReplace() {
        TextViewer textViewer = this.setupTextViewer("Hello");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.activate(SearchOptions.REGEX);
        this.setFindAndReplaceString(findReplaceLogic, "Hello", "Hello\\");
        boolean status = findReplaceLogic.performReplaceAndFind();
        Assert.assertFalse((boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello"));
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelectionText(), (Matcher)Matchers.equalTo((Object)"Hello"));
        MatcherAssert.assertThat((Object)findReplaceLogic.getStatus(), (Matcher)Matchers.instanceOf(InvalidRegExStatus.class));
        this.setFindAndReplaceString(findReplaceLogic, "Hello", "Hello" + System.lineSeparator());
        status = findReplaceLogic.performReplaceAndFind();
        Assert.assertTrue((boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)("Hello" + System.lineSeparator())));
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelectionText(), (Matcher)Matchers.equalTo((Object)("Hello" + System.lineSeparator())));
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
    }

    private void executeReplaceAndFindRegExTest(TextViewer textViewer, IFindReplaceLogic findReplaceLogic) {
        this.setFindAndReplaceString(findReplaceLogic, "<(\\w*)>", " ");
        boolean status = findReplaceLogic.performReplaceAndFind();
        Assert.assertTrue((boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello World<replace>!<r>!"));
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelectionText(), (Matcher)Matchers.equalTo((Object)"<replace>"));
        this.expectStatusEmpty(findReplaceLogic);
        status = findReplaceLogic.performReplaceAndFind();
        Assert.assertTrue((boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello World !<r>!"));
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelectionText(), (Matcher)Matchers.equalTo((Object)"<r>"));
        this.expectStatusEmpty(findReplaceLogic);
        this.setFindAndReplaceString(findReplaceLogic, "<(\\w)>", " ");
        status = findReplaceLogic.performReplaceAndFind();
        Assert.assertTrue((boolean)status);
        MatcherAssert.assertThat((Object)textViewer.getDocument().get(), (Matcher)Matchers.equalTo((Object)"Hello World ! !"));
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
        this.setFindAndReplaceString(findReplaceLogic, "<(\\w*)>", " ");
        status = findReplaceLogic.performReplaceAndFind();
        Assert.assertEquals((String)"Status wasn't correctly returned", (Object)false, (Object)status);
        Assert.assertEquals((String)"Text shouldn't have been changed", (Object)"Hello World ! !", (Object)textViewer.getDocument().get());
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
    }

    @Test
    public void testPerformSearchAndReplaceRegEx_incrementalActive() {
        TextViewer textViewer = this.setupTextViewer("some text");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.activate(SearchOptions.INCREMENTAL);
        findReplaceLogic.activate(SearchOptions.REGEX);
        findReplaceLogic.setFindString("text");
        textViewer.setSelectedRange(0, 0);
        findReplaceLogic.setReplaceString("");
        findReplaceLogic.performSelectAndReplace();
        Assert.assertEquals((Object)"some ", (Object)textViewer.getDocument().get());
    }

    @Test
    public void testPerformSelectAllForward() {
        TextViewer textViewer = this.setupTextViewer("AbAbAbAb");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.setFindString("c");
        findReplaceLogic.performSelectAll();
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
        findReplaceLogic.setFindString("b");
        findReplaceLogic.performSelectAll();
        this.expectStatusIsFindAllWithCount(findReplaceLogic, 4);
        findReplaceLogic.setFindString("AbAbAbAb");
        findReplaceLogic.performSelectAll();
        this.expectStatusIsFindAllWithCount(findReplaceLogic, 1);
    }

    @Test
    public void testPerformSelectAllRegEx() {
        TextViewer textViewer = this.setupTextViewer("AbAbAbAb");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.activate(SearchOptions.REGEX);
        findReplaceLogic.setFindString("c.*");
        findReplaceLogic.performSelectAll();
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
        findReplaceLogic.setFindString("(Ab)*");
        findReplaceLogic.performSelectAll();
        this.expectStatusIsFindAllWithCount(findReplaceLogic, 1);
        findReplaceLogic.setFindString("Ab(Ab)+Ab(Ab)+(Ab)+");
        findReplaceLogic.performSelectAll();
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
    }

    @Test
    public void testPerformSelectAllBackward() {
        TextViewer textViewer = this.setupTextViewer("AbAbAbAb");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.deactivate(SearchOptions.FORWARD);
        findReplaceLogic.setFindString("b");
        findReplaceLogic.performSelectAll();
        this.expectStatusIsFindAllWithCount(findReplaceLogic, 4);
        findReplaceLogic.setFindString("AbAbAbAb");
        findReplaceLogic.performSelectAll();
        this.expectStatusIsFindAllWithCount(findReplaceLogic, 1);
    }

    @Test
    public void testPerformSelectAllOnReadonlyTarget() {
        TextViewer textViewer = this.setupTextViewer("Ab Ab");
        textViewer.setEditable(false);
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.setFindString("Ab");
        findReplaceLogic.performSelectAll();
        this.expectStatusIsFindAllWithCount(findReplaceLogic, 2);
    }

    @Test
    public void testSelectWholeWords() {
        TextViewer textViewer = this.setupTextViewer("Hello World of get and getters, set and setters");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.activate(SearchOptions.WHOLE_WORD);
        findReplaceLogic.deactivate(SearchOptions.WRAP);
        findReplaceLogic.setFindString("get");
        findReplaceLogic.performSearch();
        findReplaceLogic.performSearch();
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
    }

    @Test
    public void testSelectInSearchScope_withZeroLengthSelection() {
        String originalContents = "line1" + System.lineSeparator() + "line2" + System.lineSeparator() + "line3";
        TextViewer textViewer = this.setupTextViewer(originalContents);
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        int lineLength = ("line1" + System.lineSeparator()).length();
        textViewer.setSelection((ISelection)new TextSelection(lineLength + 1, 0));
        findReplaceLogic.deactivate(SearchOptions.GLOBAL);
        this.setFindAndReplaceString(findReplaceLogic, "l", "");
        findReplaceLogic.performReplaceAll();
        this.expectStatusIsReplaceAllWithCount(findReplaceLogic, 1);
        MatcherAssert.assertThat((Object)textViewer.getTextWidget().getText(), (Matcher)Matchers.is((Object)("line1" + System.lineSeparator() + "ine2" + System.lineSeparator() + "line3")));
    }

    @Test
    public void testSelectInSearchScope_withZeroLengthSelectionAtBeginningOfLine() {
        String originalContents = "line1" + System.lineSeparator() + "line2" + System.lineSeparator() + "line3";
        TextViewer textViewer = this.setupTextViewer(originalContents);
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        int lineLength = ("line1" + System.lineSeparator()).length();
        textViewer.setSelection((ISelection)new TextSelection(lineLength, 0));
        findReplaceLogic.deactivate(SearchOptions.GLOBAL);
        this.setFindAndReplaceString(findReplaceLogic, "l", "");
        findReplaceLogic.performReplaceAll();
        this.expectStatusIsReplaceAllWithCount(findReplaceLogic, 1);
        MatcherAssert.assertThat((Object)textViewer.getTextWidget().getText(), (Matcher)Matchers.is((Object)("line1" + System.lineSeparator() + "ine2" + System.lineSeparator() + "line3")));
    }

    @Test
    public void testSelectInSearchScope_withSingleLineelection() {
        String originalContents = "line1" + System.lineSeparator() + "line2" + System.lineSeparator() + "line3";
        TextViewer textViewer = this.setupTextViewer(originalContents);
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        int lineLength = ("line1" + System.lineSeparator()).length();
        textViewer.setSelection((ISelection)new TextSelection(lineLength + 1, 3));
        findReplaceLogic.deactivate(SearchOptions.GLOBAL);
        this.setFindAndReplaceString(findReplaceLogic, "l", "");
        findReplaceLogic.performReplaceAll();
        this.expectStatusIsReplaceAllWithCount(findReplaceLogic, 1);
        MatcherAssert.assertThat((Object)textViewer.getTextWidget().getText(), (Matcher)Matchers.is((Object)("line1" + System.lineSeparator() + "ine2" + System.lineSeparator() + "line3")));
    }

    @Test
    public void testSelectInSearchScope_withMultiLineSelection() {
        String originalContents = "line1" + System.lineSeparator() + "line2" + System.lineSeparator() + "line3";
        TextViewer textViewer = this.setupTextViewer(originalContents);
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        int beginningOfSecondLine = originalContents.indexOf("l", 1);
        textViewer.setSelection((ISelection)new TextSelection(beginningOfSecondLine, originalContents.substring(beginningOfSecondLine).length()));
        findReplaceLogic.deactivate(SearchOptions.GLOBAL);
        this.setFindAndReplaceString(findReplaceLogic, "l", "");
        findReplaceLogic.performReplaceAll();
        this.expectStatusIsReplaceAllWithCount(findReplaceLogic, 2);
        MatcherAssert.assertThat((Object)textViewer.getTextWidget().getText(), (Matcher)Matchers.is((Object)("line1" + System.lineSeparator() + "ine2" + System.lineSeparator() + "ine3")));
    }

    @Test
    public void testSelectInSearchScope_withSelectionEndingAtBeginningOfLine() {
        String originalContents = "line1" + System.lineSeparator() + "line2" + System.lineSeparator() + "line3";
        TextViewer textViewer = this.setupTextViewer(originalContents);
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        int beginningOfSecondLine = originalContents.indexOf("l", 1);
        int lineLength = ("line1" + System.lineSeparator()).length();
        textViewer.setSelection((ISelection)new TextSelection(beginningOfSecondLine, lineLength));
        findReplaceLogic.deactivate(SearchOptions.GLOBAL);
        this.setFindAndReplaceString(findReplaceLogic, "l", "");
        findReplaceLogic.performReplaceAll();
        this.expectStatusIsReplaceAllWithCount(findReplaceLogic, 1);
        MatcherAssert.assertThat((Object)textViewer.getTextWidget().getText(), (Matcher)Matchers.is((Object)("line1" + System.lineSeparator() + "ine2" + System.lineSeparator() + "line3")));
    }

    @Test
    public void testSelectInSearchScope_changeScope() {
        String originalContents = "line1" + System.lineSeparator() + "line2" + System.lineSeparator() + "line3";
        TextViewer textViewer = this.setupTextViewer(originalContents);
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        textViewer.setSelection((ISelection)new TextSelection(8, 10));
        findReplaceLogic.deactivate(SearchOptions.GLOBAL);
        findReplaceLogic.activate(SearchOptions.GLOBAL);
        textViewer.setSelection((ISelection)new TextSelection(0, 2));
        findReplaceLogic.deactivate(SearchOptions.GLOBAL);
        this.setFindAndReplaceString(findReplaceLogic, "l", "");
        findReplaceLogic.performReplaceAll();
        this.expectStatusIsReplaceAllWithCount(findReplaceLogic, 1);
        MatcherAssert.assertThat((Object)textViewer.getTextWidget().getText(), (Matcher)Matchers.is((Object)("ine1" + System.lineSeparator() + "line2" + System.lineSeparator() + "line3")));
    }

    @Test
    public void testWholeWordSearchAvailable() {
        String originalContents = "line1" + System.lineSeparator() + "line2" + System.lineSeparator() + "line3";
        TextViewer textViewer = this.setupTextViewer(originalContents);
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        Predicate<String> isConsideredWholeWord = string -> {
            findReplaceLogic.setFindString(string);
            return findReplaceLogic.isAvailable(SearchOptions.WHOLE_WORD);
        };
        Assert.assertTrue((boolean)isConsideredWholeWord.test("oneword"));
        Assert.assertTrue((boolean)isConsideredWholeWord.test("still\u00e4one\u00e4word"));
        Assert.assertFalse((boolean)isConsideredWholeWord.test("two.words"));
        Assert.assertFalse((boolean)isConsideredWholeWord.test("two words"));
        Assert.assertTrue((boolean)isConsideredWholeWord.test("oneword"));
        Assert.assertTrue((boolean)isConsideredWholeWord.test("tw\u00f6words"));
        findReplaceLogic.activate(SearchOptions.REGEX);
        Assert.assertFalse((boolean)isConsideredWholeWord.test("oneword"));
        Assert.assertFalse((boolean)isConsideredWholeWord.test("still\u00e4one\u00e4word"));
        Assert.assertFalse((boolean)isConsideredWholeWord.test("two.words"));
        Assert.assertFalse((boolean)isConsideredWholeWord.test("two words"));
        Assert.assertFalse((boolean)isConsideredWholeWord.test(""));
    }

    @Test
    public void testReplaceInScopeStaysInScope() {
        TextViewer textViewer = this.setupTextViewer(LINE_STRING + System.lineSeparator() + LINE_STRING + System.lineSeparator() + LINE_STRING);
        int lineSeparatorLength = System.lineSeparator().length();
        textViewer.setSelectedRange(LINE_STRING_LENGTH + lineSeparatorLength, 2 * LINE_STRING_LENGTH + lineSeparatorLength);
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.deactivate(SearchOptions.GLOBAL);
        findReplaceLogic.activate(SearchOptions.WRAP);
        this.setFindAndReplaceString(findReplaceLogic, LINE_STRING, "");
        findReplaceLogic.performSelectAndReplace();
        MatcherAssert.assertThat((Object)textViewer.getTextWidget().getText(), (Matcher)Matchers.is((Object)(LINE_STRING + System.lineSeparator() + System.lineSeparator() + LINE_STRING)));
        this.expectStatusEmpty(findReplaceLogic);
        findReplaceLogic.performSelectAndReplace();
        MatcherAssert.assertThat((Object)textViewer.getTextWidget().getText(), (Matcher)Matchers.is((Object)(LINE_STRING + System.lineSeparator() + System.lineSeparator())));
        this.expectStatusEmpty(findReplaceLogic);
        findReplaceLogic.performSelectAndReplace();
        MatcherAssert.assertThat((Object)textViewer.getTextWidget().getText(), (Matcher)Matchers.is((Object)(LINE_STRING + System.lineSeparator() + System.lineSeparator())));
        this.expectStatusIsCode(findReplaceLogic, FindStatus.StatusCode.NO_MATCH);
    }

    @Test
    public void testSearchInScopeBeginsSearchInScope() {
        int lineSeparatorLength = System.lineSeparator().length();
        TextViewer textViewer = this.setupTextViewer(LINE_STRING + System.lineSeparator() + LINE_STRING + System.lineSeparator() + LINE_STRING);
        textViewer.setSelectedRange(LINE_STRING_LENGTH + lineSeparatorLength, 2 * LINE_STRING_LENGTH + lineSeparatorLength);
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.deactivate(SearchOptions.GLOBAL);
        findReplaceLogic.setFindString(LINE_STRING);
        findReplaceLogic.performSearch();
        this.expectStatusEmpty(findReplaceLogic);
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelection().x, (Matcher)Matchers.not((Matcher)Matchers.is((Object)0)));
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelection().x, (Matcher)Matchers.not((Matcher)Matchers.is((Object)(textViewer.getDocument().get().length() - LINE_STRING_LENGTH))));
    }

    @Test
    public void onlySelectAndReplacesIfFindSuccessfulOnCustomTarget() {
        IFindReplaceTarget mockedTarget = (IFindReplaceTarget)Mockito.mock(IFindReplaceTarget.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{IFindReplaceTargetExtension3.class, IFindReplaceTargetExtension2.class}));
        Mockito.when((Object)mockedTarget.getSelectionText()).thenReturn((Object)"SELECTEDTEXT");
        Mockito.when((Object)mockedTarget.getSelection()).thenReturn((Object)new Point(0, "SELECTEDTEXT".length()));
        Mockito.when((Object)mockedTarget.isEditable()).thenReturn((Object)true);
        Mockito.when((Object)mockedTarget.findAndSelect(ArgumentMatchers.anyInt(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean())).thenReturn((Object)-1);
        Mockito.when((Object)((IFindReplaceTargetExtension2)mockedTarget).validateTargetState()).thenReturn((Object)true);
        FindReplaceLogic findReplaceLogic = new FindReplaceLogic();
        findReplaceLogic.updateTarget(mockedTarget, true);
        this.setFindAndReplaceString((IFindReplaceLogic)findReplaceLogic, "NOTFOUND", "");
        findReplaceLogic.performSelectAndReplace();
        ((IFindReplaceTargetExtension3)Mockito.verify((Object)((IFindReplaceTargetExtension3)mockedTarget), (VerificationMode)Mockito.never())).replaceSelection(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
    }

    @Test
    public void testCanReplaceAfterWrap() {
        TextViewer textViewer = this.setupTextViewer(LINE_STRING + System.lineSeparator() + LINE_STRING);
        textViewer.setSelectedRange(LINE_STRING_LENGTH + System.lineSeparator().length(), 0);
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.activate(SearchOptions.WRAP);
        this.setFindAndReplaceString(findReplaceLogic, LINE_STRING, "");
        findReplaceLogic.performSelectAndReplace();
        MatcherAssert.assertThat((Object)textViewer.getTextWidget().getText(), (Matcher)Matchers.is((Object)(LINE_STRING + System.lineSeparator())));
        findReplaceLogic.performSelectAndReplace();
        MatcherAssert.assertThat((Object)textViewer.getTextWidget().getText(), (Matcher)Matchers.is((Object)System.lineSeparator()));
    }

    @Test
    public void testDontSelectAndReplaceIfFindNotSuccessful() {
        String setupString = "ABCD" + System.lineSeparator() + LINE_STRING;
        TextViewer textViewer = this.setupTextViewer(setupString);
        textViewer.setSelectedRange(0, 4);
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.activate(SearchOptions.WRAP);
        this.setFindAndReplaceString(findReplaceLogic, "NOTFOUND", "");
        findReplaceLogic.performSelectAndReplace();
        MatcherAssert.assertThat((Object)textViewer.getTextWidget().getText(), (Matcher)Matchers.is((Object)setupString));
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelection().x, (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelection().y, (Matcher)Matchers.is((Object)4));
    }

    @Test
    public void testResetIncrementalBaseLocation() {
        String setupString = "test\ntest\ntest";
        TextViewer textViewer = this.setupTextViewer(setupString);
        textViewer.setSelectedRange(0, 0);
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.activate(SearchOptions.WRAP);
        findReplaceLogic.activate(SearchOptions.INCREMENTAL);
        findReplaceLogic.setFindString("test");
        MatcherAssert.assertThat((Object)textViewer.getSelectedRange(), (Matcher)Matchers.is((Object)new Point(0, 4)));
        textViewer.setSelectedRange(5, 0);
        findReplaceLogic.resetIncrementalBaseLocation();
        findReplaceLogic.performSearch();
        MatcherAssert.assertThat((Object)textViewer.getSelectedRange(), (Matcher)Matchers.is((Object)new Point(5, 4)));
    }

    @Test
    public void testSetFindString_incrementalInactive() {
        TextViewer textViewer = this.setupTextViewer("Test Test Test Test");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        Assert.assertEquals((Object)new Point(0, 0), (Object)findReplaceLogic.getTarget().getSelection());
        findReplaceLogic.setFindString("Test");
        Assert.assertEquals((Object)new Point(0, 0), (Object)findReplaceLogic.getTarget().getSelection());
    }

    @Test
    public void testSetFindString_incrementalActive() {
        TextViewer textViewer = this.setupTextViewer("Test Test Test Test");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.INCREMENTAL);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        Assert.assertEquals((Object)new Point(0, 0), (Object)findReplaceLogic.getTarget().getSelection());
        findReplaceLogic.setFindString("Test");
        Assert.assertEquals((Object)new Point(0, 4), (Object)findReplaceLogic.getTarget().getSelection());
        findReplaceLogic.setFindString("Test");
        Assert.assertEquals((Object)new Point(0, 4), (Object)findReplaceLogic.getTarget().getSelection());
        findReplaceLogic.setFindString("T");
        Assert.assertEquals((Object)new Point(0, 1), (Object)findReplaceLogic.getTarget().getSelection());
        findReplaceLogic.setFindString("Te");
        Assert.assertEquals((Object)new Point(0, 2), (Object)findReplaceLogic.getTarget().getSelection());
        findReplaceLogic.setFindString("");
        Assert.assertEquals((Object)new Point(0, 2), (Object)findReplaceLogic.getTarget().getSelection());
    }

    @Test
    public void testIncrementBaseLocationWithRegEx() {
        TextViewer textViewer = this.setupTextViewer("Test Test Test Test Test");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.INCREMENTAL);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        findReplaceLogic.setFindString("Test");
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelection(), (Matcher)Matchers.is((Object)new Point(0, 4)));
        findReplaceLogic.activate(SearchOptions.REGEX);
        findReplaceLogic.deactivate(SearchOptions.INCREMENTAL);
        findReplaceLogic.performSearch();
        findReplaceLogic.activate(SearchOptions.INCREMENTAL);
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelection(), (Matcher)Matchers.is((Object)new Point(5, 4)));
        findReplaceLogic.deactivate(SearchOptions.INCREMENTAL);
        findReplaceLogic.performSearch();
        findReplaceLogic.activate(SearchOptions.INCREMENTAL);
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelection(), (Matcher)Matchers.is((Object)new Point(10, 4)));
        findReplaceLogic.deactivate(SearchOptions.REGEX);
        findReplaceLogic.setFindString("Test");
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelection(), (Matcher)Matchers.is((Object)new Point(10, 4)));
        findReplaceLogic.performSearch();
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelection(), (Matcher)Matchers.is((Object)new Point(15, 4)));
    }

    @Test
    public void testIncrementalSearchNoUpdateIfAlreadyOnWord() {
        TextViewer textViewer = this.setupTextViewer("hellohello");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.activate(SearchOptions.FORWARD);
        textViewer.setSelectedRange(0, 4);
        findReplaceLogic.activate(SearchOptions.INCREMENTAL);
        textViewer.setSelectedRange(0, 0);
        findReplaceLogic.setFindString("hello");
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelection(), (Matcher)Matchers.is((Object)new Point(0, 5)));
    }

    @Test
    public void testIncrementalSearchBackwardNoUpdateIfAlreadyOnWord() {
        TextViewer textViewer = this.setupTextViewer("hellohello");
        IFindReplaceLogic findReplaceLogic = this.setupFindReplaceLogicObject(textViewer);
        findReplaceLogic.deactivate(SearchOptions.FORWARD);
        textViewer.setSelectedRange(5, 5);
        findReplaceLogic.activate(SearchOptions.INCREMENTAL);
        textViewer.setSelectedRange(5, 0);
        findReplaceLogic.setFindString("hello");
        MatcherAssert.assertThat((Object)findReplaceLogic.getTarget().getSelection(), (Matcher)Matchers.is((Object)new Point(5, 5)));
    }

    private void expectStatusEmpty(IFindReplaceLogic findReplaceLogic) {
        MatcherAssert.assertThat((Object)findReplaceLogic.getStatus(), (Matcher)Matchers.instanceOf(NoStatus.class));
    }

    private void expectStatusIsCode(IFindReplaceLogic findReplaceLogic, FindStatus.StatusCode code) {
        MatcherAssert.assertThat((Object)findReplaceLogic.getStatus(), (Matcher)Matchers.instanceOf(FindStatus.class));
        MatcherAssert.assertThat((Object)((FindStatus)findReplaceLogic.getStatus()).getMessageCode(), (Matcher)Matchers.equalTo((Object)code));
    }

    private void expectStatusIsReplaceAllWithCount(IFindReplaceLogic findReplaceLogic, int count) {
        MatcherAssert.assertThat((Object)findReplaceLogic.getStatus(), (Matcher)Matchers.instanceOf(ReplaceAllStatus.class));
        MatcherAssert.assertThat((Object)((ReplaceAllStatus)findReplaceLogic.getStatus()).getReplaceCount(), (Matcher)Matchers.equalTo((Object)count));
    }

    private void expectStatusIsFindAllWithCount(IFindReplaceLogic findReplaceLogic, int count) {
        MatcherAssert.assertThat((Object)findReplaceLogic.getStatus(), (Matcher)Matchers.instanceOf(FindAllStatus.class));
        MatcherAssert.assertThat((Object)((FindAllStatus)findReplaceLogic.getStatus()).getSelectCount(), (Matcher)Matchers.equalTo((Object)count));
    }

    private void expectStatusIsMessageWithString(IFindReplaceLogic findReplaceLogic, String message) {
        MatcherAssert.assertThat((Object)findReplaceLogic.getStatus(), (Matcher)Matchers.instanceOf(InvalidRegExStatus.class));
        MatcherAssert.assertThat((Object)((InvalidRegExStatus)findReplaceLogic.getStatus()).getMessage(), (Matcher)Matchers.equalTo((Object)message));
    }
}

