/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace;

import java.util.ResourceBundle;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.findandreplace.IFindReplaceUIAccess;
import org.eclipse.ui.internal.findandreplace.SearchOptions;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public abstract class FindReplaceUITest<AccessType extends IFindReplaceUIAccess> {
    @Rule
    public TestName testName = new TestName();
    private TextViewer fTextViewer;
    private FindReplaceAction findReplaceAction;
    private AccessType dialog;

    @Before
    public final void ensureWorkbenchWindowIsActive() {
        PlatformUI.getWorkbench().getWorkbenchWindows()[0].getShell().forceActive();
    }

    protected FindReplaceAction getFindReplaceAction() {
        return this.findReplaceAction;
    }

    protected final void initializeTextViewerWithFindReplaceUI(String content) {
        this.openTextViewer(content);
        this.initializeFindReplaceUIForTextViewer();
    }

    protected void openTextViewer(String content) {
        this.fTextViewer = new TextViewer((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 2816);
        this.fTextViewer.setDocument((IDocument)new Document(content));
        this.fTextViewer.getControl().setFocus();
        this.findReplaceAction = new FindReplaceAction(ResourceBundle.getBundle("org.eclipse.ui.texteditor.ConstructedEditorMessages"), "Editor.FindReplace.", this.fTextViewer.getControl().getShell(), this.fTextViewer.getFindReplaceTarget());
    }

    protected void initializeFindReplaceUIForTextViewer() {
        this.dialog = this.openUIFromTextViewer(this.fTextViewer);
        this.dialog.assertInitialConfiguration();
    }

    protected void reopenFindReplaceUIForTextViewer() {
        this.dialog.close();
        this.dialog = this.openUIFromTextViewer(this.fTextViewer);
    }

    protected abstract AccessType openUIFromTextViewer(TextViewer var1);

    @After
    public void tearDown() throws Exception {
        if (this.dialog != null) {
            this.dialog.closeAndRestore();
            this.dialog = null;
        }
        if (this.fTextViewer != null) {
            this.fTextViewer.getControl().dispose();
            this.fTextViewer = null;
        }
    }

    @Test
    public void testInitialButtonState() {
        this.initializeTextViewerWithFindReplaceUI("");
    }

    @Test
    public void testDisableWholeWordIfRegEx() {
        this.initializeTextViewerWithFindReplaceUI("");
        this.fTextViewer = new TextViewer((Composite)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 2816);
        this.fTextViewer.setDocument((IDocument)new Document("line" + System.lineSeparator() + "line" + System.lineSeparator() + "line"));
        this.fTextViewer.getControl().setFocus();
        this.dialog.setFindText("word");
        this.dialog.assertEnabled(SearchOptions.REGEX);
        this.dialog.assertEnabled(SearchOptions.WHOLE_WORD);
        this.dialog.select(SearchOptions.WHOLE_WORD);
        this.dialog.select(SearchOptions.REGEX);
        this.dialog.assertEnabled(SearchOptions.REGEX);
        this.dialog.assertDisabled(SearchOptions.WHOLE_WORD);
        this.dialog.assertSelected(SearchOptions.WHOLE_WORD);
        this.dialog.unselect(SearchOptions.REGEX);
        this.dialog.assertEnabled(SearchOptions.REGEX);
        this.dialog.assertUnselected(SearchOptions.REGEX);
        this.dialog.assertEnabled(SearchOptions.WHOLE_WORD);
        this.dialog.assertSelected(SearchOptions.WHOLE_WORD);
    }

    @Test
    public void testDisableWholeWordIfNotWord() {
        this.initializeTextViewerWithFindReplaceUI("");
        this.dialog.select(SearchOptions.WHOLE_WORD);
        this.dialog.setFindText("word");
        this.dialog.assertEnabled(SearchOptions.REGEX);
        this.dialog.assertEnabled(SearchOptions.WHOLE_WORD);
        this.dialog.assertSelected(SearchOptions.WHOLE_WORD);
        this.dialog.setFindText("no word");
        this.dialog.assertEnabled(SearchOptions.REGEX);
        this.dialog.assertDisabled(SearchOptions.WHOLE_WORD);
        this.dialog.assertSelected(SearchOptions.WHOLE_WORD);
        this.dialog.setFindText("word_again");
        this.dialog.assertEnabled(SearchOptions.REGEX);
        this.dialog.assertEnabled(SearchOptions.WHOLE_WORD);
        this.dialog.assertSelected(SearchOptions.WHOLE_WORD);
    }

    @Test
    public void testShiftEnterReversesSearchDirection() {
        this.initializeTextViewerWithFindReplaceUI("line\nline\nline");
        this.dialog.select(SearchOptions.INCREMENTAL);
        this.dialog.setFindText("line");
        IFindReplaceTarget target = this.getFindReplaceTarget();
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        this.dialog.simulateKeyboardInteractionInFindInputField(13, false);
        Assert.assertEquals((long)5L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        this.dialog.simulateKeyboardInteractionInFindInputField(13, true);
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        this.dialog.simulateKeyboardInteractionInFindInputField(0x1000050, false);
        Assert.assertEquals((long)5L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        this.dialog.simulateKeyboardInteractionInFindInputField(0x1000050, true);
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
    }

    @Test
    public void testChangeInputForIncrementalSearch() {
        this.initializeTextViewerWithFindReplaceUI("line\nline\nline");
        this.dialog.select(SearchOptions.INCREMENTAL);
        this.dialog.setFindText("lin");
        IFindReplaceTarget target = this.getFindReplaceTarget();
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)this.dialog.getFindText().length(), (long)target.getSelection().y);
        this.dialog.setFindText("line");
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)this.dialog.getFindText().length(), (long)target.getSelection().y);
    }

    @Test
    public void testFindWithWholeWordEnabledWithMultipleWords() {
        this.initializeTextViewerWithFindReplaceUI("two words two");
        this.dialog.select(SearchOptions.INCREMENTAL);
        this.dialog.select(SearchOptions.WHOLE_WORD);
        this.dialog.select(SearchOptions.WRAP);
        this.dialog.setFindText("two");
        IFindReplaceTarget target = this.getFindReplaceTarget();
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)3L, (long)target.getSelection().y);
        this.dialog.setFindText("two wo");
        this.dialog.assertDisabled(SearchOptions.WHOLE_WORD);
        this.dialog.assertSelected(SearchOptions.WHOLE_WORD);
        this.dialog.simulateKeyboardInteractionInFindInputField(13, false);
        MatcherAssert.assertThat((Object)target.getSelectionText(), (Matcher)Matchers.is((Object)this.dialog.getFindText()));
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)this.dialog.getFindText().length(), (long)target.getSelection().y);
    }

    @Test
    public void testRegExSearch() {
        this.initializeTextViewerWithFindReplaceUI("abc");
        this.dialog.select(SearchOptions.INCREMENTAL);
        this.dialog.setFindText("(a|bc)");
        this.dialog.select(SearchOptions.REGEX);
        IFindReplaceTarget target = this.getFindReplaceTarget();
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)1L, (long)target.getSelection().y);
        this.dialog.simulateKeyboardInteractionInFindInputField(13, false);
        Assert.assertEquals((long)1L, (long)target.getSelection().x);
        Assert.assertEquals((long)2L, (long)target.getSelection().y);
        this.dialog.simulateKeyboardInteractionInFindInputField(13, false);
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)1L, (long)target.getSelection().y);
        this.dialog.setFindText("b|c");
        Assert.assertEquals((long)1L, (long)target.getSelection().x);
        Assert.assertEquals((long)1L, (long)target.getSelection().y);
    }

    @Test
    public void testSimpleReplace() {
        this.initializeTextViewerWithFindReplaceUI("ABCD ABCD ABCD");
        this.dialog.select(SearchOptions.INCREMENTAL);
        this.dialog.setFindText("ABCD");
        this.dialog.setReplaceText("abcd");
        this.dialog.performReplace();
        MatcherAssert.assertThat((Object)this.fTextViewer.getDocument().get(), (Matcher)Matchers.is((Object)"abcd ABCD ABCD"));
        this.dialog.performReplaceAll();
        MatcherAssert.assertThat((Object)this.fTextViewer.getDocument().get(), (Matcher)Matchers.is((Object)"abcd abcd abcd"));
        this.dialog.select(SearchOptions.REGEX);
        this.dialog.setFindText("(ab|cd)");
        this.dialog.setReplaceText("o");
        this.dialog.performReplaceAll();
        MatcherAssert.assertThat((Object)this.fTextViewer.getDocument().get(), (Matcher)Matchers.is((Object)"oo oo oo"));
    }

    @Test
    public void testReplaceAllInSelection() {
        this.openTextViewer("line" + System.lineSeparator() + "line" + System.lineSeparator() + "line");
        this.fTextViewer.getControl().setFocus();
        this.fTextViewer.setSelection((ISelection)new TextSelection(4 + System.lineSeparator().length(), 8 + System.lineSeparator().length()));
        this.initializeFindReplaceUIForTextViewer();
        this.dialog.unselect(SearchOptions.GLOBAL);
        this.dialog.unselect(SearchOptions.WHOLE_WORD);
        this.dialog.setFindText("line");
        this.dialog.setReplaceText("");
        this.dialog.performReplaceAll();
        MatcherAssert.assertThat((Object)this.fTextViewer.getDocument().get(), (Matcher)Matchers.is((Object)("line" + System.lineSeparator() + System.lineSeparator())));
    }

    @Test
    public void testActivateWholeWordsAndSearchForTwoWords() {
        this.initializeTextViewerWithFindReplaceUI("text text text");
        this.dialog.select(SearchOptions.WHOLE_WORD);
        this.dialog.setFindText("text text");
        this.dialog.assertDisabled(SearchOptions.WHOLE_WORD);
        this.dialog.assertSelected(SearchOptions.WHOLE_WORD);
        this.dialog.setFindText("text");
        this.dialog.assertEnabled(SearchOptions.WHOLE_WORD);
        this.dialog.assertSelected(SearchOptions.WHOLE_WORD);
        this.dialog.select(SearchOptions.REGEX);
        this.dialog.assertDisabled(SearchOptions.WHOLE_WORD);
        this.dialog.assertSelected(SearchOptions.WHOLE_WORD);
    }

    @Test
    public void testActivateDialogWithSelectionActive() {
        this.openTextViewer("text" + System.lineSeparator() + "text" + System.lineSeparator() + "text");
        this.fTextViewer.setSelection((ISelection)new TextSelection(4 + System.lineSeparator().length(), 8 + System.lineSeparator().length()));
        this.initializeFindReplaceUIForTextViewer();
        this.dialog.assertUnselected(SearchOptions.GLOBAL);
        this.dialog.setFindText("text");
        this.dialog.performReplaceAll();
        MatcherAssert.assertThat((Object)this.fTextViewer.getDocument().get(), (Matcher)Matchers.is((Object)("text" + System.lineSeparator() + System.lineSeparator())));
    }

    @Test
    public void testSearchTextSelectedWhenOpeningDialog() {
        this.openTextViewer("test");
        this.fTextViewer.setSelection((ISelection)new TextSelection(0, 4));
        this.initializeFindReplaceUIForTextViewer();
        Assert.assertEquals((Object)"test", (Object)this.dialog.getFindText());
        Assert.assertEquals((Object)this.dialog.getSelectedFindText(), (Object)this.dialog.getFindText());
    }

    @Test
    public void testSearchTextSelectedWhenSwitchingFocusToDialog() {
        this.openTextViewer("");
        this.initializeFindReplaceUIForTextViewer();
        this.dialog.setFindText("text");
        this.initializeFindReplaceUIForTextViewer();
        Assert.assertEquals((Object)"text", (Object)this.dialog.getFindText());
        Assert.assertEquals((Object)this.dialog.getSelectedFindText(), (Object)this.dialog.getFindText());
    }

    private void assertScopeActivationOnTextInput(String input) {
        this.openTextViewer(input);
        this.fTextViewer.setSelection((ISelection)new TextSelection(0, this.fTextViewer.getDocument().toString().length()));
        this.initializeFindReplaceUIForTextViewer();
        this.dialog.assertUnselected(SearchOptions.GLOBAL);
    }

    @Test
    public void testSelectionOnOpenSetsScopedMode() {
        this.assertScopeActivationOnTextInput("hello\r\nworld\r\nthis\r\nhas_many_lines");
        this.assertScopeActivationOnTextInput("hello\nworld");
    }

    @Test
    public void testActivateDialogSelectionActive_withoutRegExOptionActivated() {
        this.openTextViewer("test text.*;");
        this.initializeFindReplaceUIForTextViewer();
        this.fTextViewer.setSelection((ISelection)new TextSelection("test ".length(), "text.*".length()));
        this.reopenFindReplaceUIForTextViewer();
        this.dialog.assertUnselected(SearchOptions.REGEX);
        Assert.assertEquals((Object)"text.*", (Object)this.dialog.getFindText());
    }

    @Test
    public void testActivateDialogSelectionActive_withRegExOptionActivated() {
        this.openTextViewer("test text.*;");
        this.initializeFindReplaceUIForTextViewer();
        this.dialog.select(SearchOptions.REGEX);
        this.fTextViewer.setSelection((ISelection)new TextSelection("test ".length(), "text.*".length()));
        this.reopenFindReplaceUIForTextViewer();
        this.dialog.assertSelected(SearchOptions.REGEX);
        Assert.assertEquals((Object)"text\\.\\*", (Object)this.dialog.getFindText());
        this.dialog.performReplaceAll();
        MatcherAssert.assertThat((Object)this.fTextViewer.getDocument().get(), (Matcher)Matchers.is((Object)"test ;"));
    }

    @Test
    public void testReplaceIfSelectedOnStart() {
        this.openTextViewer("abcdefg");
        this.fTextViewer.setSelection((ISelection)new TextSelection(2, 2));
        this.initializeFindReplaceUIForTextViewer();
        this.dialog.setReplaceText("aa");
        this.dialog.performReplace();
        MatcherAssert.assertThat((Object)this.fTextViewer.getDocument().get(), (Matcher)Matchers.is((Object)"abaaefg"));
    }

    protected AccessType getDialog() {
        return this.dialog;
    }

    protected TextViewer getTextViewer() {
        return this.fTextViewer;
    }

    protected final IFindReplaceTarget getFindReplaceTarget() {
        return this.fTextViewer.getFindReplaceTarget();
    }
}

