/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.internal.findandreplace.overlay.HistoryTextWrapper;
import org.junit.Assert;

public final class WidgetExtractor {
    private final Composite rootContainer;
    private final String idDataKey;

    public WidgetExtractor(String idDataKey, Composite container) {
        this.idDataKey = idDataKey;
        this.rootContainer = container;
    }

    public HistoryTextWrapper findHistoryTextWrapper(String id) {
        return this.findWidget(this.rootContainer, HistoryTextWrapper.class, id);
    }

    public Combo findCombo(String id) {
        return this.findWidget(this.rootContainer, Combo.class, id);
    }

    public Button findButton(String id) {
        return this.findWidget(this.rootContainer, Button.class, id);
    }

    public ToolItem findToolItem(String id) {
        return this.findWidget(this.rootContainer, ToolItem.class, id);
    }

    private <T extends Widget> T findWidget(Composite container, Class<T> type, String id) {
        List<T> widgets = this.findWidgets(container, type, id);
        Assert.assertFalse((String)("more than one matching widget found for id '" + id + "':" + String.valueOf(widgets)), (widgets.size() > 1 ? 1 : 0) != 0);
        return (T)(widgets.isEmpty() ? null : (Widget)widgets.get(0));
    }

    private <T extends Widget> List<T> findWidgets(Composite container, Class<T> type, String id) {
        ArrayList<Object> children = new ArrayList<Object>();
        children.addAll(List.of(container.getChildren()));
        if (container instanceof ToolBar) {
            ToolBar toolbar = (ToolBar)container;
            children.addAll(List.of(toolbar.getItems()));
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Widget widget : children) {
            if (type.isInstance(widget) && id.equals(widget.getData(this.idDataKey))) {
                result.add((Widget)type.cast(widget));
            }
            if (!(widget instanceof Composite)) continue;
            Composite compositeChild = (Composite)widget;
            result.addAll(this.findWidgets(compositeChild, type, id));
        }
        return result;
    }
}

