/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace.overlay;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.tests.Accessor;
import org.eclipse.ui.internal.findandreplace.FindReplaceTestUtil;
import org.eclipse.ui.internal.findandreplace.FindReplaceUITest;
import org.eclipse.ui.internal.findandreplace.SearchOptions;
import org.eclipse.ui.internal.findandreplace.overlay.FindReplaceOverlay;
import org.eclipse.ui.internal.findandreplace.overlay.OverlayAccess;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class FindReplaceOverlayTest
extends FindReplaceUITest<OverlayAccess> {
    private static final String INSTANCE_SCOPE_NODE_NAME = "org.eclipse.ui.editors";
    private static final String USE_FIND_REPLACE_OVERLAY = "useFindReplaceOverlay";

    @Override
    public OverlayAccess openUIFromTextViewer(TextViewer viewer) {
        Accessor actionAccessor = new Accessor((Object)this.getFindReplaceAction(), FindReplaceAction.class);
        actionAccessor.invoke("showOverlayInEditor", new Object[0]);
        FindReplaceOverlay overlay = (FindReplaceOverlay)actionAccessor.get("overlay");
        OverlayAccess uiAccess = new OverlayAccess(this.getFindReplaceTarget(), overlay);
        FindReplaceTestUtil.waitForFocus(uiAccess::hasFocus, this.testName.getMethodName());
        return uiAccess;
    }

    @Test
    public void testDirectionalSearchButtons() {
        this.initializeTextViewerWithFindReplaceUI("line\nline\nline\nline");
        OverlayAccess dialog = (OverlayAccess)this.getDialog();
        dialog.setFindText("line");
        IFindReplaceTarget target = this.getFindReplaceTarget();
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        dialog.pressSearch(true);
        Assert.assertEquals((long)5L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        dialog.pressSearch(true);
        Assert.assertEquals((long)10L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        dialog.pressSearch(false);
        Assert.assertEquals((long)5L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        dialog.pressSearch(true);
        Assert.assertEquals((long)10L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        dialog.pressSearch(false);
        Assert.assertEquals((long)5L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        dialog.pressSearch(false);
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
    }

    @Test
    public void testIncrementalSearchUpdatesAfterChangingOptions() {
        this.initializeTextViewerWithFindReplaceUI("alinee\naLinee\nline\nline");
        OverlayAccess dialog = (OverlayAccess)this.getDialog();
        IFindReplaceTarget target = this.getFindReplaceTarget();
        dialog.setFindText("Line");
        MatcherAssert.assertThat((Object)target.getSelectionText(), (Matcher)Matchers.is((Object)"line"));
        Assert.assertEquals((Object)new Point(1, 4), (Object)target.getSelection());
        dialog.select(SearchOptions.CASE_SENSITIVE);
        MatcherAssert.assertThat((Object)target.getSelectionText(), (Matcher)Matchers.is((Object)"Line"));
        Assert.assertEquals((Object)new Point(8, 4), (Object)target.getSelection());
        dialog.unselect(SearchOptions.CASE_SENSITIVE);
        Assert.assertEquals((long)1L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        dialog.select(SearchOptions.WHOLE_WORD);
        Assert.assertEquals((long)14L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        dialog.unselect(SearchOptions.CASE_SENSITIVE);
        dialog.unselect(SearchOptions.WHOLE_WORD);
        Assert.assertEquals((long)1L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        MatcherAssert.assertThat((Object)target.getSelectionText(), (Matcher)Matchers.is((Object)"line"));
    }

    @Test
    public void testCantOpenReplaceDialogInReadOnlyEditor() {
        this.openTextViewer("text");
        this.getTextViewer().setEditable(false);
        this.initializeFindReplaceUIForTextViewer();
        OverlayAccess dialog = (OverlayAccess)this.getDialog();
        dialog.openReplaceDialog();
        MatcherAssert.assertThat((Object)dialog.isReplaceDialogOpen(), (Matcher)Matchers.is((Object)false));
        this.reopenFindReplaceUIForTextViewer();
        dialog = (OverlayAccess)this.getDialog();
        MatcherAssert.assertThat((Object)dialog.isReplaceDialogOpen(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testRememberReplaceExpandState() {
        this.initializeTextViewerWithFindReplaceUI("text");
        OverlayAccess dialog = (OverlayAccess)this.getDialog();
        dialog.openReplaceDialog();
        MatcherAssert.assertThat((Object)dialog.isReplaceDialogOpen(), (Matcher)Matchers.is((Object)true));
        this.reopenFindReplaceUIForTextViewer();
        dialog = (OverlayAccess)this.getDialog();
        MatcherAssert.assertThat((Object)dialog.isReplaceDialogOpen(), (Matcher)Matchers.is((Object)true));
        dialog.closeReplaceDialog();
        this.reopenFindReplaceUIForTextViewer();
        dialog = (OverlayAccess)this.getDialog();
        MatcherAssert.assertThat((Object)dialog.isReplaceDialogOpen(), (Matcher)Matchers.is((Object)false));
        dialog.openReplaceDialog();
        this.getTextViewer().setEditable(false);
        this.reopenFindReplaceUIForTextViewer();
        dialog = (OverlayAccess)this.getDialog();
        MatcherAssert.assertThat((Object)dialog.isReplaceDialogOpen(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testSearchBackwardsWithRegEx() {
        this.initializeTextViewerWithFindReplaceUI("text text text");
        IFindReplaceTarget target = this.getFindReplaceTarget();
        OverlayAccess dialog = (OverlayAccess)this.getDialog();
        dialog.select(SearchOptions.REGEX);
        dialog.setFindText("text");
        MatcherAssert.assertThat((Object)target.getSelection().y, (Matcher)Matchers.is((Object)4));
        dialog.pressSearch(true);
        MatcherAssert.assertThat((Object)target.getSelection().x, (Matcher)Matchers.is((Object)"text ".length()));
        dialog.pressSearch(true);
        MatcherAssert.assertThat((Object)target.getSelection().x, (Matcher)Matchers.is((Object)"text text ".length()));
        dialog.pressSearch(false);
        MatcherAssert.assertThat((Object)target.getSelection().x, (Matcher)Matchers.is((Object)"text ".length()));
    }

    @Test
    public void testDisableOverlayViaPreference() {
        this.initializeTextViewerWithFindReplaceUI("");
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(INSTANCE_SCOPE_NODE_NAME);
        boolean useOverlayPreference = preferences.getBoolean(USE_FIND_REPLACE_OVERLAY, true);
        try {
            preferences.putBoolean(USE_FIND_REPLACE_OVERLAY, false);
            Assert.assertFalse((String)"dialog should be closed after changing preference", (boolean)((OverlayAccess)this.getDialog()).isShown());
        }
        finally {
            preferences.putBoolean(USE_FIND_REPLACE_OVERLAY, useOverlayPreference);
            this.reopenFindReplaceUIForTextViewer();
        }
    }
}

