/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace.overlay;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.internal.findandreplace.FindReplaceTestUtil;
import org.eclipse.ui.internal.findandreplace.IFindReplaceUIAccess;
import org.eclipse.ui.internal.findandreplace.SearchOptions;
import org.eclipse.ui.internal.findandreplace.WidgetExtractor;
import org.eclipse.ui.internal.findandreplace.overlay.FindReplaceOverlay;
import org.eclipse.ui.internal.findandreplace.overlay.HistoryTextWrapper;
import org.junit.Assert;

class OverlayAccess
implements IFindReplaceUIAccess {
    private final IFindReplaceTarget findReplaceTarget;
    private final HistoryTextWrapper find;
    private final ToolItem inSelection;
    private final ToolItem caseSensitive;
    private final ToolItem wholeWord;
    private final ToolItem regEx;
    private final ToolItem searchForward;
    private final ToolItem searchBackward;
    private final ToolItem openReplaceDialog;
    private HistoryTextWrapper replace;
    private ToolItem replaceButton;
    private ToolItem replaceAllButton;
    private final FindReplaceOverlay overlay;

    OverlayAccess(IFindReplaceTarget findReplaceTarget, FindReplaceOverlay findReplaceOverlay) {
        this.findReplaceTarget = findReplaceTarget;
        this.overlay = findReplaceOverlay;
        WidgetExtractor widgetExtractor = new WidgetExtractor("org.eclipse.ui.internal.findreplace.overlay.FindReplaceOverlay.id", findReplaceOverlay.getContainerControl());
        this.find = widgetExtractor.findHistoryTextWrapper("searchInput");
        this.caseSensitive = widgetExtractor.findToolItem("caseSensitiveSearch");
        this.wholeWord = widgetExtractor.findToolItem("wholeWordSearch");
        this.regEx = widgetExtractor.findToolItem("regExSearch");
        this.inSelection = widgetExtractor.findToolItem("searchInSelection");
        this.searchForward = widgetExtractor.findToolItem("searchForward");
        this.searchBackward = widgetExtractor.findToolItem("searchBackward");
        this.openReplaceDialog = widgetExtractor.findToolItem("replaceToggle");
        this.extractReplaceWidgets();
    }

    private void extractReplaceWidgets() {
        if (!this.isReplaceDialogOpen() && Objects.nonNull(this.openReplaceDialog)) {
            WidgetExtractor widgetExtractor = new WidgetExtractor("org.eclipse.ui.internal.findreplace.overlay.FindReplaceOverlay.id", this.getContainerControl());
            this.replace = widgetExtractor.findHistoryTextWrapper("replaceInput");
            this.replaceButton = widgetExtractor.findToolItem("replaceOne");
            this.replaceAllButton = widgetExtractor.findToolItem("replaceAll");
        }
    }

    private Composite getContainerControl() {
        return this.overlay.getContainerControl();
    }

    private void restoreInitialConfiguration() {
        this.find.setText("");
        this.select(SearchOptions.GLOBAL);
        this.unselect(SearchOptions.REGEX);
        this.unselect(SearchOptions.CASE_SENSITIVE);
        this.unselect(SearchOptions.WHOLE_WORD);
    }

    @Override
    public void closeAndRestore() {
        this.restoreInitialConfiguration();
        this.assertInitialConfiguration();
        this.close();
    }

    @Override
    public void close() {
        this.overlay.close();
    }

    @Override
    public void select(SearchOptions option) {
        ToolItem button = this.getButtonForSearchOption(option);
        if (button == null) {
            return;
        }
        button.setSelection(true);
        if (option == SearchOptions.GLOBAL) {
            button.setSelection(false);
        }
        button.notifyListeners(13, null);
    }

    @Override
    public void unselect(SearchOptions option) {
        ToolItem button = this.getButtonForSearchOption(option);
        if (button == null) {
            return;
        }
        button.setSelection(false);
        if (option == SearchOptions.GLOBAL) {
            button.setSelection(true);
        }
        button.notifyListeners(13, null);
    }

    @Override
    public void simulateKeyboardInteractionInFindInputField(int keyCode, boolean shiftPressed) {
        Event event = new Event();
        event.type = 1;
        if (shiftPressed) {
            event.stateMask = 131072;
        }
        event.keyCode = keyCode;
        this.find.notifyListeners(1, event);
        FindReplaceTestUtil.runEventQueue();
    }

    @Override
    public String getFindText() {
        return this.find.getText();
    }

    @Override
    public String getSelectedFindText() {
        return this.find.getSelectionText();
    }

    @Override
    public String getReplaceText() {
        return this.replace.getText();
    }

    @Override
    public void setFindText(String text) {
        this.find.setText(text);
        this.find.notifyListeners(24, null);
    }

    @Override
    public void setReplaceText(String text) {
        this.openReplaceDialog();
        this.replace.setText(text);
    }

    public ToolItem getButtonForSearchOption(SearchOptions option) {
        switch (option) {
            case CASE_SENSITIVE: {
                return this.caseSensitive;
            }
            case REGEX: {
                return this.regEx;
            }
            case WHOLE_WORD: {
                return this.wholeWord;
            }
            case GLOBAL: {
                return this.inSelection;
            }
        }
        return null;
    }

    private Set<SearchOptions> getEnabledOptions() {
        return Arrays.stream(SearchOptions.values()).filter(option -> this.getButtonForSearchOption((SearchOptions)option) != null && this.getButtonForSearchOption((SearchOptions)option).getEnabled()).collect(Collectors.toSet());
    }

    private Set<SearchOptions> getSelectedOptions() {
        return Arrays.stream(SearchOptions.values()).filter(this.isOptionSelected()).collect(Collectors.toSet());
    }

    private Predicate<? super SearchOptions> isOptionSelected() {
        return option -> {
            ToolItem buttonForSearchOption = this.getButtonForSearchOption((SearchOptions)option);
            if (option == SearchOptions.GLOBAL) {
                return !buttonForSearchOption.getSelection();
            }
            return buttonForSearchOption != null && buttonForSearchOption.getSelection();
        };
    }

    public void pressSearch(boolean forward) {
        if (forward) {
            this.searchForward.notifyListeners(13, null);
        } else {
            this.searchBackward.notifyListeners(13, null);
        }
    }

    @Override
    public void performReplaceAll() {
        this.openReplaceDialog();
        this.replaceAllButton.notifyListeners(13, null);
    }

    @Override
    public void performReplace() {
        this.openReplaceDialog();
        this.replaceButton.notifyListeners(13, null);
    }

    public boolean isReplaceDialogOpen() {
        return this.replace != null;
    }

    public void openReplaceDialog() {
        if (!this.isReplaceDialogOpen() && Objects.nonNull(this.openReplaceDialog)) {
            this.openReplaceDialog.notifyListeners(13, null);
            this.extractReplaceWidgets();
        }
    }

    public void closeReplaceDialog() {
        if (this.isReplaceDialogOpen() && Objects.nonNull(this.openReplaceDialog)) {
            this.openReplaceDialog.notifyListeners(13, null);
            this.replace = null;
            this.replaceButton = null;
            this.replaceAllButton = null;
        }
    }

    @Override
    public void performReplaceAndFind() {
        this.performReplace();
    }

    @Override
    public void assertInitialConfiguration() {
        this.assertUnselected(SearchOptions.REGEX);
        this.assertUnselected(SearchOptions.WHOLE_WORD);
        this.assertUnselected(SearchOptions.CASE_SENSITIVE);
        if (!this.doesTextViewerHaveMultiLineSelection()) {
            this.assertSelected(SearchOptions.GLOBAL);
        } else {
            this.assertUnselected(SearchOptions.GLOBAL);
        }
        this.assertEnabled(SearchOptions.GLOBAL);
        this.assertEnabled(SearchOptions.REGEX);
        this.assertEnabled(SearchOptions.CASE_SENSITIVE);
        if (!this.getFindText().contains(" ")) {
            this.assertEnabled(SearchOptions.WHOLE_WORD);
        } else {
            this.assertDisabled(SearchOptions.WHOLE_WORD);
        }
    }

    private boolean doesTextViewerHaveMultiLineSelection() {
        IFindReplaceTarget iFindReplaceTarget = this.findReplaceTarget;
        if (iFindReplaceTarget instanceof IFindReplaceTargetExtension) {
            IFindReplaceTargetExtension scopeProvider = (IFindReplaceTargetExtension)iFindReplaceTarget;
            return scopeProvider.getScope() != null;
        }
        return false;
    }

    @Override
    public void assertUnselected(SearchOptions option) {
        Assert.assertFalse((boolean)this.getSelectedOptions().contains(option));
    }

    @Override
    public void assertSelected(SearchOptions option) {
        Assert.assertTrue((boolean)this.getSelectedOptions().contains(option));
    }

    @Override
    public void assertDisabled(SearchOptions option) {
        Assert.assertFalse((boolean)this.getEnabledOptions().contains(option));
    }

    @Override
    public void assertEnabled(SearchOptions option) {
        Assert.assertTrue((boolean)this.getEnabledOptions().contains(option));
    }

    @Override
    public boolean isShown() {
        return this.getContainerControl().isVisible();
    }

    @Override
    public boolean hasFocus() {
        Control focusControl = this.getContainerControl().getDisplay().getFocusControl();
        while (focusControl != null) {
            if (this.getContainerControl() == focusControl) {
                return true;
            }
            focusControl = focusControl.getParent();
        }
        return false;
    }
}

