/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.AbstractMultiEditor;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.TextZoomInHandler;
import org.junit.Assert;
import org.junit.Test;

public class AbstractTextZoomHandlerTest {
    @Test
    public void textZoomIsSupportedForAbstractTextEditor() {
        TestAbstractTextEditor part = new TestAbstractTextEditor();
        this.assertZoomSupported((Object)part, true);
    }

    @Test
    public void textZoomIsNotSupportedForNonTextEditor() {
        TestNonTextEditor part = new TestNonTextEditor();
        this.assertZoomSupported((Object)part, false);
    }

    @Test
    public void textZoomIsSupportedForMultiPageEditorPartWithAbstractTextEditorPage() {
        TestMultiPageEditorPart part = new TestMultiPageEditorPart((IEditorPart)new TestAbstractTextEditor());
        this.assertZoomSupported((Object)part, true);
    }

    @Test
    public void textZoomIsNotSupportedForMultiPageEditorPartWithNonTextPage() {
        TestMultiPageEditorPart part = new TestMultiPageEditorPart((IEditorPart)new TestNonTextEditor());
        this.assertZoomSupported((Object)part, false);
    }

    @Test
    public void textZoomIsSupportedForMultiEditorWithTextPage() {
        TestMultiEditor part = new TestMultiEditor((IEditorPart)new TestAbstractTextEditor());
        this.assertZoomSupported((Object)part, true);
    }

    @Test
    public void textZoomIsNotSupportedForMultiEditorWithNonTextPage() {
        TestMultiEditor part = new TestMultiEditor((IEditorPart)new TestNonTextEditor());
        this.assertZoomSupported((Object)part, false);
    }

    @Test
    public void textZoomIsSupportedForAdaptableToAbstractTextEditor() {
        TestAdaptableToAbstractTestEditor part = new TestAdaptableToAbstractTestEditor();
        this.assertZoomSupported((Object)part, true);
    }

    @Test
    public void textZoomIsNotSupportedForGenericObject() {
        this.assertZoomSupported(new Object(), false);
    }

    private void assertZoomSupported(Object receiver, boolean expectedEnabled) {
        TextZoomInHandler textZoomHandler = new TextZoomInHandler();
        EvaluationContext evaluationContext = new EvaluationContext(null, new Object());
        evaluationContext.addVariable("activeEditor", receiver);
        textZoomHandler.setEnabled((Object)evaluationContext);
        boolean actualEnabled = textZoomHandler.isEnabled();
        Assert.assertEquals((Object)expectedEnabled, (Object)actualEnabled);
    }

    private static class TestAbstractTextEditor
    extends AbstractTextEditor {
        private TestAbstractTextEditor() {
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        }
    }

    private static class TestAdaptableToAbstractTestEditor
    extends TestNonTextEditor {
        private TestAdaptableToAbstractTestEditor() {
        }

        @Override
        public <T> T getAdapter(Class<T> adapter) {
            if (adapter == AbstractTextEditor.class) {
                return adapter.cast((Object)new TestAbstractTextEditor());
            }
            return null;
        }
    }

    private static class TestMultiEditor
    extends AbstractMultiEditor {
        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public TestMultiEditor(IEditorPart child) {
            this.setChildren(new IEditorPart[]{child});
        }

        public void createPartControl(Composite parent) {
        }

        protected void innerEditorsCreated() {
        }

        public Composite getInnerEditorContainer(IEditorReference innerEditorReference) {
            return null;
        }
    }

    private static class TestMultiPageEditorPart
    extends MultiPageEditorPart {
        private final IEditorPart child;

        public TestMultiPageEditorPart(IEditorPart child) {
            this.child = child;
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public boolean isSaveAsAllowed() {
            return false;
        }

        public void doSaveAs() {
        }

        public void doSave(IProgressMonitor monitor) {
        }

        protected void createPages() {
        }

        public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        }

        public Object getSelectedPage() {
            return this.child;
        }
    }

    private static class TestNonTextEditor
    extends EditorPart {
        private TestNonTextEditor() {
        }

        public <T> T getAdapter(Class<T> adapter) {
            return null;
        }

        public void doSave(IProgressMonitor monitor) {
        }

        public void doSaveAs() {
        }

        public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        }

        public boolean isDirty() {
            return false;
        }

        public boolean isSaveAsAllowed() {
            return false;
        }

        public void createPartControl(Composite parent) {
        }

        public void setFocus() {
        }
    }
}

