/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.findandreplace.FindReplaceTestUtil;
import org.eclipse.ui.internal.findandreplace.IFindReplaceUIAccess;
import org.eclipse.ui.internal.findandreplace.SearchOptions;
import org.eclipse.ui.internal.findandreplace.WidgetExtractor;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

class DialogAccess
implements IFindReplaceUIAccess {
    private static final String DATA_ID = "org.eclipse.ui.texteditor.FindReplaceDialog.id";
    private final IFindReplaceTarget findReplaceTarget;
    private final Dialog findReplaceDialog;
    private final Combo findCombo;
    private final Combo replaceCombo;
    private final Button forwardRadioButton;
    private final Button globalRadioButton;
    private final Button searchInRangeRadioButton;
    private final Button caseCheckBox;
    private final Button wrapCheckBox;
    private final Button wholeWordCheckBox;
    private final Button incrementalCheckBox;
    private final Button regExCheckBox;
    private final Button replaceButton;
    private final Button replaceFindButton;
    private final Button replaceAllButton;
    private final Button findNextButton;

    DialogAccess(IFindReplaceTarget findReplaceTarget, Dialog findReplaceDialog) {
        this.findReplaceTarget = findReplaceTarget;
        this.findReplaceDialog = findReplaceDialog;
        WidgetExtractor widgetExtractor = new WidgetExtractor(DATA_ID, (Composite)findReplaceDialog.getShell());
        this.findCombo = widgetExtractor.findCombo("searchInput");
        this.replaceCombo = widgetExtractor.findCombo("replaceInput");
        this.forwardRadioButton = widgetExtractor.findButton("searchForward");
        this.globalRadioButton = widgetExtractor.findButton("globalSearch");
        this.searchInRangeRadioButton = widgetExtractor.findButton("searchInSelection");
        this.caseCheckBox = widgetExtractor.findButton("caseSensitiveSearch");
        this.wrapCheckBox = widgetExtractor.findButton("wrappedSearch");
        this.wholeWordCheckBox = widgetExtractor.findButton("wholeWordSearch");
        this.incrementalCheckBox = widgetExtractor.findButton("incrementalSearch");
        this.regExCheckBox = widgetExtractor.findButton("regExSearch");
        this.replaceButton = widgetExtractor.findButton("replaceOne");
        this.replaceFindButton = widgetExtractor.findButton("replaceFindOne");
        this.replaceAllButton = widgetExtractor.findButton("replaceAll");
        this.findNextButton = widgetExtractor.findButton("findNext");
    }

    void restoreInitialConfiguration() {
        this.findCombo.setText("");
        this.select(SearchOptions.FORWARD);
        this.select(SearchOptions.GLOBAL);
        this.select(SearchOptions.WRAP);
        this.unselect(SearchOptions.INCREMENTAL);
        this.unselect(SearchOptions.REGEX);
        this.unselect(SearchOptions.CASE_SENSITIVE);
        this.unselect(SearchOptions.WHOLE_WORD);
    }

    public Button getButtonForSearchOption(SearchOptions option) {
        switch (option) {
            case CASE_SENSITIVE: {
                return this.caseCheckBox;
            }
            case FORWARD: {
                return this.forwardRadioButton;
            }
            case GLOBAL: {
                return this.globalRadioButton;
            }
            case INCREMENTAL: {
                return this.incrementalCheckBox;
            }
            case REGEX: {
                return this.regExCheckBox;
            }
            case WHOLE_WORD: {
                return this.wholeWordCheckBox;
            }
            case WRAP: {
                return this.wrapCheckBox;
            }
        }
        return null;
    }

    @Override
    public void select(SearchOptions option) {
        Button button = this.getButtonForSearchOption(option);
        button.setSelection(true);
        button.notifyListeners(13, null);
    }

    @Override
    public void unselect(SearchOptions option) {
        Button button = this.getButtonForSearchOption(option);
        if (option == SearchOptions.GLOBAL) {
            button = this.searchInRangeRadioButton;
            button.setSelection(true);
            this.globalRadioButton.setSelection(false);
        } else {
            button.setSelection(false);
        }
        button.notifyListeners(13, null);
    }

    @Override
    public void closeAndRestore() {
        this.restoreInitialConfiguration();
        this.assertInitialConfiguration();
        this.findReplaceDialog.close();
    }

    @Override
    public void close() {
        this.findReplaceDialog.close();
    }

    @Override
    public boolean hasFocus() {
        Shell focusControlShell;
        Control focusControl = this.findReplaceDialog.getShell().getDisplay().getFocusControl();
        Shell shell = focusControlShell = focusControl != null ? focusControl.getShell() : null;
        return focusControlShell == this.findReplaceDialog.getShell();
    }

    @Override
    public void simulateKeyboardInteractionInFindInputField(int keyCode, boolean shiftPressed) {
        Event event = new Event();
        event.detail = 4;
        event.type = 1;
        if (shiftPressed) {
            event.stateMask = 131072;
        }
        event.keyCode = keyCode;
        this.findCombo.traverse(4, event);
        FindReplaceTestUtil.runEventQueue();
    }

    @Override
    public String getReplaceText() {
        return this.replaceCombo.getText();
    }

    @Override
    public void setFindText(String text) {
        this.findCombo.setText(text);
        this.findCombo.notifyListeners(24, null);
    }

    @Override
    public void setReplaceText(String text) {
        this.replaceCombo.setText(text);
        this.replaceCombo.notifyListeners(24, null);
    }

    @Override
    public String getFindText() {
        return this.findCombo.getText();
    }

    @Override
    public String getSelectedFindText() {
        Point selection = this.findCombo.getSelection();
        return this.findCombo.getText().substring(selection.x, selection.y);
    }

    public Button getReplaceButton() {
        return this.replaceButton;
    }

    public Combo getFindCombo() {
        return this.findCombo;
    }

    @Override
    public void performReplaceAll() {
        if (this.replaceAllButton.getEnabled()) {
            this.replaceAllButton.notifyListeners(13, null);
        }
    }

    @Override
    public void performReplace() {
        if (this.replaceButton.getEnabled()) {
            this.replaceButton.notifyListeners(13, null);
        }
    }

    public void performFindNext() {
        if (this.findNextButton.getEnabled()) {
            this.findNextButton.notifyListeners(13, null);
        }
    }

    @Override
    public void performReplaceAndFind() {
        if (this.replaceFindButton.getEnabled()) {
            this.replaceFindButton.notifyListeners(13, null);
        }
    }

    @Override
    public void assertInitialConfiguration() {
        this.assertSelected(SearchOptions.FORWARD);
        if (!this.doesTextViewerHaveMultiLineSelection(this.findReplaceTarget)) {
            this.assertSelected(SearchOptions.GLOBAL);
        } else {
            this.assertUnselected(SearchOptions.GLOBAL);
        }
        this.assertSelected(SearchOptions.WRAP);
        this.assertEnabled(SearchOptions.WRAP);
        this.assertEnabled(SearchOptions.CASE_SENSITIVE);
        this.assertEnabled(SearchOptions.REGEX);
        this.assertEnabled(SearchOptions.INCREMENTAL);
        this.assertUnselected(SearchOptions.CASE_SENSITIVE);
        this.assertUnselected(SearchOptions.REGEX);
        this.assertUnselected(SearchOptions.INCREMENTAL);
        String findString = this.getFindText();
        if (this.getEnabledOptions().contains(SearchOptions.WHOLE_WORD)) {
            Assert.assertFalse((boolean)findString.contains(" "));
        }
    }

    private boolean doesTextViewerHaveMultiLineSelection(IFindReplaceTarget target) {
        if (target instanceof IFindReplaceTargetExtension) {
            IFindReplaceTargetExtension scopeProvider = (IFindReplaceTargetExtension)target;
            return scopeProvider.getScope() != null;
        }
        return false;
    }

    @Override
    public void assertEnabled(SearchOptions option) {
        Set<SearchOptions> enabled = this.getEnabledOptions();
        MatcherAssert.assertThat(enabled, (Matcher)Matchers.hasItems((Object[])new SearchOptions[]{option}));
    }

    @Override
    public void assertDisabled(SearchOptions option) {
        Set<SearchOptions> enabled = this.getEnabledOptions();
        MatcherAssert.assertThat(enabled, (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new SearchOptions[]{option})));
    }

    @Override
    public void assertSelected(SearchOptions option) {
        Set<SearchOptions> enabled = this.getSelectedOptions();
        MatcherAssert.assertThat(enabled, (Matcher)Matchers.hasItems((Object[])new SearchOptions[]{option}));
    }

    @Override
    public void assertUnselected(SearchOptions option) {
        Set<SearchOptions> enabled = this.getSelectedOptions();
        MatcherAssert.assertThat(enabled, (Matcher)Matchers.not((Matcher)Matchers.hasItems((Object[])new SearchOptions[]{option})));
    }

    private Set<SearchOptions> getEnabledOptions() {
        return Arrays.stream(SearchOptions.values()).filter(option -> this.getButtonForSearchOption((SearchOptions)option).isEnabled()).collect(Collectors.toSet());
    }

    private Set<SearchOptions> getSelectedOptions() {
        return Arrays.stream(SearchOptions.values()).filter(option -> this.getButtonForSearchOption((SearchOptions)option).getSelection()).collect(Collectors.toSet());
    }

    @Override
    public boolean isShown() {
        return this.findReplaceDialog.getShell().isVisible();
    }
}

