/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.text.tests.Accessor;
import org.eclipse.ui.internal.findandreplace.FindReplaceTestUtil;
import org.eclipse.ui.internal.findandreplace.FindReplaceUITest;
import org.eclipse.ui.internal.findandreplace.SearchOptions;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.workbench.texteditor.tests.DialogAccess;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class FindReplaceDialogTest
extends FindReplaceUITest<DialogAccess> {
    @Override
    public DialogAccess openUIFromTextViewer(TextViewer viewer) {
        Accessor findActionAccessor = new Accessor((Object)this.getFindReplaceAction(), FindReplaceAction.class);
        findActionAccessor.invoke("showDialog", new Object[0]);
        Object fFindReplaceDialogStub = findActionAccessor.get("fgFindReplaceDialogStub");
        if (fFindReplaceDialogStub == null) {
            fFindReplaceDialogStub = findActionAccessor.get("fgFindReplaceDialogStubShell");
        }
        Accessor fFindReplaceDialogStubAccessor = new Accessor(fFindReplaceDialogStub, "org.eclipse.ui.texteditor.FindReplaceAction$FindReplaceDialogStub", this.getClass().getClassLoader());
        Dialog dialog = (Dialog)fFindReplaceDialogStubAccessor.invoke("getDialog", new Object[0]);
        DialogAccess uiAccess = new DialogAccess(this.getFindReplaceTarget(), dialog);
        FindReplaceTestUtil.waitForFocus(uiAccess::hasFocus, this.testName.getMethodName());
        return uiAccess;
    }

    @Test
    public void testFocusNotChangedWhenEnterPressed() {
        Assume.assumeFalse((String)"On Mac, checkboxes only take focus if 'Full Keyboard Access' is enabled in the system preferences", (boolean)Util.isMac());
        this.initializeTextViewerWithFindReplaceUI("line\nline\nline");
        DialogAccess dialog = (DialogAccess)this.getDialog();
        dialog.getFindCombo().setFocus();
        dialog.setFindText("line");
        dialog.simulateKeyboardInteractionInFindInputField(13, false);
        Assert.assertTrue((boolean)dialog.getFindCombo().isFocusControl());
        Button wrapCheckBox = dialog.getButtonForSearchOption(SearchOptions.WRAP);
        Button globalRadioButton = dialog.getButtonForSearchOption(SearchOptions.GLOBAL);
        wrapCheckBox.setFocus();
        dialog.simulateKeyboardInteractionInFindInputField(13, false);
        Assert.assertTrue((boolean)wrapCheckBox.isFocusControl());
        globalRadioButton.setFocus();
        dialog.simulateKeyboardInteractionInFindInputField(13, false);
        Assert.assertTrue((boolean)globalRadioButton.isFocusControl());
    }

    @Test
    public void testFocusNotChangedWhenButtonMnemonicPressed() {
        Assume.assumeFalse((String)"Mac does not support mnemonics", (boolean)Util.isMac());
        this.initializeTextViewerWithFindReplaceUI("");
        DialogAccess dialog = (DialogAccess)this.getDialog();
        dialog.setFindText("line");
        FindReplaceTestUtil.runEventQueue();
        Button wrapCheckBox = dialog.getButtonForSearchOption(SearchOptions.WRAP);
        wrapCheckBox.setFocus();
        Event event = new Event();
        event.detail = 128;
        event.character = (char)110;
        event.doit = false;
        wrapCheckBox.traverse(128, event);
        FindReplaceTestUtil.runEventQueue();
        Assert.assertTrue((boolean)wrapCheckBox.isFocusControl());
        Button globalRadioButton = dialog.getButtonForSearchOption(SearchOptions.GLOBAL);
        globalRadioButton.setFocus();
        event.detail = 128;
        event.doit = false;
        globalRadioButton.traverse(128, event);
        FindReplaceTestUtil.runEventQueue();
        Assert.assertTrue((boolean)globalRadioButton.isFocusControl());
        event.detail = 128;
        event.character = (char)114;
        event.doit = false;
        globalRadioButton.traverse(128, event);
        FindReplaceTestUtil.runEventQueue();
        Assert.assertTrue((boolean)globalRadioButton.isFocusControl());
    }

    @Test
    public void testShiftEnterReversesSearchDirectionDialogSpecific() {
        this.initializeTextViewerWithFindReplaceUI("line\nline\nline");
        DialogAccess dialog = (DialogAccess)this.getDialog();
        dialog.setFindText("line");
        IFindReplaceTarget target = this.getFindReplaceTarget();
        dialog.simulateKeyboardInteractionInFindInputField(13, false);
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        dialog.simulateKeyboardInteractionInFindInputField(13, false);
        Assert.assertEquals((long)5L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        dialog.simulateKeyboardInteractionInFindInputField(13, true);
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        dialog.unselect(SearchOptions.FORWARD);
        dialog.simulateKeyboardInteractionInFindInputField(13, true);
        Assert.assertEquals((long)5L, (long)target.getSelection().x);
    }

    @Test
    public void testReplaceAndFindAfterInitializingFindWithSelectedString() {
        this.openTextViewer("text text text");
        this.getTextViewer().setSelectedRange(0, 4);
        this.initializeFindReplaceUIForTextViewer();
        DialogAccess dialog = (DialogAccess)this.getDialog();
        MatcherAssert.assertThat((Object)dialog.getFindText(), (Matcher)Matchers.is((Object)"text"));
        IFindReplaceTarget target = this.getFindReplaceTarget();
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
        dialog.performReplaceAndFind();
        Assert.assertEquals((Object)" text text", (Object)this.getTextViewer().getDocument().get());
        Assert.assertEquals((long)1L, (long)target.getSelection().x);
        Assert.assertEquals((long)4L, (long)target.getSelection().y);
    }

    @Test
    public void testIncrementalSearchOptionRecoveredCorrectly() {
        this.initializeTextViewerWithFindReplaceUI("text text text");
        DialogAccess dialog = (DialogAccess)this.getDialog();
        dialog.select(SearchOptions.INCREMENTAL);
        dialog.assertSelected(SearchOptions.INCREMENTAL);
        dialog.assertEnabled(SearchOptions.INCREMENTAL);
        this.reopenFindReplaceUIForTextViewer();
        dialog = (DialogAccess)this.getDialog();
        dialog.assertSelected(SearchOptions.INCREMENTAL);
        dialog.assertEnabled(SearchOptions.INCREMENTAL);
    }

    @Test
    public void testFindWithWholeWordEnabledWithMultipleWordsNotIncremental() {
        this.initializeTextViewerWithFindReplaceUI("two words two");
        DialogAccess dialog = (DialogAccess)this.getDialog();
        dialog.setFindText("two");
        dialog.select(SearchOptions.WHOLE_WORD);
        dialog.select(SearchOptions.WRAP);
        IFindReplaceTarget target = this.getFindReplaceTarget();
        dialog.simulateKeyboardInteractionInFindInputField(13, false);
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)3L, (long)target.getSelection().y);
        dialog.setFindText("two wo");
        dialog.assertDisabled(SearchOptions.WHOLE_WORD);
        dialog.assertSelected(SearchOptions.WHOLE_WORD);
        dialog.simulateKeyboardInteractionInFindInputField(13, false);
        MatcherAssert.assertThat((Object)target.getSelectionText(), (Matcher)Matchers.is((Object)dialog.getFindText()));
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)dialog.getFindText().length(), (long)target.getSelection().y);
    }

    @Test
    public void testRegExSearch_nonIncremental() {
        this.initializeTextViewerWithFindReplaceUI("abc");
        DialogAccess dialog = (DialogAccess)this.getDialog();
        dialog.setFindText("(a|bc)");
        dialog.select(SearchOptions.REGEX);
        IFindReplaceTarget target = this.getFindReplaceTarget();
        dialog.simulateKeyboardInteractionInFindInputField(13, false);
        Assert.assertEquals((long)0L, (long)target.getSelection().x);
        Assert.assertEquals((long)1L, (long)target.getSelection().y);
        dialog.simulateKeyboardInteractionInFindInputField(13, false);
        Assert.assertEquals((long)1L, (long)target.getSelection().x);
        Assert.assertEquals((long)2L, (long)target.getSelection().y);
    }

    @Test
    public void testReplaceButtonEnabledWithRegexSearched() {
        this.initializeTextViewerWithFindReplaceUI("one two three");
        DialogAccess dialog = (DialogAccess)this.getDialog();
        dialog.setFindText("two");
        dialog.select(SearchOptions.REGEX);
        dialog.setReplaceText("two2");
        dialog.performFindNext();
        Assert.assertTrue((boolean)dialog.getReplaceButton().isEnabled());
    }
}

