/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests;

import java.io.File;
import java.io.PrintStream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;

public class ScreenshotTest {
    @Rule
    public TestName testName = new TestName();

    @Test
    public void testScreenshot() throws Exception {
        String screenshot = ScreenshotTest.takeScreenshot(ScreenshotTest.class, this.testName.getMethodName(), System.out);
        new File(screenshot).delete();
    }

    @Test
    public void testWindowsTaskManagerScreenshots() throws Exception {
        if (!Util.isWindows()) {
            return;
        }
        Display display = Display.getDefault();
        Event event = new Event();
        event.type = 1;
        event.keyCode = 262144;
        System.out.println("* CTRL " + display.post(event));
        event.keyCode = 131072;
        System.out.println("* SHIFT " + display.post(event));
        event.character = (char)27;
        event.keyCode = 27;
        System.out.println("* ESC " + display.post(event));
        event.type = 2;
        System.out.println("* ESC up " + display.post(event));
        event.character = '\u0000';
        event.keyCode = 131072;
        System.out.println("* SHIFT up " + display.post(event));
        event.keyCode = 262144;
        System.out.println("* CTRL up " + display.post(event));
        ScreenshotTest.runEventQueue();
        String screenshot1 = ScreenshotTest.takeScreenshot(ScreenshotTest.class, this.testName.getMethodName() + "2", System.out);
        event.type = 1;
        event.character = (char)27;
        event.keyCode = 27;
        System.out.println("* ESC " + display.post(event));
        event.type = 2;
        System.out.println("* ESC up " + display.post(event));
        ScreenshotTest.runEventQueue();
        String screenshot2 = ScreenshotTest.takeScreenshot(ScreenshotTest.class, this.testName.getMethodName() + "3", System.out);
        new File(screenshot1).delete();
        new File(screenshot2).delete();
    }

    public static String takeScreenshot(Class<?> testClass, String name, PrintStream out) {
        File resultsHtmlDir = ScreenshotTest.getJunitReportOutput();
        if (resultsHtmlDir == null) {
            File eclipseDir = new File("").getAbsoluteFile();
            resultsHtmlDir = ScreenshotTest.isRunByGerritHudsonJob() ? new File(eclipseDir, "/../").getAbsoluteFile() : new File(eclipseDir, "../../results/html/").getAbsoluteFile();
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        ScreenshotTest.dumpDisplayState(display, System.out);
        GC gc = new GC((Drawable)display);
        Rectangle displayBounds = display.getBounds();
        out.println("Display @ " + String.valueOf(displayBounds));
        Image image = new Image((Device)display, (iGc, width, height) -> {}, displayBounds.width, displayBounds.height);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        resultsHtmlDir.mkdirs();
        String filename = new File(resultsHtmlDir.getAbsolutePath(), testClass.getName() + "." + name + ".png").getAbsolutePath();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save(filename, 5);
        out.println("Screenshot saved to: " + filename);
        image.dispose();
        return filename;
    }

    private static void dumpDisplayState(Display display, PrintStream out) {
        Control focusControl = display.getFocusControl();
        ScreenshotTest.dumpControlParentHierarchy(out, "FocusControl", focusControl);
        Shell[] shells = display.getShells();
        if (shells.length > 0) {
            out.println("Shells: ");
            Shell[] shellArray = shells;
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                out.print(display.getActiveShell() == shell ? "  active, " : "  inactive, ");
                out.print((shell.isVisible() ? "visible: " : "invisible: ") + String.valueOf(shell));
                out.println(" @ " + shell.getBounds().toString());
                ++n2;
            }
        }
        out.println("Client area: " + String.valueOf(display.getClientArea()));
        out.println("Cursor location: " + String.valueOf(display.getCursorLocation()));
        Control cursorControl = display.getCursorControl();
        if (focusControl != cursorControl) {
            ScreenshotTest.dumpControlParentHierarchy(out, "CursorControl", cursorControl);
        }
    }

    private static void dumpControlParentHierarchy(PrintStream out, String label, Control control) {
        out.print(label + ": ");
        if (control == null) {
            out.println("<none>");
        } else {
            out.println();
            StringBuilder indent = new StringBuilder("  ");
            do {
                out.println(indent.toString() + String.valueOf(control));
                control = control.getParent();
                indent.append("  ");
            } while (control != null);
        }
    }

    private static File getJunitReportOutput() {
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length - 1) {
            if ("-junitReportOutput".equals(args[i])) {
                return new File(args[i + 1]).getAbsoluteFile();
            }
            ++i;
        }
        return null;
    }

    public static boolean isRunByGerritHudsonJob() {
        return System.getProperty("user.dir").contains("eclipse.platform.text-Gerrit");
    }

    private static void runEventQueue() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        int i = 0;
        while (i < 10) {
            while (display.readAndDispatch()) {
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
    }
}

