/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests;

import java.util.Random;
import org.eclipse.ui.internal.texteditor.HistoryTracker;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class TextEditorPluginTest {
    @Rule
    public TestName testName = new TestName();
    Random rand = new Random(55L);

    @Test
    public void testEditPositionHistory() {
        HistoryTracker history = new HistoryTracker(3, Integer.class, (a, b) -> Math.abs(a - b) < 5, true);
        Assert.assertEquals((long)0L, (long)history.getSize());
        history.addOrReplace((Object)10);
        Assert.assertEquals((long)1L, (long)history.getSize());
        Assert.assertEquals((long)10L, (long)((Integer)history.getCurrentBrowsePoint()).intValue());
        history.addOrReplace((Object)20);
        Assert.assertEquals((long)2L, (long)history.getSize());
        Assert.assertEquals((long)20L, (long)((Integer)history.getCurrentBrowsePoint()).intValue());
        history.addOrReplace((Object)30);
        Assert.assertEquals((long)3L, (long)history.getSize());
        Assert.assertEquals((long)30L, (long)((Integer)history.getCurrentBrowsePoint()).intValue());
        this.checkContent(history, new Integer[]{10, 20, 30});
        int replaced = (Integer)history.addOrReplace((Object)40);
        Assert.assertEquals((long)3L, (long)history.getSize());
        Assert.assertEquals((long)10L, (long)replaced);
        Assert.assertEquals((Object)40, (Object)history.getCurrentBrowsePoint());
        HistoryTracker.Navigator nav = history.navigator();
        Assert.assertEquals((Object)40, (Object)nav.currentItem());
        Assert.assertEquals((Object)30, (Object)nav.priorItem());
        Assert.assertEquals((Object)20, (Object)nav.priorItem());
        Assert.assertEquals((Object)40, (Object)nav.priorItem());
        this.checkContent(history, new Integer[]{20, 30, 40});
        Assert.assertFalse((boolean)history.contains((Object)10));
        replaced = (Integer)history.addOrReplace((Object)22);
        Assert.assertTrue((boolean)history.contains((Object)22));
        Assert.assertFalse((boolean)history.contains((Object)20));
        Assert.assertEquals((long)20L, (long)replaced);
        this.checkContent(history, new Integer[]{30, 40, 22});
        replaced = (Integer)history.addOrReplace((Object)31);
        Assert.assertTrue((boolean)history.contains((Object)31));
        Assert.assertFalse((boolean)history.contains((Object)30));
        Assert.assertEquals((long)30L, (long)replaced);
        Assert.assertEquals((long)31L, (long)((Integer)history.getCurrentBrowsePoint()).intValue());
        this.checkContent(history, new Integer[]{40, 22, 31});
        replaced = (Integer)history.addOrReplace((Object)60);
        Assert.assertTrue((boolean)history.contains((Object)60));
        Assert.assertEquals((long)60L, (long)((Integer)history.getCurrentBrowsePoint()).intValue());
        Assert.assertEquals((long)3L, (long)history.getSize());
        this.checkContent(history, new Integer[]{22, 31, 60});
        Assert.assertEquals((long)31L, (long)((Integer)history.browseBackward()).intValue());
        Assert.assertEquals((long)31L, (long)((Integer)history.getCurrentBrowsePoint()).intValue());
        Assert.assertEquals((long)3L, (long)history.getSize());
        this.testBacktrackCycle(history);
        history.browseBackward();
        Integer last = (Integer)history.getCurrentBrowsePoint();
        Assert.assertEquals((Object)22, (Object)last);
        history.addOrReplace((Object)11);
        this.checkContent(history, new Integer[]{31, 60, 11});
        this.testBacktrackCycle(history);
        history.browseBackward();
        Assert.assertEquals((Object)60, (Object)history.getCurrentBrowsePoint());
    }

    <T> void checkContent(HistoryTracker<T> history, T[] data) {
        HistoryTracker.Navigator nav = history.navigator();
        Assert.assertEquals(data[data.length - 1], (Object)nav.currentItem());
        int i = data.length - 2;
        while (i > 0) {
            Assert.assertEquals(data[i], (Object)nav.priorItem());
            --i;
        }
        Assert.assertEquals((long)history.getSize(), (long)data.length);
    }

    @Test
    public void testEditPositionHistory2() {
        HistoryTracker history = new HistoryTracker(3, Integer.class, (a, b) -> Math.abs(a - b) < 5, true);
        Assert.assertEquals((long)0L, (long)history.getSize());
        history.addOrReplace((Object)10);
        Assert.assertEquals((long)1L, (long)history.getSize());
        Assert.assertEquals((long)10L, (long)((Integer)history.getCurrentBrowsePoint()).intValue());
        history.addOrReplace((Object)20);
        Assert.assertEquals((long)2L, (long)history.getSize());
        Assert.assertEquals((long)20L, (long)((Integer)history.getCurrentBrowsePoint()).intValue());
        history.addOrReplace((Object)30);
        Assert.assertEquals((long)3L, (long)history.getSize());
        Assert.assertEquals((long)30L, (long)((Integer)history.getCurrentBrowsePoint()).intValue());
        int replaced = (Integer)history.addOrReplace((Object)22);
        Assert.assertEquals((long)3L, (long)history.getSize());
        Assert.assertEquals((long)20L, (long)replaced);
        Assert.assertEquals((Object)22, (Object)history.getCurrentBrowsePoint());
        Assert.assertEquals((Object)30, (Object)history.browseBackward());
        Assert.assertEquals((Object)10, (Object)history.browseBackward());
        Assert.assertEquals((Object)22, (Object)history.browseBackward());
        this.testBacktrackCycle(history);
    }

    @Test
    public void testHistoryEviction() {
        HistoryTracker history = new HistoryTracker(3, Integer.class, (a, b) -> Math.abs(a - b) < 5, true);
        Assert.assertEquals((long)0L, (long)history.getSize());
        history.addOrReplace((Object)10);
        Assert.assertEquals((long)1L, (long)history.getSize());
        Assert.assertEquals((long)10L, (long)((Integer)history.getCurrentBrowsePoint()).intValue());
        history.addOrReplace((Object)10);
        Assert.assertEquals((long)1L, (long)history.getSize());
        Assert.assertEquals((long)10L, (long)((Integer)history.getCurrentBrowsePoint()).intValue());
        history.addOrReplace((Object)11);
        Assert.assertEquals((long)1L, (long)history.getSize());
        Assert.assertEquals((long)11L, (long)((Integer)history.getCurrentBrowsePoint()).intValue());
    }

    @Test
    public void testHistoryEviction2() {
        HistoryTracker history = new HistoryTracker(3, Integer.class, (a, b) -> Math.abs(a - b) < 5, true);
        history.addOrReplace((Object)10);
        history.addOrReplace((Object)20);
        history.addOrReplace((Object)30);
        Assert.assertEquals((Object)20, (Object)history.browseBackward());
        Assert.assertEquals((Object)10, (Object)history.addOrReplace((Object)40));
    }

    @Test
    public void testHistoryEviction3() {
        HistoryTracker history = new HistoryTracker(3, Integer.class, (a, b) -> Math.abs(a - b) < 5, true);
        history.addOrReplace((Object)10);
        history.addOrReplace((Object)11);
        history.addOrReplace((Object)20);
        history.addOrReplace((Object)21);
        history.addOrReplace((Object)12);
        this.checkContent(history, new Integer[]{21, 12});
    }

    @Test
    public void testLinearEditPositionHistory() {
        HistoryTracker history = new HistoryTracker(3, Integer.class, (a, b) -> Math.abs(a - b) < 5, false);
        Assert.assertEquals((long)0L, (long)history.getSize());
        history.addOrReplace((Object)10);
        Assert.assertEquals((long)1L, (long)history.getSize());
        Assert.assertEquals((long)10L, (long)((Integer)history.getCurrentBrowsePoint()).intValue());
        history.addOrReplace((Object)20);
        Assert.assertEquals((long)2L, (long)history.getSize());
        Assert.assertEquals((long)20L, (long)((Integer)history.getCurrentBrowsePoint()).intValue());
        history.addOrReplace((Object)30);
        Assert.assertEquals((long)3L, (long)history.getSize());
        Assert.assertEquals((long)30L, (long)((Integer)history.getCurrentBrowsePoint()).intValue());
        int replaced = (Integer)history.addOrReplace((Object)22);
        Assert.assertEquals((long)3L, (long)history.getSize());
        Assert.assertEquals((long)20L, (long)replaced);
        Assert.assertEquals((Object)22, (Object)history.getCurrentBrowsePoint());
        Assert.assertEquals((Object)30, (Object)history.browseBackward());
        Assert.assertEquals((Object)10, (Object)history.browseBackward());
        Assert.assertEquals((Object)10, (Object)history.browseBackward());
        Assert.assertEquals((Object)30, (Object)history.browseForward());
        Assert.assertEquals((Object)22, (Object)history.browseForward());
        Assert.assertEquals((Object)22, (Object)history.browseForward());
    }

    @Test
    public void testLinearEditPositionHistory2() {
        HistoryTracker history = new HistoryTracker(3, Integer.class, (a, b) -> Math.abs(a - b) < 5, false);
        history.addOrReplace((Object)10);
        history.addOrReplace((Object)20);
        history.addOrReplace((Object)30);
        int replaced = (Integer)history.addOrReplace((Object)22);
        Assert.assertEquals((long)3L, (long)history.getSize());
        Assert.assertEquals((long)20L, (long)replaced);
        Assert.assertEquals((Object)22, (Object)history.getCurrentBrowsePoint());
        Assert.assertEquals((Object)22, (Object)history.getNext());
        Assert.assertEquals((Object)30, (Object)history.browseBackward());
        Assert.assertEquals((Object)10, (Object)history.browseBackward());
        Assert.assertEquals((Object)10, (Object)history.browseBackward());
    }

    @Test
    public void testMRUOrderAlwaysPreserved() {
        HistoryTracker history = new HistoryTracker(3, Integer.class, (a, b) -> Math.abs(a - b) < 5, false);
        history.addOrReplace((Object)10);
        history.addOrReplace((Object)20);
        history.addOrReplace((Object)30);
        Assert.assertEquals((Object)20, (Object)history.browseBackward());
        history.addOrReplace((Object)11);
        Assert.assertEquals((Object)11, (Object)history.getCurrentBrowsePoint());
        Assert.assertEquals((Object)30, (Object)history.browseBackward());
        Assert.assertEquals((Object)20, (Object)history.browseBackward());
    }

    @Test
    public void testMRUOrderAlwaysPreserved2() {
        HistoryTracker history = new HistoryTracker(3, Integer.class, (a, b) -> Math.abs(a - b) < 5, false);
        history.addOrReplace((Object)10);
        history.addOrReplace((Object)20);
        history.addOrReplace((Object)30);
        Assert.assertEquals((Object)20, (Object)history.browseBackward());
        history.addOrReplace((Object)40);
        Assert.assertEquals((Object)40, (Object)history.getCurrentBrowsePoint());
        Assert.assertEquals((Object)30, (Object)history.browseBackward());
        Assert.assertEquals((Object)20, (Object)history.browseBackward());
        Assert.assertEquals((Object)20, (Object)history.browseBackward());
    }

    private <T> void testBacktrackCycle(HistoryTracker<T> history) {
        Object last = history.getCurrentBrowsePoint();
        int i = 0;
        while (i < history.getSize() - 1) {
            history.browseBackward();
            Assert.assertNotEquals((Object)last, (Object)history.getCurrentBrowsePoint());
            ++i;
        }
        history.browseBackward();
        Assert.assertEquals((Object)last, (Object)history.getCurrentBrowsePoint());
    }

    @Test
    public void testEditPositionHistoryChaos() {
        int HISTORY_SIZE = 10;
        HistoryTracker history = new HistoryTracker(10, Integer.class, (a, b) -> Math.abs(a - b) < 5, true);
        int i = 0;
        while (i < 100) {
            if (this.rand.nextBoolean()) {
                this.addRandom((HistoryTracker<Integer>)history);
            } else {
                this.goBack((HistoryTracker<Integer>)history);
            }
            Assert.assertTrue((boolean)history.isHealthy());
            Assert.assertTrue((history.getSize() <= 10 ? 1 : 0) != 0);
            ++i;
        }
    }

    @Test
    public void testLinearEditPositionHistoryChaos() {
        int HISTORY_SIZE = 10;
        HistoryTracker history = new HistoryTracker(10, Integer.class, (a, b) -> Math.abs(a - b) < 5, false);
        int backsInARow = 0;
        int i = 0;
        while (i < 100) {
            if (this.rand.nextBoolean()) {
                backsInARow = 0;
                this.addRandom((HistoryTracker<Integer>)history);
            } else {
                this.goBackLinear((HistoryTracker<Integer>)history, ++backsInARow < history.getSize());
            }
            Assert.assertTrue((boolean)history.isHealthy());
            Assert.assertTrue((history.getSize() <= 10 ? 1 : 0) != 0);
            ++i;
        }
    }

    private void addRandom(HistoryTracker<Integer> history) {
        Integer latest = this.rand.nextInt(50);
        history.addOrReplace((Object)latest);
        Assert.assertEquals((Object)latest, (Object)history.getCurrentBrowsePoint());
    }

    private void goBack(HistoryTracker<Integer> history) {
        int size = history.getSize();
        Integer latest = (Integer)history.getCurrentBrowsePoint();
        Integer prior = (Integer)history.browseBackward();
        if (size > 1) {
            Assert.assertNotEquals((Object)latest, (Object)prior);
        }
    }

    private void goBackLinear(HistoryTracker<Integer> history, boolean shouldMove) {
        Integer latest = (Integer)history.getCurrentBrowsePoint();
        Integer prior = (Integer)history.browseBackward();
        if (shouldMove) {
            Assert.assertNotEquals((Object)latest, (Object)prior);
        } else {
            Assert.assertEquals((Object)latest, (Object)prior);
        }
    }
}

