/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.TextViewerDeleteLineTarget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TextViewerDeleteLineTargetTest {
    private Document document;
    private Shell parentShell;
    private TextViewerDeleteLineTarget underTest;

    @Before
    public void setUp() {
        this.document = new Document("first line\n\nthird line\n");
        this.parentShell = new Shell();
        TextViewer textViewer = new TextViewer((Composite)this.parentShell, 0);
        textViewer.setDocument((IDocument)this.document);
        this.underTest = new TextViewerDeleteLineTarget((ITextViewer)textViewer);
    }

    @After
    public void tearDown() {
        if (this.parentShell != null) {
            this.parentShell.dispose();
            this.parentShell = null;
        }
    }

    @Test
    public void testWholeLineDeletion() throws Exception {
        this.underTest.deleteLine((IDocument)this.document, (ITextSelection)new TextSelection((IDocument)this.document, 1, 3), 0, false);
        Assert.assertEquals((Object)"\nthird line\n", (Object)this.document.get());
    }

    @Test
    public void testWholeLineDeletionOnLastEmptyLine() throws Exception {
        this.underTest.deleteLine((IDocument)this.document, (ITextSelection)new TextSelection((IDocument)this.document, 23, 0), 0, false);
        Assert.assertEquals((Object)"first line\n\nthird line", (Object)this.document.get());
    }

    @Test
    public void testWholeLineDeletionWithCopyToClipboard() throws Exception {
        Clipboard clipboard = new Clipboard(Display.getCurrent());
        try {
            this.underTest.deleteLine((IDocument)this.document, (ITextSelection)new TextSelection((IDocument)this.document, 1, 4), 0, true);
            Assert.assertEquals((Object)"first line\n", (Object)clipboard.getContents((Transfer)TextTransfer.getInstance()));
        }
        finally {
            clipboard.dispose();
        }
    }

    @Test
    public void testLineDeletionToBeginning() throws Exception {
        this.underTest.deleteLine((IDocument)this.document, (ITextSelection)new TextSelection((IDocument)this.document, 6, 0), 1, false);
        Assert.assertEquals((Object)"line\n\nthird line\n", (Object)this.document.get());
    }

    @Test
    public void testLineDeletionToEnd() throws Exception {
        this.underTest.deleteLine((IDocument)this.document, (ITextSelection)new TextSelection((IDocument)this.document, 17, 0), 2, false);
        Assert.assertEquals((Object)"first line\n\nthird\n", (Object)this.document.get());
    }

    @Test
    public void testThrowsExceptionWithUnsupportedDeleteLineActionType() throws Exception {
        Assert.assertThrows(IllegalArgumentException.class, () -> this.underTest.deleteLine((IDocument)this.document, 0, 0, 8, false));
    }
}

