/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests.minimap;

import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.views.minimap.MinimapWidget;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MinimapWidgetTest {
    private ITextViewer editorViewer;
    private Composite minimapParent;
    private StyledText editorStyledText;
    private StyledText minimapStyledText;

    @Before
    public void createMinimap() {
        this.minimapParent = new Shell();
        this.editorViewer = new TextViewer(this.minimapParent, 0);
        MinimapWidget minimapWidget = new MinimapWidget(this.minimapParent, this.editorViewer);
        minimapWidget.install();
        this.editorStyledText = this.editorViewer.getTextWidget();
        this.minimapStyledText = (StyledText)minimapWidget.getControl();
    }

    @After
    public void tearDownMinimap() {
        if (this.minimapParent != null) {
            this.minimapParent.dispose();
            this.minimapParent = null;
        }
    }

    @Test
    public void testMinimapContent() {
        this.editorStyledText.setText("abcd");
        Assert.assertEquals((Object)"abcd", (Object)this.minimapStyledText.getText());
        this.editorStyledText.replaceTextRange(1, 0, "ABCD");
        Assert.assertEquals((Object)"aABCDbcd", (Object)this.minimapStyledText.getText());
    }

    @Test
    public void testMinimapSetStyles() {
        Object[] orginalMinimapStyles = this.minimapStyledText.getStyleRanges();
        this.editorStyledText.setText("abcd");
        StyleRange[] ranges = new StyleRange[]{new StyleRange(0, 1, this.editorStyledText.getDisplay().getSystemColor(2), null)};
        this.editorStyledText.setStyleRanges(ranges);
        Assert.assertArrayEquals((Object[])orginalMinimapStyles, (Object[])this.minimapStyledText.getStyleRanges());
    }

    @Test
    public void testMinimapSetStylesWithTextPresentation() {
        this.editorStyledText.setText("abcd");
        StyleRange[] ranges = new StyleRange[]{new StyleRange(0, 1, this.editorStyledText.getDisplay().getSystemColor(2), null)};
        TextPresentation presentation = new TextPresentation();
        presentation.mergeStyleRanges(ranges);
        this.editorViewer.changeTextPresentation(presentation, false);
        Object[] expectedRanges = new StyleRange[]{new StyleRange(0, 1, this.editorStyledText.getDisplay().getSystemColor(2), null)};
        Assert.assertArrayEquals((Object[])expectedRanges, (Object[])this.minimapStyledText.getStyleRanges());
        ranges = new StyleRange[]{new StyleRange(1, 1, this.editorStyledText.getDisplay().getSystemColor(3), null)};
        presentation = new TextPresentation();
        presentation.mergeStyleRanges(ranges);
        this.editorViewer.changeTextPresentation(presentation, false);
        expectedRanges = new StyleRange[]{new StyleRange(0, 1, this.editorStyledText.getDisplay().getSystemColor(2), null), new StyleRange(1, 1, this.editorStyledText.getDisplay().getSystemColor(3), null)};
        Assert.assertArrayEquals((Object[])expectedRanges, (Object[])this.minimapStyledText.getStyleRanges());
    }
}

