/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests.revisions;

import java.util.Date;
import java.util.List;
import org.eclipse.jface.internal.text.revisions.ChangeRegion;
import org.eclipse.jface.internal.text.revisions.Hunk;
import org.eclipse.jface.internal.text.revisions.Range;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.workbench.texteditor.tests.revisions.RangeUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangeRegionTest {
    private Revision fRevision;

    @Before
    public void setUp() throws Exception {
        this.fRevision = new TestRevision();
    }

    @Test
    public void testCreation() throws Exception {
        ChangeRegion changeRegion2;
        try {
            changeRegion2 = new ChangeRegion(this.fRevision, null);
            Assert.fail();
        }
        catch (Exception changeRegion2) {
            // empty catch block
        }
        try {
            changeRegion2 = new ChangeRegion(null, (ILineRange)new LineRange(12, 3));
            Assert.fail();
        }
        catch (Exception changeRegion3) {
            // empty catch block
        }
        try {
            changeRegion2 = new ChangeRegion(null, null);
            Assert.fail();
        }
        catch (Exception changeRegion4) {
            // empty catch block
        }
        ChangeRegion r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        Assert.assertEquals((Object)this.fRevision, (Object)r.getRevision());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 3), (ILineRange)r.getAdjustedRanges().get(0));
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 3), r.getAdjustedCoverage());
    }

    @Test
    public void testHunkAfter() throws Exception {
        ChangeRegion r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        List<Range> before = RangeUtil.deepClone(r.getAdjustedRanges());
        r.adjustTo(new Hunk(16, 3, 2));
        RangeUtil.assertEqualRanges(before, r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)before.get(0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        before = RangeUtil.deepClone(r.getAdjustedRanges());
        r.adjustTo(new Hunk(16, -33, 2));
        RangeUtil.assertEqualRanges(before, r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)before.get(0), r.getAdjustedCoverage());
    }

    @Test
    public void testHunkRightAfter() throws Exception {
        ChangeRegion r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        List<Range> before = RangeUtil.deepClone(r.getAdjustedRanges());
        r.adjustTo(new Hunk(15, 3, 2));
        RangeUtil.assertEqualRanges(before, r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)before.get(0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        before = RangeUtil.deepClone(r.getAdjustedRanges());
        r.adjustTo(new Hunk(15, -3, 2));
        RangeUtil.assertEqualRanges(before, r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)before.get(0), r.getAdjustedCoverage());
    }

    @Test
    public void testHunkBefore() throws Exception {
        ChangeRegion r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        r.adjustTo(new Hunk(5, 3, 2));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(15, 3), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(15, 3), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        r.adjustTo(new Hunk(5, 3, 0));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(15, 3), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(15, 3), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        r.adjustTo(new Hunk(5, -3, 0));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(9, 3), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(9, 3), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        r.adjustTo(new Hunk(5, 3, 3));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(15, 3), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(15, 3), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        r.adjustTo(new Hunk(5, -3, 2));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(9, 3), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(9, 3), r.getAdjustedCoverage());
    }

    @Test
    public void testHunkRightBefore() throws Exception {
        ChangeRegion r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        r.adjustTo(new Hunk(10, 0, 2));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(12, 3), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 3), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        r.adjustTo(new Hunk(10, 2, 2));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(14, 3), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(14, 3), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        r.adjustTo(new Hunk(9, -3, 0));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(9, 3), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(9, 3), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        r.adjustTo(new Hunk(9, -1, 2));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(11, 3), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(11, 3), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        r.adjustTo(new Hunk(9, 3, 3));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(15, 3), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(15, 3), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 3));
        r.adjustTo(new Hunk(12, 3, 0));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(15, 3), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(15, 3), r.getAdjustedCoverage());
    }

    @Test
    public void testHunkAtStart() throws Exception {
        ChangeRegion r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(12, 0, 2));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(14, 5), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(14, 5), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(12, -2, 0));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(12, 5), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 5), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(12, -2, 1));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(13, 4), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(13, 4), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(12, 3, 0));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(15, 7), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(15, 7), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(12, 3, 2));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(17, 5), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(17, 5), r.getAdjustedCoverage());
    }

    @Test
    public void testHunkAtEnd() throws Exception {
        ChangeRegion r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(17, 0, 2));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(12, 5), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 5), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(17, 2, 2));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(12, 5), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 5), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(15, -2, 2));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(12, 3), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 3), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(17, -2, 0));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(12, 5), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 5), r.getAdjustedCoverage());
    }

    @Test
    public void testHunkOverStart() throws Exception {
        ChangeRegion r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(11, 0, 2));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(13, 6), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(13, 6), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(11, 2, 2));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(15, 6), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(15, 6), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(11, -2, 2));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(13, 4), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(13, 4), r.getAdjustedCoverage());
    }

    @Test
    public void testHunkOverEnd() throws Exception {
        ChangeRegion r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(18, 0, 2));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(12, 6), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 6), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(18, -2, 0));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(12, 6), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 6), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(18, -2, 2));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(12, 6), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 6), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(17, -2, 1));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(12, 5), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 5), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(17, -2, 3));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(12, 5), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 5), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(17, 2, 3));
        RangeUtil.assertEqualSingleRange((ILineRange)new LineRange(12, 5), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 5), r.getAdjustedCoverage());
    }

    @Test
    public void testHunkCovering() throws Exception {
        ChangeRegion r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(12, 0, 7));
        Assert.assertTrue((boolean)r.getAdjustedRanges().isEmpty());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(11, 0, 8));
        Assert.assertTrue((boolean)r.getAdjustedRanges().isEmpty());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(11, 0, 9));
        Assert.assertTrue((boolean)r.getAdjustedRanges().isEmpty());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(12, 0, 9));
        Assert.assertTrue((boolean)r.getAdjustedRanges().isEmpty());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(12, -7, 0));
        Assert.assertTrue((boolean)r.getAdjustedRanges().isEmpty());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(12, -8, 0));
        Assert.assertTrue((boolean)r.getAdjustedRanges().isEmpty());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(11, -8, 0));
        Assert.assertTrue((boolean)r.getAdjustedRanges().isEmpty());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(11, -9, 0));
        Assert.assertTrue((boolean)r.getAdjustedRanges().isEmpty());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(8, -9, 6));
        Assert.assertTrue((boolean)r.getAdjustedRanges().isEmpty());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(8, -4, 8));
        Assert.assertTrue((boolean)r.getAdjustedRanges().isEmpty());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(8, -3, 9));
        Assert.assertTrue((boolean)r.getAdjustedRanges().isEmpty());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(8, -12, 5));
        Assert.assertTrue((boolean)r.getAdjustedRanges().isEmpty());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(8, -12, 20));
        Assert.assertTrue((boolean)r.getAdjustedRanges().isEmpty());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(8, 12, 20));
        Assert.assertTrue((boolean)r.getAdjustedRanges().isEmpty());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 0), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(8, -3, 8));
        Assert.assertTrue((boolean)r.getAdjustedRanges().isEmpty());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 0), r.getAdjustedCoverage());
    }

    @Test
    public void testHunkInBetween() throws Exception {
        ChangeRegion r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(15, -2, 0));
        RangeUtil.assertEqualRanges((ILineRange)new LineRange(12, 3), (ILineRange)new LineRange(15, 2), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 5), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(15, 2, 0));
        RangeUtil.assertEqualRanges((ILineRange)new LineRange(12, 3), (ILineRange)new LineRange(17, 4), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 9), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(15, 0, 2));
        RangeUtil.assertEqualRanges((ILineRange)new LineRange(12, 3), (ILineRange)new LineRange(17, 2), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 7), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(15, -1, 2));
        RangeUtil.assertEqualRanges((ILineRange)new LineRange(12, 3), (ILineRange)new LineRange(17, 1), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 6), r.getAdjustedCoverage());
        r = new ChangeRegion(this.fRevision, (ILineRange)new LineRange(12, 7));
        r.adjustTo(new Hunk(15, 2, 2));
        RangeUtil.assertEqualRanges((ILineRange)new LineRange(12, 3), (ILineRange)new LineRange(19, 2), r.getAdjustedRanges());
        RangeUtil.assertEqualRange((ILineRange)new LineRange(12, 9), r.getAdjustedCoverage());
    }

    public static final class TestRevision
    extends Revision {
        public Object getHoverInfo() {
            return null;
        }

        public RGB getColor() {
            return null;
        }

        public String getId() {
            return null;
        }

        public Date getDate() {
            return null;
        }
    }
}

