/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests.revisions;

import org.eclipse.jface.internal.text.revisions.Hunk;
import org.eclipse.jface.internal.text.revisions.HunkComputer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.junit.Assert;
import org.junit.Test;

public class HunkComputerTest {
    private static final int A = 1;
    private static final int C = 2;
    private static final int U = 0;
    private int[] fDiffInformation;
    private final ILineDiffer fDiffer = new ILineDiffer(){

        public ILineDiffInfo getLineInfo(final int line) {
            return new ILineDiffInfo(){

                public int getChangeType() {
                    return (this).HunkComputerTest.this.fDiffInformation[line * 2];
                }

                public String[] getOriginalText() {
                    throw new UnsupportedOperationException();
                }

                public int getRemovedLinesAbove() {
                    return (this).HunkComputerTest.this.fDiffInformation[line * 2 + 1];
                }

                public int getRemovedLinesBelow() {
                    if ((this).HunkComputerTest.this.fRemovedBelow == null) {
                        return 0;
                    }
                    return (this).HunkComputerTest.this.fRemovedBelow[line];
                }

                public boolean hasChanges() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public int restoreAfterLine(int line) throws BadLocationException {
            throw new UnsupportedOperationException();
        }

        public void revertBlock(int line) throws BadLocationException {
            throw new UnsupportedOperationException();
        }

        public void revertLine(int line) throws BadLocationException {
            throw new UnsupportedOperationException();
        }

        public void revertSelection(int line, int nLines) throws BadLocationException {
            throw new UnsupportedOperationException();
        }
    };
    private int[] fRemovedBelow;

    @Test
    public void testNoDiff() throws Exception {
        int[] diffInfo = new int[24];
        int[] expected = new int[]{};
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testShiftOne() throws Exception {
        int[] nArray = new int[24];
        nArray[0] = 2;
        int[] diffInfo = nArray;
        int[] nArray2 = new int[3];
        nArray2[2] = 1;
        int[] expected = nArray2;
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testRemoveFirstLine() throws Exception {
        int[] nArray = new int[22];
        nArray[1] = 1;
        int[] diffInfo = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = -1;
        int[] expected = nArray2;
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testRemoveSecondLine() throws Exception {
        int[] nArray = new int[22];
        nArray[3] = 1;
        int[] diffInfo = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 1;
        nArray2[1] = -1;
        int[] expected = nArray2;
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testAddFirstLine() throws Exception {
        int[] nArray = new int[24];
        nArray[0] = 1;
        int[] diffInfo = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        int[] expected = nArray2;
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testAddSecondLine() throws Exception {
        int[] nArray = new int[24];
        nArray[2] = 1;
        int[] diffInfo = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 1;
        nArray2[1] = 1;
        int[] expected = nArray2;
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testAddThirdLine() throws Exception {
        int[] nArray = new int[24];
        nArray[4] = 1;
        int[] diffInfo = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 2;
        nArray2[1] = 1;
        int[] expected = nArray2;
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testRemoveFirstRegion() throws Exception {
        int[] nArray = new int[18];
        nArray[1] = 2;
        int[] diffInfo = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = -2;
        int[] expected = nArray2;
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testReplaceFirstRegion() throws Exception {
        int[] nArray = new int[22];
        nArray[0] = 2;
        nArray[2] = 2;
        int[] diffInfo = nArray;
        int[] nArray2 = new int[3];
        nArray2[2] = 2;
        int[] expected = nArray2;
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testRemoveOverlappingRegion() throws Exception {
        int[] nArray = new int[18];
        nArray[3] = 2;
        int[] diffInfo = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 1;
        nArray2[1] = -2;
        int[] expected = nArray2;
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testReplaceOverlappingRegion() throws Exception {
        int[] nArray = new int[22];
        nArray[2] = 2;
        nArray[4] = 2;
        int[] diffInfo = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 1;
        nArray2[2] = 2;
        int[] expected = nArray2;
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testRemoveInnerLines() throws Exception {
        int[] nArray = new int[18];
        nArray[17] = 2;
        int[] diffInfo = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 8;
        nArray2[1] = -2;
        int[] expected = nArray2;
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testReplaceInnerLines() throws Exception {
        int[] nArray = new int[22];
        nArray[16] = 2;
        nArray[18] = 2;
        int[] diffInfo = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 8;
        nArray2[2] = 2;
        int[] expected = nArray2;
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testAddInnerLines() throws Exception {
        int[] nArray = new int[26];
        nArray[16] = 1;
        nArray[18] = 1;
        int[] diffInfo = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 8;
        nArray2[1] = 2;
        int[] expected = nArray2;
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testRemoveLastLine() throws Exception {
        int[] diffInfo = new int[20];
        this.fRemovedBelow = new int[10];
        this.fRemovedBelow[9] = 1;
        int[] nArray = new int[3];
        nArray[0] = 10;
        nArray[1] = -1;
        int[] expected = nArray;
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testReplaceLastLine() throws Exception {
        int[] nArray = new int[22];
        nArray[20] = 2;
        int[] diffInfo = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 10;
        nArray2[2] = 1;
        int[] expected = nArray2;
        this.assertHunks(diffInfo, expected);
    }

    @Test
    public void testAddLastLine() throws Exception {
        int[] nArray = new int[24];
        nArray[22] = 1;
        int[] diffInfo = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 12;
        nArray2[1] = 1;
        int[] expected = nArray2;
        this.assertHunks(diffInfo, expected);
    }

    private void assertHunks(int[] diffInfo, int[] expected) {
        this.fDiffInformation = diffInfo;
        Assert.assertEquals((long)0L, (long)(diffInfo.length % 2));
        Hunk[] hunks = HunkComputer.computeHunks((ILineDiffer)this.fDiffer, (int)(this.fDiffInformation.length / 2));
        Assert.assertEquals((long)0L, (long)(expected.length % 3));
        int n = expected.length / 3;
        Assert.assertEquals((long)n, (long)hunks.length);
        int i = 0;
        while (i < n) {
            Hunk h = hunks[i];
            Assert.assertEquals((Object)new Hunk(expected[3 * i], expected[3 * i + 1], expected[3 * i + 2]), (Object)h);
            ++i;
        }
    }
}

