/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.workbench.texteditor.tests.revisions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.internal.text.revisions.Range;
import org.eclipse.jface.text.source.ILineRange;
import org.junit.Assert;

class RangeUtil
extends Assert {
    private RangeUtil() {
    }

    static void assertEqualRange(ILineRange expected, ILineRange actual) {
        RangeUtil.assertEquals((long)expected.getStartLine(), (long)actual.getStartLine());
        RangeUtil.assertEquals((long)expected.getNumberOfLines(), (long)actual.getNumberOfLines());
    }

    static List<Range> deepClone(List<Range> ranges) {
        ArrayList<Range> list = new ArrayList<Range>(ranges.size());
        for (ILineRange iLineRange : ranges) {
            list.add(Range.copy((ILineRange)iLineRange));
        }
        return list;
    }

    static void assertEqualRanges(ILineRange expected1, ILineRange expected2, List<Range> actual) {
        RangeUtil.assertEquals((long)2L, (long)actual.size());
        RangeUtil.assertEqualRange(expected1, (ILineRange)actual.get(0));
        RangeUtil.assertEqualRange(expected2, (ILineRange)actual.get(1));
    }

    static void assertEqualSingleRange(ILineRange expected, List<Range> actual) {
        RangeUtil.assertEquals((long)1L, (long)actual.size());
        RangeUtil.assertEqualRange(expected, (ILineRange)actual.get(0));
    }

    static void assertEqualRanges(List<Range> expected, List<Range> actual) {
        RangeUtil.assertEquals((long)expected.size(), (long)actual.size());
        Iterator<Range> it1 = expected.iterator();
        Iterator<Range> it2 = actual.iterator();
        while (it1.hasNext()) {
            ILineRange r1 = (ILineRange)it1.next();
            ILineRange r2 = (ILineRange)it2.next();
            RangeUtil.assertEqualRange(r1, r2);
        }
    }
}

