/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.eclipse.ui.tests.navigator.extension.TestContentProvider;
import org.eclipse.ui.tests.navigator.extension.TestExtensionTreeData;
import org.junit.Assert;
import org.junit.Test;

public class ActionProviderTest
extends NavigatorTestBase {
    private static final boolean SLEEP_LONG = false;

    public ActionProviderTest() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.TestView";
    }

    @Test
    public void testBasicModel() throws Exception {
        this.waitForModelObjects();
        TestExtensionTreeData data = TestContentProvider._modelRoot;
        StructuredSelection sel = new StructuredSelection((Object)data);
        this._viewer.setSelection((ISelection)sel);
        this.verifyMenu((IStructuredSelection)sel, "org.eclipse.ui.tests.navigator.NestedAction");
        data = data.getChildren()[0];
        sel = new StructuredSelection((Object)data);
        this._viewer.setSelection((ISelection)sel);
        this.verifyMenu((IStructuredSelection)sel, "org.eclipse.ui.tests.navigator.NestedAction");
        data = data.getChildren()[0];
        sel = new StructuredSelection((Object)data);
        this._viewer.setSelection((ISelection)sel);
        this.verifyMenu((IStructuredSelection)sel, "org.eclipse.ui.tests.navigator.NestedAction");
    }

    @Test
    public void testOverride() throws CoreException {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentActionProvider"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentActionProvider"}, false);
        this.refreshViewer();
        StructuredSelection sel = new StructuredSelection((Object)((IContainer)this._p2.members()[1]).members()[0]);
        this._viewer.setSelection((ISelection)sel);
        Assert.assertNull((Object)this.verifyMenu((IStructuredSelection)sel, "Rena&me"));
        IMenuManager mm = (IMenuManager)this.verifyMenu((IStructuredSelection)sel, "CN Test Menu");
        Assert.assertNotNull((Object)mm);
        Assert.assertEquals((long)4L, (long)mm.getItems().length);
        this._contentService.getActivationService().deactivateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentActionProvider"}, false);
        this._viewer.setSelection((ISelection)sel);
        Assert.assertNotNull((Object)this.verifyMenu((IStructuredSelection)sel, "Rena&me"));
        mm = (IMenuManager)this.verifyMenu((IStructuredSelection)sel, "CN Test Menu");
        Assert.assertNull((Object)mm);
    }

    @Test
    public void testAppearsBefore() throws CoreException {
        IContributionItem[] items;
        StructuredSelection sel = new StructuredSelection((Object)((IContainer)this._p2.members()[1]).members()[0]);
        this._viewer.setSelection((ISelection)sel);
        MenuManager mm = new MenuManager();
        this._actionService.setContext(new ActionContext((ISelection)sel));
        this._actionService.fillContextMenu((IMenuManager)mm);
        ArrayList<String> priorityItems = new ArrayList<String>();
        IContributionItem[] iContributionItemArray = items = mm.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ActionContributionItem aci;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && (aci = (ActionContributionItem)item).getAction().getText().startsWith("org.eclipse.ui.tests.navigator.extension.TestActionProviderPriority")) {
                priorityItems.add(aci.getAction().getText());
            }
            ++n2;
        }
        Assert.assertEquals((long)4L, (long)priorityItems.size());
        Assert.assertEquals((Object)"org.eclipse.ui.tests.navigator.extension.TestActionProviderPriority2", priorityItems.get(0));
        Assert.assertEquals((Object)"org.eclipse.ui.tests.navigator.extension.TestActionProviderPriority4", priorityItems.get(1));
        Assert.assertEquals((Object)"org.eclipse.ui.tests.navigator.extension.TestActionProviderPriority1", priorityItems.get(2));
        Assert.assertEquals((Object)"org.eclipse.ui.tests.navigator.extension.TestActionProviderPriority3", priorityItems.get(3));
    }
}

