/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import java.util.concurrent.Semaphore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.eclipse.ui.tests.navigator.extension.DecorationSchedulerRaceConditionTestDecorator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DecorationSchedulerRaceConditionTest
extends NavigatorTestBase {
    private static final long TIMEOUT_DECORATOR = 2000L;
    private static final long TIMEOUT_UPDATE_JOB = 500L;
    private static final String DECORATION_TEXT_1 = "**1**";
    private static final String DECORATION_TEXT_2 = "**2**";
    private static final String DECORATION_TEXT_3 = "**3**";
    private static final DisplayHelper waitForP1Decoration = new DisplayHelper(){

        protected boolean condition() {
            try {
                return DecorationSchedulerRaceConditionTestDecorator.hasP1Run(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
    };
    private static final DisplayHelper waitForP2Decoration = new DisplayHelper(){

        protected boolean condition() {
            try {
                return DecorationSchedulerRaceConditionTestDecorator.hasP2Run(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                return false;
            }
        }
    };
    private IProject p1Project;
    private IProject p2Project;

    public DecorationSchedulerRaceConditionTest() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.OverrideTestView";
    }

    @Override
    @Before
    public void setUp() throws CoreException {
        super.setUp();
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent"}, true);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent"}, true);
        this.p1Project = ResourcesPlugin.getWorkspace().getRoot().getProject("p1");
        this.p2Project = ResourcesPlugin.getWorkspace().getRoot().getProject("p2");
        this.p1Project.setSessionProperty(DecorationSchedulerRaceConditionTestDecorator.DECO_PROP, (Object)DECORATION_TEXT_1);
        IDecoratorManager manager = PlatformUI.getWorkbench().getDecoratorManager();
        manager.setEnabled("org.eclipse.ui.tests.navigator.bug417255Decorator", true);
        waitForP1Decoration.waitForCondition(Display.getCurrent(), 2000L);
        DisplayHelper.sleep((Display)Display.getCurrent(), (long)500L);
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        Assert.assertEquals((Object)"p1**1**", (Object)rootItems[0].getText());
    }

    @After
    public void resetDecoratorEnablement() throws CoreException {
        IDecoratorManager manager = PlatformUI.getWorkbench().getDecoratorManager();
        manager.setEnabled("org.eclipse.ui.tests.navigator.bug417255Decorator", false);
    }

    @Test
    public void testBug417255raceConditionDuringDecoration() throws Exception {
        this.p1Project.setSessionProperty(DecorationSchedulerRaceConditionTestDecorator.DECO_PROP, (Object)DECORATION_TEXT_2);
        this.p2Project.setSessionProperty(DecorationSchedulerRaceConditionTestDecorator.DECO_PROP, (Object)DECORATION_TEXT_2);
        DecorationSchedulerRaceConditionTestDecorator.resetWait();
        DecorationSchedulerRaceConditionTestDecorator.blockDecoration();
        this._viewer.update((Object)this.p1Project, null);
        this._viewer.update((Object)this.p2Project, null);
        waitForP1Decoration.waitForCondition(Display.getCurrent(), 2000L);
        DecorationSchedulerRaceConditionTestDecorator.resetWait();
        DecorationSchedulerRaceConditionTestDecorator.unblockDecorationOnce();
        waitForP2Decoration.waitForCondition(Display.getCurrent(), 2000L);
        this.p1Project.setSessionProperty(DecorationSchedulerRaceConditionTestDecorator.DECO_PROP, (Object)DECORATION_TEXT_3);
        this._viewer.update((Object)this.p1Project, null);
        DecorationSchedulerRaceConditionTestDecorator.resetWait();
        DecorationSchedulerRaceConditionTestDecorator.unblockDecoration();
        waitForP1Decoration.waitForCondition(Display.getCurrent(), 2000L);
        DisplayHelper.sleep((Display)Display.getCurrent(), (long)500L);
        TreeItem[] rootItemsAfter = this._viewer.getTree().getItems();
        Assert.assertEquals((Object)"p1**3**", (Object)rootItemsAfter[0].getText());
    }

    @Test
    public void testBug417255raceConditionBeforeUpdate() throws Exception {
        final Semaphore updateJobScheduled = new Semaphore(0);
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void scheduled(IJobChangeEvent event) {
                event.getJob().getName().equals(WorkbenchMessages.DecorationScheduler_UpdateJobName);
                updateJobScheduled.release();
            }
        };
        Job.getJobManager().addJobChangeListener((IJobChangeListener)listener);
        this.p1Project.setSessionProperty(DecorationSchedulerRaceConditionTestDecorator.DECO_PROP, (Object)DECORATION_TEXT_2);
        this._viewer.update((Object)this.p1Project, null);
        waitForP1Decoration.waitForCondition(Display.getCurrent(), 2000L);
        updateJobScheduled.acquire();
        this.p1Project.setSessionProperty(DecorationSchedulerRaceConditionTestDecorator.DECO_PROP, (Object)DECORATION_TEXT_3);
        this._viewer.update((Object)this.p1Project, null);
        Job.getJobManager().removeJobChangeListener((IJobChangeListener)listener);
        waitForP1Decoration.waitForCondition(Display.getCurrent(), 2000L);
        DisplayHelper.sleep((Display)Display.getCurrent(), (long)500L);
        TreeItem[] rootItemsAfter = this._viewer.getTree().getItems();
        Assert.assertEquals((Object)"p1**3**", (Object)rootItemsAfter[0].getText());
    }
}

