/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.internal.navigator.VisibilityAssistant;
import org.eclipse.ui.internal.navigator.extensions.EvaluationCache;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorActivationService;
import org.eclipse.ui.navigator.INavigatorViewerDescriptor;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.eclipse.ui.tests.navigator.util.TestNavigatorActivationService;
import org.eclipse.ui.tests.navigator.util.TestNavigatorViewerDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class EvaluationCacheTest
extends NavigatorTestBase {
    EvaluationCache cache;

    public EvaluationCacheTest() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.ProgrammaticTestView";
    }

    @Override
    public void setUp() throws CoreException {
        super.setUp();
        TestNavigatorViewerDescriptor mockViewerDescript = new TestNavigatorViewerDescriptor();
        TestNavigatorActivationService mockActivationService = new TestNavigatorActivationService();
        VisibilityAssistant mockAssistant = new VisibilityAssistant((INavigatorViewerDescriptor)mockViewerDescript, (INavigatorActivationService)mockActivationService);
        this.cache = new EvaluationCache(mockAssistant);
    }

    private void doSimpleAddGet(boolean toComputeOverrides) {
        Object key = new Object();
        NavigatorContentDescriptor[] value = new NavigatorContentDescriptor[]{};
        this.cache.setDescriptors(key, value, toComputeOverrides);
        Assert.assertSame((Object)value, (Object)this.cache.getDescriptors(key, toComputeOverrides));
        Assert.assertNull((Object)this.cache.getDescriptors(key, !toComputeOverrides));
    }

    @Test
    public void testSimpleAddGetNotOverrides() {
        this.doSimpleAddGet(false);
    }

    @Test
    public void testSimpleAddGetOverrides() {
        this.doSimpleAddGet(true);
    }

    private void doNotSameInstEqual(boolean toComputeOverrides) {
        ArrayList<String> key = new ArrayList<String>(2);
        key.add("Hi");
        key.add("There");
        NavigatorContentDescriptor[] value = new NavigatorContentDescriptor[]{};
        this.cache.setDescriptors(key, value, toComputeOverrides);
        ArrayList key2 = new ArrayList(key);
        Assert.assertSame((Object)value, (Object)this.cache.getDescriptors(key2, toComputeOverrides));
        Assert.assertNull((Object)this.cache.getDescriptors(key, !toComputeOverrides));
        Assert.assertNull((Object)this.cache.getDescriptors(key2, !toComputeOverrides));
    }

    @Test
    public void testNotSameInstEqualNotOverrides() {
        this.doNotSameInstEqual(false);
    }

    @Test
    public void testNotSameInstEqualOverrides() {
        this.doNotSameInstEqual(true);
    }

    private void doTestReplace(boolean toComputeOverrides) {
        Object key = new Object();
        NavigatorContentDescriptor[] value1 = new NavigatorContentDescriptor[]{};
        this.cache.setDescriptors(key, value1, toComputeOverrides);
        Assert.assertSame((Object)value1, (Object)this.cache.getDescriptors(key, toComputeOverrides));
        NavigatorContentDescriptor[] value2 = new NavigatorContentDescriptor[]{};
        this.cache.setDescriptors(key, value2, toComputeOverrides);
        Assert.assertSame((Object)value2, (Object)this.cache.getDescriptors(key, toComputeOverrides));
    }

    @Test
    public void testReplaceNotOverrides() {
        this.doTestReplace(false);
    }

    @Test
    public void testReplaceOverrides() {
        this.doTestReplace(true);
    }

    @Test
    public void testOnVisibilityOrActivationChangeClearsCaches() {
        Object key = new Object();
        NavigatorContentDescriptor[] value1 = new NavigatorContentDescriptor[]{};
        this.cache.setDescriptors(key, value1, false);
        Assert.assertSame((Object)value1, (Object)this.cache.getDescriptors(key, false));
        NavigatorContentDescriptor[] value2 = new NavigatorContentDescriptor[]{};
        this.cache.setDescriptors(key, value2, true);
        Assert.assertSame((Object)value2, (Object)this.cache.getDescriptors(key, true));
        this.cache.onVisibilityOrActivationChange();
        Assert.assertNull((Object)this.cache.getDescriptors(key, false));
        Assert.assertNull((Object)this.cache.getDescriptors(key, true));
    }
}

