/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.NavigationHistoryAction;
import org.eclipse.ui.intro.IIntroPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.tests.harness.util.CloseTestWindowsRule;
import org.eclipse.ui.tests.harness.util.EditorTestHelper;
import org.eclipse.ui.tests.harness.util.FileUtil;
import org.eclipse.ui.tests.harness.util.UITestUtil;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.TextSelectionNavigationLocation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class GoBackForwardsTest {
    private static final String PROJECT_NAME = "GoBackForwardsTestProject";
    private static final String FILE_NAME = "GoBackForwardsTestFile.java";
    private static final String FILE_CONTENTS = "public class GoBackForwardsTestFile {\n    public static void main(String[] args) {\n        System.out.println(\"Hello world!\");\n    }\n}";
    private static final String GENERIC_EDITOR_ID = "org.eclipse.ui.genericeditor.GenericEditor";
    private static final String TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    private static final String SELECTION_STRING = "Selection<offset: 10, length: 5>";
    private IProject project;
    private IFile file;
    @Rule
    public final CloseTestWindowsRule closeTestWindows = new CloseTestWindowsRule();

    @Before
    public void setUp() throws CoreException, IOException {
        this.project = FileUtil.createProject((String)PROJECT_NAME);
        this.file = FileUtil.createFile((String)FILE_NAME, (IProject)this.project);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(FILE_CONTENTS);
        Files.writeString(Paths.get(this.file.getLocation().toOSString(), new String[0]), (CharSequence)stringBuilder, new OpenOption[0]);
        this.project.refreshLocal(2, null);
    }

    @Test
    public void testNavigationHistoryNavigation() throws PartInitException {
        IIntroPart introPart = PlatformUI.getWorkbench().getIntroManager().getIntro();
        PlatformUI.getWorkbench().getIntroManager().closeIntro(introPart);
        UITestUtil.processEvents();
        UITestUtil.Condition genericEditorNoSelection = this.currentNavigationHistoryLocationCondition(GENERIC_EDITOR_ID, false);
        UITestUtil.Condition genericEditorSelection = this.currentNavigationHistoryLocationCondition(GENERIC_EDITOR_ID, true);
        UITestUtil.Condition textEditorNoSelection = this.currentNavigationHistoryLocationCondition(TEXT_EDITOR_ID, false);
        UITestUtil.Condition textEditorSelection = this.currentNavigationHistoryLocationCondition(TEXT_EDITOR_ID, true);
        FileEditorInput editorInput = new FileEditorInput(this.file);
        this.openGenericEditor((IEditorInput)editorInput);
        Assert.assertTrue((String)("Timeout during navigation." + this.getStateDetails()), (boolean)UITestUtil.processEventsUntil((UITestUtil.Condition)genericEditorNoSelection, (long)1000L));
        this.selectInGenericEditor((IEditorInput)editorInput);
        Assert.assertTrue((String)("Timeout during navigation." + this.getStateDetails()), (boolean)UITestUtil.processEventsUntil((UITestUtil.Condition)genericEditorSelection, (long)1000L));
        this.openTextEditor((IEditorInput)editorInput);
        Assert.assertTrue((String)("Timeout during navigation." + this.getStateDetails()), (boolean)UITestUtil.processEventsUntil((UITestUtil.Condition)textEditorNoSelection, (long)1000L));
        this.selectInTextEditor((IEditorInput)editorInput);
        Assert.assertTrue((String)("Timeout during navigation." + this.getStateDetails()), (boolean)UITestUtil.processEventsUntil((UITestUtil.Condition)textEditorSelection, (long)1000L));
        this.openGenericEditor((IEditorInput)editorInput);
        Assert.assertTrue((String)("Timeout during navigation." + this.getStateDetails()), (boolean)UITestUtil.processEventsUntil((UITestUtil.Condition)genericEditorSelection, (long)1000L));
        this.openTextEditor((IEditorInput)editorInput);
        Assert.assertTrue((String)("Timeout during navigation." + this.getStateDetails()), (boolean)UITestUtil.processEventsUntil((UITestUtil.Condition)textEditorSelection, (long)1000L));
        this.goBackward(EditorTestHelper.getActiveWorkbenchWindow(), genericEditorSelection);
        Assert.assertEquals((String)("Failed to correctly navigate backward from text editor to java editor." + this.getStateDetails()), (Object)GENERIC_EDITOR_ID, (Object)this.getActiveEditorId());
        this.goBackward(EditorTestHelper.getActiveWorkbenchWindow(), textEditorSelection);
        Assert.assertEquals((String)("Failed to correctly navigate backward from java editor to test editor." + this.getStateDetails()), (Object)TEXT_EDITOR_ID, (Object)this.getActiveEditorId());
        this.goBackward(EditorTestHelper.getActiveWorkbenchWindow(), textEditorNoSelection);
        Assert.assertEquals((String)("Failed to correctly navigate backward from text editor to text editor." + this.getStateDetails()), (Object)TEXT_EDITOR_ID, (Object)this.getActiveEditorId());
        this.goBackward(EditorTestHelper.getActiveWorkbenchWindow(), genericEditorSelection);
        this.goBackward(EditorTestHelper.getActiveWorkbenchWindow(), genericEditorNoSelection);
        Assert.assertEquals((String)("Failed to correctly navigate backward from java editor to java editor." + this.getStateDetails()), (Object)GENERIC_EDITOR_ID, (Object)this.getActiveEditorId());
        this.goForward(EditorTestHelper.getActiveWorkbenchWindow(), genericEditorSelection);
        Assert.assertEquals((String)("Failed to correctly navigate forward from java editor to java editor." + this.getStateDetails()), (Object)GENERIC_EDITOR_ID, (Object)this.getActiveEditorId());
        this.goForward(EditorTestHelper.getActiveWorkbenchWindow(), textEditorNoSelection);
        this.goForward(EditorTestHelper.getActiveWorkbenchWindow(), textEditorSelection);
        Assert.assertEquals((String)("Failed to correctly navigate forward from java editor to java editor." + this.getStateDetails()), (Object)TEXT_EDITOR_ID, (Object)this.getActiveEditorId());
        this.goForward(EditorTestHelper.getActiveWorkbenchWindow(), genericEditorSelection);
        Assert.assertEquals((String)("Failed to correctly navigate forward from text editor to java editor." + this.getStateDetails()), (Object)GENERIC_EDITOR_ID, (Object)this.getActiveEditorId());
        this.goForward(EditorTestHelper.getActiveWorkbenchWindow(), textEditorSelection);
        Assert.assertEquals((String)("Failed to correctly navigate forward from java editor to text editor." + this.getStateDetails()), (Object)TEXT_EDITOR_ID, (Object)this.getActiveEditorId());
    }

    private UITestUtil.Condition currentNavigationHistoryLocationCondition(String editorId, boolean selection) {
        return () -> {
            INavigationLocation location = EditorTestHelper.getActiveWorkbenchWindow().getActivePage().getNavigationHistory().getCurrentLocation();
            if (location instanceof TextSelectionNavigationLocation) {
                return editorId.equals(location.getId()) && (!selection || SELECTION_STRING.equals(location.toString()));
            }
            return false;
        };
    }

    private void openGenericEditor(IEditorInput editorInput) throws PartInitException {
        EditorTestHelper.getActivePage().openEditor(editorInput, GENERIC_EDITOR_ID, true, 3);
    }

    private void selectInGenericEditor(IEditorInput editorInput) throws PartInitException {
        AbstractTextEditor editor = (AbstractTextEditor)EditorTestHelper.getActivePage().openEditor(editorInput, GENERIC_EDITOR_ID, true, 3);
        editor.selectAndReveal(10, 5);
    }

    private void selectInTextEditor(IEditorInput editorInput) throws PartInitException {
        AbstractTextEditor editor = (AbstractTextEditor)EditorTestHelper.getActivePage().openEditor(editorInput, TEXT_EDITOR_ID, true, 3);
        editor.selectAndReveal(10, 5);
    }

    private void openTextEditor(IEditorInput editorInput) throws PartInitException {
        EditorTestHelper.getActivePage().openEditor(editorInput, TEXT_EDITOR_ID, true, 3);
    }

    private void goForward(IWorkbenchWindow window, UITestUtil.Condition condition) {
        NavigationHistoryAction action = new NavigationHistoryAction(window, true);
        action.run();
        Assert.assertTrue((String)"Timeout during navigation.", (boolean)UITestUtil.processEventsUntil((UITestUtil.Condition)condition, (long)1000L));
    }

    private void goBackward(IWorkbenchWindow window, UITestUtil.Condition condition) {
        NavigationHistoryAction action = new NavigationHistoryAction(window, false);
        action.run();
        Assert.assertTrue((String)"Timeout during navigation.", (boolean)UITestUtil.processEventsUntil((UITestUtil.Condition)condition, (long)1000L));
    }

    private String getActiveEditorId() {
        return EditorTestHelper.getActivePage().getActiveEditor().getEditorSite().getId();
    }

    private String getStateDetails() {
        INavigationLocation[] locations;
        String id;
        StringBuilder result = new StringBuilder();
        result.append("\nOpen Editors:\n");
        IWorkbenchPage activePage = EditorTestHelper.getActivePage();
        IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editor = editorReference.getEditor(false);
            if (editor != null) {
                id = editorReference.getId();
                IEditorInput editorInput = editor.getEditorInput();
                result.append("  id=").append(id).append(", input=").append(editorInput).append("\n");
            }
            ++n2;
        }
        result.append("Navigation Locations:\n");
        INavigationLocation[] iNavigationLocationArray = locations = activePage.getNavigationHistory().getLocations();
        int n3 = locations.length;
        n = 0;
        while (n < n3) {
            INavigationLocation location = iNavigationLocationArray[n];
            id = location.getId();
            Object input = location.getInput();
            result.append("  id=").append(id).append(", input=").append(input).append(", location=").append(location).append("\n");
            ++n;
        }
        return result.toString();
    }
}

