/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.NavigatorContentServiceFactory;
import org.eclipse.ui.tests.harness.util.EditorTestHelper;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.eclipse.ui.tests.navigator.extension.TestContentProvider;
import org.junit.Assert;
import org.junit.Test;

public class INavigatorContentServiceTests
extends NavigatorTestBase {
    public INavigatorContentServiceTests() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.TestView";
    }

    @Test
    public void testFindValidExtensions() {
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContent", "org.eclipse.ui.navigator.resourceContent"}, true);
        ITreeContentProvider contentServiceContentProvider = this._contentService.createCommonContentProvider();
        ILabelProvider contentServiceLabelProvider = this._contentService.createCommonLabelProvider();
        ITreeContentProvider[] rootContentProviders = ((NavigatorContentService)this._contentService).findRootContentProviders((Object)ResourcesPlugin.getWorkspace().getRoot());
        Assert.assertEquals((String)"Ensure there is only one root content provider.", (long)1L, (long)rootContentProviders.length);
        Set projectContentExtensions = this._contentService.findContentExtensionsByTriggerPoint((Object)this._project);
        Assert.assertEquals((String)"Ensure there are two content providers for an IProject.", (long)2L, (long)projectContentExtensions.size());
        boolean found = false;
        for (INavigatorContentExtension ext : projectContentExtensions) {
            if (!(ext.getContentProvider() instanceof TestContentProvider)) continue;
            TestContentProvider testContentProvider = (TestContentProvider)ext.getContentProvider();
            Object[] projectChildren = testContentProvider.getChildren(this._project);
            Assert.assertEquals((String)"There should be one test-type child of the project.", (long)1L, (long)projectChildren.length);
            Assert.assertEquals((Object)"BlueParent", (Object)contentServiceLabelProvider.getText(projectChildren[0]));
            Object[] testRootChildren = contentServiceContentProvider.getChildren(projectChildren[0]);
            Assert.assertEquals((String)"There should be one test-type child of the root test-type item.", (long)3L, (long)testRootChildren.length);
            found = true;
        }
        Assert.assertTrue((String)"The test content provider was not found.", (boolean)found);
    }

    @Test
    public void testDeactivateTestExtension() {
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent"}, true);
        this._contentService.createCommonContentProvider();
        this._contentService.createCommonLabelProvider();
        Set rootContentProviders = this._contentService.findRootContentExtensions((Object)ResourcesPlugin.getWorkspace().getRoot());
        Assert.assertEquals((String)"Ensure there is only one root content provider.", (long)1L, (long)rootContentProviders.size());
        Set projectContentExtensions = this._contentService.findContentExtensionsByTriggerPoint((Object)this._project);
        Assert.assertEquals((String)"Ensure there is one content provider for an IProject.", (long)1L, (long)projectContentExtensions.size());
    }

    @Test
    public void testBindTestExtension() {
        INavigatorContentService contentServiceWithProgrammaticBindings = NavigatorContentServiceFactory.INSTANCE.createContentService("org.eclipse.ui.tests.navigator.TestView");
        INavigatorContentDescriptor[] boundDescriptors = contentServiceWithProgrammaticBindings.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContent2"}, false);
        contentServiceWithProgrammaticBindings.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.ui.tests.navigator.testContent", "org.eclipse.ui.tests.navigator.testContent2"}, false);
        Assert.assertEquals((String)"One descriptor should have been returned.", (long)1L, (long)boundDescriptors.length);
        Assert.assertEquals((String)"The declarative content service should have one fewer visible extension ids than the one created programmatically.", (long)(this._contentService.getVisibleExtensionIds().length + 1), (long)contentServiceWithProgrammaticBindings.getVisibleExtensionIds().length);
        INavigatorContentDescriptor[] visibleDescriptors = contentServiceWithProgrammaticBindings.getVisibleExtensions();
        boolean found = false;
        INavigatorContentDescriptor[] iNavigatorContentDescriptorArray = visibleDescriptors;
        int n = visibleDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            INavigatorContentDescriptor visibleDescriptor = iNavigatorContentDescriptorArray[n2];
            if ("org.eclipse.ui.tests.navigator.testContent2".equals(visibleDescriptor.getId())) {
                found = true;
            }
            ++n2;
        }
        Assert.assertTrue((String)"The programmatically bound extension should be bound.", (boolean)found);
        Set enabledDescriptors = contentServiceWithProgrammaticBindings.findContentExtensionsByTriggerPoint((Object)this._project);
        Assert.assertEquals((String)"There should be a three extensions.", (long)3L, (long)enabledDescriptors.size());
    }

    @Test
    public void testTestExtensionVisibility() {
        Assert.assertTrue((String)"The test extension should be visible.", (boolean)this._contentService.getViewerDescriptor().isVisibleContentExtension("org.eclipse.ui.tests.navigator.testContent"));
    }

    @Test
    public void testResourceExtensionVisibility() {
        Assert.assertTrue((String)"The test extension should be visible.", (boolean)this._contentService.getViewerDescriptor().isVisibleContentExtension("org.eclipse.ui.navigator.resourceContent"));
    }

    @Test
    public void testVisibleExtensionIds() {
        String[] visibleIds = this._contentService.getVisibleExtensionIds();
        Assert.assertEquals((String)"There should be three visible extensions.", (long)3L, (long)visibleIds.length);
        String[] stringArray = visibleIds;
        int n = visibleIds.length;
        int n2 = 0;
        while (n2 < n) {
            String visibleId = stringArray[n2];
            if (!("org.eclipse.ui.tests.navigator.testContent".equals(visibleId) || "org.eclipse.ui.navigator.resourceContent".equals(visibleId) || "org.eclipse.ui.tests.navigator.testContentHasChildren".equals(visibleId))) {
                Assert.fail((String)("The extension id is invalid:" + visibleId));
            }
            ++n2;
        }
        INavigatorContentDescriptor[] visibleDescriptors = this._contentService.getVisibleExtensions();
        int i = 0;
        while (i < visibleIds.length) {
            if (!("org.eclipse.ui.tests.navigator.testContent".equals(visibleDescriptors[i].getId()) || "org.eclipse.ui.navigator.resourceContent".equals(visibleDescriptors[i].getId()) || "org.eclipse.ui.tests.navigator.testContentHasChildren".equals(visibleDescriptors[i].getId()))) {
                Assert.fail((String)("The extension id is invalid:" + visibleDescriptors[i].getId()));
            }
            ++i;
        }
    }

    @Test
    public void testNonCommonViewer() throws Exception {
        EditorTestHelper.showView((String)"org.eclipse.ui.tests.navigator.NonCommonViewerTestView", (boolean)true);
    }
}

