/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import java.util.HashSet;
import java.util.Set;
import java.util.function.BooleanSupplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.NavigatorActionService;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.tests.harness.util.EditorTestHelper;
import org.eclipse.ui.tests.harness.util.FileUtil;
import org.eclipse.ui.tests.navigator.extension.TestContentProvider;
import org.eclipse.ui.tests.navigator.extension.TestContentProviderPipelined;
import org.eclipse.ui.tests.navigator.extension.TestContentProviderResource;
import org.eclipse.ui.tests.navigator.extension.TestDragAssistant;
import org.eclipse.ui.tests.navigator.extension.TestEmptyContentProvider;
import org.eclipse.ui.tests.navigator.extension.TestLabelProvider;
import org.eclipse.ui.tests.navigator.extension.TestSorterData;
import org.eclipse.ui.tests.navigator.extension.TestSorterResource;
import org.eclipse.ui.tests.navigator.m12.model.ResourceWrapper;
import org.eclipse.ui.tests.navigator.util.TestWorkspace;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class NavigatorTestBase {
    public static final String COMMON_NAVIGATOR_RESOURCE_EXT = "org.eclipse.ui.navigator.resourceContent";
    public static final String COMMON_NAVIGATOR_JAVA_EXT = "org.eclipse.jdt.java.ui.javaContent";
    public static final String TEST_VIEWER = "org.eclipse.ui.tests.navigator.TestView";
    public static final String TEST_VIEWER_PROGRAMMATIC = "org.eclipse.ui.tests.navigator.ProgrammaticTestView";
    public static final String TEST_VIEWER_PIPELINE = "org.eclipse.ui.tests.navigator.PipelineTestView";
    public static final String TEST_VIEWER_HIDE_EXTENSIONS = "org.eclipse.ui.tests.navigator.HideAvailableExtensionsTestView";
    public static final String TEST_VIEWER_INHERITED = "org.eclipse.ui.tests.navigator.InheritedTestView";
    public static final String TEST_VIEWER_NON_COMMONVIEWER = "org.eclipse.ui.tests.navigator.NonCommonViewerTestViewer";
    public static final String TEST_VIEWER_FILTER = "org.eclipse.ui.tests.navigator.FilterTestView";
    public static final String TEST_VIEWER_INITIAL_ACTIVATION = "org.eclipse.ui.tests.navigator.InitialActivationView";
    public static final String TEST_VIEWER_LINK_HELPER = "org.eclipse.ui.tests.navigator.TestLinkHelperView";
    public static final String TEST_VIEWER_SHOW_IN = "org.eclipse.ui.tests.navigator.TestShowInView";
    public static final String TEST_VIEW_NON_COMMONVIEWER = "org.eclipse.ui.tests.navigator.NonCommonViewerTestView";
    public static final String TEST_CONTENT = "org.eclipse.ui.tests.navigator.testContent";
    public static final String TEST_CONTENT2 = "org.eclipse.ui.tests.navigator.testContent2";
    public static final String TEST_CONTENT_OVERRIDDEN1 = "org.eclipse.ui.tests.navigator.testContentOverridden1";
    public static final String TEST_CONTENT_OVERRIDDEN2 = "org.eclipse.ui.tests.navigator.testContentOverridden2";
    public static final String TEST_CONTENT_OVERRIDE1 = "org.eclipse.ui.tests.navigator.testContentOverride1";
    public static final String TEST_CONTENT_OVERRIDE2 = "org.eclipse.ui.tests.navigator.testContentOverride2";
    public static final String TEST_CONTENT_OVERRIDE2_BLANK = "org.eclipse.ui.tests.navigator.testContentOverride2Blank";
    public static final String TEST_CONTENT_RESOURCE_OVERRIDE = "org.eclipse.ui.tests.navigator.testContentResourceOverride";
    public static final String TEST_CONTENT_PIPELINE = "org.eclipse.ui.tests.navigator.testPipeline";
    public static final String TEST_CONTENT_WITH = "org.eclipse.ui.tests.navigator.testContentWith";
    public static final String TEST_CONTENT_NO_CHILDREN = "org.eclipse.ui.tests.navigator.testContentNoChildren";
    public static final String TEST_CONTENT_EMPTY = "org.eclipse.ui.tests.navigator.testContentEmpty";
    public static final String TEST_CONTENT_TOOLTIPS = "org.eclipse.ui.tests.navigator.testContentTooltips";
    public static final String TEST_CONTENT_RESOURCE_UNSORTED = "org.eclipse.ui.tests.navigator.resourceContent.unsorted";
    public static final String TEST_CONTENT_INITIAL_ACTIVATION_FALSE = "org.eclipse.ui.tests.navigator.testInitialActivationFalse";
    public static final String TEST_CONTENT_INITIAL_ACTIVATION_TRUE = "org.eclipse.ui.tests.navigator.testInitialActivationTrue";
    public static final String TEST_SIMPLE_CHILDREN1 = "org.eclipse.ui.tests.navigator.testSimpleChildrenContent1";
    public static final String TEST_SIMPLE_CHILDREN2 = "org.eclipse.ui.tests.navigator.testSimpleChildrenContent2";
    public static final String TEST_SIMPLE_CHILDREN3 = "org.eclipse.ui.tests.navigator.testSimpleChildrenContent3";
    public static final String TEST_SIMPLE_CHILDREN_NOT_FOUND = "org.eclipse.ui.tests.navigator.testSimpleChildrenAppearsBeforeNotFound";
    public static final String TEST_CONTENT_M12_VIEW = "org.eclipse.ui.tests.navigator.M12View";
    public static final String TEST_CONTENT_M12_M1_CONTENT = "org.eclipse.ui.tests.navigator.m12.M1";
    public static final String TEST_CONTENT_M12_M1_CONTENT_FIRST_CLASS = "org.eclipse.ui.tests.navigator.m12.M1FirstClass";
    public static final String TEST_CONTENT_M12_M2_CONTENT = "org.eclipse.ui.tests.navigator.m12.M2";
    public static final String TEST_CONTENT_LABEL1 = "org.eclipse.ui.tests.navigator.testContentLabel1";
    public static final String TEST_CONTENT_LABEL2 = "org.eclipse.ui.tests.navigator.testContentLabel2";
    public static final String TEST_CONTENT_COMPARATOR_MODEL = "org.eclipse.ui.tests.navigator.testContentComparatorModel";
    public static final String TEST_CONTENT_SORTER_MODEL = "org.eclipse.ui.tests.navigator.testContentSorterModel";
    public static final String TEST_CONTENT_SORTER_MODEL_OVERRIDE = "org.eclipse.ui.tests.navigator.testContentSorterModel.override";
    public static final String TEST_CONTENT_SORTER_MODEL_OVERRIDE_NOSORT = "org.eclipse.ui.tests.navigator.testContentSorterModel.override.nosort";
    public static final String TEST_CONTENT_SORTER_RESOURCE = "org.eclipse.ui.tests.navigator.testContentSorterResource";
    public static final String TEST_CONTENT_SORTER_RESOURCE_SORTONLY = "org.eclipse.ui.tests.navigator.testContentSorterResource.sortOnly";
    public static final String TEST_CONTENT_SORTER_RESOURCE_SORTONLY_OVERRIDE = "org.eclipse.ui.tests.navigator.testContentSorterResource.sortOnly.override";
    public static final String TEST_CONTENT_SORTER_RESOURCE_OVERRIDE = "org.eclipse.ui.tests.navigator.testContentSorterResource.override";
    public static final String TEST_CONTENT_SORTER_RESOURCE_OVERRIDE_SORTER = "org.eclipse.ui.tests.navigator.testContentSorterResource.override.sorter";
    public static final String TEST_CONTENT_SORTER_BASIC_A = "org.eclipse.ui.tests.navigator.testContentBasic.a";
    public static final String TEST_CONTENT_SORTER_BASIC_B = "org.eclipse.ui.tests.navigator.testContentBasic.b";
    public static final String TEST_CONTENT_SORTER_BASIC_SORTONLY_SORTER = "org.eclipse.ui.tests.navigator.testContentBasic.sortOnlySorter";
    public static final String TEST_CONTENT_REDLABEL = "org.eclipse.ui.tests.navigator.testContentRedLabel";
    public static final String TEST_CONTENT_MISSINGLABEL = "org.eclipse.ui.tests.navigator.testContentMissingLabel";
    public static final String TEST_CONTENT_DROP_COPY = "org.eclipse.ui.tests.navigator.testContentDropCopy";
    public static final String TEST_CONTENT_HAS_CHILDREN = "org.eclipse.ui.tests.navigator.testContentHasChildren";
    public static final String TEST_CONTENT_ACTION_PROVIDER = "org.eclipse.ui.tests.navigator.testContentActionProvider";
    public static final String TEST_CONTENT_TRACKING_LABEL = "org.eclipse.ui.tests.navigator.testTrackingLabel";
    public static final String TEST_CONTENT_JST = "org.eclipse.ui.tests.navigator.jst.ContentProvider";
    protected static final String TEST_ACTIVITY = "org.eclipse.ui.tests.navigator.testActivity";
    protected static final String TEST_ACTIVITY_PROVIDER = "org.eclipse.ui.tests.navigator.testActivityProvider";
    public static final String TEST_ACTION_PROVIDER_PRIORITY = "org.eclipse.ui.tests.navigator.extension.TestActionProviderPriority";
    protected static final String ACTION_NESTED = "org.eclipse.ui.tests.navigator.NestedAction";
    public static final String TEST_VIEWER_HELP_CONTEXT = "org.eclipse.ui.tests.navigator.testHelpContext";
    public static final String TEST_C_CONTENT = "org.eclipse.ui.tests.navigator.cdt.content";
    public static final String TEST_FILTER_P1 = "org.eclipse.ui.tests.navigator.filters.p1";
    public static final String TEST_FILTER_P2 = "org.eclipse.ui.tests.navigator.filters.p2";
    protected String _navigatorInstanceId;
    protected Set<IResource> _expectedChildren = new HashSet<IResource>();
    protected IProject _project;
    protected IProject _p1;
    protected IProject _p2;
    protected static final int _p1Ind = 0;
    protected static final int _p2Ind = 1;
    protected static final int _projectInd = 2;
    protected static int _projectCount;
    protected CommonViewer _viewer;
    protected CommonNavigator _commonNavigator;
    protected INavigatorContentService _contentService;
    protected NavigatorActionService _actionService;
    protected boolean _initTestData = true;
    protected static final boolean DEBUG = false;
    protected static final boolean ALL = true;
    protected static final boolean TEXT = true;

    public NavigatorTestBase() {
    }

    public NavigatorTestBase(String name) {
    }

    @Before
    public void setUp() throws CoreException {
        if (this._navigatorInstanceId == null) {
            throw new RuntimeException("Set the _navigatorInstanceId in the constructor");
        }
        if (!this._navigatorInstanceId.equals("org.eclipse.ui.navigator.ProjectExplorer")) {
            EditorTestHelper.showView((String)"org.eclipse.ui.navigator.ProjectExplorer", (boolean)false);
        }
        TestContentProviderPipelined.resetTest();
        TestContentProviderResource.resetTest();
        TestSorterData.resetTest();
        TestSorterResource.resetTest();
        TestLabelProvider.resetTest();
        TestDragAssistant.resetTest();
        TestEmptyContentProvider.resetTest();
        if (this._initTestData) {
            this.clearAll();
            TestWorkspace.init();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            this._project = root.getProject("Test");
            this._expectedChildren.add((IResource)this._project.getFolder("src"));
            this._expectedChildren.add((IResource)this._project.getFolder("bin"));
            this._expectedChildren.add((IResource)this._project.getFile(".project"));
            this._expectedChildren.add((IResource)this._project.getFile(".classpath"));
            this._expectedChildren.add((IResource)this._project.getFile("model.properties"));
            this._p1 = ResourcesPlugin.getWorkspace().getRoot().getProject("p1");
            this._p1.open(null);
            this._p2 = ResourcesPlugin.getWorkspace().getRoot().getProject("p2");
            this._p2.open(null);
            _projectCount = 3;
        }
        this.showNavigator();
        this.refreshViewer();
        this._contentService = this._viewer.getNavigatorContentService();
        this._actionService = this._commonNavigator.getNavigatorActionService();
        ((NavigatorFilterService)this._contentService.getFilterService()).resetFilterActivationState();
    }

    protected void lookAt() {
        DisplayHelper.sleep((long)1000000L);
    }

    protected void waitForModelObjects() throws Exception {
        this._project.findMember(TestContentProvider.MODEL_FILE_PATH).touch(null);
        DisplayHelper.sleep((long)50L);
    }

    protected void waitForCondition(String description, BooleanSupplier condition) {
        int i = 1;
        while (i <= 1200) {
            if (condition.getAsBoolean()) {
                System.out.println("The condition '" + description + "' was met in " + i * 50 + " ms or less");
                return;
            }
            DisplayHelper.sleep((long)50L);
            ++i;
        }
        Assert.fail((String)("The condition '" + description + "' was never met"));
    }

    protected void showNavigator() throws PartInitException {
        EditorTestHelper.showView((String)this._navigatorInstanceId, (boolean)true);
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWindow.getActivePage();
        this._commonNavigator = (CommonNavigator)activePage.findView(this._navigatorInstanceId);
        this._commonNavigator.setFocus();
        this._viewer = (CommonViewer)this._commonNavigator.getAdapter(CommonViewer.class);
    }

    @After
    public void tearDown() throws CoreException {
        this.clearAll();
        EditorTestHelper.showView((String)this._navigatorInstanceId, (boolean)false);
    }

    protected void clearAll() throws CoreException {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            FileUtil.delete((IResource)project);
            ++n2;
        }
    }

    protected void refreshViewer() {
        try {
            TreeItem[] rootItems;
            TreeItem[] treeItemArray = rootItems = this._viewer.getTree().getItems();
            int n = rootItems.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem rootItem = treeItemArray[n2];
                rootItem.setText("");
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._viewer.refresh();
    }

    protected Object verifyMenu(IStructuredSelection sel, String item) {
        IContributionItem[] items;
        MenuManager mm = new MenuManager();
        this._actionService.setContext(new ActionContext((ISelection)sel));
        this._actionService.fillContextMenu((IMenuManager)mm);
        IContributionItem[] iContributionItemArray = items = mm.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ActionContributionItem aci;
            IContributionItem item1 = iContributionItemArray[n2];
            if (item1 instanceof MenuManager) {
                MenuManager childMm = (MenuManager)item1;
                if (childMm.getMenuText().contains(item)) {
                    return childMm;
                }
            } else if (item1 instanceof ActionContributionItem && (aci = (ActionContributionItem)item1).getAction().getText().contains(item)) {
                return aci;
            }
            ++n2;
        }
        return null;
    }

    protected boolean verifyMenu(IStructuredSelection sel, String item, boolean useNewMenu) {
        MenuManager mm = new MenuManager();
        this._actionService.setContext(new ActionContext((ISelection)sel));
        this._actionService.fillContextMenu((IMenuManager)mm);
        IContributionItem[] items = mm.getItems();
        if (useNewMenu) {
            MenuManager newMm = (MenuManager)items[1];
            items = newMm.getItems();
        }
        IContributionItem[] iContributionItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            ActionContributionItem aci;
            IContributionItem i = iContributionItemArray[n2];
            if (i instanceof ActionContributionItem && (aci = (ActionContributionItem)i).getAction().getText().startsWith(item)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void checkItems(TreeItem[] rootItems, TestLabelProvider tlp) {
        this.checkItems(rootItems, tlp, true, true);
    }

    protected void checkItemsText(TreeItem[] rootItems, TestLabelProvider tlp, boolean all) {
        this.checkItems(rootItems, tlp, all, true);
    }

    protected void checkItems(TreeItem[] rootItems, TestLabelProvider tlp, boolean all, boolean text) {
        TreeItem[] treeItemArray = rootItems;
        int n = rootItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem rootItem = treeItemArray[n2];
            if (rootItem.getText() != null && !rootItem.getText().equals("")) {
                if (text && !rootItem.getText().startsWith(tlp.getColorName())) {
                    Assert.fail((String)("Wrong text: " + rootItem.getText()));
                }
                Assert.assertEquals((Object)tlp.backgroundColor, (Object)rootItem.getBackground(0));
                Assert.assertEquals((Object)TestLabelProvider.toForegroundColor(tlp.backgroundColor), (Object)rootItem.getForeground(0));
                Assert.assertEquals((Object)TestLabelProvider.font, (Object)rootItem.getFont(0));
                Assert.assertEquals((Object)tlp.image, (Object)rootItem.getImage(0));
                if (all) {
                    this.checkItems(rootItem.getItems(), tlp, all, text);
                }
            }
            ++n2;
        }
    }

    protected TreeItem _findChild(String name, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Assert.assertTrue((String)("Child " + String.valueOf(item) + " should be an M1 or M2 resource"), (boolean)(item.getData() instanceof ResourceWrapper));
            ResourceWrapper rw = (ResourceWrapper)item.getData();
            if (name.equals(rw.getResource().getName())) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    protected void _expand(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this._viewer.setExpandedState(item.getData(), true);
            ++n2;
        }
    }

    protected void waitForInitialization(TestLabelProvider tlp) {
        int i = 0;
        while (i < 1200) {
            TreeItem[] rootItems = this._viewer.getTree().getItems();
            if (tlp != null && rootItems[0].getBackground(0).equals((Object)tlp.backgroundColor)) {
                System.out.println("The label provider '" + ((Object)((Object)tlp)).getClass().getCanonicalName() + "' was initialized after " + i * 50 + " ms");
                return;
            }
            DisplayHelper.sleep((long)50L);
            ++i;
        }
        Assert.fail((String)"The label provider was not initialized.");
    }
}

