/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.internal.navigator.filters.UpdateActiveFiltersOperation;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.junit.Assert;
import org.junit.Test;

public class OpenTest
extends NavigatorTestBase {
    public OpenTest() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.TestView";
    }

    @Test
    public void testNavigatorRootContents() throws Exception {
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent"}, true);
        UpdateActiveFiltersOperation updateFilters = new UpdateActiveFiltersOperation(this._viewer, new String[0]);
        updateFilters.execute(null, null);
        this.refreshViewer();
        this._viewer.expandAll();
        TreeItem[] items = this._viewer.getTree().getItems();
        Assert.assertTrue((String)"There should be some items.", (items.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this._project, (Object)items[2].getData());
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)this._project.getFile(".project")));
        TreeItem[] children = items[2].getItems();
        Assert.assertEquals((long)this._expectedChildren.size(), (long)children.length);
        TreeItem[] treeItemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            Assert.assertTrue((boolean)this._expectedChildren.contains(child.getData()));
            ++n2;
        }
    }

    @Test
    public void testNavigatorExtensionEnablement() throws Exception {
        this._contentService.getActivationService().activateExtensions(new String[0], true);
        this.refreshViewer();
        this._viewer.expandAll();
        TreeItem[] items = this._viewer.getTree().getItems();
        Assert.assertEquals((String)"There should be NO items.", (long)0L, (long)items.length);
        this._contentService.getActivationService().deactivateExtensions(new String[0], true);
        this._viewer.expandToLevel(2);
        items = this._viewer.getTree().getItems();
        Assert.assertTrue((String)"There should be some items.", (items.length > 0 ? 1 : 0) != 0);
    }
}

