/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.tests.harness.util.TestRunLogUtil;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.eclipse.ui.tests.navigator.extension.TestPipelineProvider;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestWatcher;

public class PipelineChainTest
extends NavigatorTestBase {
    @Rule
    public TestWatcher LOG_TESTRUN = TestRunLogUtil.LOG_TESTRUN;
    private static final boolean SLEEP_LONG = false;

    public PipelineChainTest() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.PipelineTestView";
    }

    private void _initContent() {
        String[] EXTENSIONS = new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.ui.tests.navigator.testPipeline.A", "org.eclipse.ui.tests.navigator.testPipeline.B", "org.eclipse.ui.tests.navigator.testPipeline.C", "org.eclipse.ui.tests.navigator.testPipeline.D", "org.eclipse.ui.tests.navigator.testPipeline.E", "org.eclipse.ui.tests.navigator.testPipeline.F", "org.eclipse.ui.tests.navigator.testPipeline.G"};
        this.activateAndWait(EXTENSIONS);
    }

    private void _initContentWithLabel() {
        String[] EXTENSIONS = new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.ui.tests.navigator.testPipeline.A", "org.eclipse.ui.tests.navigator.testPipeline.B", "org.eclipse.ui.tests.navigator.testPipeline.C", "org.eclipse.ui.tests.navigator.testPipeline.D", "org.eclipse.ui.tests.navigator.testPipeline.E", "org.eclipse.ui.tests.navigator.testPipeline.F", "org.eclipse.ui.tests.navigator.testPipeline.G", "org.eclipse.ui.tests.navigator.testPipeline.label"};
        this.activateAndWait(EXTENSIONS);
    }

    private void activateAndWait(String[] extensionIds) {
        this._contentService.bindExtensions(extensionIds, false);
        this._contentService.getActivationService().activateExtensions(extensionIds, true);
        String[] stringArray = extensionIds;
        int n = extensionIds.length;
        int n2 = 0;
        while (n2 < n) {
            String extensionId = stringArray[n2];
            this.waitForCondition("Wait for content pipelines", () -> this._contentService.getActivationService().isNavigatorExtensionActive(extensionId));
            ++n2;
        }
    }

    @Test
    public void testPipelinedChildren() throws Exception {
        this._initContent();
        this._testPipelinedChildren();
    }

    @Test
    public void testPipelinedChildrenWithLabel() throws Exception {
        this._initContentWithLabel();
        this._testPipelinedChildren();
    }

    private void _testPipelinedChildren() throws CoreException {
        String NEW_FOLDER = "newFolder_" + System.currentTimeMillis();
        IFolder newFolder = this._p1.getFolder(NEW_FOLDER);
        TestPipelineProvider.reset();
        newFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this._expand(rootItems);
        this._viewer.refresh((Object)rootItems[0]);
        Assert.assertEquals((String)"Wrong query sequence for getPipelineChildren", (Object)"A1CGFBDE", TestPipelineProvider.CHILDREN.get(this._p1));
    }

    @Test
    public void testInterceptAdd() throws CoreException {
        this._initContent();
        this._testInterceptAdd();
    }

    @Test
    public void testInterceptAddWithLabel() throws CoreException {
        this._initContentWithLabel();
        this._testInterceptAdd();
    }

    private void _testInterceptAdd() throws CoreException {
        String NEW_FOLDER_1 = "newFolder1";
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this._expand(rootItems);
        IFolder newFolder1 = this._p1.getFolder("newFolder1");
        TestPipelineProvider.reset();
        newFolder1.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"Wrong query sequence for interceptAdd", (Object)"ACGFBDE", TestPipelineProvider.ADDS.get(newFolder1));
    }

    @Test
    public void testInterceptRemove() throws CoreException {
        this._initContent();
        this._testInterceptRemove();
    }

    @Test
    public void testInterceptRemoveWithLabel() throws CoreException {
        this._initContentWithLabel();
        this._testInterceptRemove();
    }

    private void _testInterceptRemove() throws CoreException {
        String NEW_FOLDER_1 = "newFolder1";
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this._expand(rootItems);
        IFolder newFolder1 = this._p1.getFolder("newFolder1");
        if (!newFolder1.exists()) {
            newFolder1.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        TestPipelineProvider.reset();
        newFolder1.delete(true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"Wrong query sequence for interceptRemove", (Object)"ACGFBDE", TestPipelineProvider.REMOVES.get(newFolder1));
    }

    @Test
    public void testInterceptRefreshOnChildTypeChange() throws CoreException {
        this._initContent();
        this._testInterceptRefreshOnChildTypeChange();
    }

    @Test
    public void testInterceptRefreshOnChildTypeChangeWithLabel() throws CoreException {
        this._initContentWithLabel();
        this._testInterceptRefreshOnChildTypeChange();
    }

    private void _testInterceptRefreshOnChildTypeChange() throws CoreException {
        IFile file2 = this._p2.getFile("file2.txt");
        IWorkspaceRunnable runnable = monitor -> {
            file2.delete(true, (IProgressMonitor)new NullProgressMonitor());
            file2.create(null, true, null);
        };
        TestPipelineProvider.reset();
        ResourcesPlugin.getWorkspace().run(runnable, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertEquals((String)"Wrong query sequence for interceptRefresh/update", (Object)"ACGFBDE", TestPipelineProvider.UPDATES.get(file2));
    }

    @Test
    public void testInterceptUpdate() throws CoreException {
        this._initContent();
        this._testInterceptUpdate();
    }

    @Test
    public void testInterceptUpdateWithLabel() throws CoreException {
        this._initContentWithLabel();
        this._testInterceptUpdate();
    }

    private void _testInterceptUpdate() throws CoreException {
        String NEW_FOLDER_1 = "newFolder1";
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this._expand(rootItems);
        IFolder newFolder1 = this._p1.getFolder("newFolder1");
        if (!newFolder1.exists()) {
            newFolder1.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        TestPipelineProvider.reset();
        newFolder1.move(newFolder1.getFullPath().removeLastSegments(1).append("newFolderRenamed"), true, null);
        Assert.assertEquals((String)"Wrong query sequence for interceptUpdate", (Object)"ACGFBDE", TestPipelineProvider.REMOVES.get(newFolder1));
    }
}

