/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.eclipse.ui.tests.navigator.extension.TestContentProviderNoChildren;
import org.eclipse.ui.tests.navigator.extension.TestContentProviderPipelined;
import org.junit.Assert;
import org.junit.Test;

public class PipelineTest
extends NavigatorTestBase {
    public PipelineTest() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.PipelineTestView";
    }

    @Test
    public void testNavigatorResourceJava() throws Exception {
        Assert.assertEquals((String)"There should be no visible extensions for the pipeline viewer.", (long)0L, (long)this._contentService.getVisibleExtensionIds().length);
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.jdt.java.ui.javaContent"}, false);
        Assert.assertEquals((String)"There should be two visible extensions for the pipeline viewer.", (long)2L, (long)this._contentService.getVisibleExtensionIds().length);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.jdt.java.ui.javaContent"}, true);
        this.refreshViewer();
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)this._project.getFile(".project")), true);
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        Assert.assertEquals((String)("There should be " + _projectCount + " item(s)."), (long)_projectCount, (long)rootItems.length);
        Assert.assertTrue((String)"The root object should be an IJavaProject, which is IAdaptable.", (boolean)(rootItems[0].getData() instanceof IAdaptable));
        IProject adaptedProject = (IProject)((IAdaptable)rootItems[2].getData()).getAdapter(IProject.class);
        Assert.assertEquals((Object)this._project, (Object)adaptedProject);
        IFolder sourceFolder = this._project.getFolder(IPath.fromOSString((String)"src"));
        this._viewer.add((Object)this._project, (Object)sourceFolder);
        TreeItem[] projectChildren = rootItems[2].getItems();
        Assert.assertTrue((String)"There should be some items.", (projectChildren.length > 0 ? 1 : 0) != 0);
        TreeItem[] treeItemArray = projectChildren;
        int n = projectChildren.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem projectChild = treeItemArray[n2];
            if (projectChild.getData() == sourceFolder) {
                Assert.fail((String)"The src folder should not be added as an IFolder.");
            }
            ++n2;
        }
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject("New Project");
        this._viewer.add(this._viewer.getInput(), (Object)newProject);
        rootItems = this._viewer.getTree().getItems();
        Assert.assertEquals((String)("There should be " + (_projectCount + 1) + " items."), (long)(_projectCount + 1), (long)rootItems.length);
        boolean found = false;
        int i = 0;
        while (i < rootItems.length && !found) {
            IProject newProjectFromTree;
            if (rootItems[i].getData() instanceof IProject && newProject.equals((Object)(newProjectFromTree = (IProject)rootItems[i].getData()))) {
                found = true;
            }
            ++i;
        }
        Assert.assertTrue((boolean)found);
    }

    @Test
    public void testInterceptAddThrow() throws Exception {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.ui.tests.navigator.testContentResourceOverride"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.ui.tests.navigator.testContentResourceOverride"}, true);
        this.refreshViewer();
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)this._project.getFile(".project")), true);
        IFile f = this._project.getFile("newfile");
        TestContentProviderPipelined._throw = true;
        this._viewer.add((Object)this._project, new Object[]{f});
    }

    private void testHasNoChildrenOverride(boolean hasChildren) throws Exception {
        TestContentProviderNoChildren._hasChildrenTrue = hasChildren;
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.ui.tests.navigator.testContentNoChildren"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.ui.tests.navigator.testContentNoChildren"}, true);
        this.refreshViewer();
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        Assert.assertEquals((Object)"p1", (Object)rootItems[0].getText());
        Assert.assertEquals((long)(hasChildren ? 1 : 0), (long)rootItems[0].getItems().length);
        this._viewer.expandAll();
        rootItems = this._viewer.getTree().getItems();
        Assert.assertEquals((long)0L, (long)rootItems[0].getItems().length);
    }

    @Test
    public void testHasNoChildrenOverrideHasChildren() throws Exception {
        this.testHasNoChildrenOverride(true);
    }

    @Test
    public void testHasNoChildrenOverride() throws Exception {
        this.testHasNoChildrenOverride(false);
    }
}

