/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorSorterService;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.eclipse.ui.tests.navigator.extension.TestLabelProviderBlue;
import org.eclipse.ui.tests.navigator.extension.TestLabelProviderCyan;
import org.eclipse.ui.tests.navigator.extension.TestLabelProviderStyledGreen;
import org.eclipse.ui.tests.navigator.extension.TestSorterData;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ProgrammaticOpenTest
extends NavigatorTestBase {
    public ProgrammaticOpenTest() {
        this._navigatorInstanceId = "org.eclipse.ui.tests.navigator.ProgrammaticTestView";
    }

    @Test
    public void testNavigatorRootContents() throws Exception {
        Assert.assertEquals((String)"There should be no visible extensions for the programmatic viewer.", (long)0L, (long)this._contentService.getVisibleExtensionIds().length);
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent"}, false);
        Assert.assertEquals((String)"There should be one visible extension for the programmatic viewer.", (long)1L, (long)this._contentService.getVisibleExtensionIds().length);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent"}, true);
        this.refreshViewer();
        this._viewer.expandAll();
        TreeItem[] items = this._viewer.getTree().getItems();
        Assert.assertTrue((String)"There should be some items.", (items.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this._project, (Object)items[2].getData());
        this._viewer.setSelection((ISelection)new StructuredSelection((Object)this._project.getFile(".project")));
        TreeItem[] children = items[2].getItems();
        Assert.assertEquals((long)this._expectedChildren.size(), (long)children.length);
        TreeItem[] treeItemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem child = treeItemArray[n2];
            Assert.assertTrue((boolean)this._expectedChildren.contains(child.getData()));
            ++n2;
        }
    }

    @Test
    public void testNavigatorExtensionEnablement() throws Exception {
        Assert.assertEquals((String)"There should be no visible extensions for the programmatic viewer.", (long)0L, (long)this._contentService.getVisibleExtensionIds().length);
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent"}, false);
        Assert.assertEquals((String)"There should be one visible extension for the programmatic viewer.", (long)1L, (long)this._contentService.getVisibleExtensionIds().length);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent"}, true);
        this._contentService.getActivationService().activateExtensions(new String[0], true);
        this.refreshViewer();
        this._viewer.expandAll();
        TreeItem[] items = this._viewer.getTree().getItems();
        Assert.assertEquals((String)"There should be NO items.", (long)0L, (long)items.length);
        this._contentService.getActivationService().deactivateExtensions(new String[0], true);
        this._viewer.expandToLevel(2);
        items = this._viewer.getTree().getItems();
        Assert.assertTrue((String)"There should be some items.", (items.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNavigatorSorterAccess() throws Exception {
        INavigatorSorterService sorterService = this._contentService.getSorterService();
        INavigatorContentDescriptor testDescriptor = this._contentService.getContentDescriptorById("org.eclipse.ui.tests.navigator.testContent");
        Map sorters = sorterService.findAvailableSorters(testDescriptor);
        Assert.assertEquals((long)1L, (long)sorters.size());
        Iterator iterator = sorters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element;
            Map.Entry entry = element = iterator.next();
            Assert.assertTrue((boolean)(entry.getValue() instanceof TestSorterData));
        }
    }

    @Test
    public void testChangeNceActivation() throws Exception {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverridden1", "org.eclipse.ui.tests.navigator.testContentOverride1", "org.eclipse.ui.tests.navigator.testContentOverridden2", "org.eclipse.ui.tests.navigator.testContentOverride2"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverridden2", "org.eclipse.ui.tests.navigator.testContentOverride2"}, true);
        this.refreshViewer();
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this.checkItems(rootItems, TestLabelProviderCyan.instance);
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverridden1", "org.eclipse.ui.tests.navigator.testContentOverride1"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testContentOverridden1", "org.eclipse.ui.tests.navigator.testContentOverride1"}, true);
        this.refreshViewer();
        this._viewer.expandAll();
        rootItems = this._viewer.getTree().getItems();
        this.checkItems(rootItems, TestLabelProviderStyledGreen.instance);
    }

    @Test
    public void testEvaluateWith() throws Exception {
        Assume.assumeFalse((String)"Test fails on Mac: Bug 537641", (boolean)"macosx".equals(Platform.getOS()));
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.ui.tests.navigator.testContentWith"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.ui.tests.navigator.testContentWith"}, true);
        this.refreshViewer();
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this.checkItems(rootItems, TestLabelProviderBlue.instance);
    }

    @Test
    public void testNceOrdering() throws Exception {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.ui.tests.navigator.testSimpleChildrenContent1"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.ui.tests.navigator.testSimpleChildrenContent1"}, true);
        TreeItem[] rootItems = this._viewer.getTree().getItems();
        this._viewer.expandAll();
        Assert.assertEquals((Object)"10", (Object)rootItems[0].getItems()[0].getText());
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testSimpleChildrenContent3"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testSimpleChildrenContent3"}, false);
        this._viewer.expandAll();
        Assert.assertEquals((Object)"30", (Object)rootItems[0].getItems()[0].getText());
        Assert.assertEquals((Object)"10", (Object)rootItems[0].getItems()[4].getText());
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.tests.navigator.testSimpleChildrenContent2"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.tests.navigator.testSimpleChildrenContent2"}, false);
        this._viewer.expandAll();
        Assert.assertEquals((Object)"30", (Object)rootItems[0].getItems()[0].getText());
        Assert.assertEquals((Object)"20", (Object)rootItems[0].getItems()[4].getText());
        Assert.assertEquals((Object)"10", (Object)rootItems[0].getItems()[8].getText());
    }

    @Test
    public void testNceNotFound() throws Exception {
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.ui.tests.navigator.testSimpleChildrenAppearsBeforeNotFound"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent", "org.eclipse.ui.tests.navigator.testSimpleChildrenAppearsBeforeNotFound"}, true);
    }
}

