/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ResourceWorkingSetFilter;
import org.eclipse.ui.internal.AggregateWorkingSet;
import org.eclipse.ui.internal.WorkingSet;
import org.eclipse.ui.internal.navigator.resources.actions.WorkingSetActionProvider;
import org.eclipse.ui.internal.navigator.resources.plugin.WorkbenchNavigatorMessages;
import org.eclipse.ui.internal.navigator.workingsets.WorkingSetsContentProvider;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.tests.navigator.NavigatorTestBase;
import org.eclipse.ui.tests.navigator.TestAccessHelper;
import org.junit.Assert;
import org.junit.Test;

public class WorkingSetTest
extends NavigatorTestBase {
    private static final boolean SLEEP_LONG = false;
    private static final IWorkingSet[] NO_WORKINGSET = new IWorkingSet[0];

    public WorkingSetTest() {
        this._navigatorInstanceId = "org.eclipse.ui.navigator.ProjectExplorer";
    }

    @Test
    public void testEmptyWindowWorkingSet() throws Exception {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().setWorkingSets(NO_WORKINGSET);
        WorkingSetActionProvider provider = (WorkingSetActionProvider)TestAccessHelper.getActionProvider(this._contentService, this._actionService, WorkingSetActionProvider.class);
        IWorkingSet workingSet = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getAggregateWorkingSet();
        IPropertyChangeListener l = provider.getFilterChangeListener();
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "changeWorkingSet", null, (Object)workingSet);
        l.propertyChange(event);
        TreeItem[] items = this._viewer.getTree().getItems();
        Assert.assertTrue((String)"There should be some items.", (items.length > 0 ? 1 : 0) != 0);
        Assert.assertEquals(null, (Object)this._commonNavigator.getWorkingSetLabel());
    }

    @Test
    public void testMissingProjectsInWorkingSet() throws Exception {
        IFile f1 = this._p1.getFile("f1");
        WorkingSetActionProvider provider = (WorkingSetActionProvider)TestAccessHelper.getActionProvider(this._contentService, this._actionService, WorkingSetActionProvider.class);
        WorkingSet workingSet = new WorkingSet("ws1", "ws1", new IAdaptable[]{f1});
        AggregateWorkingSet agWorkingSet = new AggregateWorkingSet("AgWs", "Ag Working Set", new IWorkingSet[]{workingSet});
        IPropertyChangeListener l = provider.getFilterChangeListener();
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "changeWorkingSet", null, (Object)agWorkingSet);
        l.propertyChange(event);
        TreeItem[] items = this._viewer.getTree().getItems();
        Assert.assertEquals((String)"First item needs to be project", (Object)this._p1, (Object)items[0].getData());
        Assert.assertEquals((Object)"ws1", (Object)this._commonNavigator.getWorkingSetLabel());
    }

    @Test
    public void testTopLevelWorkingSet() throws Exception {
        WorkingSetActionProvider provider = (WorkingSetActionProvider)TestAccessHelper.getActionProvider(this._contentService, this._actionService, WorkingSetActionProvider.class);
        IExtensionStateModel extensionStateModel = this._contentService.findStateModel("org.eclipse.ui.navigator.resources.workingSets");
        extensionStateModel.setBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets", true);
        WorkingSet workingSet = new WorkingSet("ws1", "ws1", new IAdaptable[]{this._p1});
        IPropertyChangeListener l = provider.getFilterChangeListener();
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "changeWorkingSet", null, (Object)workingSet);
        l.propertyChange(event);
        this._viewer.expandAll();
        TreeItem[] items = this._viewer.getTree().getItems();
        Assert.assertEquals((String)"First item needs to be working set", (Object)workingSet, (Object)items[0].getData());
        Assert.assertEquals((Object)"ws1", (Object)this._commonNavigator.getWorkingSetLabel());
        TreeItem projectItem = items[0].getItem(0);
        Assert.assertEquals((Object)"p1", (Object)projectItem.getText());
    }

    @Test
    public void testTopLevelChange() throws Exception {
        IExtensionStateModel extensionStateModel = this._contentService.findStateModel("org.eclipse.ui.navigator.resources.workingSets");
        INavigatorContentExtension ce = this._contentService.getContentExtensionById("org.eclipse.ui.navigator.resources.workingSets");
        ce.getContentProvider();
        WorkingSet workingSet = new WorkingSet("ws1", "ws1", new IAdaptable[]{this._p1});
        WorkingSetActionProvider provider = (WorkingSetActionProvider)TestAccessHelper.getActionProvider(this._contentService, this._actionService, WorkingSetActionProvider.class);
        IPropertyChangeListener l = provider.getFilterChangeListener();
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "changeWorkingSet", null, (Object)workingSet);
        l.propertyChange(event);
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWindow.getActivePage();
        IWorkingSet[] activeWorkingSets = activePage.getWorkingSets();
        activePage.setWorkingSets(new IWorkingSet[]{workingSet});
        extensionStateModel.setBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets", true);
        this.refreshViewer();
        TreeItem[] items = this._viewer.getTree().getItems();
        Assert.assertEquals((String)"First item needs to be working set", (Object)workingSet, (Object)items[0].getData());
        extensionStateModel.setBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets", false);
        this.refreshViewer();
        items = this._viewer.getTree().getItems();
        Assert.assertEquals((String)"First item needs to be project", (Object)this._p1, (Object)items[0].getData());
        extensionStateModel.setBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets", true);
        this.refreshViewer();
        items = this._viewer.getTree().getItems();
        Assert.assertEquals((String)"First item needs to be working set", (Object)workingSet, (Object)items[0].getData());
        activePage.setWorkingSets(activeWorkingSets);
    }

    @Test
    public void testMultipleWorkingSets() throws Exception {
        INavigatorContentExtension ce = this._contentService.getContentExtensionById("org.eclipse.ui.navigator.resources.workingSets");
        ce.getContentProvider();
        WorkingSet workingSet1 = new WorkingSet("ws1", "ws1", new IAdaptable[]{this._p1});
        WorkingSet workingSet2 = new WorkingSet("ws2", "ws2", new IAdaptable[]{this._p1});
        AggregateWorkingSet agWorkingSet = new AggregateWorkingSet("AgWs", "Ag Working Set", new IWorkingSet[]{workingSet1, workingSet2});
        WorkingSetActionProvider provider = (WorkingSetActionProvider)TestAccessHelper.getActionProvider(this._contentService, this._actionService, WorkingSetActionProvider.class);
        IPropertyChangeListener l = provider.getFilterChangeListener();
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "changeWorkingSet", null, (Object)agWorkingSet);
        l.propertyChange(event);
        Assert.assertEquals((Object)WorkbenchNavigatorMessages.WorkingSetActionProvider_multipleWorkingSets, (Object)this._commonNavigator.getWorkingSetLabel());
    }

    @Test
    public void testWorkingSetFilter() throws Exception {
        ViewerFilter vf1;
        this._contentService.bindExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent"}, false);
        this._contentService.getActivationService().activateExtensions(new String[]{"org.eclipse.ui.navigator.resourceContent"}, true);
        WorkingSet workingSet = new WorkingSet("ws1", "ws1", new IAdaptable[]{this._p1});
        WorkingSetActionProvider provider = (WorkingSetActionProvider)TestAccessHelper.getActionProvider(this._contentService, this._actionService, WorkingSetActionProvider.class);
        IPropertyChangeListener l = provider.getFilterChangeListener();
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "changeWorkingSet", null, (Object)workingSet);
        l.propertyChange(event);
        ViewerFilter[] vf = this._viewer.getFilters();
        boolean found = false;
        ViewerFilter[] viewerFilterArray = vf;
        int n = vf.length;
        int n2 = 0;
        while (n2 < n) {
            vf1 = viewerFilterArray[n2];
            if (vf1 instanceof ResourceWorkingSetFilter) {
                found = true;
                break;
            }
            ++n2;
        }
        Assert.assertTrue((boolean)found);
        this._contentService.getFilterService().activateFilterIdsAndUpdateViewer(new String[]{"org.eclipse.ui.tests.navigator.filters.p1", "org.eclipse.ui.tests.navigator.filters.p2"});
        vf = this._viewer.getFilters();
        found = false;
        viewerFilterArray = vf;
        n = vf.length;
        n2 = 0;
        while (n2 < n) {
            vf1 = viewerFilterArray[n2];
            if (vf1 instanceof ResourceWorkingSetFilter) {
                found = true;
                break;
            }
            ++n2;
        }
        Assert.assertTrue((String)"Working set filter is gone, oh my!", (boolean)found);
    }

    @Test
    public void testDeletedAndRecreated() throws Exception {
        INavigatorContentExtension ce = this._contentService.getContentExtensionById("org.eclipse.ui.navigator.resources.workingSets");
        ce.getContentProvider();
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet ws1 = workingSetManager.createWorkingSet("ws1", new IAdaptable[]{this._p1});
        workingSetManager.addWorkingSet(ws1);
        IWorkingSet ws2 = workingSetManager.createWorkingSet("ws2", new IAdaptable[]{this._p2});
        workingSetManager.addWorkingSet(ws2);
        WorkingSetActionProvider provider = (WorkingSetActionProvider)TestAccessHelper.getActionProvider(this._contentService, this._actionService, WorkingSetActionProvider.class);
        IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWindow.getActivePage();
        activePage.setWorkingSets(new IWorkingSet[]{ws1, ws2});
        IPropertyChangeListener l = provider.getFilterChangeListener();
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "changeWorkingSet", null, (Object)ws2);
        l.propertyChange(event);
        TreeItem[] items = this._viewer.getTree().getItems();
        Assert.assertEquals((Object)this._p2, (Object)items[0].getData());
        l = provider.getFilterChangeListener();
        event = new PropertyChangeEvent((Object)this, "changeWorkingSet", null, (Object)ws1);
        l.propertyChange(event);
        items = this._viewer.getTree().getItems();
        Assert.assertEquals((Object)this._p1, (Object)items[0].getData());
        workingSetManager.removeWorkingSet(ws2);
        ws2 = workingSetManager.createWorkingSet("ws2", new IAdaptable[]{this._p2});
        workingSetManager.addWorkingSet(ws2);
        l = provider.getFilterChangeListener();
        event = new PropertyChangeEvent((Object)this, "changeWorkingSet", null, (Object)ws2);
        l.propertyChange(event);
        items = this._viewer.getTree().getItems();
        Assert.assertEquals((Object)this._p2, (Object)items[0].getData());
    }

    @Test
    public void testOtherProjectWorkingSet() throws Exception {
        WorkingSetActionProvider provider = (WorkingSetActionProvider)TestAccessHelper.getActionProvider(this._contentService, this._actionService, WorkingSetActionProvider.class);
        IExtensionStateModel extensionStateModel = this._contentService.findStateModel("org.eclipse.ui.navigator.resources.workingSets");
        extensionStateModel.setBooleanProperty("org.eclipse.ui.navigator.resources.workingSets.showTopLevelWorkingSets", true);
        WorkingSet workingSet = new WorkingSet("ws1", "ws1", new IAdaptable[]{this._p1});
        IPropertyChangeListener l = provider.getFilterChangeListener();
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "changeWorkingSet", null, (Object)workingSet);
        l.propertyChange(event);
        this._viewer.expandAll();
        TreeItem[] items = this._viewer.getTree().getItems();
        Assert.assertEquals((String)"Missing working set or 'other projects'", (long)2L, (long)items.length);
        Assert.assertEquals((String)"First item needs to be working set", (Object)workingSet, (Object)items[0].getData());
        Assert.assertEquals((Object)workingSet, (Object)items[0].getData());
        Assert.assertEquals((Object)this._p1, (Object)items[0].getItem(0).getData());
        Assert.assertEquals((String)"Last item needs to be 'other project'", (Object)WorkingSetsContentProvider.OTHERS_WORKING_SET, (Object)items[1].getData());
        Assert.assertEquals((long)(this._p1.getWorkspace().getRoot().getProjects().length - 1), (long)items[1].getItemCount());
        workingSet.setElements((IAdaptable[])this._p1.getWorkspace().getRoot().getProjects());
        l = provider.getFilterChangeListener();
        event = new PropertyChangeEvent((Object)this, "workingSetContentChange", null, (Object)workingSet);
        l.propertyChange(event);
        this._viewer.expandAll();
        items = this._viewer.getTree().getItems();
        Assert.assertEquals((String)"Should be the single working set", (long)1L, (long)items.length);
        Assert.assertEquals((Object)workingSet, (Object)items[0].getData());
        workingSet.setElements(new IAdaptable[]{this._p1});
        l = provider.getFilterChangeListener();
        event = new PropertyChangeEvent((Object)this, "workingSetContentChange", null, (Object)workingSet);
        l.propertyChange(event);
        this._viewer.expandAll();
        items = this._viewer.getTree().getItems();
        Assert.assertEquals((String)"Missing working set or 'other projects'", (long)2L, (long)items.length);
        Assert.assertEquals((String)"First item needs to be working set", (Object)workingSet, (Object)items[0].getData());
        Assert.assertEquals((Object)workingSet, (Object)items[0].getData());
        Assert.assertEquals((Object)this._p1, (Object)items[0].getItem(0).getData());
        Assert.assertEquals((String)"Last item needs to be 'other project'", (Object)WorkingSetsContentProvider.OTHERS_WORKING_SET, (Object)items[1].getData());
        Assert.assertEquals((long)(this._p1.getWorkspace().getRoot().getProjects().length - 1), (long)items[1].getItemCount());
    }
}

