/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.cdt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.tests.navigator.cdt.CContainer;
import org.eclipse.ui.tests.navigator.cdt.CNavigatorContentProvider;

public class CElement
implements IAdaptable {
    protected IResource _resource;
    protected CElement _parent;
    protected List _children;
    protected CNavigatorContentProvider _cp;

    public CElement(CNavigatorContentProvider cp, IResource resource, CElement parent) {
        this._cp = cp;
        this._resource = resource;
        cp._resourceToModel.put(this._resource, this);
        this._children = new ArrayList();
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public IResource getResource() {
        return this._resource;
    }

    public void setResource(IResource Resource) {
        this._resource = Resource;
    }

    public String getElementName() {
        return "CElement: " + this._resource.getName();
    }

    public CElement getParent() {
        return this._parent;
    }

    public List getChildren() {
        try {
            if (this._children.isEmpty() && this._resource instanceof IContainer) {
                IResource[] members;
                IResource[] iResourceArray = members = ((IContainer)this._resource).members();
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    if (member instanceof IProject) {
                        this._children.add(member);
                    } else if (member instanceof IFolder) {
                        this._children.add(new CContainer(this._cp, member, this));
                    } else {
                        this._children.add(member);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException ex) {
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }
        return this._children;
    }

    public void addChild(CElement child) {
        if (!(child instanceof CContainer)) {
            this._children.add(child.getResource());
        } else {
            this._children.add(child);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IResource.class) {
            return adapter.cast(this._resource);
        }
        return null;
    }

    public String toString() {
        return this.getClass().getName() + ": " + String.valueOf(this._resource);
    }
}

