/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.cdt;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;
import org.eclipse.ui.tests.navigator.cdt.CContainer;
import org.eclipse.ui.tests.navigator.cdt.CElement;
import org.eclipse.ui.tests.navigator.cdt.CProject;
import org.eclipse.ui.tests.navigator.cdt.CRoot;

public class CNavigatorContentProvider
implements IPipelinedTreeContentProvider,
ICommonContentProvider {
    private boolean fLinkingEnabledDelayed;
    protected Map<IResource, CElement> _resourceToModel = new HashMap<IResource, CElement>();
    protected CRoot _root;
    protected Object _realInput;

    public void init(ICommonContentExtensionSite commonContentExtensionSite) {
        IMemento memento = commonContentExtensionSite.getMemento();
        this.restoreState(memento);
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this._realInput = newInput;
        if (newInput instanceof IWorkspaceRoot) {
            this._root = new CRoot(this, (IResource)newInput);
        }
        this.workaroundForBug186344();
    }

    private void workaroundForBug186344() {
        if (this.fLinkingEnabledDelayed) {
            IViewPart viewPart;
            IWorkbenchPage page;
            this.fLinkingEnabledDelayed = false;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null && (viewPart = page.findView("org.eclipse.ui.navigator.ProjectExplorer")) instanceof CommonNavigator) {
                CommonNavigator cn = (CommonNavigator)viewPart;
                viewPart.getSite().getShell().getDisplay().asyncExec(() -> cn.setLinkingEnabled(true));
            }
        }
    }

    public Object getParent(Object element) {
        CElement parent = element instanceof CElement ? ((CElement)element).getParent() : ((IResource)element).getParent();
        if (parent instanceof CRoot) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        if (parent instanceof CProject) {
            return ((CProject)parent).getResource();
        }
        return parent;
    }

    public Object[] getElements(Object parent) {
        if (parent instanceof IWorkspaceRoot) {
            Object[] projects;
            Object[] objectArray = projects = ((IWorkspaceRoot)parent).getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                Object project = objectArray[n2];
                new CProject(this, (IResource)project, this._root);
                ++n2;
            }
            return projects;
        }
        CElement cElement = this._resourceToModel.get(parent);
        if (cElement == null) {
            return new Object[0];
        }
        return cElement.getChildren().toArray();
    }

    public Object[] getChildren(Object element) {
        return this.getElements(element);
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            return project.isAccessible();
        }
        return this.getChildren(element).length > 0;
    }

    public void getPipelinedChildren(Object parent, Set currentChildren) {
        this.customizeCElements(this.getChildren(parent), currentChildren);
    }

    public void getPipelinedElements(Object input, Set currentElements) {
        this.customizeCElements(this.getElements(input), currentElements);
    }

    private void customizeCElements(Object[] cChildren, Set proposedChildren) {
        List<Object> elementList = Arrays.asList(cChildren);
        for (Object element : proposedChildren) {
            int i;
            IResource resource = null;
            if (element instanceof IResource) {
                resource = (IResource)element;
            } else if (element instanceof IAdaptable) {
                resource = (IResource)((IAdaptable)element).getAdapter(IResource.class);
            }
            if (resource == null || (i = elementList.indexOf(resource)) < 0) continue;
            cChildren[i] = null;
        }
        Object[] objectArray = cChildren;
        int n = cChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Object cChild = objectArray[n2];
            if (cChild instanceof CElement) {
                IResource resource = ((CElement)cChild).getResource();
                if (resource != null) {
                    proposedChildren.remove(resource);
                }
                proposedChildren.add(cChild);
            } else if (cChild != null) {
                proposedChildren.add(cChild);
            }
            ++n2;
        }
    }

    public Object getPipelinedParent(Object object, Object suggestedParent) {
        return this.getParent(object);
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification addModification) {
        Object parent = addModification.getParent();
        if (parent instanceof CProject) {
            if (this._realInput instanceof IWorkspaceRoot) {
                addModification.setParent((Object)((CProject)parent).getResource());
            }
        } else if (parent instanceof IProject || parent instanceof IFolder) {
            IProject project = ((IResource)parent).getProject();
            if (this.hasCNature(project)) {
                addModification.getChildren().clear();
                return addModification;
            }
        } else if (parent instanceof IWorkspaceRoot) {
            Iterator iterator = addModification.getChildren().iterator();
            while (iterator.hasNext()) {
                Object child = iterator.next();
                if (!(child instanceof IProject) || !this.hasCNature((IProject)child)) continue;
                iterator.remove();
            }
        }
        this.convertToCElements(addModification);
        return addModification;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate refreshSynchronization) {
        Set refreshTargets = refreshSynchronization.getRefreshTargets();
        return this.convertToCElements(refreshTargets);
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification removeModification) {
        Set children = removeModification.getChildren();
        this.convertToCElements(children);
        return removeModification;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate updateSynchronization) {
        Set refreshTargets = updateSynchronization.getRefreshTargets();
        return this.convertToCElements(refreshTargets);
    }

    private boolean convertToCElements(PipelinedShapeModification modification) {
        CContainer element;
        IContainer container;
        IProject project;
        Object parent = modification.getParent();
        if (parent instanceof IContainer && (project = (container = (IContainer)parent).getProject()) != null && this.hasCNature(project) && (element = new CContainer(this, (IResource)container, this._resourceToModel.get(container.getParent()))) != null) {
            Set children = modification.getChildren();
            return this.convertToCElements(children);
        }
        return false;
    }

    private boolean convertToCElements(Set currentChildren) {
        LinkedHashSet<CElement> convertedChildren = new LinkedHashSet<CElement>();
        Iterator iter = currentChildren.iterator();
        while (iter.hasNext()) {
            CElement newChild;
            IResource resource;
            Object child = iter.next();
            if (child instanceof IFile && (resource = (IResource)child).isAccessible() && this.hasCNature(resource.getProject()) && (newChild = new CElement(this, resource, this._resourceToModel.get(resource.getParent()))) != null) {
                iter.remove();
                convertedChildren.add(newChild);
            }
            if (!(child instanceof IFolder) || !(resource = (IResource)child).isAccessible() || !this.hasCNature(resource.getProject()) || (newChild = new CContainer(this, resource, this._resourceToModel.get(resource.getParent()))) == null) continue;
            iter.remove();
            convertedChildren.add(newChild);
        }
        if (!convertedChildren.isEmpty()) {
            currentChildren.addAll(convertedChildren);
            return true;
        }
        return false;
    }

    private boolean hasCNature(IProject project) {
        return project.getName().startsWith("C");
    }

    public void dispose() {
    }
}

