/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.extension;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

public class DecorationSchedulerRaceConditionTestDecorator
implements ILightweightLabelDecorator {
    public static final QualifiedName DECO_PROP = new QualifiedName("org.eclipse.ui.tests.navigator", "decoProp");
    private static final Semaphore semaphoreDecoratorP1Ran = new Semaphore(0);
    private static final Semaphore semaphoreDecoratorP2Ran = new Semaphore(0);
    private static final Semaphore semaphoreBlockDecoration = new Semaphore(200);

    public static void resetWait() {
        semaphoreDecoratorP1Ran.drainPermits();
        semaphoreDecoratorP2Ran.drainPermits();
    }

    public static boolean hasP1Run(long timeout) throws InterruptedException {
        return semaphoreDecoratorP1Ran.tryAcquire(timeout, TimeUnit.MILLISECONDS);
    }

    public static boolean hasP2Run(long timeout) throws InterruptedException {
        return semaphoreDecoratorP2Ran.tryAcquire(timeout, TimeUnit.MILLISECONDS);
    }

    public static void blockDecoration() {
        semaphoreBlockDecoration.drainPermits();
    }

    public static void unblockDecorationOnce() {
        semaphoreBlockDecoration.release(1);
    }

    public static void unblockDecoration() {
        semaphoreBlockDecoration.release(200);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        Object suffix;
        if (!(element instanceof IProject)) {
            return;
        }
        IProject prj = (IProject)element;
        String prjName = prj.getName();
        try {
            suffix = prj.getSessionProperty(DECO_PROP);
        }
        catch (CoreException e) {
            e.printStackTrace();
            suffix = null;
        }
        if (suffix != null) {
            decoration.addSuffix((String)suffix);
        }
        if (prjName.equals("p1")) {
            try {
                semaphoreDecoratorP1Ran.release();
                semaphoreBlockDecoration.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else if (prjName.equals("p2")) {
            try {
                semaphoreDecoratorP2Ran.release();
                semaphoreBlockDecoration.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

