/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.extension;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.tests.navigator.extension.TestExtensionTreeData;

public class TestContentProvider
implements ITreeContentProvider,
IResourceChangeListener,
IResourceDeltaVisitor {
    private static final String MODEL_ROOT = "root";
    private static final Object[] NO_CHILDREN = new Object[0];
    public static final IPath MODEL_FILE_PATH = IPath.fromOSString((String)"model.properties");
    private final Map rootElements = new HashMap();
    private StructuredViewer viewer;
    public static TestExtensionTreeData _modelRoot;
    public static boolean _dieOnSetInput;
    public static boolean _diedOnSetInput;

    public TestContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        _dieOnSetInput = false;
        _diedOnSetInput = false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof TestExtensionTreeData) {
            TestExtensionTreeData data = (TestExtensionTreeData)parentElement;
            return data.getChildren();
        }
        IProject project = this.adaptToProject(parentElement);
        if (project != null && project.isAccessible()) {
            IFile modelFile = project.getFile(MODEL_FILE_PATH);
            if (this.rootElements.containsKey(modelFile)) {
                TestExtensionTreeData model = (TestExtensionTreeData)this.rootElements.get(modelFile);
                return model != null ? model.getChildren() : NO_CHILDREN;
            }
            TestExtensionTreeData model = this.updateModel(modelFile);
            return model != null ? model.getChildren() : NO_CHILDREN;
        }
        return NO_CHILDREN;
    }

    private IProject adaptToProject(Object parentElement) {
        if (parentElement instanceof IProject) {
            return (IProject)parentElement;
        }
        if (parentElement instanceof IAdaptable) {
            return (IProject)((IAdaptable)parentElement).getAdapter(IProject.class);
        }
        return (IProject)Platform.getAdapterManager().getAdapter(parentElement, IProject.class);
    }

    private TestExtensionTreeData updateModel(IFile modelFile) {
        Properties model = new Properties();
        if (modelFile.exists()) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream is = modelFile.getContents();){
                    TestExtensionTreeData root;
                    model.load(is);
                    is.close();
                    _modelRoot = root = new TestExtensionTreeData(null, MODEL_ROOT, model, modelFile);
                    this.rootElements.put(modelFile, root);
                    return root;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | CoreException throwable) {}
        } else {
            this.rootElements.remove(modelFile);
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof TestExtensionTreeData) {
            TestExtensionTreeData data = (TestExtensionTreeData)element;
            return data.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof TestExtensionTreeData) {
            TestExtensionTreeData data = (TestExtensionTreeData)element;
            return data.getChildren().length > 0;
        }
        return false;
    }

    public void dispose() {
        this.rootElements.clear();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer aViewer, Object oldInput, Object newInput) {
        if (_dieOnSetInput) {
            _diedOnSetInput = true;
        }
        if (oldInput != null && !oldInput.equals(newInput)) {
            this.rootElements.clear();
        }
        this.viewer = (StructuredViewer)aViewer;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        try {
            delta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource source = delta.getResource();
        switch (source.getType()) {
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
            case 1: {
                IFile file = (IFile)source;
                if ("model.properties".equals(file.getName())) {
                    this.updateModel(file);
                    UIJob.create((String)"Update Test Model in CommonViewer", m -> {
                        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
                            this.viewer.refresh((Object)file.getParent());
                        }
                    }).schedule();
                }
                return false;
            }
        }
        return false;
    }
}

