/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.extension;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;

public class TestExtensionTreeData {
    private final Map<String, TestExtensionTreeData> children = new HashMap<String, TestExtensionTreeData>();
    private final TestExtensionTreeData parent;
    private final String name;
    private final Properties model;
    private final IFile container;

    public TestExtensionTreeData(TestExtensionTreeData aParent, String aName, Properties theModel, IFile aFile) {
        this.parent = aParent;
        this.name = aName;
        this.model = theModel;
        this.container = aFile;
    }

    public TestExtensionTreeData getParent() {
        return this.parent;
    }

    public TestExtensionTreeData[] getChildren() {
        String childrenString;
        HashSet<TestExtensionTreeData> updatedChildren = new HashSet<TestExtensionTreeData>();
        if (this.model != null && (childrenString = this.model.getProperty(this.getName())) != null) {
            String[] childrenElements;
            String[] stringArray = childrenElements = childrenString.split(",");
            int n = childrenElements.length;
            int n2 = 0;
            while (n2 < n) {
                String childrenElement = stringArray[n2];
                if (this.children.containsKey(childrenElement)) {
                    updatedChildren.add(this.children.get(childrenElement));
                } else {
                    TestExtensionTreeData newChild = new TestExtensionTreeData(this, childrenElement, this.model, this.container);
                    this.children.put(newChild.getName(), newChild);
                    updatedChildren.add(newChild);
                }
                ++n2;
            }
        }
        return updatedChildren.toArray(new TestExtensionTreeData[updatedChildren.size()]);
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof TestExtensionTreeData && ((TestExtensionTreeData)obj).getName().equals(this.name);
    }

    public String toString() {
        StringBuilder toString = new StringBuilder(this.getName()).append(":");
        toString.append("[");
        for (TestExtensionTreeData child : this.children.values()) {
            toString.append(child.toString());
        }
        toString.append("]");
        return toString.toString();
    }

    public IFile getFile() {
        return this.container;
    }
}

