/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.extension;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.eclipse.ui.tests.navigator.extension.TestExtensionTreeData;

public abstract class TestLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
IDescriptionProvider,
IColorProvider,
IFontProvider {
    protected static FontData boldFontData = new FontData();
    public Color backgroundColor;
    public String backgroundColorName;
    public Image image;
    public static final Font font = new Font((Device)Display.getDefault(), new FontData());
    private Font boldFont;
    public boolean _blank;
    public boolean _null;
    public static Runnable _runnable;

    static {
        boldFontData.setStyle(1);
    }

    public static void resetTest() {
        _runnable = null;
    }

    public void init(ICommonContentExtensionSite aSite) {
        this.boldFont = new Font((Device)Display.getDefault(), boldFontData);
        this.initSubclass();
    }

    protected void initSubclass() {
    }

    public static Color toForegroundColor(Color backColor) {
        RGB rgb = backColor.getRGB();
        RGB newRgb = new RGB(rgb.blue, rgb.red, rgb.green);
        return new Color((Device)Display.getCurrent(), newRgb);
    }

    public Color getTestColor() {
        return this.backgroundColor;
    }

    public String getColorName() {
        return this.backgroundColorName;
    }

    public Image getImage(Object element) {
        if (_runnable != null) {
            _runnable.run();
        }
        if (element instanceof TestExtensionTreeData) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
        return this.image;
    }

    public String getText(Object element) {
        if (_runnable != null) {
            _runnable.run();
        }
        if (this._blank) {
            return "";
        }
        if (this._null) {
            return null;
        }
        if (element instanceof TestExtensionTreeData) {
            TestExtensionTreeData data = (TestExtensionTreeData)element;
            return this.getColorName() + data.getName();
        }
        if (element instanceof IResource) {
            return this.getColorName() + ((IResource)element).getName();
        }
        return element.toString();
    }

    public String getDescription(Object anElement) {
        if (_runnable != null) {
            _runnable.run();
        }
        if (anElement instanceof TestExtensionTreeData) {
            TestExtensionTreeData data = (TestExtensionTreeData)anElement;
            return "TestItem: " + data.getName();
        }
        return null;
    }

    public void restoreState(IMemento aMemento) {
        if (_runnable != null) {
            _runnable.run();
        }
    }

    public void saveState(IMemento aMemento) {
        if (_runnable != null) {
            _runnable.run();
        }
    }

    public Color getForeground(Object element) {
        if (_runnable != null) {
            _runnable.run();
        }
        return TestLabelProvider.toForegroundColor(this.getTestColor());
    }

    public Color getBackground(Object element) {
        if (_runnable != null) {
            _runnable.run();
        }
        return this.getTestColor();
    }

    public Font getFont(Object element) {
        TestExtensionTreeData data;
        if (_runnable != null) {
            _runnable.run();
        }
        if (element instanceof TestExtensionTreeData && (data = (TestExtensionTreeData)element).getParent() != null && data.getParent().getParent() == null) {
            return this.boldFont;
        }
        return font;
    }

    public void dispose() {
        if (_runnable != null) {
            _runnable.run();
        }
        this.boldFont.dispose();
        this.boldFont = null;
    }
}

