/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.extension;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;

public class TestLinkHelper
implements ILinkHelper {
    public IEditorInput findSelectionEditorInput;
    public int findSelectionCount;
    public IStructuredSelection activateEditorSelection;
    public int activateEditorCount;
    public static TestLinkHelper instance;

    public TestLinkHelper() {
        instance = this;
    }

    public void resetTest() {
        this.findSelectionEditorInput = null;
        this.findSelectionCount = 0;
        this.activateEditorSelection = null;
        this.activateEditorCount = 0;
    }

    public IStructuredSelection findSelection(IEditorInput anInput) {
        this.findSelectionEditorInput = anInput;
        ++this.findSelectionCount;
        System.out.println("findSelection: " + String.valueOf(this));
        IFile file = ResourceUtil.getFile((IEditorInput)anInput);
        if (file != null) {
            return new StructuredSelection((Object)file);
        }
        return StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        ++this.activateEditorCount;
        this.activateEditorSelection = aSelection;
        System.out.println("activateEditor: " + String.valueOf(this));
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        if (aSelection.getFirstElement() instanceof IFile) {
            FileEditorInput fileInput = new FileEditorInput((IFile)aSelection.getFirstElement());
            IEditorPart editor = null;
            editor = aPage.findEditor((IEditorInput)fileInput);
            if (editor != null) {
                aPage.bringToTop((IWorkbenchPart)editor);
            }
        }
    }

    public String toString() {
        return "findSel: " + String.valueOf(this.findSelectionEditorInput) + " (" + this.findSelectionCount + ") activate: " + String.valueOf(this.activateEditorSelection) + " (" + this.activateEditorCount + ")";
    }
}

