/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.jst;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;
import org.eclipse.ui.tests.navigator.jst.CompressedJavaLibraries;
import org.eclipse.ui.tests.navigator.jst.CompressedJavaProject;

public class WebJavaContentProvider
implements IPipelinedTreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private static final String JAVA_EXTENSION_ID = "org.eclipse.jdt.java.ui.javaContent";
    public static Class<?> JAVA_CORE_CLASS;
    public static Class<?> IJAVA_PROJECT_CLASS;
    public static Class<?> IJAVA_ELEMENT_CLASS;
    public static Class<?> IPACKAGE_FRAGMENT_ROOT_CLASS;
    public static Class<?> IPACKAGE_FRAGMENT_CLASS;
    public static Class<?> INTERNAL_CONTAINER_CLASS;
    private CommonViewer commonViewer;
    private ITreeContentProvider delegateContentProvider;
    private final Map compressedNodes = new HashMap();

    public static void staticInit(ClassLoader cl) {
        try {
            JAVA_CORE_CLASS = cl.loadClass("org.eclipse.jdt.core.JavaCore");
            IJAVA_PROJECT_CLASS = cl.loadClass("org.eclipse.jdt.core.IJavaProject");
            IJAVA_ELEMENT_CLASS = cl.loadClass("org.eclipse.jdt.core.IJavaElement");
            IPACKAGE_FRAGMENT_ROOT_CLASS = cl.loadClass("org.eclipse.jdt.core.IPackageFragmentRoot");
            IPACKAGE_FRAGMENT_CLASS = cl.loadClass("org.eclipse.jdt.core.IPackageFragment");
            INTERNAL_CONTAINER_CLASS = cl.loadClass("org.eclipse.jdt.internal.ui.packageview.ClassPathContainer");
        }
        catch (Throwable t) {
            INTERNAL_CONTAINER_CLASS = null;
        }
    }

    public static Object javaCoreCreateResource(IResource res) throws Exception {
        Method m = JAVA_CORE_CLASS.getMethod("create", IResource.class);
        return m.invoke(null, res);
    }

    public static Object javaCoreCreateProject(IResource res) throws Exception {
        Method m = JAVA_CORE_CLASS.getMethod("create", IProject.class);
        return m.invoke(null, res);
    }

    public void getPipelinedChildren(Object aParent, Set theCurrentChildren) {
        try {
            if (aParent instanceof IProject) {
                this.cleanJavaContribution(theCurrentChildren);
                theCurrentChildren.add(this.getCompressedNode((IProject)aParent));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void cleanJavaContribution(Set theCurrentChildren) throws Exception {
        Iterator iter = theCurrentChildren.iterator();
        while (iter.hasNext()) {
            Object child = iter.next();
            if (child instanceof IResource && WebJavaContentProvider.javaCoreCreateResource((IResource)child) != null) {
                iter.remove();
                continue;
            }
            if (INTERNAL_CONTAINER_CLASS != null && INTERNAL_CONTAINER_CLASS.isInstance(child)) {
                iter.remove();
                continue;
            }
            if (!IJAVA_ELEMENT_CLASS.isInstance(child)) continue;
            iter.remove();
        }
    }

    private CompressedJavaProject getCompressedNode(IProject project) {
        CompressedJavaProject result = (CompressedJavaProject)this.compressedNodes.get(project);
        if (result == null) {
            result = new CompressedJavaProject((StructuredViewer)this.commonViewer, project);
            this.compressedNodes.put(project, result);
        }
        return result;
    }

    public void getPipelinedElements(Object anInput, Set theCurrentElements) {
    }

    public Object getPipelinedParent(Object anObject, Object aSuggestedParent) {
        try {
            Method m = IJAVA_PROJECT_CLASS.getMethod("getProject", new Class[0]);
            if (IPACKAGE_FRAGMENT_ROOT_CLASS.isInstance(anObject)) {
                if (IJAVA_PROJECT_CLASS.isInstance(aSuggestedParent)) {
                    return this.getCompressedNode((IProject)m.invoke(aSuggestedParent, new Object[0]));
                }
                if (aSuggestedParent instanceof IProject) {
                    return this.getCompressedNode((IProject)aSuggestedParent);
                }
            } else if (INTERNAL_CONTAINER_CLASS.isInstance(anObject)) {
                if (IJAVA_PROJECT_CLASS.isInstance(aSuggestedParent)) {
                    return this.getCompressedNode((IProject)m.invoke(aSuggestedParent, new Object[0])).getCompressedJavaLibraries();
                }
                if (aSuggestedParent instanceof IProject) {
                    return this.getCompressedNode((IProject)aSuggestedParent).getCompressedJavaLibraries();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return null;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        return anAddModification;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        return aRemoveModification;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        return false;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        return false;
    }

    public void init(ICommonContentExtensionSite aSite) {
    }

    public Object[] getChildren(Object parentElement) {
        if (this.delegateContentProvider != null) {
            if (parentElement instanceof CompressedJavaProject) {
                return ((CompressedJavaProject)parentElement).getChildren(this.delegateContentProvider);
            }
            if (parentElement instanceof CompressedJavaLibraries) {
                return ((CompressedJavaLibraries)parentElement).getChildren(this.delegateContentProvider);
            }
        }
        return NO_CHILDREN;
    }

    public Object getParent(Object element) {
        if (element instanceof CompressedJavaProject) {
            return ((CompressedJavaProject)element).getProject();
        }
        if (element instanceof CompressedJavaLibraries) {
            return ((CompressedJavaLibraries)element).getCompressedProject();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof CompressedJavaProject || element instanceof CompressedJavaLibraries;
    }

    public Object[] getElements(Object inputElement) {
        return NO_CHILDREN;
    }

    public void dispose() {
        this.compressedNodes.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (viewer instanceof CommonViewer) {
            this.commonViewer = (CommonViewer)viewer;
            INavigatorContentService service = this.commonViewer.getNavigatorContentService();
            INavigatorContentExtension javaext = service.getContentExtensionById(JAVA_EXTENSION_ID);
            if (javaext != null) {
                this.delegateContentProvider = javaext.getContentProvider();
            }
            this.compressedNodes.clear();
        }
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public boolean isClasspathContainer(Object o) {
        return INTERNAL_CONTAINER_CLASS != null && INTERNAL_CONTAINER_CLASS.isInstance(o);
    }
}

