/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.navigator.m12;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider2;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;
import org.eclipse.ui.tests.navigator.m12.model.ResourceWrapper;

public abstract class ResourceWrapperContentProvider
implements IPipelinedTreeContentProvider2 {
    protected static final Object[] NO_CHILDREN = new Object[0];
    protected static final String INTERCEPT_ADD = "ADD";
    protected static final String INTERCEPT_REMOVE = "REMOVE";
    protected static final String INTERCEPT_REFRESH = "REFRESH";
    protected static final String INTERCEPT_UPDATE = "UPDATE";
    private static Map _counters;

    public ResourceWrapperContentProvider() {
        _counters = new HashMap();
    }

    public void getPipelinedChildren(Object aParent, Set theCurrentChildren) {
    }

    public void getPipelinedElements(Object input, Set currentElements) {
    }

    public Object getPipelinedParent(Object object, Object suggestedParent) {
        return object instanceof ResourceWrapper ? ((ResourceWrapper)object).getParent() : suggestedParent;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        return NO_CHILDREN;
    }

    public Object getParent(Object element) {
        if (element instanceof ResourceWrapper) {
            return ((ResourceWrapper)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        try {
            return ((ResourceWrapper)element).hasChildren();
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Object[] getElements(Object inputElement) {
        return NO_CHILDREN;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification modification) {
        this._convertToModelObjects(modification);
        this._incrementCounter(INTERCEPT_ADD);
        return modification;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification modification) {
        this._incrementCounter(INTERCEPT_REMOVE);
        this._convertToModelObjects(modification.getChildren());
        return modification;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate refreshSynchronization) {
        this._incrementCounter(INTERCEPT_REFRESH);
        return this._convertToModelObjects(refreshSynchronization.getRefreshTargets());
    }

    public boolean interceptUpdate(PipelinedViewerUpdate update) {
        this._incrementCounter(INTERCEPT_UPDATE);
        return this._convertToModelObjects(update.getRefreshTargets());
    }

    private void _incrementCounter(String counterId) {
        Integer current;
        HashMap<String, Integer> counters = (HashMap<String, Integer>)_counters.get(this.getClass().getName());
        if (counters == null) {
            counters = new HashMap<String, Integer>();
            _counters.put(this.getClass().getName(), counters);
        }
        if ((current = (Integer)counters.get(counterId)) == null) {
            counters.put(counterId, 1);
        } else {
            counters.put(counterId, current + 1);
        }
    }

    protected static void resetCounters(String className) {
        _counters.remove(className);
    }

    protected static int getCounter(String className, String counterId) {
        Map counters = (Map)_counters.get(className);
        if (counters == null) {
            return 0;
        }
        Integer value = (Integer)counters.get(counterId);
        return value == null ? 0 : value;
    }

    protected boolean _convertToModelObjects(PipelinedShapeModification modification) {
        Object parent = modification.getParent();
        Object node = this._convertToModelObject(parent);
        if (node != null && node != parent) {
            modification.setParent(node);
        }
        return this._convertToModelObjects(modification.getChildren());
    }

    protected boolean _convertToModelObjects(Set children) {
        LinkedHashSet<Object> convertedChildren = new LinkedHashSet<Object>();
        Iterator childrenItr = children.iterator();
        while (childrenItr.hasNext()) {
            Object child = childrenItr.next();
            Object node = this._convertToModelObject(child);
            if (node == null || node == child) continue;
            childrenItr.remove();
            convertedChildren.add(node);
        }
        children.addAll(convertedChildren);
        return !convertedChildren.isEmpty();
    }

    protected abstract Object _convertToModelObject(Object var1);
}

